/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElOperator;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import io.github.wycst.wast.common.expression.ExprCalculateUtils;
import io.github.wycst.wast.common.expression.ExprChildParser;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.ReflectUtils;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprEvaluator {
    protected static final int EVAL_TYPE_OPERATOR = 1;
    protected static final int EVAL_TYPE_VARIABLE = 2;
    protected static final int EVAL_TYPE_FUN = 3;
    protected static final int EVAL_TYPE_QUESTION = 4;
    protected static final int EVAL_TYPE_BRACKET = 5;
    protected int evalType;
    protected ElOperator operator = ElOperator.ATOM;
    protected ExprEvaluator left;
    protected ExprEvaluator right;
    protected boolean negate;
    protected boolean logicalNot;
    boolean constant;
    Object result;
    static final int OPTIMIZE_DEPTH_VALUE = 1024;
    static final Object[] EMPTY_ARGS = new Object[0];

    public boolean isConstantExpr() {
        if (this.left == null && this.right == null) {
            return this.constant;
        }
        if (this.left == null) {
            return this.right.isConstantExpr();
        }
        if (this.right == null) {
            return this.left.isConstantExpr();
        }
        return this.left.isConstantExpr() && this.right.isConstantExpr();
    }

    public final ExprEvaluator getLeft() {
        return this.left;
    }

    public final ExprEvaluator getRight() {
        return this.right;
    }

    String[] parseStringArr(String splitStr, AtomicInteger atomicInteger, AtomicBoolean strArr, AtomicBoolean doubleArr) {
        int length = splitStr.length();
        boolean isStrArr = false;
        boolean isDoubleArr = false;
        String[] strings = new String[10];
        int beginIndex = 0;
        int arrLen = 0;
        int bracketCount = 0;
        int bigBracketCount = 0;
        for (int i = 0; i < length; ++i) {
            char ch = splitStr.charAt(i);
            if (!isStrArr && ch == '\'') {
                isStrArr = true;
            }
            if (!isDoubleArr && ch == '.') {
                isDoubleArr = true;
            }
            if (ch == '(') {
                ++bracketCount;
                continue;
            }
            if (ch == ')') {
                --bracketCount;
                continue;
            }
            if (ch == '{') {
                ++bigBracketCount;
                continue;
            }
            if (ch == '}') {
                --bigBracketCount;
                continue;
            }
            if (bracketCount != 0 || bigBracketCount != 0 || ch != ',') continue;
            if (arrLen == strings.length) {
                String[] tmp = strings;
                strings = new String[strings.length << 1];
                System.arraycopy(tmp, 0, strings, 0, tmp.length);
            }
            String val = new String(splitStr.substring(beginIndex, i).trim());
            strings[arrLen++] = val;
            beginIndex = i + 1;
        }
        if (arrLen == strings.length) {
            String[] tmp = strings;
            strings = new String[strings.length << 1];
            System.arraycopy(tmp, 0, strings, 0, tmp.length);
        }
        strings[arrLen++] = new String(splitStr.substring(beginIndex, length).trim());
        atomicInteger.set(arrLen);
        strArr.set(isStrArr);
        doubleArr.set(isDoubleArr);
        return strings;
    }

    public void setArrayValue(String splitStr) {
        this.constant = true;
        int length = (splitStr = splitStr.trim()).length();
        if (length == 0) {
            this.result = EMPTY_ARGS;
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicBoolean strArr = new AtomicBoolean();
        AtomicBoolean doubleArr = new AtomicBoolean();
        String[] strings = this.parseStringArr(splitStr, atomicInteger, strArr, doubleArr);
        int arrLen = atomicInteger.get();
        boolean isStrArr = strArr.get();
        boolean isDoubleArr = doubleArr.get();
        Object[] result = isStrArr ? new String[arrLen] : (isDoubleArr ? new Double[arrLen] : new Long[arrLen]);
        for (int i = 0; i < arrLen; ++i) {
            String val = strings[i];
            if (isStrArr) {
                if (!val.startsWith("'") || !val.endsWith("'")) {
                    throw new ExpressionException("\u65e0\u6548\u7684\u5b57\u7b26\u4e32\u6570\u7ec4\u5143\u7d20: " + val + ", \u6570\u7ec4\u7247\u6bb5\uff1a '" + splitStr + "'");
                }
                val = new String(val.substring(1, val.length() - 1));
                result[i] = val;
                continue;
            }
            result[i] = isDoubleArr ? (Number)Double.parseDouble(val.trim()) : (Number)Long.parseLong(val.trim());
        }
        this.result = result;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public ExprEvaluator negate(boolean negate) {
        this.negate = negate;
        return this;
    }

    public void setLogicalNot(boolean logicalNot) {
        this.logicalNot = logicalNot;
    }

    public Object evaluate() {
        return this.evaluate(null, EvaluateEnvironment.DEFAULT);
    }

    public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
        if (this.constant) {
            return this.result;
        }
        if (this.evalType == 0) {
            this.result = this.left.evaluate(context, evaluateEnvironment);
            this.constant = this.left.constant;
            return this.result;
        }
        if (this.evalType == 1) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (evaluateEnvironment.isAutoParseStringAsDouble()) {
                if (leftValue instanceof String) {
                    leftValue = Double.parseDouble(leftValue.toString());
                }
                if (rightValue instanceof String) {
                    rightValue = Double.parseDouble(rightValue.toString());
                }
            }
            this.constant = this.left.constant && this.right.constant;
            try {
                switch (this.operator) {
                    case MULTI: {
                        this.result = ExprCalculateUtils.multiply(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case DIVISION: {
                        this.result = ExprCalculateUtils.divide(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case MOD: {
                        this.result = ExprCalculateUtils.mod(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case EXP: {
                        this.result = ExprCalculateUtils.pow(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case PLUS: {
                        this.result = ExprCalculateUtils.plus(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case MINUS: {
                        this.result = ExprCalculateUtils.subtract(leftValue, rightValue, evaluateEnvironment);
                        return this.result;
                    }
                    case BIT_RIGHT: {
                        this.result = ((Number)leftValue).longValue() >> (int)((Number)rightValue).longValue();
                        return this.result;
                    }
                    case BIT_LEFT: {
                        this.result = ((Number)leftValue).longValue() << (int)((Number)rightValue).longValue();
                        return this.result;
                    }
                    case AND: {
                        this.result = ((Number)leftValue).longValue() & ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case XOR: {
                        if (leftValue instanceof Boolean) {
                            this.result = (Boolean)leftValue ^ (Boolean)rightValue;
                            return this.result;
                        }
                        this.result = ((Number)leftValue).longValue() ^ ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case OR: {
                        this.result = ((Number)leftValue).longValue() | ((Number)rightValue).longValue();
                        return this.result;
                    }
                    case GT: {
                        this.result = ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case LT: {
                        this.result = ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case EQ: {
                        if (leftValue instanceof Number && rightValue instanceof Number) {
                            this.result = ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
                            return this.result;
                        }
                        if (leftValue == rightValue) {
                            this.result = true;
                            return this.result;
                        }
                        this.result = leftValue != null && leftValue.equals(rightValue);
                        return this.result;
                    }
                    case GE: {
                        this.result = ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case LE: {
                        this.result = ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    case NE: {
                        if (leftValue instanceof Number && rightValue instanceof Number) {
                            this.result = ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
                            return this.result;
                        }
                        if (leftValue == rightValue) {
                            this.result = false;
                            return this.result;
                        }
                        this.result = leftValue == null || !leftValue.equals(rightValue);
                        return this.result;
                    }
                    case LOGICAL_AND: {
                        this.result = (Boolean)leftValue != false && (Boolean)rightValue != false;
                        return this.result;
                    }
                    case LOGICAL_OR: {
                        this.result = (Boolean)leftValue != false || (Boolean)rightValue != false;
                        return this.result;
                    }
                    case IN: {
                        this.result = this.evaluateIn(leftValue, rightValue);
                        return this.result;
                    }
                    case OUT: {
                        this.result = !this.evaluateIn(leftValue, rightValue);
                        return this.result;
                    }
                }
            }
            catch (RuntimeException exception) {
                this.throwEvalOperatorException(exception, leftValue, rightValue, this.left, this.right);
            }
        } else {
            if (this.evalType == 5) {
                Object bracketValue = this.right.evaluate(context, evaluateEnvironment);
                this.constant = this.right.constant;
                if (this.negate) {
                    this.result = ExprCalculateUtils.negate(bracketValue);
                    return this.result;
                }
                if (this.logicalNot) {
                    this.result = bracketValue == Boolean.FALSE || bracketValue == null;
                    return this.result;
                }
                this.result = bracketValue;
                return this.result;
            }
            if (this.evalType == 4) {
                Object conditionValue = this.left.evaluate(context, evaluateEnvironment);
                Object result = this.right.evaluateTernary(context, evaluateEnvironment, (Boolean)conditionValue, this.left.constant);
                boolean bl = this.constant = this.left.constant && this.right.constant;
                if (this.constant) {
                    this.result = result;
                }
                return result;
            }
            this.result = this.left.evaluate(context, evaluateEnvironment);
            this.constant = this.left.constant;
            return this.result;
        }
        return null;
    }

    private void throwEvalOperatorException(RuntimeException exception, Object leftValue, Object rightValue, ExprEvaluator left, ExprEvaluator right) {
        if (exception instanceof NullPointerException) {
            if (leftValue == null) {
                left.throwNotAllowNullException();
            } else if (rightValue == null) {
                right.throwNotAllowNullException();
            }
        } else {
            throw exception;
        }
    }

    void throwNotAllowNullException() {
    }

    boolean evaluateIn(Object leftValue, Object rightValue) {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (rightValue instanceof Collection) {
            Collection collection = (Collection)rightValue;
            for (Object value : collection) {
                boolean isEqual = this.execEquals(value, leftValue);
                if (!isEqual) continue;
                return true;
            }
        } else {
            Class<?> rightCls = rightValue.getClass();
            if (rightCls.isArray()) {
                Class<?> componentType = rightCls.getComponentType();
                if (componentType.isPrimitive()) {
                    ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
                    int length = primitiveType.arrayLength(rightValue);
                    for (int i = 0; i < length; ++i) {
                        boolean isEqual;
                        Object value = primitiveType.elementAt(rightValue, i);
                        boolean bl = isEqual = leftValue == value;
                        if (!isEqual) continue;
                        return true;
                    }
                } else {
                    for (Object value : (Object[])rightValue) {
                        boolean isEqual = this.execEquals(value, leftValue);
                        if (!isEqual) continue;
                        return true;
                    }
                }
            } else {
                if (rightValue instanceof Number || rightValue instanceof CharSequence) {
                    return false;
                }
                return ObjectUtils.contains(rightValue, String.valueOf(leftValue));
            }
        }
        return false;
    }

    private boolean execEquals(Object value, Object leftValue) {
        if (value instanceof Number && leftValue instanceof Number && ((Number)value).doubleValue() == ((Number)leftValue).doubleValue()) {
            return true;
        }
        return value == leftValue || String.valueOf(leftValue).equals(String.valueOf(value));
    }

    Object evaluateTernary(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment, Boolean bool, boolean isStatic) {
        Object result;
        if (this.constant) {
            return this.result;
        }
        if (bool == null || !bool.booleanValue()) {
            this.constant = isStatic && this.right.constant;
            result = this.right.evaluate(context, evaluateEnvironment);
        } else {
            this.constant = isStatic && this.left.constant;
            result = this.left.evaluate(context, evaluateEnvironment);
        }
        if (this.constant) {
            this.result = result;
        }
        return result;
    }

    final ExprEvaluator update(ExprEvaluator left, ExprEvaluator right) {
        this.left = left;
        this.right = right;
        return this;
    }

    public ExprEvaluator optimize() {
        ExprEvaluator next;
        ExprEvaluator optimized = this.optimizeDepth();
        while (optimized != (next = optimized.optimizeDepth())) {
            optimized = next;
        }
        return optimized;
    }

    public ExprEvaluator optimizeDepth() {
        boolean optimizeFlag;
        ExprEvaluator optimizedRoot = this.optimizeDepth(this, 0);
        ExprEvaluator target = optimizedRoot;
        boolean bl = optimizeFlag = target != this;
        while (optimizeFlag) {
            ExprEvaluator oldLeft = target.left;
            ExprEvaluator newLeft = oldLeft.optimizeDepth(oldLeft, 0);
            optimizeFlag = newLeft != oldLeft;
            target.left = newLeft;
            target = newLeft;
        }
        return optimizedRoot;
    }

    ExprEvaluator optimizeDepth(ExprEvaluator target, int depth) {
        if (this.left == null) {
            return target;
        }
        if (++depth > 1024) {
            StackSplitImpl stackSplit = new StackSplitImpl(target, this.left);
            ContextValueHolderImpl valueHolder = new ContextValueHolderImpl();
            this.left = valueHolder;
            return stackSplit;
        }
        return this.left.optimizeDepth(target, depth);
    }

    public String code() {
        throw new UnsupportedOperationException("non compiled executor are not supported code()");
    }

    static class ContextValueHolderImpl
    extends ExprEvaluator {
        ContextValueHolderImpl() {
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return context.value;
        }
    }

    static class StackSplitImpl
    extends ExprEvaluator {
        ExprEvaluator front;

        StackSplitImpl(ExprEvaluator front, ExprEvaluator left) {
            this.front = front;
            this.left = left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object val = this.left.evaluate(context, evaluateEnvironment);
            try {
                context.value = val;
                Object object = this.front.evaluate(context, evaluateEnvironment);
                return object;
            }
            finally {
                context.value = null;
            }
        }
    }

    static final class MethodImpl
    extends FunctionImpl {
        ElVariableInvoker variableInvoker;

        MethodImpl() {
        }

        @Override
        public String toString() {
            return "MethodImpl{@method}";
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            builder.append("_$").append(this.variableInvoker.getIndex()).append(".").append(this.functionName).append("(");
            for (int i = 0; i < this.paramLength; ++i) {
                builder.append(this.paramExprParsers[i].getEvaluator().code());
                if (i >= this.paramLength - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }

        public void setMethod(ElVariableInvoker variableInvoker, String methodName, String params, ExprParser global) {
            this.variableInvoker = variableInvoker;
            this.setFunction(methodName, params, global);
        }

        Object evaluateMethod(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object invokeObj = null;
            try {
                invokeObj = evaluatorContext.getContextValue(this.variableInvoker);
            }
            catch (RuntimeException e) {
                if (invokeObj == null) {
                    throw new ExpressionException("unresolved property or variable: '" + this.variableInvoker + "' from context");
                }
                throw e;
            }
            try {
                if (invokeObj == null && evaluateEnvironment.allowVariableNull) {
                    return null;
                }
                return ReflectUtils.invoke(invokeObj, this.functionName, this.invokeParams(evaluatorContext, evaluateEnvironment));
            }
            catch (Throwable throwable) {
                if (invokeObj == null) {
                    throw new ExpressionException("unresolved property or variable: '" + this.variableInvoker + "' from context");
                }
                throw new ExpressionException(String.format("invoke error, %s and methodName '%s', message: %s", invokeObj.getClass(), this.functionName, throwable.getMessage()));
            }
        }

        @Override
        public Object evaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object functionValue = this.evaluateMethod(evaluatorContext, evaluateEnvironment);
            if (this.negate) {
                return ExprCalculateUtils.negate(functionValue);
            }
            if (this.logicalNot) {
                return functionValue == Boolean.FALSE || functionValue == null;
            }
            return functionValue;
        }
    }

    static class FunctionImpl
    extends ExprEvaluator {
        String functionName;
        String[] paramExprs;
        int paramLength;
        ExprParser[] paramExprParsers;

        public FunctionImpl() {
            this.evalType = 3;
        }

        public String toString() {
            return "FunctionImpl{@function}";
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.functionName).append("(");
            for (int i = 0; i < this.paramLength; ++i) {
                builder.append(this.paramExprParsers[i].getEvaluator().code());
                if (i >= this.paramLength - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }

        public void setFunction(String funName, String params, ExprParser global) {
            this.functionName = funName.trim();
            if (params.isEmpty()) {
                this.paramLength = 0;
                this.paramExprs = new String[0];
                return;
            }
            AtomicInteger atomicInteger = new AtomicInteger();
            AtomicBoolean strArr = new AtomicBoolean(true);
            AtomicBoolean doubleArr = new AtomicBoolean(true);
            String[] paramExprs = this.parseStringArr(params, atomicInteger, strArr, doubleArr);
            this.paramExprs = paramExprs;
            this.paramLength = atomicInteger.get();
            ExprParser[] paramExprParsers = new ExprParser[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                paramExprParsers[i] = new ExprChildParser(paramExprs[i], global);
            }
            this.paramExprParsers = paramExprParsers;
        }

        protected final Object[] invokeParams(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            if (this.paramLength == 0) {
                return EMPTY_ARGS;
            }
            Object[] params = new Object[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                params[i] = this.paramExprParsers[i].doEvaluate(evaluatorContext, evaluateEnvironment);
            }
            return params;
        }

        Object evaluateFunction(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object[] params = this.invokeParams(evaluatorContext, evaluateEnvironment);
            ExprFunction exprFunction = evaluateEnvironment.getFunction(this.functionName);
            if (exprFunction == null) {
                throw new ExpressionException("function '" + this.functionName + "' is unregistered!");
            }
            return exprFunction.call(params);
        }

        @Override
        public Object evaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object functionValue = this.evaluateFunction(evaluatorContext, evaluateEnvironment);
            if (this.negate) {
                return ExprCalculateUtils.negate(functionValue);
            }
            if (this.logicalNot) {
                return functionValue == Boolean.FALSE || functionValue == null;
            }
            return functionValue;
        }
    }

    static final class OutImpl
    extends ExprEvaluator {
        OutImpl() {
        }

        static OutImpl of(ExprEvaluator evaluator) {
            OutImpl evaluatorImpl = new OutImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "OutImpl{out}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object rightValue;
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            return !this.evaluateIn(leftValue, rightValue = this.right.evaluate(context, evaluateEnvironment));
        }
    }

    static final class InImpl
    extends ExprEvaluator {
        InImpl() {
        }

        static InImpl of(ExprEvaluator evaluator) {
            InImpl evaluatorImpl = new InImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "InImpl{in}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return this.evaluateIn(leftValue, rightValue);
        }
    }

    static final class TernaryImpl
    extends ExprEvaluator {
        private ExprEvaluator condition;
        private ExprEvaluator question;
        private ExprEvaluator colon;

        TernaryImpl() {
        }

        static TernaryImpl of(ExprEvaluator evaluator) {
            TernaryImpl evaluatorImpl = new TernaryImpl();
            evaluatorImpl.condition = evaluator.left;
            evaluatorImpl.question = evaluator.right.left;
            evaluatorImpl.colon = evaluator.right.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "TernaryImpl{?:}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.condition.evaluate(context, evaluateEnvironment);
            boolean conditionResult = leftValue == null ? false : (Boolean)leftValue;
            return conditionResult ? this.question.evaluate(context, evaluateEnvironment) : this.colon.evaluate(context, evaluateEnvironment);
        }
    }

    static final class LogicalOrImpl
    extends ExprEvaluator {
        LogicalOrImpl() {
        }

        static LogicalOrImpl of(ExprEvaluator evaluator) {
            LogicalOrImpl evaluatorImpl = new LogicalOrImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "LogicalOrImpl{||}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return (Boolean)leftValue != false || (Boolean)rightValue != false;
        }
    }

    static final class LogicalAndImpl
    extends ExprEvaluator {
        LogicalAndImpl() {
        }

        static LogicalAndImpl of(ExprEvaluator evaluator) {
            LogicalAndImpl evaluatorImpl = new LogicalAndImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "LogicalAndImpl{&&}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return (Boolean)leftValue != false && (Boolean)rightValue != false;
        }
    }

    static final class NEImpl
    extends ExprEvaluator {
        NEImpl() {
        }

        static NEImpl of(ExprEvaluator evaluator) {
            NEImpl evaluatorImpl = new NEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "NEImpl{!=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
            }
            if (leftValue == rightValue) {
                return false;
            }
            return leftValue == null || !leftValue.equals(rightValue);
        }
    }

    static final class LEImpl
    extends ExprEvaluator {
        LEImpl() {
        }

        static LEImpl of(ExprEvaluator evaluator) {
            LEImpl evaluatorImpl = new LEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "LEImpl{<=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
        }
    }

    static final class GEImpl
    extends ExprEvaluator {
        GEImpl() {
        }

        static GEImpl of(ExprEvaluator evaluator) {
            GEImpl evaluatorImpl = new GEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "GEImpl{>=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
        }
    }

    static final class LtImpl
    extends ExprEvaluator {
        LtImpl() {
        }

        static LtImpl of(ExprEvaluator evaluator) {
            LtImpl evaluatorImpl = new LtImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "LtImpl{<}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
        }
    }

    static final class GtImpl
    extends ExprEvaluator {
        GtImpl() {
        }

        static GtImpl of(ExprEvaluator evaluator) {
            GtImpl evaluatorImpl = new GtImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "GtImpl{>}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
        }
    }

    static final class EqualImpl
    extends ExprEvaluator {
        EqualImpl() {
        }

        static EqualImpl of(ExprEvaluator evaluator) {
            EqualImpl evaluatorImpl = new EqualImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "EqualImpl{==}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            if (leftValue == rightValue) {
                return true;
            }
            return leftValue != null && leftValue.equals(rightValue);
        }
    }

    static final class BitXorImpl
    extends ExprEvaluator {
        BitXorImpl() {
        }

        static BitXorImpl of(ExprEvaluator evaluator) {
            BitXorImpl evaluatorImpl = new BitXorImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "BitOrImpl{^}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Boolean) {
                return (Boolean)leftValue ^ (Boolean)rightValue;
            }
            return ((Number)leftValue).longValue() ^ ((Number)rightValue).longValue();
        }
    }

    static final class BitOrImpl
    extends ExprEvaluator {
        BitOrImpl() {
        }

        static BitOrImpl of(ExprEvaluator evaluator) {
            BitOrImpl evaluatorImpl = new BitOrImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "BitOrImpl{|}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() | ((Number)rightValue).longValue();
        }
    }

    static final class BitAndImpl
    extends ExprEvaluator {
        BitAndImpl() {
        }

        static BitAndImpl of(ExprEvaluator evaluator) {
            BitAndImpl evaluatorImpl = new BitAndImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "BitAndImpl{&}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() & ((Number)rightValue).longValue();
        }
    }

    static final class BitRightImpl
    extends ExprEvaluator {
        BitRightImpl() {
        }

        static BitRightImpl of(ExprEvaluator evaluator) {
            BitRightImpl evaluatorImpl = new BitRightImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "BitRightImpl{>>}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() >> (int)((Number)rightValue).longValue();
        }
    }

    static final class BitLeftImpl
    extends ExprEvaluator {
        BitLeftImpl() {
        }

        static BitLeftImpl of(ExprEvaluator evaluator) {
            BitLeftImpl evaluatorImpl = new BitLeftImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "BitLeftImpl{<<}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() << (int)((Number)rightValue).longValue();
        }
    }

    static final class ModulusImpl
    extends ExprEvaluator {
        ModulusImpl() {
        }

        static ModulusImpl of(ExprEvaluator evaluator) {
            ModulusImpl evaluatorImpl = new ModulusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ModulusImpl{%}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.mod(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class DivisionImpl
    extends ExprEvaluator {
        DivisionImpl() {
        }

        static DivisionImpl of(ExprEvaluator evaluator) {
            DivisionImpl evaluatorImpl = new DivisionImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "DivisionImpl{/}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.divide(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class PowerImpl
    extends ExprEvaluator {
        PowerImpl() {
        }

        static PowerImpl of(ExprEvaluator evaluator) {
            PowerImpl evaluatorImpl = new PowerImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "PowerImpl{**}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.pow(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class MultiplyImpl
    extends ExprEvaluator {
        MultiplyImpl() {
        }

        static MultiplyImpl of(ExprEvaluator evaluator) {
            MultiplyImpl evaluatorImpl = new MultiplyImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "MultiplyImpl{*}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.multiply(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class MinusImpl
    extends ExprEvaluator {
        MinusImpl() {
        }

        static MinusImpl of(ExprEvaluator evaluator) {
            MinusImpl evaluatorImpl = new MinusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "MinusImpl{-}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.subtract(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class PlusImpl
    extends ExprEvaluator {
        PlusImpl() {
        }

        static PlusImpl of(ExprEvaluator evaluator) {
            PlusImpl evaluatorImpl = new PlusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "PlusImpl{+}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return ExprCalculateUtils.plus(this.left.evaluate(context, evaluateEnvironment), this.right.evaluate(context, evaluateEnvironment), evaluateEnvironment);
        }
    }

    static final class BracketImpl
    extends ExprEvaluator {
        BracketImpl() {
        }

        static BracketImpl of(ExprEvaluator evaluator) {
            BracketImpl exprEvaluatorImpl = new BracketImpl();
            exprEvaluatorImpl.right = evaluator.right;
            exprEvaluatorImpl.negate = evaluator.negate;
            exprEvaluatorImpl.logicalNot = evaluator.logicalNot;
            return exprEvaluatorImpl;
        }

        public String toString() {
            return "BracketImpl{()}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object bracketValue = this.right.evaluate(context, evaluateEnvironment);
            if (this.negate) {
                if (bracketValue instanceof Double) {
                    return -((Double)bracketValue).doubleValue();
                }
                if (bracketValue instanceof Long) {
                    return -((Long)bracketValue).longValue();
                }
                if (bracketValue instanceof Integer) {
                    return -((Integer)bracketValue).intValue();
                }
                return -((Number)bracketValue).doubleValue();
            }
            if (this.logicalNot) {
                return bracketValue == Boolean.FALSE || bracketValue == null;
            }
            return bracketValue;
        }
    }

    static final class ConstantImpl
    extends ExprEvaluator {
        ConstantImpl(Object result) {
            this.result = result;
            this.constant = true;
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return this.result;
        }

        public String toString() {
            return String.valueOf(this.result);
        }

        @Override
        public String code() {
            if (this.result instanceof String) {
                StringBuilder builder = new StringBuilder();
                String strValue = (String)this.result;
                if (strValue.indexOf(34) > -1) {
                    strValue = strValue.replace("\"", "\\\"");
                }
                return builder.append("\"").append(strValue).append("\"").toString();
            }
            return String.valueOf(this.result);
        }
    }

    static class VariableImpl
    extends ExprEvaluator {
        ElVariableInvoker variableInvoker;

        public VariableImpl() {
            this.evalType = 2;
        }

        public void setVariableInvoker(ElVariableInvoker variableInvoker) {
            this.variableInvoker = variableInvoker;
        }

        public VariableImpl normal() {
            return new NormalVariableImpl(this.variableInvoker);
        }

        @Override
        final void throwNotAllowNullException() {
            throw new ExpressionException("unresolved property or variable '" + this.variableInvoker + "' from context");
        }

        public final Object getVariableValue(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object obj = null;
            try {
                obj = evaluatorContext.getContextValue(this.variableInvoker);
                if (evaluateEnvironment.isAutoParseStringAsDouble() && obj instanceof String) {
                    obj = Double.parseDouble((String)obj);
                }
            }
            catch (RuntimeException e) {
                if (obj == null && evaluatorContext == null) {
                    throw new ExpressionException("unresolved property or variable '" + this.variableInvoker + "' from context");
                }
                throw e;
            }
            return obj;
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object obj = this.getVariableValue(context, evaluateEnvironment);
            if (this.negate) {
                Number number = (Number)obj;
                if (number instanceof Double || number instanceof Float) {
                    return -number.doubleValue();
                }
                if (number instanceof Integer) {
                    return -number.intValue();
                }
                return -number.longValue();
            }
            if (this.logicalNot) {
                return obj == Boolean.FALSE || obj == null;
            }
            return obj;
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            if (this.negate) {
                builder.append('-');
            }
            if (this.logicalNot) {
                builder.append("!(");
            }
            builder.append("_$").append(this.variableInvoker.getIndex());
            if (this.logicalNot) {
                builder.append(")");
            }
            return builder.toString();
        }

        ExprEvaluator internKey() {
            this.variableInvoker.internKey();
            return this;
        }

        public String toString() {
            return "VariableImpl{" + this.variableInvoker + "}";
        }

        static final class NormalVariableImpl
        extends VariableImpl {
            NormalVariableImpl(ElVariableInvoker variableInvoke) {
                this.setVariableInvoker(variableInvoke);
            }

            @Override
            public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
                return this.getVariableValue(context, evaluateEnvironment);
            }
        }
    }
}

