/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElChainVariableInvoker;
import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElOperator;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ElVariableUtils;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import io.github.wycst.wast.common.expression.EvaluatorContextBuilder;
import io.github.wycst.wast.common.expression.ExprEvaluator;
import io.github.wycst.wast.common.expression.ExprParserContext;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprParser
extends Expression {
    public static final int GROUP_TOKEN_OPS = 1;
    public static final int GROUP_TOKEN_VALUE = 2;
    public static final int RESET_TOKEN = 1;
    public static final int OPS_TOKEN = 2;
    public static final int NEGATE_TOKEN = 5;
    public static final int NOT_TOKEN = 6;
    public static final int BRACKET_TOKEN = 9;
    public static final int NUM_TOKEN = 10;
    public static final int STR_TOKEN = 11;
    public static final int VAR_TOKEN = 12;
    public static final int ARR_TOKEN = 13;
    public static final int FUN_TOKEN = 14;
    public static final int BRACKET_END_TOKEN = 20;
    static final int MAX_OPTIMIZE_COUNT = 2049;
    private String exprSource;
    private char[] sourceChars;
    private int offset;
    private int count;
    private int readIndex;
    private boolean findMode;
    private int findEndIndex;
    private String errorMsg;
    private Map<String, ElVariableInvoker> invokes;
    private Map<String, ElVariableInvoker> tailInvokes;
    int variableCount;
    boolean existChain;
    protected int variableSize;
    protected ElInvoker tailChainInvoker;
    protected EvaluatorContextBuilder evaluatorContextBuilder = EvaluatorContextBuilder.EMPTY;
    private int prevTokenType;
    private int tokenType = 1;
    private ElOperator operator;
    private int evaluatorCount;
    private ExprEvaluator exprEvaluator = this.createExprEvaluator();
    private ExprParserContext parserContext = new ExprParserContext();
    private final AtomicInteger cntForCompress = new AtomicInteger(0);
    private boolean compressed = false;
    private static final ThreadLocal<List<String>> localVariableKeys = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    public ExprParser(String exprSource) {
        this.init(exprSource);
        this.parse();
    }

    ExprParser(char[] buffers, int offset, int count) {
        this.init(buffers, offset, count);
        this.parse();
    }

    ExprParser(String exprSource, int offset) {
        this.init(exprSource, offset, exprSource.length() - offset);
        this.findMode = true;
        this.findEndIndex = exprSource.length();
        this.parse();
    }

    protected ExprParser() {
    }

    protected ExprParser global() {
        return this;
    }

    protected Map<String, ElVariableInvoker> getInvokes() {
        return this.invokes;
    }

    protected Map<String, ElVariableInvoker> getTailInvokes() {
        return this.tailInvokes;
    }

    protected ExprEvaluator createExprEvaluator() {
        return new ExprEvaluator();
    }

    @Override
    public String getSource() {
        if (this.findMode) {
            return new String(this.sourceChars, this.offset, this.findEndIndex - this.offset);
        }
        if (this.offset == 0 && this.count == this.sourceChars.length) {
            return this.exprSource;
        }
        return new String(this.sourceChars, this.offset, this.count);
    }

    public int length() {
        return this.count;
    }

    public final int findIndex() {
        return this.findMode ? this.findEndIndex : -1;
    }

    protected ExprEvaluator getEvaluator() {
        return this.exprEvaluator;
    }

    protected final void init(String exprSource) {
        this.init(exprSource, 0, exprSource.length());
    }

    protected final void init(String exprSource, int offset, int count) {
        this.exprSource = exprSource;
        this.sourceChars = ExprParser.getChars(exprSource);
        this.offset = offset;
        this.count = count;
    }

    protected final void init(char[] buffers, int offset, int count) {
        this.sourceChars = buffers;
        this.offset = offset;
        this.count = count;
    }

    protected final void parse() {
        this.parseEvaluator();
        this.displacement(this.exprEvaluator);
        this.merge();
        this.compressVariables();
        this.checkOptimizeRequired();
        this.validate();
    }

    private void checkOptimizeRequired() {
        if (this.evaluatorCount > 2049) {
            this.optimize();
        }
    }

    private void validate() {
        if (this.exprEvaluator == null) {
            throw new ExpressionException("syntax error, input maybe empty");
        }
    }

    private void parseEvaluator() {
        this.parserContext.setContext(this.exprEvaluator, false, false);
        do {
            this.parseNext(this.parserContext);
            ++this.evaluatorCount;
        } while (this.readable());
        this.checkEndTokenSyntaxError(this.tokenType);
    }

    private void checkEndTokenSyntaxError(int tokenType) {
        if (tokenType == 2) {
            String errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unsupported operator ends, Expression[... " + errorMessage + " ]");
        }
    }

    private void merge() {
        if (this.exprEvaluator.evalType == 0) {
            this.exprEvaluator = this.exprEvaluator.left;
        } else {
            ExprParser.mergeLast(this.exprEvaluator);
        }
    }

    static final void mergeLast(ExprEvaluator root) {
        ExprEvaluator rr = root.right;
        if (rr != null && rr.evalType == 0 && rr.left != null) {
            root.right = rr.left;
        }
    }

    final void displacement(ExprEvaluator exprEvaluator) {
        this.displacementChain(exprEvaluator);
        this.displacementChain(exprEvaluator);
    }

    private void displacementChain(ExprEvaluator exprEvaluator) {
        this.parserContext.exprEvaluator = exprEvaluator;
        do {
            this.displacementSplit(this.parserContext);
        } while (this.parserContext.exprEvaluator != null);
    }

    final void displacementSplit(ExprParserContext exprParserContext) {
        ExprEvaluator exprEvaluator = exprParserContext.exprEvaluator;
        if (exprEvaluator == null) {
            return;
        }
        ElOperator exprOperator = exprEvaluator.operator;
        int level = exprOperator.level;
        int evalType = exprEvaluator.evalType;
        ExprEvaluator left = exprEvaluator.left;
        ExprEvaluator right = exprEvaluator.right;
        if (right == null) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        int rLevel = right.operator.level;
        if (rLevel <= 0) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        if (level > rLevel) {
            this.mergeRight(right, level);
            rLevel = right.operator.level;
        }
        int rEvalType = right.evalType;
        ExprEvaluator rLeft = right.left;
        ExprEvaluator rRight = right.right;
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.evalType = evalType;
            newLeft.operator = exprOperator;
            newLeft.negate = exprEvaluator.negate;
            newLeft.logicalNot = exprEvaluator.logicalNot;
            newLeft.left = left;
            newLeft.right = rLeft;
            exprEvaluator.operator = right.operator;
            exprEvaluator.negate = right.negate;
            exprEvaluator.logicalNot = right.logicalNot;
            exprEvaluator.evalType = rEvalType;
            exprEvaluator.left = newLeft;
            exprEvaluator.right = rRight;
        } else {
            if (rLevel == 1) {
                this.displacement(right.right.left);
            }
            exprParserContext.exprEvaluator = right;
        }
    }

    final void mergeRight(ExprEvaluator exprEvaluator, int targetLevel) {
        if (exprEvaluator == null) {
            return;
        }
        int evalType = exprEvaluator.evalType;
        int level = exprEvaluator.operator.level;
        if (level >= targetLevel) {
            return;
        }
        ExprEvaluator left = exprEvaluator.left;
        ExprEvaluator right = exprEvaluator.right;
        if (right == null) {
            return;
        }
        int rLevel = right.operator.level;
        if (rLevel <= 0) {
            return;
        }
        int rEvalType = right.evalType;
        ExprEvaluator rLeft = right.left;
        ExprEvaluator rRight = right.right;
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.evalType = evalType;
            newLeft.operator = exprEvaluator.operator;
            newLeft.negate = exprEvaluator.negate;
            newLeft.logicalNot = exprEvaluator.logicalNot;
            newLeft.left = left;
            newLeft.right = rLeft;
            exprEvaluator.operator = right.operator;
            exprEvaluator.negate = right.negate;
            exprEvaluator.logicalNot = right.logicalNot;
            exprEvaluator.evalType = rEvalType;
            exprEvaluator.left = newLeft;
            exprEvaluator.right = rRight;
            this.mergeRight(exprEvaluator, targetLevel);
        }
    }

    protected void compressVariables() {
        if (this.tailInvokes != null) {
            this.variableSize = this.invokes.size();
            int tailSize = this.tailInvokes.size();
            if (this.variableCount == tailSize || !this.existChain) {
                if (tailSize == 1) {
                    this.evaluatorContextBuilder = new EvaluatorContextBuilder.SingleReusableRootImpl((ElVariableInvoker)this.tailChainInvoker);
                } else if (tailSize == 2) {
                    Iterator<ElVariableInvoker> iterator = this.invokes.values().iterator();
                    this.evaluatorContextBuilder = new EvaluatorContextBuilder.SibbingTwinsRootReusableImpl(iterator.next(), iterator.next());
                } else if (this.variableCount == tailSize) {
                    this.evaluatorContextBuilder = new EvaluatorContextBuilder.ReusablelessRootImpl();
                } else {
                    ElVariableInvoker[] arr = new ElVariableInvoker[tailSize];
                    int len = 0;
                    for (ElVariableInvoker variableInvoker : this.invokes.values()) {
                        arr[len++] = variableInvoker;
                    }
                    this.evaluatorContextBuilder = new EvaluatorContextBuilder.SibbingRootReusableImpl(arr);
                }
            } else if (tailSize == 1) {
                this.evaluatorContextBuilder = new EvaluatorContextBuilder.SingleReusableImpl(this.tailChainInvoker);
            } else {
                Collection<ElVariableInvoker> values = this.tailInvokes.values();
                if (tailSize == 2) {
                    Iterator<ElVariableInvoker> iterator = values.iterator();
                    ElVariableInvoker one = iterator.next();
                    ElVariableInvoker next = iterator.next();
                    this.evaluatorContextBuilder = one.parent == next.parent ? new EvaluatorContextBuilder.SibbingTwinsReusableImpl(one.parent, one, next) : new EvaluatorContextBuilder.GeneralReusableImpl(ElChainVariableInvoker.buildTailChainInvoker(this.tailInvokes), this.variableSize);
                } else {
                    ElVariableInvoker tailParent = null;
                    boolean sibbingMode = true;
                    for (ElVariableInvoker variableInvoker : values) {
                        if (!sibbingMode) continue;
                        if (variableInvoker.parent == null) {
                            sibbingMode = false;
                            continue;
                        }
                        if (tailParent == null) {
                            tailParent = variableInvoker.parent;
                            continue;
                        }
                        if (tailParent == variableInvoker.parent) continue;
                        sibbingMode = false;
                    }
                    this.evaluatorContextBuilder = sibbingMode ? new EvaluatorContextBuilder.SibbingReusableImpl(tailParent, ElChainVariableInvoker.buildTailChainInvoker(this.tailInvokes), this.variableSize) : new EvaluatorContextBuilder.GeneralReusableImpl(ElChainVariableInvoker.buildTailChainInvoker(this.tailInvokes), this.variableSize);
                }
            }
        }
    }

    public final Collection<ElVariableInvoker> getTailVariableInvokers() {
        return this.tailInvokes == null ? new ArrayList<ElVariableInvoker>() : new ArrayList<ElVariableInvoker>(this.tailInvokes.values());
    }

    @Override
    public final List<String> getVariables() {
        if (this.variableSize > 0) {
            return new ArrayList<String>(this.tailInvokes.keySet());
        }
        return new ArrayList<String>();
    }

    @Override
    public final List<String> getRootVariables() {
        if (this.variableSize > 0) {
            ArrayList<String> variables = new ArrayList<String>();
            Set<Map.Entry<String, ElVariableInvoker>> entrySet = this.invokes.entrySet();
            for (Map.Entry<String, ElVariableInvoker> entry : entrySet) {
                if (entry.getValue().parent != null) continue;
                variables.add(entry.getKey());
            }
            return variables;
        }
        return new ArrayList<String>();
    }

    private void parseOpsToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        evaluator.evalType = 1;
        ExprEvaluator right = this.createExprEvaluator();
        if (this.operator == ElOperator.MINUS) {
            evaluator.operator = ElOperator.PLUS;
            negate = true;
        } else {
            evaluator.operator = this.operator;
        }
        evaluator.right = right;
        exprParserContext.setContext(right, negate, logicalNot);
    }

    private void parseVarToken(ExprParserContext exprParserContext, char startChar, String identifierValue, List<String> variableKeys) {
        ElVariableInvoker variableInvoker;
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        if (identifierValue != null) {
            switch (startChar) {
                case 't': {
                    if (!"true".equals(identifierValue)) break;
                    evaluator.left = new ExprEvaluator.ConstantImpl(!logicalNot);
                    exprParserContext.setContext(evaluator, false, false);
                    return;
                }
                case 'f': {
                    if (!"false".equals(identifierValue)) break;
                    evaluator.left = new ExprEvaluator.ConstantImpl(logicalNot);
                    exprParserContext.setContext(evaluator, false, false);
                    return;
                }
                case 'n': {
                    if (!"null".equals(identifierValue)) break;
                    evaluator.left = new ExprEvaluator.ConstantImpl(null);
                    exprParserContext.setContext(evaluator, false, false);
                    return;
                }
            }
        }
        this.checkInitializedInvokes();
        ExprEvaluator.VariableImpl left = new ExprEvaluator.VariableImpl();
        left.negate = negate;
        left.logicalNot = logicalNot;
        if (identifierValue == null) {
            variableInvoker = ElVariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes());
            this.global().variableCount += variableKeys.size();
            this.global().existChain = true;
        } else {
            variableInvoker = ElVariableUtils.buildRoot(identifierValue, this.getInvokes(), this.getTailInvokes());
            ++this.global().variableCount;
        }
        this.global().tailChainInvoker = variableInvoker;
        left.variableInvoker = variableInvoker;
        evaluator.left = left;
        exprParserContext.setContext(evaluator, false, false);
    }

    void checkInitializedInvokes() {
        if (this.invokes == null) {
            this.invokes = new HashMap<String, ElVariableInvoker>();
            this.tailInvokes = new HashMap<String, ElVariableInvoker>();
        }
    }

    static final void parseNumToken(ExprParserContext exprParserContext, Number numberValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        evaluator.left = new ExprEvaluator.ConstantImpl(numberValue);
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseBracketToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator bracketChild = this.createExprEvaluator();
        ExprParserContext bracketParserContext = new ExprParserContext(bracketChild, false, false);
        bracketParserContext.bracketMode = true;
        do {
            this.parseNext(bracketParserContext);
        } while (this.readable() && !bracketParserContext.bracketEndFlag);
        if (!bracketParserContext.bracketEndFlag) {
            String errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", missing closing symbol ')'" + ", Expression[... " + errorMessage + " ]");
        }
        this.displacementChain(bracketChild);
        ExprParser.mergeLast(bracketChild);
        ExprEvaluator bracketEvaluator = this.createExprEvaluator();
        bracketEvaluator.negate(negate).setLogicalNot(logicalNot);
        bracketEvaluator.evalType = 5;
        bracketEvaluator.operator = ElOperator.BRACKET;
        bracketEvaluator.right = bracketChild;
        evaluator.left = bracketEvaluator;
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseQuestionToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        evaluator.operator = ElOperator.QUESTION;
        evaluator.evalType = 4;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator questionChild = this.createExprEvaluator();
        ExprParserContext questionParserContext = new ExprParserContext(questionChild, false, false);
        questionParserContext.questionMode = true;
        do {
            this.parseNext(questionParserContext);
        } while (this.readable() && !questionParserContext.questionEndFlag);
        if (!questionParserContext.questionEndFlag) {
            String errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", missing symbol ':'" + ", Expression[... " + errorMessage + " ]");
        }
        this.displacementChain(questionChild);
        ExprParser.mergeLast(questionChild);
        ExprEvaluator colonChild = this.createExprEvaluator();
        exprParserContext.setContext(colonChild, false, false);
        do {
            this.parseNext(exprParserContext);
        } while (this.readable() && !exprParserContext.questionEndFlag && !exprParserContext.bracketEndFlag);
        this.displacementChain(colonChild);
        ExprParser.mergeLast(colonChild);
        ExprEvaluator questionColonEvaluator = this.createExprEvaluator();
        questionColonEvaluator.evalType = 1;
        questionColonEvaluator.negate(negate).setLogicalNot(logicalNot);
        questionColonEvaluator.left = questionChild;
        questionColonEvaluator.right = colonChild;
        ExprEvaluator next = this.createExprEvaluator();
        next.left = questionColonEvaluator;
        evaluator.right = next;
        exprParserContext.setContext(next, false, false);
    }

    static final void parseStrToken(ExprParserContext exprParserContext, String strValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(strValue);
        left.negate = negate;
        left.logicalNot = logicalNot;
        evaluator.left = left;
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseArrToken(ExprParserContext exprParserContext, String arrStr) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator left = this.createExprEvaluator();
        left.negate = negate;
        left.logicalNot = logicalNot;
        left.setArrayValue(arrStr);
        evaluator.left = left;
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseFunToken(ExprParserContext exprParserContext, String functionName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.FunctionImpl left = new ExprEvaluator.FunctionImpl();
        left.negate = negate;
        left.logicalNot = logicalNot;
        left.setFunction(functionName, args, this.global());
        evaluator.left = left;
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseMethodToken(ExprParserContext exprParserContext, List<String> variableKeys, String methodName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        this.checkInitializedInvokes();
        ExprEvaluator.MethodImpl left = new ExprEvaluator.MethodImpl();
        left.negate = negate;
        left.logicalNot = logicalNot;
        ElVariableInvoker variableInvoker = ElVariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes());
        this.global().tailChainInvoker = variableInvoker;
        int kl = variableKeys.size();
        this.global().variableCount += kl;
        if (kl > 1) {
            this.global().existChain = true;
        }
        left.setMethod(variableInvoker, methodName, args, this.global());
        evaluator.left = left;
        exprParserContext.setContext(evaluator, false, false);
    }

    static final void parseNegateToken(ExprParserContext exprParserContext) {
        boolean negate = exprParserContext.negate;
        exprParserContext.negate = !negate;
    }

    static final void parseNotToken(ExprParserContext exprParserContext) {
        boolean logicalNot = exprParserContext.logicalNot;
        exprParserContext.logicalNot = !logicalNot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNext(ExprParserContext exprParserContext) {
        block127: {
            block132: {
                block133: {
                    block135: {
                        block136: {
                            block126: {
                                block137: {
                                    block143: {
                                        block144: {
                                            block141: {
                                                block142: {
                                                    block140: {
                                                        block139: {
                                                            block138: {
                                                                block130: {
                                                                    block134: {
                                                                        block131: {
                                                                            this.resetToken();
                                                                            currentChar = '\u0000';
                                                                            while (this.readable() && ExprParser.isWhitespace(currentChar = this.read())) {
                                                                                ++this.readIndex;
                                                                            }
                                                                            if (this.isEnd()) {
                                                                                this.checkEndTokenSyntaxError(this.prevTokenType);
                                                                                return;
                                                                            }
                                                                            isMinusSymbol = false;
                                                                            if (!NumberUtils.isDigit(currentChar) && !(isMinusSymbol = currentChar == '-') || this.prevTokenType >= 10) break block130;
                                                                            begin = this.readIndex++;
                                                                            cnt = 0;
                                                                            readIndex = this.readIndex;
                                                                            numberRadix = 10;
                                                                            firstDigitChar = '\u0000';
                                                                            secondeDigitChar = '\u0000';
                                                                            if (isMinusSymbol) {
                                                                                if (readIndex + 1 < this.length()) {
                                                                                    firstDigitChar = this.read(readIndex++);
                                                                                    secondeDigitChar = this.read(readIndex++);
                                                                                }
                                                                            } else {
                                                                                firstDigitChar = currentChar;
                                                                                if (readIndex < this.length()) {
                                                                                    secondeDigitChar = this.read(readIndex++);
                                                                                }
                                                                            }
                                                                            decimalVal = 0L;
                                                                            valInitSet = false;
                                                                            hexOrOctVal = 0L;
                                                                            if (firstDigitChar == '0') {
                                                                                if (secondeDigitChar == 'x' || secondeDigitChar == 'X') {
                                                                                    numberRadix = 16;
                                                                                    this.readIndex = readIndex;
                                                                                    ++cnt;
                                                                                    while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 16)) != -1) {
                                                                                        hexOrOctVal = hexOrOctVal << 4 | (long)val;
                                                                                        ++this.readIndex;
                                                                                        ++cnt;
                                                                                    }
                                                                                    if (currentChar == 'l' || currentChar == 'L') {
                                                                                        ++this.readIndex;
                                                                                    }
                                                                                } else if (NumberUtils.isDigit(secondeDigitChar)) {
                                                                                    numberRadix = 8;
                                                                                    this.readIndex = readIndex;
                                                                                    hexOrOctVal = ExprParser.digit(secondeDigitChar, 8);
                                                                                    ++cnt;
                                                                                    while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 8)) != -1) {
                                                                                        hexOrOctVal = hexOrOctVal << 3 | (long)val;
                                                                                        ++this.readIndex;
                                                                                        ++cnt;
                                                                                    }
                                                                                    switch (currentChar) {
                                                                                        case '.': 
                                                                                        case 'D': 
                                                                                        case 'E': 
                                                                                        case 'F': 
                                                                                        case 'd': 
                                                                                        case 'e': 
                                                                                        case 'f': {
                                                                                            numberRadix = 10;
                                                                                            decimalVal = hexOrOctVal;
                                                                                            valInitSet = true;
                                                                                            break;
                                                                                        }
                                                                                        case 'L': 
                                                                                        case 'l': {
                                                                                            ++this.readIndex;
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            mode = 0;
                                                                            specifySuffix = 0;
                                                                            expValue = 0;
                                                                            expNegative = false;
                                                                            decimalCount = 0;
                                                                            if (numberRadix == 10) {
                                                                                if (!isMinusSymbol && !valInitSet) {
                                                                                    ++cnt;
                                                                                    decimalVal = currentChar & 15;
                                                                                }
                                                                                while (this.readable() && NumberUtils.isDigit(currentChar = this.read())) {
                                                                                    decimalVal = decimalVal * 10L + (long)(currentChar & 15);
                                                                                    ++this.readIndex;
                                                                                    ++cnt;
                                                                                }
                                                                                if (currentChar == '.') {
                                                                                    ++this.readIndex;
                                                                                    mode = 1;
                                                                                    while (this.readable() && NumberUtils.isDigit(currentChar = this.read())) {
                                                                                        decimalVal = decimalVal * 10L + (long)(currentChar & 15);
                                                                                        ++decimalCount;
                                                                                        ++cnt;
                                                                                        ++this.readIndex;
                                                                                    }
                                                                                }
                                                                                if (currentChar == 'E' || currentChar == 'e') {
                                                                                    mode = 2;
                                                                                    ++this.readIndex;
                                                                                    try {
                                                                                        currentChar = this.read();
                                                                                        expNegative = currentChar == '-';
                                                                                        if (expNegative || currentChar == '+') {
                                                                                            ++this.readIndex;
                                                                                            currentChar = this.read();
                                                                                        }
                                                                                        if (NumberUtils.isDigit(currentChar)) {
                                                                                            expValue = currentChar & 15;
                                                                                            ++this.readIndex;
                                                                                            while (this.readable() && NumberUtils.isDigit(currentChar = this.read())) {
                                                                                                expValue = (expValue << 3) + (expValue << 1) + (currentChar & 15);
                                                                                                ++this.readIndex;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (RuntimeException throwable) {
                                                                                        errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                                                                        throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[... " + errorMessage + " ]");
                                                                                    }
                                                                                }
                                                                                switch (currentChar) {
                                                                                    case 'L': 
                                                                                    case 'l': {
                                                                                        specifySuffix = 1;
                                                                                        ++this.readIndex;
                                                                                        break;
                                                                                    }
                                                                                    case 'F': 
                                                                                    case 'f': {
                                                                                        specifySuffix = 2;
                                                                                        ++this.readIndex;
                                                                                        break;
                                                                                    }
                                                                                    case 'D': 
                                                                                    case 'd': {
                                                                                        specifySuffix = 3;
                                                                                        ++this.readIndex;
                                                                                        break;
                                                                                    }
                                                                                    case '$': {
                                                                                        specifySuffix = 4;
                                                                                        ++this.readIndex;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                value = decimalVal;
                                                                            } else {
                                                                                value = hexOrOctVal;
                                                                                decimalVal = hexOrOctVal;
                                                                            }
                                                                            if (cnt == 0 && isMinusSymbol) {
                                                                                switch (this.prevTokenType) {
                                                                                    case 1: 
                                                                                    case 2: 
                                                                                    case 9: {
                                                                                        this.tokenType = 5;
                                                                                        this.checkTokenSyntaxError();
                                                                                        ExprParser.parseNegateToken(exprParserContext);
                                                                                        return;
                                                                                    }
                                                                                }
                                                                                this.tokenType = 2;
                                                                                this.operator = ElOperator.MINUS;
                                                                                this.checkTokenSyntaxError();
                                                                                this.parseOpsToken(exprParserContext);
                                                                                return;
                                                                            }
                                                                            this.tokenType = 10;
                                                                            overflow = cnt > 19 || decimalVal < 0L;
                                                                            negate = exprParserContext.negate ^ isMinusSymbol;
                                                                            if (mode != 0 || overflow) break block131;
                                                                            if (negate) {
                                                                                value = -value;
                                                                            }
                                                                            numberValue /* !! */  = specifySuffix == 0 ? (value >= -9.223372036854776E18 && value <= 9.223372036854776E18 ? Long.valueOf((long)value) : Double.valueOf(value)) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : (specifySuffix == 4 ? BigDecimal.valueOf((long)value) : Double.valueOf(value))));
                                                                            break block132;
                                                                        }
                                                                        if (!overflow) break block133;
                                                                        if (specifySuffix != 4) break block134;
                                                                        numberValue /* !! */  = this.createBigDecimal(begin, this.readIndex - 1, negate);
                                                                        break block132;
                                                                    }
                                                                    decimalVal = 0L;
                                                                    cnt = 0;
                                                                    decimalPointIndex = this.readIndex;
                                                                    decimalCount = 0;
                                                                    break block135;
                                                                }
                                                                if (this.prevTokenType <= 2 || (elOperator = this.getOperator(currentChar)) == null) break block136;
                                                                firstMatchChar = currentChar;
                                                                ++this.readIndex;
                                                                this.tokenType = 2;
                                                                if (!this.readable() || ExprParser.isWhitespace(currentChar = this.read())) break block137;
                                                                if (elOperator != ElOperator.MULTI) break block138;
                                                                if (currentChar == '*') {
                                                                    this.operator = ElOperator.EXP;
                                                                    ++this.readIndex;
                                                                }
                                                                break block126;
                                                            }
                                                            if (elOperator != ElOperator.AND) break block139;
                                                            if (currentChar == '&') {
                                                                ++this.readIndex;
                                                                this.operator = ElOperator.LOGICAL_AND;
                                                            }
                                                            break block126;
                                                        }
                                                        if (elOperator != ElOperator.OR) break block140;
                                                        if (currentChar == '|') {
                                                            ++this.readIndex;
                                                            this.operator = ElOperator.LOGICAL_OR;
                                                        }
                                                        break block126;
                                                    }
                                                    if (elOperator == ElOperator.NOT) {
                                                        if (currentChar == '=') {
                                                            ++this.readIndex;
                                                            this.operator = ElOperator.NE;
                                                            break block126;
                                                        } else {
                                                            if (currentChar == '!') {
                                                                this.tokenType = 6;
                                                                this.checkTokenSyntaxError();
                                                                ExprParser.parseNotToken(exprParserContext);
                                                                return;
                                                            }
                                                            if (this.getOperator(currentChar) != null) {
                                                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                                                this.throwSyntaxError();
                                                            }
                                                            this.tokenType = 6;
                                                            this.checkTokenSyntaxError();
                                                            ExprParser.parseNotToken(exprParserContext);
                                                            return;
                                                        }
                                                    }
                                                    if (elOperator != ElOperator.GT) break block141;
                                                    if (currentChar != '>') break block142;
                                                    ++this.readIndex;
                                                    this.operator = ElOperator.BIT_RIGHT;
                                                    break block126;
                                                }
                                                if (currentChar == '=') {
                                                    ++this.readIndex;
                                                    this.operator = ElOperator.GE;
                                                    break block126;
                                                } else if (this.getOperator(currentChar) != null) {
                                                    this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                                    this.throwSyntaxError();
                                                }
                                                break block126;
                                            }
                                            if (elOperator != ElOperator.LT) break block143;
                                            if (currentChar != '<') break block144;
                                            ++this.readIndex;
                                            this.operator = ElOperator.BIT_LEFT;
                                            break block126;
                                        }
                                        if (currentChar == '=') {
                                            ++this.readIndex;
                                            this.operator = ElOperator.LE;
                                            break block126;
                                        } else if (this.getOperator(currentChar) != null) {
                                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                            this.throwSyntaxError();
                                        }
                                        break block126;
                                    }
                                    if (elOperator == ElOperator.EQ) {
                                        if (currentChar == '=') {
                                            ++this.readIndex;
                                            this.operator = ElOperator.EQ;
                                            break block126;
                                        } else {
                                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                            this.throwSyntaxError();
                                        }
                                    }
                                    break block126;
                                }
                                if (elOperator == ElOperator.EQ) {
                                    this.errorMsg = String.valueOf(firstMatchChar);
                                    readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", '=' is not supported, please use '==' instead, Expression[" + readSource + "]");
                                }
                            }
                            this.checkOpsTokenSyntaxError();
                            this.parseOpsToken(exprParserContext);
                            return;
                        }
                        if (this.isBracketSymbol(currentChar)) {
                            this.operator = ElOperator.BRACKET;
                            ++this.readIndex;
                            if (currentChar == '(') {
                                this.tokenType = 9;
                                this.checkBeforeBracketTokenSyntaxError();
                                this.parseBracketToken(exprParserContext);
                                return;
                            }
                            this.tokenType = 20;
                            if (!exprParserContext.bracketMode) {
                                this.errorMsg = ")";
                                this.throwSyntaxError();
                            }
                            this.checkBeforeBracketEndTokenSyntaxError();
                            exprParserContext.bracketEndFlag = true;
                            return;
                        }
                        if (this.isQuestionColon(currentChar)) {
                            ++this.readIndex;
                            this.tokenType = 2;
                            if (currentChar == '?') {
                                this.checkBeforeQuestionTokenSyntaxError();
                                this.parseQuestionToken(exprParserContext);
                                return;
                            }
                            if (!exprParserContext.questionMode) {
                                this.errorMsg = ":";
                                this.throwSyntaxError();
                            }
                            this.checkBeforeColonTokenSyntaxError();
                            exprParserContext.questionEndFlag = true;
                            return;
                        }
                        if (ExprParser.isIdentifierStart(currentChar)) {
                            if (this.prevTokenType >= 10) {
                                this.errorMsg = String.valueOf(currentChar);
                                this.throwSyntaxError();
                                return;
                            }
                            start = this.readIndex++;
                            startChar = currentChar;
                            localOffset = start;
                            variableKeys = this.getLocalVariableKeys();
                            ** try [egrp 1[TRYBLOCK] [1 : 2410->3182)] { 
lbl283:
                            // 1 sources

                        } else {
                            if (currentChar == '!') {
                                ++this.readIndex;
                                this.tokenType = 6;
                                ExprParser.parseNotToken(exprParserContext);
                                return;
                            }
                            if (currentChar == '\'') {
                                start = this.readIndex + 1;
                                this.scanString();
                                this.tokenType = 11;
                                this.checkTokenSyntaxError();
                                ExprParser.parseStrToken(exprParserContext, new String(this.sourceChars, this.offset + start, this.readIndex - start));
                                ++this.readIndex;
                                return;
                            }
                            if (currentChar == '{') {
                                start = ++this.readIndex;
                                while (this.readable() && (currentChar = this.read()) != '}') {
                                    ++this.readIndex;
                                    if (this.readIndex < this.length()) continue;
                                }
                                if (currentChar != '}') {
                                    errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'{'\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '}'");
                                }
                                this.tokenType = 13;
                                this.checkTokenSyntaxError();
                                this.parseArrToken(exprParserContext, new String(this.sourceChars, start + this.offset, this.readIndex - start));
                                ++this.readIndex;
                                return;
                            }
                            if (currentChar == '@') {
                                ++this.readIndex;
                                start = this.readIndex++;
                                if (this.readable() && !Character.isJavaIdentifierStart(currentChar = this.read())) {
                                    errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ], unexpected function start char  : '" + currentChar + "'");
                                }
                                while (this.readable() && ExprParser.isIdentifierAppend(currentChar = this.read())) {
                                    ++this.readIndex;
                                    if (this.readIndex < this.length()) continue;
                                }
                                while (this.readable() && ExprParser.isWhitespace(currentChar = this.read())) {
                                    ++this.readIndex;
                                }
                                if (currentChar != '(') {
                                    readSource = new String(this.exprSource.substring(0, this.readIndex));
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", source: '" + readSource + "' function start symbol '(' not found !");
                                }
                                functionName = new String(this.sourceChars, start + this.offset, this.readIndex - start);
                                start = ++this.readIndex;
                                bracketCount = 1;
                                break block127;
                            } else {
                                if (currentChar == '.' && this.prevTokenType == 14) {
                                    throw new UnsupportedOperationException("currently, it is not supported to access method return values as variables or method call handles");
                                }
                                if (currentChar == '+' && this.prevTokenType == 1) {
                                    ++this.readIndex;
                                    this.tokenType = 2;
                                    return;
                                }
                                if (this.prevTokenType != 2 && this.findMode) {
                                    this.endFind();
                                    return;
                                }
                                errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[... " + errorMessage + " ]");
                            }
                        }
                    }
                    for (j = begin; j < this.readIndex; ++j) {
                        c = this.sourceChars[this.offset + j];
                        if (NumberUtils.isDigit(c)) {
                            if (cnt++ < 18) {
                                decimalVal = decimalVal * 10L + (long)(c & 15);
                            }
                            if (j > decimalPointIndex) {
                                ++decimalCount;
                            }
                        } else if (c == '.') {
                            decimalPointIndex = j;
                        } else if (c == 'e' || c == 'E') break;
                        if (cnt >= 18 && decimalCount > 0) break;
                    }
                    decimalCount -= cnt - 18;
                }
                v0 = expValue = expNegative != false ? -expValue - decimalCount : expValue - decimalCount;
                if (specifySuffix == 4) {
                    numberValue /* !! */  = BigDecimal.valueOf(negate != false ? -decimalVal : decimalVal, -expValue);
                } else {
                    value = NumberUtils.scientificToIEEEDouble(decimalVal, -expValue);
                    if (negate) {
                        value = -value;
                    }
                    numberValue /* !! */  = specifySuffix == 0 ? Double.valueOf(value) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : Double.valueOf(value)));
                }
            }
            this.checkValueTokenSyntaxError();
            ExprParser.parseNumToken(exprParserContext, numberValue /* !! */ );
            return;
            {
                block128: {
                    block129: {
                        block30: while (true) {
                            if (this.readable() && ExprParser.isVariableAppend(currentChar = this.read())) {
                                ++this.readIndex;
                                continue;
                            }
                            if (currentChar == '.') {
                                if (this.readIndex == localOffset) {
                                    errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[... " + errorMessage + " ]");
                                }
                                variableKeys.add(ExprParserContext.getString(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                                localOffset = ++this.readIndex;
                                continue;
                            }
                            if (currentChar != '[') break block128;
                            if (this.readIndex == localOffset) {
                                errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[... " + errorMessage + " ]");
                            }
                            variableKeys.add(new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                            localOffset = ++this.readIndex;
                            while (true) {
                                cnt = 1;
                                stringKey = true;
                                while (this.readable()) {
                                    currentChar = this.read();
                                    if (currentChar <= ' ') {
                                        ++this.readIndex;
                                        continue;
                                    }
                                    if (currentChar == '\'') {
                                        this.scanString();
                                        ++this.readIndex;
                                        while (this.readable() && (currentChar = this.read()) <= ' ') {
                                            ++this.readIndex;
                                        }
                                        if (currentChar != ']' || cnt != 1) continue;
                                        break;
                                    }
                                    stringKey = false;
                                    if (currentChar == ']') {
                                        --cnt;
                                    } else if (currentChar == '[') {
                                        ++cnt;
                                    }
                                    if (cnt == 0) break;
                                    ++this.readIndex;
                                }
                                if (currentChar != ']') {
                                    errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", missing closing symbol ']', Expression[... " + errorMessage + " ]");
                                }
                                identifierValue = null;
                                if (stringKey) {
                                    et = this.readIndex + this.offset;
                                    for (st = localOffset + this.offset; st < et && this.sourceChars[st] <= ' '; ++st) {
                                    }
                                    while (st < et && this.sourceChars[et - 1] <= ' ') {
                                        --et;
                                    }
                                    identifierValue = ExprParserContext.getString(this.sourceChars, st + 1, et - st - 2);
                                } else {
                                    chars = new char[this.readIndex - localOffset + 2];
                                    chars[0] = 40;
                                    chars[chars.length - 1] = 41;
                                    System.arraycopy(this.sourceChars, localOffset + this.offset, chars, 1, chars.length - 2);
                                    identifierValue = new String(chars);
                                }
                                ++this.readIndex;
                                if (!this.readable()) break block129;
                                currentChar = this.read();
                                if (currentChar == '.') {
                                    variableKeys.add(identifierValue);
                                    localOffset = ++this.readIndex;
                                    continueOuterLoop = true;
                                    if (continueOuterLoop) {
                                        continue block30;
                                    }
                                    break block128;
                                }
                                if (currentChar != '[') break block30;
                                variableKeys.add(identifierValue);
                                localOffset = ++this.readIndex;
                            }
                            break;
                        }
                        if (currentChar == '(') {
                            this.handleParseFunctionToken(identifierValue, false, variableKeys, exprParserContext);
                            return;
                        }
                    }
                    variableKeys.add(identifierValue);
                    this.tokenType = 12;
                    this.checkValueTokenSyntaxError();
                    this.parseVarToken(exprParserContext, startChar, null, variableKeys);
                    return;
                }
                if (this.readIndex == localOffset) {
                    errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[... " + errorMessage + " ]");
                }
                identifierValue = ExprParserContext.getString(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset);
                v1 = oneLevelAccess = localOffset == start;
                if (currentChar == '(') {
                    this.handleParseFunctionToken(identifierValue, oneLevelAccess, variableKeys, exprParserContext);
                    return;
                }
                if (oneLevelAccess) {
                    var = identifierValue;
                } else {
                    variableKeys.add(identifierValue);
                    var = null;
                }
                this.tokenType = 12;
                this.checkValueTokenSyntaxError();
                this.parseVarToken(exprParserContext, startChar, var, variableKeys);
                return;
            }
lbl476:
            // 1 sources

            finally {
                variableKeys.clear();
            }
        }
        while (this.readable()) {
            currentChar = this.read();
            if (currentChar == '\'') {
                this.scanString();
                ++this.readIndex;
                continue;
            }
            ++this.readIndex;
            if (currentChar == ')') {
                --bracketCount;
            } else if (currentChar == '(') {
                ++bracketCount;
            }
            if (bracketCount != 0) continue;
        }
        args = new String(this.sourceChars, start + this.offset, this.readIndex - start - 1);
        this.tokenType = 14;
        this.checkTokenSyntaxError();
        this.parseFunToken(exprParserContext, functionName, args);
    }

    protected final Number createBigDecimal(int beginIndex, int endIndex, boolean negate) {
        BigDecimal value = new BigDecimal(this.sourceChars, this.offset + beginIndex, endIndex - beginIndex);
        return negate ? value.negate() : value;
    }

    private void handleParseFunctionToken(String identifierValue, boolean oneLevelAccess, List<String> variableKeys, ExprParserContext exprParserContext) {
        int localOffset = ++this.readIndex;
        int bracketCount = 1;
        char currentChar = '\u0000';
        while (this.readable()) {
            currentChar = this.read();
            if (currentChar == '\'') {
                this.scanString();
                ++this.readIndex;
                continue;
            }
            ++this.readIndex;
            if (currentChar == ')') {
                --bracketCount;
            } else if (currentChar == '(') {
                ++bracketCount;
            }
            if (bracketCount != 0) continue;
        }
        if (currentChar != ')') {
            String errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",Expression[... " + errorMessage + " ], end token ')' not found !");
        }
        String args = new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset - 1);
        this.tokenType = 14;
        this.checkValueTokenSyntaxError();
        if (oneLevelAccess) {
            this.parseFunToken(exprParserContext, identifierValue, args);
        } else {
            this.parseMethodToken(exprParserContext, variableKeys, identifierValue, args);
        }
    }

    protected List<String> getLocalVariableKeys() {
        return localVariableKeys.get();
    }

    private void scanString() {
        int currentChar = 0;
        ++this.readIndex;
        int prevCh = 0;
        while (this.readable()) {
            char c = this.read();
            currentChar = c;
            if (c == '\'' && prevCh != 92) break;
            ++this.readIndex;
            prevCh = currentChar;
        }
        if (currentChar != 39 || prevCh == 92) {
            String errorMessage = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'''\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '''");
        }
    }

    final boolean readable() {
        return this.readIndex < this.count;
    }

    final boolean isEnd() {
        return this.readIndex >= this.count;
    }

    final char read() {
        return this.sourceChars[this.offset + this.readIndex];
    }

    final void endFind() {
        this.findEndIndex = this.offset + this.readIndex;
        this.readIndex = this.count;
    }

    final char read(int index) {
        return this.sourceChars[this.offset + index];
    }

    static final int getTokenTypeGroup(int tokenType) {
        switch (tokenType) {
            case 2: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 2;
            }
        }
        return 0;
    }

    private void checkValueTokenSyntaxError() {
        if (this.prevTokenType == 20) {
            String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", value cannot appear after the closing bracket, Expression[" + readSource + "]");
        }
    }

    private void checkOpsTokenSyntaxError() {
        if (this.prevTokenType == 9) {
            String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unsupported operation symbols follow '(' , Expression[" + readSource + "]");
        }
    }

    private void checkTokenSyntaxError() {
        int groupValue;
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (preGroupValue == (groupValue = ExprParser.getTokenTypeGroup(this.tokenType))) {
            if (preGroupValue == 1) {
                String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", duplicate token operation, Expression[" + readSource + "]");
            }
            if (preGroupValue == 2) {
                String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", missing operation symbol, Expression[" + readSource + "]");
            }
        } else {
            if (groupValue == 2 && this.prevTokenType == 20) {
                String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", value cannot appear after the closing bracket, Expression[" + readSource + "]");
            }
            if (groupValue == 1 && this.prevTokenType == 9) {
                String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unsupported operation symbols follow '(' , Expression[" + readSource + "]");
            }
        }
    }

    private void checkBeforeBracketEndTokenSyntaxError() {
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 9 || preGroupValue == 1) {
            String readSource = this.createErrorContextText(this.sourceChars, --this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected symbol : ')', Expression[" + readSource + "]");
        }
    }

    private void checkBeforeBracketTokenSyntaxError() {
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 20 || preGroupValue == 2) {
            String readSource = this.createErrorContextText(this.sourceChars, --this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",unexpected symbol : '(', Expression[" + readSource + "]");
        }
    }

    private void checkBeforeColonTokenSyntaxError() {
    }

    private void checkBeforeQuestionTokenSyntaxError() {
    }

    private void throwSyntaxError() {
        if (this.findMode) {
            this.endFind();
        } else {
            this.throwUnsupportedError();
        }
    }

    private void throwUnsupportedError() {
        String readSource = this.createErrorContextText(this.sourceChars, this.readIndex);
        throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected symbol '" + this.errorMsg + "', Expression[" + readSource + "]");
    }

    static final boolean isWhitespace(char c) {
        return c <= ' ';
    }

    static final boolean isIdentifierStart(char c) {
        return c == '_' || c == '$' || Character.isLetter(c);
    }

    static final boolean isIdentifierAppend(char c) {
        return c == '_' || c == '$' || c == '.' || Character.isLetter(c) || NumberUtils.isDigit(c);
    }

    static final boolean isVariableAppend(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        if (c <= ' ') {
            return false;
        }
        return c == '_' || c == '$' || NumberUtils.isDigit(c);
    }

    static final int digit(char c, int numberRadix) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
        }
        if (numberRadix == 16) {
            if (c >= 'a' && c <= 'f') {
                return c - 87;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 55;
            }
        }
        return -1;
    }

    private void resetToken() {
        this.prevTokenType = this.tokenType;
        this.tokenType = 1;
        this.operator = ElOperator.ATOM;
    }

    private ElOperator getOperator(char symbol) {
        if (symbol >= ElOperator.INDEXS_OPERATORS.length) {
            if (symbol == '\u2208') {
                this.operator = ElOperator.IN;
                return this.operator;
            }
            if (symbol == '\u2209') {
                this.operator = ElOperator.OUT;
                return this.operator;
            }
            return null;
        }
        ElOperator elOperator = ElOperator.INDEXS_OPERATORS[symbol];
        if (elOperator != null) {
            this.operator = elOperator;
        }
        return elOperator;
    }

    final boolean isBracketSymbol(char c) {
        return c == '(' || c == ')';
    }

    final boolean isQuestionColon(char c) {
        return c == '?' || c == ':';
    }

    @Override
    public Object evaluate() {
        return this.doEvaluate(EvaluatorContext.EMPTY, EvaluateEnvironment.DEFAULT);
    }

    @Override
    public Object evaluate(Object context) {
        if (context instanceof EvaluateEnvironment) {
            return this.evaluate((EvaluateEnvironment)context);
        }
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(context), EvaluateEnvironment.DEFAULT);
    }

    @Override
    public final Object evaluate(Map context, long timeout) {
        return this.evaluate(context);
    }

    @Override
    public final Object evaluate(Object context, long timeout) {
        return this.evaluate(context);
    }

    @Override
    public final Object evaluate(Map context) {
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(context), EvaluateEnvironment.DEFAULT);
    }

    @Override
    public final Object evaluate(Map context, EvaluateEnvironment evaluateEnvironment) {
        if (this.variableSize == 0) {
            return this.doEvaluate(EvaluatorContext.EMPTY, evaluateEnvironment);
        }
        if (evaluateEnvironment.computable) {
            return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(evaluateEnvironment.computedVariables(context)), evaluateEnvironment);
        }
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(context), evaluateEnvironment);
    }

    final Object evaluateInternal(Map context, EvaluateEnvironment evaluateEnvironment) {
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(context), evaluateEnvironment);
    }

    @Override
    public final Object evaluate(Object context, EvaluateEnvironment evaluateEnvironment) {
        if (this.variableSize > 0 && evaluateEnvironment.computable) {
            context = evaluateEnvironment.computedVariables(context);
        }
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(context), evaluateEnvironment);
    }

    @Override
    public final Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        if (this.variableSize == 0 || evaluateEnvironment == null) {
            return this.exprEvaluator.evaluate(EvaluatorContext.EMPTY, evaluateEnvironment);
        }
        if (evaluateEnvironment.isMapContext()) {
            return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext((Map)evaluateEnvironment.computedVariables()), evaluateEnvironment);
        }
        return this.doEvaluate(this.evaluatorContextBuilder.createEvaluatorContext(evaluateEnvironment.computedVariables()), evaluateEnvironment);
    }

    @Override
    public final Object evaluateParameters(Object ... params) {
        return this.doEvaluate(new EvaluatorContext.ParametersImpl(params), EvaluateEnvironment.DEFAULT);
    }

    @Override
    public final Object evaluateParameters(EvaluateEnvironment evaluateEnvironment, Object ... params) {
        return this.doEvaluate(new EvaluatorContext.ParametersImpl(params), evaluateEnvironment);
    }

    final Object doEvaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
        Object result = this.exprEvaluator.evaluate(evaluatorContext, evaluateEnvironment);
        if (!this.compressed && this.cntForCompress.getAndIncrement() == 1) {
            this.compressEvaluator();
        }
        return result;
    }

    protected final void compressEvaluator() {
        this.exprEvaluator = ExprParser.compressEvaluator(this.exprEvaluator);
        this.compressed = true;
    }

    private static ExprEvaluator compressEvaluator(ExprEvaluator exprEvaluator) {
        if (exprEvaluator.constant) {
            if (exprEvaluator instanceof ExprEvaluator.ConstantImpl) {
                return exprEvaluator;
            }
            return new ExprEvaluator.ConstantImpl(exprEvaluator.result);
        }
        if (exprEvaluator instanceof ExprEvaluator.StackSplitImpl) {
            ExprEvaluator.StackSplitImpl stackSplit = (ExprEvaluator.StackSplitImpl)exprEvaluator;
            stackSplit.front = ExprParser.compressEvaluator(stackSplit.front);
            stackSplit.left = ExprParser.compressEvaluator(stackSplit.left);
            return stackSplit;
        }
        if (exprEvaluator instanceof ExprEvaluator.ContextValueHolderImpl) {
            return exprEvaluator;
        }
        ExprEvaluator left = exprEvaluator.left;
        ExprEvaluator right = exprEvaluator.right;
        int evalType = exprEvaluator.evalType;
        if (evalType == 0) {
            return ExprParser.compressEvaluator(left);
        }
        if (evalType == 1) {
            left = ExprParser.compressEvaluator(left);
            right = ExprParser.compressEvaluator(right);
            ElOperator elOperator = exprEvaluator.operator;
            switch (elOperator) {
                case MULTI: {
                    return ExprEvaluator.MultiplyImpl.of(exprEvaluator.update(left, right));
                }
                case DIVISION: {
                    return ExprEvaluator.DivisionImpl.of(exprEvaluator.update(left, right));
                }
                case MOD: {
                    return ExprEvaluator.ModulusImpl.of(exprEvaluator.update(left, right));
                }
                case EXP: {
                    return ExprEvaluator.PowerImpl.of(exprEvaluator.update(left, right));
                }
                case PLUS: {
                    if (right.negate) {
                        right.negate = false;
                        return ExprEvaluator.MinusImpl.of(exprEvaluator.update(left, right));
                    }
                    return ExprEvaluator.PlusImpl.of(exprEvaluator.update(left, right));
                }
                case MINUS: {
                    return ExprEvaluator.MinusImpl.of(exprEvaluator.update(left, right));
                }
                case BIT_RIGHT: {
                    return ExprEvaluator.BitRightImpl.of(exprEvaluator.update(left, right));
                }
                case BIT_LEFT: {
                    return ExprEvaluator.BitLeftImpl.of(exprEvaluator.update(left, right));
                }
                case AND: {
                    return ExprEvaluator.BitAndImpl.of(exprEvaluator.update(left, right));
                }
                case XOR: {
                    return ExprEvaluator.BitXorImpl.of(exprEvaluator.update(left, right));
                }
                case OR: {
                    return ExprEvaluator.BitOrImpl.of(exprEvaluator.update(left, right));
                }
                case GT: {
                    return ExprEvaluator.GtImpl.of(exprEvaluator.update(left, right));
                }
                case LT: {
                    return ExprEvaluator.LtImpl.of(exprEvaluator.update(left, right));
                }
                case EQ: {
                    return ExprEvaluator.EqualImpl.of(exprEvaluator.update(left, right));
                }
                case GE: {
                    return ExprEvaluator.GEImpl.of(exprEvaluator.update(left, right));
                }
                case LE: {
                    return ExprEvaluator.LEImpl.of(exprEvaluator.update(left, right));
                }
                case NE: {
                    return ExprEvaluator.NEImpl.of(exprEvaluator.update(left, right));
                }
                case LOGICAL_AND: {
                    return ExprEvaluator.LogicalAndImpl.of(exprEvaluator.update(left, right));
                }
                case LOGICAL_OR: {
                    return ExprEvaluator.LogicalOrImpl.of(exprEvaluator.update(left, right));
                }
                case IN: {
                    return ExprEvaluator.InImpl.of(exprEvaluator.update(left, right));
                }
                case OUT: {
                    return ExprEvaluator.OutImpl.of(exprEvaluator.update(left, right));
                }
            }
            return exprEvaluator.update(left, right);
        }
        if (evalType == 5) {
            if (!exprEvaluator.negate && !exprEvaluator.logicalNot) {
                return ExprParser.compressEvaluator(right);
            }
            return ExprEvaluator.BracketImpl.of(exprEvaluator.update(left, ExprParser.compressEvaluator(right)));
        }
        if (evalType == 4) {
            return ExprEvaluator.TernaryImpl.of(exprEvaluator.update(ExprParser.compressEvaluator(left), ExprParser.compressEvaluator(right)));
        }
        if (evalType == 2) {
            if (!exprEvaluator.negate && !exprEvaluator.logicalNot) {
                return ((ExprEvaluator.VariableImpl)exprEvaluator).normal().internKey();
            }
            return ((ExprEvaluator.VariableImpl)exprEvaluator).internKey();
        }
        if (evalType == 3) {
            return exprEvaluator;
        }
        return left == null ? null : ExprParser.compressEvaluator(left);
    }

    protected String createErrorContextText(char[] buf, int readIndex) {
        try {
            int at = this.offset + readIndex;
            int len = buf.length;
            char[] text = new char[100];
            int begin = Math.max(at - 49, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 49);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void optimize() {
        this.exprEvaluator = this.exprEvaluator.optimize();
    }

    boolean isConstantExpr() {
        return this.exprEvaluator.isConstantExpr();
    }
}

