/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.beans.KeyValuePair;
import io.github.wycst.wast.common.compiler.JDKCompiler;
import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.exceptions.ParserException;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.CompilerExprParser;
import io.github.wycst.wast.common.expression.compile.CompilerExpression;
import io.github.wycst.wast.common.expression.compile.CompilerExpressionCoder;
import io.github.wycst.wast.common.expression.functions.JavassistExprFunction;
import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

final class CompilerCodeUtils {
    private static final AtomicLong ATOMIC_LONG = new AtomicLong(0L);
    private static final String PACKAGE_NAME = CompilerExpression.class.getPackage().getName();
    private static final String NATIVE_JAVA_CODE_TEMPLATE = "package io.github.wycst.wast.common.expression.compile;\r\nimport io.github.wycst.wast.common.expression.ExprFunction;\r\nimport io.github.wycst.wast.common.expression.ElVariableInvoker;\r\n${importSet}public class ${className} extends CompilerExpression {\r\n\r\n\tpublic ${className}(CompilerEnvironment environment){\r\n\t\tsuper(environment);\r\n${initInvokes}\t}\r\n\r\n${declareInvokes}${registerFunctions}\r\n\tprotected Object invokeParameters(Object[] parameters) throws Throwable {\r\n${assignmentArrayVariables}\t\treturn ${expressionCode};\r\n\t}\r\n\r\n\tprotected Object invoke(Object context) throws Throwable {\r\n${assignmentObjectVariables}\t\treturn ${expressionCode};\r\n\t}\r\n\r\n\tprotected Object invoke(java.util.Map context) throws Throwable {\r\n${assignmentMapVariables}\t\treturn ${expressionCode};\r\n\t}\r\n\r\n}";
    private static final Map<Class, KeyValuePair<String, String>> PRIMITIVE_VALUE_METHODS = new ConcurrentHashMap<Class, KeyValuePair<String, String>>();

    CompilerCodeUtils() {
    }

    static String generateNativeJavaCode(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.generateNativeJavaCode(expr, CompilerCodeUtils.generateClassName(), environment);
    }

    static String generateNativeJavaCode(String expr, String expressionClassName, CompilerEnvironment environment) {
        String exprCode;
        boolean skipParse = environment.isSkipParse();
        if (skipParse) {
            environment.initTypeNameInvokers();
            exprCode = CompilerCodeUtils.prepareElOnSkipMode(expr, environment);
        } else {
            CompilerExprParser exprParser = new CompilerExprParser(expr);
            exprCode = exprParser.code();
            environment.initTypeNameInvokers(exprParser);
        }
        return CompilerCodeUtils.generateNativeJavaSourceCode(exprCode, expressionClassName, environment);
    }

    static String generateClassName() {
        return "CEL$_" + IdGenerator.hex();
    }

    static CompilerExpression compileByNative(String expr, CompilerEnvironment environment) {
        String expressionClassName = CompilerCodeUtils.generateClassName();
        String javaCode = CompilerCodeUtils.generateNativeJavaCode(expr, expressionClassName, environment);
        try {
            Class<?> clazz = JDKCompiler.compileJavaSource(new JavaSourceObject(PACKAGE_NAME, expressionClassName, javaCode));
            Constructor<?> clazzConstructor = clazz.getConstructor(CompilerEnvironment.class);
            clazzConstructor.setAccessible(true);
            return (CompilerExpression)clazzConstructor.newInstance(environment);
        }
        catch (Throwable e) {
            if (e instanceof ExpressionException) {
                throw (ExpressionException)e;
            }
            throw new ParserException(" parse exception :" + e.getMessage(), e);
        }
    }

    static CompilerExpression compileByJavassist(String expr, CompilerEnvironment environment) {
        Map<String, CompilerEnvironment.ExprFunctionMeta> javassistFunctionMetaMap;
        Set<Map.Entry<String, CompilerEnvironment.ExprFunctionMeta>> set;
        int len;
        int returnStatementIndex;
        boolean skipParse = environment.isSkipParse();
        if (skipParse) {
            environment.initTypeNameInvokers();
            expr = CompilerCodeUtils.prepareElOnSkipMode(expr, environment).trim();
        } else {
            CompilerExprParser exprParser = new CompilerExprParser(expr);
            expr = exprParser.code().trim();
            environment.initTypeNameInvokers(exprParser);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("className", CompilerCodeUtils.generateClassName());
        vars.put("superclass", CompilerExpression.class.getName());
        StringBuilder constructorBodyBuilder = new StringBuilder();
        constructorBodyBuilder.append("{\n");
        constructorBodyBuilder.append("\t\tsuper($1);\n");
        StringBuilder invokeObjMethodBuilder = new StringBuilder();
        StringBuilder invokeMapMethodBuilder = new StringBuilder();
        invokeObjMethodBuilder.append("protected void doInvoke(Object context, ValueHolder valueHolder) {\n");
        invokeMapMethodBuilder.append("protected void doInvoke(java.util.Map context, ValueHolder valueHolder) {\n");
        ArrayList<String> functionSources = new ArrayList<String>();
        ArrayList<String> fieldSources = new ArrayList<String>();
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        HashSet<Integer> defineIndexs = new HashSet<Integer>();
        HashMap<String, String> defineJavaIdentifiers = new HashMap<String, String>();
        HashMap<String, Class> definedTypes = new HashMap<String, Class>(environment.getVariableTypes());
        HashMap<String, Class> deductionTypes = new HashMap<String, Class>();
        HashMap<Integer, Class> tailTypes = new HashMap<Integer, Class>();
        int ofIndex = 0;
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            ElVariableInvoker parent;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            ElVariableInvoker elVariableInvoker = typeNameInvoker.variableInvoker;
            int index = elVariableInvoker.getIndex();
            tailTypes.put(index, typeNameInvoker.type);
            if (defineIndexs.add(index)) {
                constructorBodyBuilder.append("\t\t$0._invoke_").append(index).append(" = getInvokerAt(").append(ofIndex).append(");\r\n");
                fieldSources.add("final ElVariableInvoker _invoke_" + index + ";\r\n");
            }
            int currentIndex = index;
            for (ElVariableInvoker _parentInvoker = parent = elVariableInvoker.getParent(); _parentInvoker != null; _parentInvoker = _parentInvoker.getParent()) {
                int parentIndex = _parentInvoker.getIndex();
                if (defineIndexs.add(parentIndex)) {
                    constructorBodyBuilder.append("\t\t$0._invoke_").append(parentIndex).append(" = $0._invoke_").append(currentIndex).append(".getParent();\r\n");
                    fieldSources.add("final ElVariableInvoker _invoke_" + parentIndex + ";\r\n");
                }
                currentIndex = parentIndex;
            }
            CompilerCodeUtils.generateInvokerCodeTo(elVariableInvoker, defineJavaIdentifier, invokeObjMethodBuilder, invokeMapMethodBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes, environment);
            ++ofIndex;
        }
        constructorBodyBuilder.append("}");
        if (environment.isSkipParse() && (returnStatementIndex = expr.lastIndexOf("return ")) > -1) {
            invokeObjMethodBuilder.append("\r\n\t\t").append(expr, 0, returnStatementIndex).append("\r\n");
            invokeMapMethodBuilder.append("\r\n\t\t").append(expr, 0, returnStatementIndex).append("\r\n");
            expr = new String(expr.substring(returnStatementIndex + 7));
        }
        if (expr.startsWith("return ")) {
            for (len = expr.length(); len > 7 && expr.charAt(len - 1) == ';'; --len) {
            }
            invokeObjMethodBuilder.append("\t\t$2.setValue(").append(expr, 7, len).append(");\n").append("}");
            invokeMapMethodBuilder.append("\t\t$2.setValue(").append(expr, 7, len).append(");\n").append("}");
        } else {
            for (len = expr.length(); len > 0 && expr.charAt(len - 1) == ';'; --len) {
            }
            invokeObjMethodBuilder.append("\t\t$2.setValue(").append(expr, 0, len).append(");\n").append("}");
            invokeMapMethodBuilder.append("\t\t$2.setValue(").append(expr, 0, len).append(");\n").append("}");
        }
        vars.put("constructorBody", constructorBodyBuilder.toString());
        vars.put("fieldSources", fieldSources);
        vars.put("invokeObjectSource", invokeObjMethodBuilder.toString());
        vars.put("invokeMapSource", invokeMapMethodBuilder.toString());
        vars.put("functionSources", functionSources);
        Map<String, ExprFunction> functionMap = environment.getFunctionMap();
        Set<Map.Entry<String, ExprFunction>> functionEntrys = functionMap.entrySet();
        if (functionEntrys.size() > 0) {
            for (Map.Entry entry : functionEntrys) {
                StringBuilder functionBuilder = new StringBuilder();
                String functionName = (String)entry.getKey();
                ExprFunction function = (ExprFunction)entry.getValue();
                if (function instanceof JavassistExprFunction) continue;
                Type[] types = CompilerCodeUtils.getFunctionGenericTypes(function.getClass());
                Class inClass = types == null ? Object.class : (Class)types[0];
                Class outClass = types == null ? Object.class : (Class)types[1];
                String inClassName = inClass.getName();
                String outClassName = outClass.getName();
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(").append(inClassName).append("[] params) {\r\n");
                functionBuilder.append("\t\tExprFunction function = getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn function.call(params);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
            }
        }
        if ((set = (javassistFunctionMetaMap = environment.javassistFunctionMetaMap).entrySet()).size() > 0) {
            for (Map.Entry<String, CompilerEnvironment.ExprFunctionMeta> functionMetaEntry : set) {
                String functionName = functionMetaEntry.getKey();
                CompilerEnvironment.ExprFunctionMeta functionMeta = functionMetaEntry.getValue();
                Class<?> outClass = functionMeta.returnClass;
                Class<?>[] paramClassList = functionMeta.paramClassList;
                String outClassName = outClass.getName();
                StringBuilder functionBuilder = new StringBuilder();
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(");
                int len2 = paramClassList.length;
                for (int i = 0; i < len2; ++i) {
                    functionBuilder.append(paramClassList[i].getName()).append(" $").append(i + 1);
                    if (i >= len2 - 1) continue;
                    functionBuilder.append(",");
                }
                functionBuilder.append(") {\r\n");
                functionBuilder.append("\t\tExprFunction function = getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($args);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
                if (paramClassList.length <= 0) continue;
                functionBuilder.setLength(0);
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(");
                functionBuilder.append(paramClassList[0].getName()).append("[] params");
                functionBuilder.append(") {\r\n");
                functionBuilder.append("\t\tJavassistExprFunction function = (JavassistExprFunction) getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($1);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
                if (paramClassList[0] == Object.class) continue;
                functionBuilder.setLength(0);
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(Object[] params) {\r\n");
                functionBuilder.append("\t\tJavassistExprFunction function = (JavassistExprFunction) getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($1);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
            }
        }
        if (!CompilerExpressionCoder.isJavassistSupported()) {
            throw new UnsupportedOperationException("Javassist toolkit dependencies not imported");
        }
        return CompilerExpressionCoder.JAVASSIST_CODER.compile(vars, environment);
    }

    private static String prepareElOnSkipMode(String expr, CompilerEnvironment environment) {
        StringBuilder builder = new StringBuilder();
        char[] chars = UnsafeHelper.getChars(expr);
        int offset = 0;
        int len = chars.length;
        String fragment = null;
        for (int i = 0; i < len; ++i) {
            int j;
            int ch = chars[i];
            int prev = 0;
            if (ch == 34) {
                fragment = new String(chars, offset, i - offset);
                builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
                for (j = i + 1; j < len && ((ch = chars[j]) != 34 || prev == 92); ++j) {
                    prev = ch;
                }
                if (ch != 34 || prev == 92) {
                    throw new ExpressionException("Expression syntax error, from pos " + i + ", End token '\"' not found");
                }
                builder.append(new String(chars, i, j - i + 1));
                i = j++;
                offset = j;
                continue;
            }
            if (ch == 39) {
                fragment = new String(chars, offset, i - offset);
                builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
                for (j = i + 1; j < len && ((ch = chars[j]) != 39 || prev == 92); ++j) {
                    prev = ch;
                }
                if (ch != 39 || prev == 92) {
                    throw new ExpressionException("Expression syntax error, from pos " + i + ", End token ''' not found");
                }
                builder.append('\"').append(new String(chars, i + 1, j - i - 1)).append('\"');
                i = j++;
                offset = j;
                continue;
            }
            if (ch != 64) continue;
            fragment = new String(chars, offset, i - offset);
            builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
            offset = i + 1;
        }
        fragment = new String(chars, offset, len - offset);
        builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
        return builder.toString();
    }

    private static String checkAndReplaceVariable(String fragment, CompilerEnvironment environment) {
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            String varName = typeNameInvoker.varName;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            if (varName == defineJavaIdentifier) continue;
            fragment = fragment.replace(varName, defineJavaIdentifier);
        }
        if (!environment.isDisableSecurityCheck()) {
            String[] lines;
            Set<String> disableKeys = environment.getDisableKeys();
            String codeExpr = fragment;
            for (String line : lines = codeExpr.split(";")) {
                if (!environment.isEnableSystem() && line.indexOf("System") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'System', code fragment: '%s'", fragment));
                }
                if (line.indexOf("Runtime") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'Runtime', code fragment: '%s'", fragment));
                }
                if (line.indexOf("Class") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'Class', code fragment: '%s'", fragment));
                }
                for (String key : disableKeys) {
                    if (line.indexOf(key) <= -1) continue;
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a '%s', code fragment: '%s'", key, fragment));
                }
            }
        }
        return fragment;
    }

    private static String generateNativeJavaSourceCode(String source, String expressionClassName, CompilerEnvironment environment) {
        int n;
        StringBuilder initInvokesBuilder = new StringBuilder();
        StringBuilder declareInvokesBuilder = new StringBuilder();
        StringBuilder assignmentObjectVariablesBuilder = new StringBuilder();
        StringBuilder assignmentArrayVariables = new StringBuilder();
        StringBuilder assignmentMapVariablesBuilder = new StringBuilder();
        StringBuilder registerFunctionsBuilder = new StringBuilder();
        HashMap<String, CharSequence> vars = new HashMap<String, CharSequence>();
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        HashSet<Integer> defineIndexs = new HashSet<Integer>();
        HashMap<String, String> defineJavaIdentifiers = new HashMap<String, String>();
        Map<String, Class> definedTypes = environment.getVariableTypes();
        HashMap<String, Class> deductionTypes = new HashMap<String, Class>();
        HashMap<Integer, Class> tailTypes = new HashMap<Integer, Class>();
        int ofIndex = 0;
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            ElVariableInvoker parent;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            ElVariableInvoker elVariableInvoker = typeNameInvoker.variableInvoker;
            int index = elVariableInvoker.getIndex();
            tailTypes.put(index, typeNameInvoker.type);
            Class type = typeNameInvoker.type;
            assignmentArrayVariables.append("\t\t").append(typeNameInvoker.type.getCanonicalName()).append(" ").append(defineJavaIdentifier).append(" = ");
            if (type.isPrimitive() && EnvUtils.JDK_7_BELOW) {
                String primitiveMethodValue = PRIMITIVE_VALUE_METHODS.get(type).getValue();
                assignmentArrayVariables.append(primitiveMethodValue).append("(").append("parameters[").append(elVariableInvoker.getTailIndex()).append("]);\r\n");
            } else {
                assignmentArrayVariables.append("(").append(type.getCanonicalName()).append(") parameters[").append(elVariableInvoker.getTailIndex()).append("];\r\n");
            }
            if (defineIndexs.add(index)) {
                initInvokesBuilder.append("\t\tthis._invoke_").append(index).append(" = getInvokerAt(").append(ofIndex).append(");\r\n");
                declareInvokesBuilder.append("\tfinal ElVariableInvoker _invoke_").append(index).append(";\r\n");
            }
            int currentIndex = index;
            for (ElVariableInvoker _parentInvoker = parent = elVariableInvoker.getParent(); _parentInvoker != null; _parentInvoker = _parentInvoker.getParent()) {
                int parentIndex = _parentInvoker.getIndex();
                if (defineIndexs.add(parentIndex)) {
                    initInvokesBuilder.append("\t\tthis._invoke_").append(parentIndex).append(" = this._invoke_").append(currentIndex).append(".getParent();\r\n");
                    declareInvokesBuilder.append("\tfinal ElVariableInvoker _invoke_").append(parentIndex).append(";\r\n");
                }
                currentIndex = parentIndex;
            }
            CompilerCodeUtils.generateInvokerCodeTo(elVariableInvoker, defineJavaIdentifier, assignmentObjectVariablesBuilder, assignmentMapVariablesBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes, environment);
            ++ofIndex;
        }
        Map<String, ExprFunction> functionMap = environment.getFunctionMap();
        Set<Map.Entry<String, ExprFunction>> functionEntrys = functionMap.entrySet();
        if (functionEntrys.size() > 0) {
            registerFunctionsBuilder.append("\r\n");
            for (Map.Entry entry : functionEntrys) {
                String functionName = (String)entry.getKey();
                ExprFunction function = (ExprFunction)entry.getValue();
                if (function instanceof JavassistExprFunction) continue;
                Type[] types = CompilerCodeUtils.getFunctionGenericTypes(function.getClass());
                Class inClass = types == null ? Object.class : (Class)types[0];
                Class outClass = types == null ? Object.class : (Class)types[1];
                String inClassName = inClass.getName();
                String outClassName = outClass.getName();
                registerFunctionsBuilder.append("\t@SuppressWarnings(\"unchecked\")\r\n");
                registerFunctionsBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(").append(inClassName).append("...params) {\r\n");
                registerFunctionsBuilder.append("\t\tExprFunction<").append(inClassName).append(",").append(outClassName).append("> function = getFunction(\"").append(functionName).append("\");\r\n");
                registerFunctionsBuilder.append("\t\treturn function.call(params);\r\n");
                registerFunctionsBuilder.append("\t}\r\n");
            }
        }
        String expressionCode = source;
        if (environment.isSkipParse() && (n = source.lastIndexOf("return ")) > -1) {
            int len;
            assignmentObjectVariablesBuilder.append("\r\n\t\t").append(source, 0, n).append("\r\n");
            assignmentMapVariablesBuilder.append("\r\n\t\t").append(source, 0, n).append("\r\n");
            assignmentArrayVariables.append("\r\n\t\t").append(source, 0, n).append("\r\n");
            for (len = source.length(); len > 0 && source.charAt(len - 1) == ';'; --len) {
            }
            expressionCode = new String(source.substring(n + 7, len));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set<Class> importSet = environment.getImportSet();
        for (Class iptClass : importSet) {
            stringBuilder.append("import " + iptClass.getName() + ";\r\n");
        }
        vars.put("importSet", stringBuilder);
        vars.put("className", expressionClassName);
        vars.put("expressionCode", expressionCode);
        vars.put("initInvokes", initInvokesBuilder);
        vars.put("declareInvokes", declareInvokesBuilder);
        vars.put("assignmentObjectVariables", assignmentObjectVariablesBuilder);
        vars.put("assignmentArrayVariables", assignmentArrayVariables);
        vars.put("assignmentMapVariables", assignmentMapVariablesBuilder);
        vars.put("registerFunctions", registerFunctionsBuilder);
        return Expression.renderTemplate(NATIVE_JAVA_CODE_TEMPLATE, vars);
    }

    private static void generateInvokerCodeTo(ElVariableInvoker variableInvoker, String defineJavaIdentifier, StringBuilder objVariablesBuilder, StringBuilder mapVariablesBuilder, Map<String, String> defineJavaIdentifiers, Map<String, Class> definedTypes, Map<String, Class> deductionTypes, Map<Integer, Class> tailTypes, CompilerEnvironment environment) {
        if (variableInvoker == null) {
            return;
        }
        ElVariableInvoker parent = variableInvoker.getParent();
        CompilerCodeUtils.generateInvokerCodeTo(parent, null, objVariablesBuilder, mapVariablesBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes, environment);
        int index = variableInvoker.getIndex();
        String key = variableInvoker.getKey();
        boolean childEl = variableInvoker.isChildEl();
        boolean tail = variableInvoker.isTail();
        String invokeUniqueKey = variableInvoker.toString();
        if (defineJavaIdentifier == null) {
            defineJavaIdentifier = definedTypes.containsKey(invokeUniqueKey) ? invokeUniqueKey.replace('.', '_') : "_$" + index;
        }
        if (!defineJavaIdentifiers.containsValue(defineJavaIdentifier)) {
            objVariablesBuilder.append("\t\t");
            mapVariablesBuilder.append("\t\t");
            if (parent == null) {
                boolean isDefineType;
                String typeName = null;
                Class defineType = definedTypes.get(invokeUniqueKey);
                boolean bl = isDefineType = defineType != null;
                if (defineType == null && tail && tailTypes.containsKey(index)) {
                    defineType = tailTypes.get(index);
                }
                if (defineType != null) {
                    ClassStrucWrap parentStructureWrapper;
                    GetterInfo getterInfo;
                    ReflectConsts.ClassCategory classCategory;
                    typeName = CompilerCodeUtils.getTypeName(defineType);
                    mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    boolean pojoGetterMatched = false;
                    Class objectParameterClass = environment.getObjectParameterClass();
                    if (objectParameterClass != null && (classCategory = ReflectConsts.getClassCategory(objectParameterClass)) == ReflectConsts.ClassCategory.ObjectCategory && (getterInfo = (parentStructureWrapper = ClassStrucWrap.get(objectParameterClass)).matchGenerateGetterInfo(key)) != null && getterInfo.isPublic() && (!isDefineType || defineType == getterInfo.getReturnType())) {
                        objVariablesBuilder.append(getterInfo.getReturnType().getCanonicalName()).append(" ").append(defineJavaIdentifier).append(" = ");
                        objVariablesBuilder.append("((").append(objectParameterClass.getCanonicalName()).append(")context).").append(getterInfo.generateCode());
                        objVariablesBuilder.append(";\r\n");
                        pojoGetterMatched = true;
                    }
                    if (!pojoGetterMatched) {
                        objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    }
                    if (defineType.isPrimitive()) {
                        String primitiveMethodValue = PRIMITIVE_VALUE_METHODS.get(defineType).getValue();
                        mapVariablesBuilder.append(primitiveMethodValue).append("(");
                        if (!childEl) {
                            mapVariablesBuilder.append("context.get(\"").append(key).append("\")");
                        } else {
                            mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context)");
                        }
                        mapVariablesBuilder.append(");\r\n");
                        if (!pojoGetterMatched) {
                            objVariablesBuilder.append(primitiveMethodValue).append("(");
                            objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context)");
                            objVariablesBuilder.append(");\r\n");
                        }
                    } else {
                        mapVariablesBuilder.append("(").append(typeName).append(") ");
                        if (!childEl) {
                            mapVariablesBuilder.append("context.get(\"").append(key).append("\");\r\n");
                        } else {
                            mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                        }
                        if (!pojoGetterMatched) {
                            objVariablesBuilder.append("(").append(typeName).append(") ");
                            if (environment.isSupportedContextRoot()) {
                                objVariablesBuilder.append("(").append("context instanceof ").append(typeName).append(" ? context : ");
                                objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context));\r\n");
                            } else {
                                objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                            }
                        }
                        deductionTypes.put(invokeUniqueKey, defineType);
                    }
                } else {
                    objVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = ");
                    mapVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = ");
                    if (!childEl) {
                        mapVariablesBuilder.append("context.get(\"").append(key).append("\");\r\n");
                    } else {
                        mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                    }
                    objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                }
            } else {
                String parentUniqueKey = parent.toString();
                String parentValueVar = defineJavaIdentifiers.get(parentUniqueKey);
                if (parentValueVar == null) {
                    throw new IllegalStateException("Unexpected exception");
                }
                Class parentType = deductionTypes.get(parentUniqueKey);
                Class defineType = definedTypes.get(invokeUniqueKey);
                boolean forceConversionType = defineType != null;
                boolean forcePrimitiveType = forceConversionType ? defineType.isPrimitive() : false;
                GetterInfo getterInfo = null;
                boolean isParentMapType = false;
                if (parentType != null && !parentType.isPrimitive()) {
                    if (Map.class.isAssignableFrom(parentType)) {
                        isParentMapType = true;
                    } else {
                        ClassStrucWrap parentStructureWrapper;
                        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(parentType);
                        if (classCategory == ReflectConsts.ClassCategory.ObjectCategory && (getterInfo = (parentStructureWrapper = ClassStrucWrap.get(parentType)).matchGenerateGetterInfo(key)) != null) {
                            if (!getterInfo.isPublic()) {
                                forceConversionType = true;
                                if (EnvUtils.JDK_7_BELOW && getterInfo.isPrimitive()) {
                                    forcePrimitiveType = true;
                                }
                            } else if (getterInfo.getReturnType() == defineType) {
                                forceConversionType = false;
                                forcePrimitiveType = false;
                            }
                        }
                        if (defineType == null) {
                            Class clazz = defineType = getterInfo == null ? null : getterInfo.getReturnType();
                        }
                    }
                    if (defineType == null) {
                        defineType = tail && tailTypes.containsKey(index) ? tailTypes.get(index) : Object.class;
                    }
                    String typeName = CompilerCodeUtils.getTypeName(defineType);
                    objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    if (forceConversionType) {
                        if (forcePrimitiveType) {
                            String primitiveMethodValue = PRIMITIVE_VALUE_METHODS.get(defineType).getValue();
                            objVariablesBuilder.append(primitiveMethodValue).append("(");
                            mapVariablesBuilder.append(primitiveMethodValue).append("(");
                        } else {
                            objVariablesBuilder.append("(").append(typeName).append(") ");
                            mapVariablesBuilder.append("(").append(typeName).append(") ");
                        }
                    }
                    if (getterInfo != null && getterInfo.isPublic()) {
                        objVariablesBuilder.append(parentValueVar).append(".").append(getterInfo.generateCode());
                        mapVariablesBuilder.append(parentValueVar).append(".").append(getterInfo.generateCode());
                    } else if (isParentMapType && !childEl) {
                        objVariablesBuilder.append(parentValueVar).append(".get(\"").append(key).append("\")");
                        mapVariablesBuilder.append(parentValueVar).append(".get(\"").append(key).append("\")");
                    } else {
                        objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(")");
                        mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(")");
                    }
                    if (forcePrimitiveType) {
                        objVariablesBuilder.append(");\r\n");
                        mapVariablesBuilder.append(");\r\n");
                    } else {
                        objVariablesBuilder.append(";\r\n");
                        mapVariablesBuilder.append(";\r\n");
                    }
                } else {
                    String typeName = null;
                    if (defineType == null && tail && tailTypes.containsKey(index)) {
                        defineType = tailTypes.get(index);
                    }
                    if (defineType != null) {
                        typeName = CompilerCodeUtils.getTypeName(defineType);
                        objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                        mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                        if (defineType.isPrimitive()) {
                            String primitiveMethodValue = PRIMITIVE_VALUE_METHODS.get(defineType).getValue();
                            objVariablesBuilder.append(primitiveMethodValue).append("(_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append("));\r\n");
                            mapVariablesBuilder.append(primitiveMethodValue).append("(_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append("));\r\n");
                        } else {
                            objVariablesBuilder.append("(").append(typeName).append(") _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                            mapVariablesBuilder.append("(").append(typeName).append(") _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                            deductionTypes.put(invokeUniqueKey, defineType);
                        }
                    } else {
                        objVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                        mapVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                    }
                }
                if (defineType != null && defineType != Object.class && !defineType.isPrimitive()) {
                    deductionTypes.put(invokeUniqueKey, defineType);
                }
            }
            defineJavaIdentifiers.put(invokeUniqueKey, defineJavaIdentifier);
        }
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            StringBuilder builder = new StringBuilder();
            Class<?> componentType = type.getComponentType();
            int cnt = 1;
            while (componentType.isArray()) {
                ++cnt;
                componentType = componentType.getComponentType();
            }
            builder.append(componentType.getName());
            for (int i = 0; i < cnt; ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        return type.getName();
    }

    private static Type[] getFunctionGenericTypes(Class<?> targetClass) {
        Type[] typeArray;
        int n;
        int n2;
        Type[] implementTypes = targetClass.getGenericInterfaces();
        if (implementTypes.length == 0) {
            Class<?> parentCls = targetClass.getSuperclass();
            implementTypes = parentCls.getGenericInterfaces();
        }
        if ((n2 = 0) < (n = (typeArray = implementTypes).length)) {
            ParameterizedType parameterizedType;
            Type[] types;
            Type implementType = typeArray[n2];
            if (implementType instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)implementType).getActualTypeArguments()) != null && types.length > 0) {
                return types;
            }
            return null;
        }
        return null;
    }

    static {
        KeyValuePair<String, String> intType = new KeyValuePair<String, String>("int", "intValue");
        KeyValuePair<String, String> longType = new KeyValuePair<String, String>("long", "longValue");
        KeyValuePair<String, String> doubleType = new KeyValuePair<String, String>("double", "doubleValue");
        KeyValuePair<String, String> floatType = new KeyValuePair<String, String>("float", "floatValue");
        KeyValuePair<String, String> shortType = new KeyValuePair<String, String>("short", "shortValue");
        KeyValuePair<String, String> byteType = new KeyValuePair<String, String>("byte", "byteValue");
        KeyValuePair<String, String> booleanType = new KeyValuePair<String, String>("boolean", "booleanValue");
        KeyValuePair<String, String> charType = new KeyValuePair<String, String>("char", "charValue");
        PRIMITIVE_VALUE_METHODS.put(Integer.TYPE, intType);
        PRIMITIVE_VALUE_METHODS.put(Long.TYPE, longType);
        PRIMITIVE_VALUE_METHODS.put(Double.TYPE, doubleType);
        PRIMITIVE_VALUE_METHODS.put(Float.TYPE, floatType);
        PRIMITIVE_VALUE_METHODS.put(Short.TYPE, shortType);
        PRIMITIVE_VALUE_METHODS.put(Byte.TYPE, byteType);
        PRIMITIVE_VALUE_METHODS.put(Boolean.TYPE, booleanType);
        PRIMITIVE_VALUE_METHODS.put(Character.TYPE, charType);
        PRIMITIVE_VALUE_METHODS.put(Integer.class, intType);
        PRIMITIVE_VALUE_METHODS.put(Long.class, longType);
        PRIMITIVE_VALUE_METHODS.put(Double.class, doubleType);
        PRIMITIVE_VALUE_METHODS.put(Float.class, floatType);
        PRIMITIVE_VALUE_METHODS.put(Short.class, shortType);
        PRIMITIVE_VALUE_METHODS.put(Byte.class, byteType);
    }
}

