/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.ExprEvaluator;
import io.github.wycst.wast.common.expression.ExpressionException;

public final class CompilerExprEvaluator
extends ExprEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String code() {
        StringBuilder builder = new StringBuilder();
        if (this.isConstantExpr()) {
            Object result = this.evaluate();
            if (result instanceof String) {
                String strValue = (String)result;
                if (strValue.indexOf(34) > -1) {
                    strValue = strValue.replace("\"", "\\\"");
                }
                return builder.append("\"").append(strValue).append("\"").toString();
            }
            return String.valueOf(result);
        }
        int evalType = this.evalType;
        boolean negate = this.negate;
        boolean logicalNot = this.logicalNot;
        ExprEvaluator left = this.left;
        ExprEvaluator right = this.right;
        if (evalType == 1) {
            String leftGenerateCode = left.code();
            if (right == null) {
                return leftGenerateCode;
            }
            String rightGenerateCode = right.code();
            switch (this.operator) {
                case MULTI: {
                    return builder.append(leftGenerateCode).append(" * ").append(rightGenerateCode).toString();
                }
                case DIVISION: {
                    return builder.append(leftGenerateCode).append(" / ").append(rightGenerateCode).toString();
                }
                case MOD: {
                    return builder.append(leftGenerateCode).append(" % ").append(rightGenerateCode).toString();
                }
                case EXP: {
                    return builder.append("Math.pow(").append(leftGenerateCode).append(", ").append(rightGenerateCode).append(")").toString();
                }
                case PLUS: {
                    if (right.isNegate()) {
                        try {
                            String string = builder.append(leftGenerateCode).append(" - ").append(right.negate(false).code()).toString();
                            return string;
                        }
                        finally {
                            right.negate(true);
                        }
                    }
                    if (right.isConstantExpr() && rightGenerateCode.startsWith("-")) {
                        return builder.append(leftGenerateCode).append(" - ").append(rightGenerateCode.substring(1)).toString();
                    }
                    return builder.append(leftGenerateCode).append(" + ").append(rightGenerateCode).toString();
                }
                case MINUS: {
                    return builder.append(leftGenerateCode).append(" - ").append(rightGenerateCode).toString();
                }
                case BIT_RIGHT: {
                    return builder.append(leftGenerateCode).append(" >> ").append(rightGenerateCode).toString();
                }
                case BIT_LEFT: {
                    return builder.append(leftGenerateCode).append(" << ").append(rightGenerateCode).toString();
                }
                case AND: {
                    return builder.append(leftGenerateCode).append(" & ").append(rightGenerateCode).toString();
                }
                case XOR: {
                    return builder.append(leftGenerateCode).append(" ^ ").append(rightGenerateCode).toString();
                }
                case OR: {
                    return builder.append(leftGenerateCode).append(" | ").append(rightGenerateCode).toString();
                }
                case GT: {
                    return builder.append(leftGenerateCode).append(" > ").append(rightGenerateCode).toString();
                }
                case LT: {
                    return builder.append(leftGenerateCode).append(" < ").append(rightGenerateCode).toString();
                }
                case EQ: {
                    return builder.append(leftGenerateCode).append(" == ").append(rightGenerateCode).toString();
                }
                case GE: {
                    return builder.append(leftGenerateCode).append(" >= ").append(rightGenerateCode).toString();
                }
                case LE: {
                    return builder.append(leftGenerateCode).append(" <= ").append(rightGenerateCode).toString();
                }
                case NE: {
                    return builder.append(leftGenerateCode).append(" != ").append(rightGenerateCode).toString();
                }
                case LOGICAL_AND: {
                    return builder.append(leftGenerateCode).append(" && ").append(rightGenerateCode).toString();
                }
                case LOGICAL_OR: {
                    return builder.append(leftGenerateCode).append(" || ").append(rightGenerateCode).toString();
                }
                case IN: {
                    throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'in(\u2208)'\u7b26\u53f7\u7f16\u8bd1");
                }
                case OUT: {
                    throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'out(\u2209)'\u7b26\u53f7\u7f16\u8bd1");
                }
            }
        } else {
            if (evalType == 5) {
                if (negate) {
                    return builder.append("-(").append(right.code()).append(")").toString();
                }
                if (logicalNot) {
                    return builder.append("!(").append(right.code()).append(")").toString();
                }
                return builder.append("(").append(right.code()).append(")").toString();
            }
            if (evalType == 4) {
                ExprEvaluator rLeft = right.getLeft();
                ExprEvaluator rRight = right.getRight();
                return builder.append(left.code()).append(" ? ").append(rLeft.code()).append(" : ").append(rRight.code()).toString();
            }
            return left.code();
        }
        return null;
    }
}

