/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.compile.CompilerCodeUtils;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.ValueHolder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CompilerExpression
extends Expression {
    private static Coder defaultCoder = Coder.Native;
    protected final CompilerEnvironment environment;

    public static void setDefaultCoder(Coder defaultCoder) {
        CompilerExpression.defaultCoder = defaultCoder;
    }

    protected CompilerExpression(CompilerEnvironment environment) {
        this.environment = environment;
    }

    public static CompilerEnvironment createEnvironment() {
        return new CompilerEnvironment();
    }

    public static CompilerExpression compile(String expr) {
        return CompilerExpression.compile(expr, CompilerEnvironment.COMPILER_DEFAULT);
    }

    public static String generateJavaCode(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.generateNativeJavaCode(expr, environment);
    }

    public static CompilerExpression compile(String expr, CompilerEnvironment environment) {
        return CompilerExpression.compile(expr, environment, defaultCoder);
    }

    public static CompilerExpression compile(String expr, CompilerEnvironment environment, Coder coder) {
        if (coder == null) {
            coder = defaultCoder == null ? Coder.Native : defaultCoder;
        }
        switch (coder) {
            case Native: {
                return CompilerCodeUtils.compileByNative(expr, environment);
            }
            case Javassist: {
                return CompilerCodeUtils.compileByJavassist(expr, environment);
            }
        }
        throw new UnsupportedOperationException("unknown coder " + (Object)((Object)coder));
    }

    @Deprecated
    public static CompilerExpression compileJavassist(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.compileByJavassist(expr, environment);
    }

    protected final ExprFunction getFunction(String functionName) {
        return this.environment.getFunction(functionName);
    }

    @Override
    public final Object evaluate() {
        return this.evaluate((Object)null);
    }

    @Override
    public Object evaluate(Map context) {
        try {
            return this.invoke(context);
        }
        catch (Throwable e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    @Override
    public Object evaluate(Object context) {
        try {
            return this.invoke(context);
        }
        catch (Throwable e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    @Override
    public final Object evaluate(final Map context, long timeout) {
        final ValueHolder valueHolder = new ValueHolder();
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        return this.evaluateAsync(valueHolder, atomicBoolean, new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    valueHolder.value = CompilerExpression.this.evaluate(context);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof Error)) {
                        throwable.printStackTrace();
                    }
                }
                finally {
                    atomicBoolean.set(true);
                    ValueHolder valueHolder2 = valueHolder;
                    synchronized (valueHolder2) {
                        valueHolder.notify();
                    }
                }
            }
        }), timeout);
    }

    @Override
    public final Object evaluate(final Object context, long timeout) {
        final ValueHolder valueHolder = new ValueHolder();
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        return this.evaluateAsync(valueHolder, atomicBoolean, new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    valueHolder.value = CompilerExpression.this.evaluate(context);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof Error)) {
                        throwable.printStackTrace();
                    }
                }
                finally {
                    atomicBoolean.set(true);
                    ValueHolder valueHolder2 = valueHolder;
                    synchronized (valueHolder2) {
                        valueHolder.notify();
                    }
                }
            }
        }), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object evaluateAsync(ValueHolder valueHolder, AtomicBoolean atomicBoolean, Thread thread, long timeout) {
        try {
            thread.start();
            ValueHolder valueHolder2 = valueHolder;
            synchronized (valueHolder2) {
                valueHolder.wait(timeout);
                if (!atomicBoolean.get()) {
                    thread.interrupt();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return valueHolder.value;
    }

    @Override
    public final Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        return this.evaluate(evaluateEnvironment.getContext());
    }

    @Override
    public final Object evaluate(Map context, EvaluateEnvironment evaluateEnvironment) {
        return this.evaluate(context);
    }

    @Override
    public final Object evaluate(Object context, EvaluateEnvironment evaluateEnvironment) {
        return this.evaluate(context);
    }

    @Override
    public final Object evaluateParameters(Object ... params) {
        try {
            return this.invokeParameters(params);
        }
        catch (Throwable e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    @Override
    public final Object evaluateParameters(EvaluateEnvironment evaluateEnvironment, Object ... params) {
        try {
            return this.invokeParameters(params);
        }
        catch (Throwable e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    protected final <T> T getValue(Object value, Class<T> tClass) {
        return (T)value;
    }

    protected ElVariableInvoker getInvokerAt(int index) {
        return this.environment.getTypeNameInvokers().get((int)index).variableInvoker;
    }

    protected Object invoke(Object context) throws Throwable {
        throw new UnsupportedOperationException();
    }

    protected Object invoke(Map context) throws Throwable {
        throw new UnsupportedOperationException();
    }

    protected Object invokeParameters(Object[] parameters) throws Throwable {
        throw new UnsupportedOperationException();
    }

    protected final int intValue(Object value) {
        Number number = (Number)value;
        return number.intValue();
    }

    protected final byte byteValue(Object value) {
        Number number = (Number)value;
        return number.byteValue();
    }

    protected final double doubleValue(Object value) {
        Number number = (Number)value;
        return number.doubleValue();
    }

    protected final float floatValue(Object value) {
        Number number = (Number)value;
        return number.floatValue();
    }

    protected final long longValue(Object value) {
        Number number = (Number)value;
        return number.longValue();
    }

    protected final char charValue(Object value) {
        return ((Character)value).charValue();
    }

    protected final short shortValue(Object value) {
        Number number = (Number)value;
        return number.shortValue();
    }

    protected final boolean booleanValue(Object value) {
        return (Boolean)value;
    }

    protected final String stringValue(Object value) {
        return String.valueOf(value);
    }

    protected final Object objectValue(Object value) {
        return value;
    }

    public static enum Coder {
        Native,
        Javassist;

    }
}

