/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class SetterInfo {
    Field field;
    long fieldOffset = -1L;
    private String name;
    private Class<?> parameterType;
    private Class<?> actualTypeArgument;
    private int index;
    private GenericParameterizedType genericParameterizedType;
    private boolean nonInstanceType;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Boolean existDefault;
    private boolean fieldDisabled;

    public static SetterInfo fromField(Field field) {
        boolean primitive = field.getType().isPrimitive();
        SetterInfo setterInfo = primitive ? new PrimitiveImpl() : new SetterInfo();
        setterInfo.setField(field);
        return setterInfo;
    }

    public final boolean isInstance(Object target) {
        return this.field.getDeclaringClass().isInstance(target);
    }

    public void invoke(Object target, Object value) {
        target.getClass();
        if (!this.parameterType.isInstance(value) && value != null || !this.isInstance(target)) {
            throw new SecurityException("invoke error: parameter mismatch");
        }
        this.invokeInternal(target, value);
    }

    void invokeInternal(Object target, Object value) {
        UnsafeHelper.UNSAFE.putObject(target, this.fieldOffset, value);
    }

    public final String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public final Class<?> getParameterType() {
        return this.parameterType;
    }

    void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public final Class<?> getActualTypeArgument() {
        return this.actualTypeArgument;
    }

    void setActualTypeArgument(Class<?> actualTypeArgument) {
        this.actualTypeArgument = actualTypeArgument;
    }

    public final boolean isNonInstanceType() {
        return this.nonInstanceType;
    }

    void setNonInstanceType(boolean nonInstanceType) {
        this.nonInstanceType = nonInstanceType;
    }

    void setAnnotations(Map<Class<? extends Annotation>, Annotation> annotations) {
        this.annotations = annotations;
    }

    void setField(Field field) {
        this.field = field;
        try {
            this.fieldOffset = UnsafeHelper.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            this.fieldOffset = -1L;
        }
    }

    public final GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    void setGenericParameterizedType(GenericParameterizedType genericParameterizedType) {
        this.genericParameterizedType = genericParameterizedType;
    }

    Object getDefaultFieldValue(Object instance) {
        try {
            if (this.existDefault == Boolean.FALSE) {
                return null;
            }
            Object fieldValue = this.getFieldValue(instance);
            this.existDefault = fieldValue != null;
            if (fieldValue != null) {
                return fieldValue;
            }
        }
        catch (Exception e) {
            this.existDefault = Boolean.FALSE;
        }
        return null;
    }

    Object getFieldValue(Object instance) throws IllegalAccessException {
        return UnsafeHelper.getObjectValue(instance, this.fieldOffset);
    }

    public final Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotations.get(annotationType);
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public final int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setFieldDisabled(boolean disabled) {
        this.fieldDisabled = disabled;
    }

    public boolean isFieldDisabled() {
        return this.fieldDisabled;
    }

    static final class PrimitiveImpl
    extends SetterInfo {
        private ReflectConsts.PrimitiveType primitiveType;

        PrimitiveImpl() {
        }

        @Override
        public void invoke(Object target, Object value) {
            if (!this.isInstance(target)) {
                throw new SecurityException("invoke error: parameter mismatch");
            }
            this.primitiveType.put(target, this.fieldOffset, value);
        }

        @Override
        void invokeInternal(Object target, Object value) {
            this.primitiveType.putValue(target, this.fieldOffset, value);
        }

        @Override
        Object getFieldValue(Object instance) {
            return this.primitiveType.get(instance, this.fieldOffset);
        }

        @Override
        void setField(Field field) {
            super.setField(field);
            this.primitiveType = ReflectConsts.PrimitiveType.typeOf(field.getType());
        }
    }

    static final class FieldImpl
    extends SetterInfo {
        FieldImpl() {
        }

        @Override
        void setField(Field field) {
            this.field = field;
        }

        @Override
        public void invoke(Object target, Object value) {
            this.invokeInternal(target, value);
        }

        @Override
        Object getFieldValue(Object instance) throws IllegalAccessException {
            return this.field.get(instance);
        }

        @Override
        void invokeInternal(Object target, Object value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

