/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.annotations.Id;
import io.github.wycst.wast.jdbc.annotations.Table;
import io.github.wycst.wast.jdbc.exception.EntityException;
import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.executer.CacheableEntityHandler;
import io.github.wycst.wast.jdbc.executer.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.executer.EntityHandler;
import io.github.wycst.wast.jdbc.executer.FieldColumn;
import io.github.wycst.wast.jdbc.executer.FieldCondition;
import io.github.wycst.wast.jdbc.executer.FieldOrder;
import io.github.wycst.wast.jdbc.executer.JoinColumn;
import io.github.wycst.wast.jdbc.executer.JoinEntityMapping;
import io.github.wycst.wast.jdbc.executer.OqlQuery;
import io.github.wycst.wast.jdbc.executer.SqlExecuteContext;
import io.github.wycst.wast.jdbc.executer.SubOqlQuery;
import io.github.wycst.wast.jdbc.executer.SubQueryCondition;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import io.github.wycst.wast.jdbc.transform.TypeTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class EntitySqlMapping {
    private final Class<?> entityClass;
    private final Table table;
    private final String tableName;
    private final Map<String, FieldColumn> fieldColumnMapping;
    private final FieldColumn primary;
    final EntityHandler entityHandler;
    final boolean disableLog;
    private final Map<Class<?>, JoinEntityMapping> joinEntityMappings;
    private final List<CascadeFetchMapping> cascadeFetchMappings;
    private String selectByPrimarySql;
    private String selectSql;
    private String insertSql;
    private String insertSqlPrefix;
    private String insertSqlSuffix;
    private String updateByPrimarySql;
    private String deleteByPrimarySql;
    private List<FieldColumn> insertColumns = new ArrayList<FieldColumn>();
    private List<FieldColumn> updateColumns = new ArrayList<FieldColumn>();
    private Map<String, FieldColumn> placeholderColumns = new HashMap<String, FieldColumn>();
    private boolean usePlaceholderOnInsert;
    private boolean usePlaceholderOnUpdate;

    public EntitySqlMapping(Class<?> entityClass, String tableName, Map<String, FieldColumn> fieldColumnMapping, FieldColumn primary, Map<Class<?>, JoinEntityMapping> joinEntityMappings, List<CascadeFetchMapping> cascadeFetchMappings, Table table) {
        this.entityClass = entityClass;
        this.tableName = tableName;
        this.fieldColumnMapping = fieldColumnMapping;
        this.primary = primary;
        this.joinEntityMappings = joinEntityMappings;
        this.cascadeFetchMappings = cascadeFetchMappings;
        this.table = table;
        this.entityHandler = table != null && table.cacheable() ? new CacheableEntityHandler(this) : new EntityHandler(this);
        this.disableLog = table != null && table.disableLog();
        this.init();
    }

    public FieldColumn getFieldColumn(String field) {
        return this.fieldColumnMapping.get(field);
    }

    void init() {
        this.initSelectSql();
        this.initInsertSql();
        this.initUpdateSql();
        this.initDeleteSql();
    }

    Map<Class<?>, JoinEntityMapping> getJoinEntityMappings() {
        return this.joinEntityMappings;
    }

    private void appendQueryFieldColumn(FieldColumn fieldColumn, StringBuilder columnsBuilder) {
        columnsBuilder.append(fieldColumn.getQueryColumnSyntax());
    }

    Sql getSelectSqlObject(Object params) {
        return this.getSelectSqlObject(params, false);
    }

    Sql getSelectSqlObject(Object params, boolean total) {
        OqlQuery oqlQuery = OqlQuery.create();
        if (params != null) {
            oqlQuery.addConditions(this.getParamsFields(params));
        }
        return this.getSelectSqlObject(oqlQuery, params, total);
    }

    Sql getDeleteSqlObject(String deleteTemplate, OqlQuery oqlQuery, Object params) {
        Sql sqlObject = new Sql();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        if (deleteTemplate == null) {
            deleteTemplate = "DELETE t FROM %s t%s";
        }
        StringBuilder whereBuilder = new StringBuilder();
        this.appendWhereClause(whereBuilder, oqlQuery, params, paramValues);
        String sql = StringUtils.replacePlaceholder(deleteTemplate, "%s", this.tableName, whereBuilder.toString());
        sqlObject.setFormalSql(sql);
        sqlObject.setParamValues(paramValues.toArray());
        return sqlObject;
    }

    Sql getSelectSqlObject(OqlQuery oqlQuery, Object params) {
        return this.getSelectSqlObject(oqlQuery, params, false);
    }

    final void appendSelectColumns(OqlQuery oqlQuery, StringBuilder columnsBuilder, boolean disableJoin, StringBuilder onClause) {
        boolean selectAll;
        int deleteDotIndex = -1;
        Collection<String> selectFields = oqlQuery.getSelectFields();
        boolean bl = selectAll = selectFields.size() == 0;
        if (selectAll) {
            selectFields = this.fieldColumnMapping.keySet();
        }
        for (String queryField : selectFields) {
            FieldColumn fieldColumn = this.fieldColumnMapping.get(queryField);
            if (fieldColumn == null || selectAll && fieldColumn.isDisabledOnSelect()) continue;
            this.appendQueryFieldColumn(fieldColumn, columnsBuilder);
            deleteDotIndex = columnsBuilder.length() - 1;
        }
        if (!disableJoin && this.joinEntityMappings != null && this.joinEntityMappings.size() > 0) {
            onClause.append(" ");
            this.handleJoinSql(columnsBuilder, onClause, deleteDotIndex);
        } else if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
    }

    Sql getSelectSqlObject(OqlQuery oqlQuery, Object params, boolean total) {
        Sql sqlObject = new Sql();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        String selectTemplate = "SELECT %s FROM %s t%s%s%s";
        StringBuilder columnsBuilder = new StringBuilder();
        StringBuilder onClause = new StringBuilder();
        this.appendSelectColumns(oqlQuery, columnsBuilder, oqlQuery.isDisableJoin(), onClause);
        StringBuilder whereBuilder = new StringBuilder();
        this.appendWhereClause(whereBuilder, oqlQuery, params, paramValues);
        List<FieldOrder> orders = oqlQuery.getOrders();
        StringBuilder orderBuilder = new StringBuilder();
        boolean appendFlag = false;
        for (FieldOrder fieldOrder : orders) {
            String field = fieldOrder.getField();
            FieldColumn fieldColumn = this.fieldColumnMapping.get(field);
            if (fieldColumn == null) continue;
            if (appendFlag) {
                orderBuilder.append(",");
            } else {
                orderBuilder.append(" ORDER BY ");
                appendFlag = true;
            }
            orderBuilder.append("t.").append(fieldColumn.getColumnName()).append(" ").append((Object)fieldOrder.getOrder());
        }
        String sql = StringUtils.replacePlaceholder(selectTemplate, "%s", columnsBuilder.toString(), this.tableName, onClause.toString(), whereBuilder.toString(), orderBuilder.toString());
        if (total) {
            String totalSql = StringUtils.replacePlaceholder("SELECT count(*) FROM %s t %s", "%s", this.tableName, whereBuilder.toString());
            sqlObject.setTotalSql(totalSql);
        }
        sqlObject.setFormalSql(sql);
        sqlObject.setParamValues(paramValues.toArray());
        return sqlObject;
    }

    private void handleJoinSql(StringBuilder columnsBuilder, StringBuilder onClause, int deleteDotIndex) {
        int i = 1;
        for (Map.Entry<Class<?>, JoinEntityMapping> entry : this.joinEntityMappings.entrySet()) {
            JoinColumn onlyOneJoinColumn;
            JoinEntityMapping joinEntityMapping = entry.getValue();
            List<JoinColumn> joinColumns = joinEntityMapping.getJoinColumns();
            Map<String, String> joinOnColumnKeys = joinEntityMapping.getJoinOnColumnKeys();
            String tableName = joinEntityMapping.getTableName();
            String tableAlias = "t" + i;
            if (joinColumns.size() == 1 && (onlyOneJoinColumn = joinColumns.get(0)).useSubQuery()) {
                String fieldName = onlyOneJoinColumn.getFieldName();
                FieldColumn fieldColumn = onlyOneJoinColumn.getJoinFieldColumn();
                StringBuilder subQueryWhere = new StringBuilder();
                if (joinOnColumnKeys.size() > 0) {
                    subQueryWhere.append(" WHERE ");
                    int s = 0;
                    for (Map.Entry<String, String> columnKeyEntry : joinOnColumnKeys.entrySet()) {
                        String columnName = columnKeyEntry.getKey();
                        String joinColumnName = columnKeyEntry.getValue();
                        if (s++ > 0) {
                            subQueryWhere.append(" AND ");
                        }
                        subQueryWhere.append("t.").append(columnName).append(" = ").append(tableAlias).append(".").append(joinColumnName);
                    }
                }
                fieldColumn.getQueryColumnSyntax(tableAlias);
                columnsBuilder.append("(SELECT ").append(fieldColumn.getQueryColumnSyntax(tableAlias)).append(" FROM ").append(tableName).append(" ").append(tableAlias).append((CharSequence)subQueryWhere).append(")").append(" as \"").append(fieldName).append("\",");
                deleteDotIndex = columnsBuilder.length() - 1;
            } else {
                for (JoinColumn joinColumn : joinColumns) {
                    String fieldName = joinColumn.getFieldName();
                    FieldColumn fieldColumn = joinColumn.getJoinFieldColumn();
                    columnsBuilder.append(fieldColumn.getQueryColumnSyntax(tableAlias)).append(" as \"").append(fieldName).append("\",");
                    deleteDotIndex = columnsBuilder.length() - 1;
                }
                if (joinOnColumnKeys.size() > 0) {
                    onClause.append(" LEFT JOIN ").append(tableName).append(" ").append(tableAlias).append(" ON ");
                    int j = 0;
                    for (Map.Entry<String, String> columnKeyEntry : joinOnColumnKeys.entrySet()) {
                        String columnName = columnKeyEntry.getKey();
                        String joinColumnName = columnKeyEntry.getValue();
                        if (j++ > 0) {
                            onClause.append(" AND ");
                        }
                        onClause.append("t.").append(columnName).append(" = ").append(tableAlias).append(".").append(joinColumnName);
                    }
                }
            }
            ++i;
        }
        if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
    }

    <E> Sql getUpdateSqlObject(String updateTemplate, E entity, Collection<String> fields, boolean isExclude) {
        if (this.primary == null) {
            return null;
        }
        Sql sqlObject = new Sql();
        ArrayList<Object> values = new ArrayList<Object>();
        if (updateTemplate == null) {
            updateTemplate = "UPDATE %s SET %s WHERE %s = %s";
        }
        Collection<String> updateFields = null;
        Set<String> fullFields = this.fieldColumnMapping.keySet();
        if (isExclude) {
            updateFields = new HashSet<String>(fullFields);
            if (fields != null) {
                updateFields.removeAll(fields);
            }
        } else {
            updateFields = fields == null || fields.size() == 0 ? fullFields : fields;
        }
        StringBuilder columnsBuilder = new StringBuilder();
        int deleteDotIndex = -1;
        for (String updateField : updateFields) {
            if (!this.fieldColumnMapping.containsKey(updateField) || updateField.equals(this.primary.getField().getName())) continue;
            FieldColumn fieldColumn = this.fieldColumnMapping.get(updateField);
            columnsBuilder.append(fieldColumn.getColumnName()).append(" = ?,");
            values.add(this.getFieldColumnValue(false, fieldColumn, entity));
            deleteDotIndex = columnsBuilder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
        values.add(this.getId(entity));
        String sql = StringUtils.replacePlaceholder(updateTemplate, "%s", this.tableName, columnsBuilder.toString(), this.primary.getColumnName(), "?");
        sqlObject.setFormalSql(sql);
        sqlObject.setParamValues(values.toArray());
        return sqlObject;
    }

    private void initSelectSql() {
        if (this.primary == null) {
            return;
        }
        StringBuilder columnsBuilder = new StringBuilder();
        StringBuilder onClause = new StringBuilder();
        this.handleSelectColumns(columnsBuilder, onClause);
        this.selectSql = StringUtils.replacePlaceholder("SELECT %s FROM %s t %s", "%s", columnsBuilder.toString(), this.tableName, onClause.toString()).trim();
        this.selectByPrimarySql = StringUtils.replacePlaceholder("SELECT %s FROM %s t %s WHERE t.%s = ?", "%s", columnsBuilder.toString(), this.tableName, onClause.toString(), this.primary.getColumnName());
    }

    void handleSelectColumns(StringBuilder columnsBuilder, StringBuilder onClause) {
        int deleteDotIndex = -1;
        for (FieldColumn fieldColumn : this.fieldColumnMapping.values()) {
            if (fieldColumn.isDisabledOnSelect()) continue;
            this.appendQueryFieldColumn(fieldColumn, columnsBuilder);
            deleteDotIndex = columnsBuilder.length() - 1;
        }
        if (this.joinEntityMappings != null && this.joinEntityMappings.size() > 0) {
            this.handleJoinSql(columnsBuilder, onClause, deleteDotIndex);
        } else if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
    }

    private void initInsertSql() {
        this.insertColumns.clear();
        String insertTemplate = "INSERT INTO %s(%s) VALUES(%s)";
        StringBuilder columnsNameBuilder = new StringBuilder();
        StringBuilder columnsValueBuilder = new StringBuilder();
        int deleteDotOfNameIndex = -1;
        int deleteDotOfValueIndex = -1;
        for (Map.Entry<String, FieldColumn> entry : this.fieldColumnMapping.entrySet()) {
            Id id;
            Id.GenerationType type;
            String field = entry.getKey();
            FieldColumn fieldColumn = entry.getValue();
            if (fieldColumn.isPrimary() && (type = (id = fieldColumn.getId()).strategy()) == Id.GenerationType.Identity || fieldColumn.isDisabledOnInsert()) continue;
            columnsNameBuilder.append(fieldColumn.getColumnName()).append(",");
            if (fieldColumn.usePlaceholderOnWrite()) {
                this.usePlaceholderOnInsert = true;
                columnsValueBuilder.append(fieldColumn.getPlaceholderOnWriteTemplate()).append(",");
                this.placeholderColumns.put(field, fieldColumn);
            } else {
                this.insertColumns.add(fieldColumn);
                columnsValueBuilder.append("?,");
            }
            deleteDotOfNameIndex = columnsNameBuilder.length() - 1;
            deleteDotOfValueIndex = columnsValueBuilder.length() - 1;
        }
        if (deleteDotOfNameIndex > -1) {
            columnsNameBuilder.deleteCharAt(deleteDotOfNameIndex);
        }
        if (deleteDotOfValueIndex > -1) {
            columnsValueBuilder.deleteCharAt(deleteDotOfValueIndex);
        }
        this.insertSqlPrefix = StringUtils.replacePlaceholder("INSERT INTO %s(%s) VALUES", "%s", this.tableName, columnsNameBuilder.toString());
        this.insertSqlSuffix = "(" + columnsValueBuilder + ")";
        this.insertSql = StringUtils.replacePlaceholder(insertTemplate, "%s", this.tableName, columnsNameBuilder.toString(), columnsValueBuilder.toString());
    }

    private void initUpdateSql() {
        if (this.primary == null) {
            return;
        }
        String updateTemplate = "UPDATE %s SET %s WHERE %s = ?";
        ArrayList<FieldColumn> updateFiledColumns = new ArrayList<FieldColumn>();
        Collection<FieldColumn> fullFieldColumns = this.fieldColumnMapping.values();
        StringBuilder columnsBuilder = new StringBuilder();
        int deleteDotIndex = -1;
        for (FieldColumn fieldColumn : fullFieldColumns) {
            if (fieldColumn == this.primary || fieldColumn.isDisabledOnUpdate()) continue;
            if (fieldColumn.usePlaceholderOnWrite()) {
                this.usePlaceholderOnUpdate = true;
                columnsBuilder.append(fieldColumn.getColumnName()).append(" = ").append(fieldColumn.getPlaceholderOnWriteTemplate()).append(",");
                this.placeholderColumns.put(fieldColumn.getField().getName(), fieldColumn);
            } else {
                columnsBuilder.append(fieldColumn.getColumnName()).append(" = ?,");
                updateFiledColumns.add(fieldColumn);
            }
            deleteDotIndex = columnsBuilder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
        updateFiledColumns.add(this.primary);
        this.updateColumns = updateFiledColumns;
        this.updateByPrimarySql = StringUtils.replacePlaceholder(updateTemplate, "%s", this.tableName, columnsBuilder.toString(), this.primary.getColumnName());
    }

    private void initDeleteSql() {
        this.deleteByPrimarySql = this.getDeleteSql("DELETE FROM %s WHERE %s = ?");
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    String getSelectSql() {
        return this.selectByPrimarySql;
    }

    Map<String, FieldColumn> getFieldColumnMapping() {
        return this.fieldColumnMapping;
    }

    FieldColumn getPrimary() {
        return this.primary;
    }

    Sql getDeleteSqlObjectByParams(String sqlTemplate, Object params) {
        if (sqlTemplate == null) {
            sqlTemplate = "DELETE FROM %s%s";
        }
        Sql sqlObject = new Sql();
        StringBuilder whereClause = new StringBuilder();
        Object[] values = null;
        if (params != null) {
            boolean isEntityInstance = this.entityClass.isInstance(params);
            boolean isBeginer = true;
            Collection<String> fields = this.getParamsFields(params);
            values = new Object[fields.size()];
            int index = -1;
            for (String fieldName : fields) {
                FieldColumn fieldColumn = this.fieldColumnMapping.get(fieldName);
                if (fieldColumn == null) {
                    throw new OqlParematerException("\u6761\u4ef6params\u4e2d\u5b58\u5728\u5b9e\u4f53\u7c7b\u4e2d\u672a\u5b9a\u4e49\u7684\u5c5e\u6027\u57df\uff1a " + fieldName);
                }
                if (isBeginer) {
                    whereClause.append(" WHERE ");
                } else {
                    whereClause.append(" AND ");
                }
                whereClause.append(fieldColumn.getColumnName()).append(" = ?");
                values[++index] = isEntityInstance ? this.getFieldColumnValue(false, fieldColumn, params) : ((Map)params).get(fieldName);
                isBeginer = false;
            }
        }
        String sql = StringUtils.replacePlaceholder(sqlTemplate, "%s", this.tableName, whereClause.toString());
        sqlObject.setParamValues(values);
        sqlObject.setFormalSql(sql);
        return sqlObject;
    }

    Collection<String> getParamsFields(Object params) {
        Collection<String> fields;
        if (params instanceof Map) {
            Map map = (Map)params;
            fields = map.keySet();
        } else {
            fields = ObjectUtils.getNonEmptyFields(params);
        }
        return fields;
    }

    Sql getCountSqlObject(Object params) {
        OqlQuery oqlQuery = OqlQuery.create();
        if (params != null) {
            oqlQuery.addConditions(this.getParamsFields(params));
        }
        return this.getCountSqlObject(oqlQuery, params);
    }

    Sql getCountSqlObject(OqlQuery oqlQuery, Object params) {
        Sql sqlObject = new Sql();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        String countTemplate = "SELECT count(*) FROM %s t %s ";
        StringBuilder whereBuilder = new StringBuilder();
        this.appendWhereClause(whereBuilder, oqlQuery, params, paramValues);
        String sql = StringUtils.replacePlaceholder(countTemplate, "%s", this.tableName, whereBuilder.toString().trim());
        sqlObject.setFormalSql(sql);
        sqlObject.setParamValues(paramValues.toArray());
        return sqlObject;
    }

    void appendWhereClause(StringBuilder whereBuilder, OqlQuery oqlQuery, Object params, List<Object> paramValues) {
        boolean appendFlag = false;
        boolean isEntityInstance = this.entityClass.isInstance(params);
        List<FieldCondition> conditions = oqlQuery.getConditions();
        for (FieldCondition fieldCondition : conditions) {
            String field = fieldCondition.getField();
            FieldColumn fieldColumn = this.fieldColumnMapping.get(field);
            if (fieldColumn == null) continue;
            if (appendFlag) {
                whereBuilder.append(oqlQuery.getLogicTypeSpace());
            } else {
                whereBuilder.append(" WHERE ");
                appendFlag = true;
            }
            fieldCondition.appendWhereField(whereBuilder, fieldColumn);
            Object conditionValue = fieldCondition.getValue();
            if (conditionValue == null) {
                Object object = conditionValue = isEntityInstance ? this.getFieldColumnValue(false, fieldColumn, params) : ObjectUtils.getAttrValue(params, field);
            }
            if (fieldCondition.isLike()) {
                whereBuilder.append(fieldCondition.likeValueLeft()).append(EntitySqlMapping.getLikeConditionValue(conditionValue)).append(fieldCondition.likeValueRight());
                continue;
            }
            fieldCondition.appendWhereValue(whereBuilder, paramValues, conditionValue);
        }
        List<SubQueryCondition> subQueryConditions = oqlQuery.getSubQueryConditions();
        StringBuilder subBuilder = new StringBuilder();
        for (SubQueryCondition subQueryCondition : subQueryConditions) {
            String field = subQueryCondition.getField();
            String symbol = subQueryCondition.getSymbol();
            subBuilder.setLength(0);
            if (field != null) {
                FieldColumn fieldColumn = this.fieldColumnMapping.get(field);
                if (fieldColumn == null) continue;
                subBuilder.append("t.").append(fieldColumn.getColumnName()).append(" ").append(symbol);
            } else {
                subBuilder.append(symbol);
            }
            if (appendFlag) {
                whereBuilder.append(oqlQuery.getLogicTypeSpace());
            } else {
                whereBuilder.append(" WHERE ");
                appendFlag = true;
            }
            whereBuilder.append((CharSequence)subBuilder).append(" ");
            SubOqlQuery subOqlQuery = subQueryCondition.getSubOqlQuery();
            whereBuilder.append("(");
            EntitySqlMapping subEntitySqlMapping = subOqlQuery.getSubEntitySqlMapping();
            Sql subSql = subEntitySqlMapping.getSelectSqlObject(subOqlQuery, params);
            whereBuilder.append(subSql.getFormalSql());
            paramValues.addAll(Arrays.asList(subSql.getParamValues()));
            whereBuilder.append(")");
        }
    }

    private static String getLikeConditionValue(Object conditionValue) {
        if (conditionValue == null) {
            return "";
        }
        return EntitySqlMapping.getPlaceholderValue(conditionValue);
    }

    private static String getPlaceholderValue(Object value) {
        String message = value.toString();
        int placeholderIndex = message.indexOf(39);
        if (placeholderIndex == -1) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        int fromIndex = 0;
        while (placeholderIndex > -1) {
            builder.append(message, fromIndex, placeholderIndex);
            builder.append("\\'");
            fromIndex = placeholderIndex + 1;
            placeholderIndex = message.indexOf(39, fromIndex);
        }
        if (fromIndex < message.length()) {
            builder.append(message, fromIndex, message.length());
        }
        return builder.toString();
    }

    String getSelectSqlByIds(Collection ids) {
        StringBuilder baseSelectSql = new StringBuilder(this.selectSql);
        baseSelectSql.append(" WHERE t.").append(this.primary.getColumnName()).append(" in (");
        int len = ids.size();
        while (len-- > 0) {
            baseSelectSql.append("?");
            if (len <= 0) continue;
            baseSelectSql.append(",");
        }
        baseSelectSql.append(")");
        return baseSelectSql.toString();
    }

    <E> Serializable getId(E entity) {
        if (entity == null || !this.entityClass.isInstance(entity)) {
            throw new EntityException("entity is null or not an instance of " + this.entityClass);
        }
        try {
            return (Serializable)this.primary.getFieldValue(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    List<CascadeFetchMapping> getCascadeFetchMappings() {
        return this.cascadeFetchMappings;
    }

    public boolean isCacheable() {
        return this.table.cacheable();
    }

    public long expires() {
        return this.table.expires();
    }

    final EntityHandler getEntityHandler() {
        return this.entityHandler;
    }

    CacheableEntityHandler getCacheableEntityHandler() {
        return (CacheableEntityHandler)this.entityHandler;
    }

    <E> Sql getUpdateSqlObject(String sqlStringFormat, E entity) {
        if (this.primary == null) {
            return null;
        }
        Sql sql = new Sql();
        sql.setFormalSql(sqlStringFormat == null ? this.getUpdateByPrimarySql(entity) : this.getUpdateSql(sqlStringFormat));
        sql.setParamValues(this.getUpdateValues(entity));
        return sql;
    }

    <E> String getUpdateByPrimarySql(E entity) {
        if (this.usePlaceholderOnUpdate) {
            return this.renderPlaceholder(this.updateByPrimarySql, entity);
        }
        return this.updateByPrimarySql;
    }

    Sql getUpdateSqlObject(String sqlStringFormat, OqlQuery oqlQuery, Object params, String[] fields) {
        Sql sqlObject = new Sql();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        if (sqlStringFormat == null) {
            sqlStringFormat = "UPDATE %s t SET %s%s";
        }
        StringBuilder updateColumns = new StringBuilder();
        int deleteDotIndex = -1;
        boolean isEntityInstance = this.entityClass.isInstance(params);
        for (String field : fields) {
            Object value;
            FieldColumn fieldColumn = this.getFieldColumn(field);
            if (fieldColumn == null) continue;
            Object object = value = isEntityInstance ? this.getFieldColumnValue(false, fieldColumn, params) : ObjectUtils.getAttrValue(params, field);
            if (fieldColumn.usePlaceholderOnWrite()) {
                String placeholderTemplate = fieldColumn.getPlaceholderOnWriteTemplate();
                HashMap<String, String> vars = new HashMap<String, String>();
                vars.put(field, value == null || Number.class.isInstance(value) ? String.valueOf(value) : "'" + EntitySqlMapping.getPlaceholderValue(value) + "'");
                updateColumns.append(fieldColumn.getColumnName()).append(" = ").append(Expression.renderTemplate(placeholderTemplate, vars)).append(",");
            } else {
                updateColumns.append(fieldColumn.getColumnName()).append(" = ?,");
                paramValues.add(value);
            }
            deleteDotIndex = updateColumns.length() - 1;
        }
        if (deleteDotIndex > -1) {
            updateColumns.deleteCharAt(deleteDotIndex);
        }
        StringBuilder whereBuilder = new StringBuilder();
        this.appendWhereClause(whereBuilder, oqlQuery, params, paramValues);
        String sql = StringUtils.replacePlaceholder(sqlStringFormat, "%s", this.tableName, updateColumns.toString(), whereBuilder.toString());
        sqlObject.setFormalSql(sql);
        sqlObject.setParamValues(paramValues.toArray());
        return sqlObject;
    }

    Sql getDeleteSqlObject(String sqlStringFormat, Serializable id) {
        if (this.primary == null) {
            return null;
        }
        Sql sql = new Sql();
        sql.setFormalSql(sqlStringFormat == null ? this.deleteByPrimarySql : this.getDeleteSql(sqlStringFormat));
        sql.setParamValues(new Object[]{id});
        return sql;
    }

    String getUpdateSql(String updateTemplate) {
        StringBuilder columnsBuilder = new StringBuilder();
        int deleteDotIndex = -1;
        for (FieldColumn fieldColumn : this.updateColumns) {
            if (fieldColumn == this.primary) continue;
            columnsBuilder.append(fieldColumn.getColumnName()).append(" = ?,");
            deleteDotIndex = columnsBuilder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            columnsBuilder.deleteCharAt(deleteDotIndex);
        }
        return StringUtils.replacePlaceholder(updateTemplate, "%s", this.tableName, columnsBuilder.toString(), this.primary.getColumnName(), "?");
    }

    String getDeleteSql(String deleteTemplate) {
        if (this.primary == null) {
            return null;
        }
        return deleteTemplate == null ? this.deleteByPrimarySql : StringUtils.replacePlaceholder(deleteTemplate, "%s", this.tableName, this.primary.getColumnName());
    }

    <E> Sql getInsertSqlObject(E entity) {
        Sql sql = new Sql();
        sql.setFormalSql(this.getInsertSql(entity));
        sql.setParamValues(this.getInsertValues(entity));
        return sql;
    }

    <E> String getInsertSql(E entity) {
        return this.usePlaceholderOnInsert ? this.renderPlaceholder(this.insertSql, entity) : this.insertSql;
    }

    <E> Sql getInsertSqlObjectList(List<E> entityList) {
        Sql sql = new Sql();
        sql.setFormalSql(this.insertSql);
        ArrayList<Object[]> paramValuesList = new ArrayList<Object[]>(entityList.size());
        for (E entity : entityList) {
            paramValuesList.add(this.getInsertValues(entity));
        }
        sql.setParamValuesList(paramValuesList);
        return sql;
    }

    <E> Sql getBatchInsertSqlObject(List<E> entityList) {
        Sql sqlObject = new Sql();
        StringBuilder builder = new StringBuilder(this.insertSqlPrefix);
        Object[] paramValues = new Object[entityList.size() * this.insertColumns.size()];
        int index = -1;
        StringBuilder columnsValueBuilder = new StringBuilder();
        int deleteDotOfValueIndex = -1;
        for (E entity : entityList) {
            for (FieldColumn fieldColumn : this.insertColumns) {
                Object value = this.getFieldColumnValue(fieldColumn.isPrimary(), fieldColumn, entity);
                paramValues[++index] = value;
            }
            if (this.usePlaceholderOnInsert) {
                columnsValueBuilder.append(this.renderPlaceholder(this.insertSqlSuffix, entity)).append(",");
            } else {
                columnsValueBuilder.append(this.insertSqlSuffix).append(",");
            }
            deleteDotOfValueIndex = columnsValueBuilder.length() - 1;
        }
        if (deleteDotOfValueIndex > -1) {
            columnsValueBuilder.deleteCharAt(deleteDotOfValueIndex);
        }
        builder.append((CharSequence)columnsValueBuilder);
        sqlObject.setFormalSql(builder.toString());
        sqlObject.setParamValues(paramValues);
        return sqlObject;
    }

    <E> String renderPlaceholder(String template, E entity) {
        HashMap<String, String> vars = new HashMap<String, String>();
        Set<Map.Entry<String, FieldColumn>> entrySet = this.placeholderColumns.entrySet();
        for (Map.Entry<String, FieldColumn> entry : entrySet) {
            String field = entry.getKey();
            FieldColumn fieldColumn = entry.getValue();
            Object fieldValue = this.getFieldColumnValue(false, fieldColumn, entity);
            vars.put(field, fieldValue == null || Number.class.isInstance(fieldValue) ? String.valueOf(fieldValue) : "'" + EntitySqlMapping.getPlaceholderValue(fieldValue) + "'");
        }
        return Expression.renderTemplate(template, vars);
    }

    <E> Object[] getInsertValues(E entity) {
        return this.getFieldValues(entity, this.insertColumns, true);
    }

    <E> Object[] getUpdateValues(E entity) {
        return this.getFieldValues(entity, this.updateColumns, false);
    }

    <E> Object[] getFieldValues(E entity, List<FieldColumn> fieldColumns, boolean insertMode) {
        Object[] values = new Object[fieldColumns.size()];
        int index = -1;
        for (FieldColumn fieldColumn : fieldColumns) {
            Object value = this.getFieldColumnValue(insertMode && fieldColumn.isPrimary(), fieldColumn, entity);
            values[++index] = value;
        }
        return values;
    }

    <E> Object getFieldColumnValue(boolean primaryFlag, FieldColumn fieldColumn, E entity) {
        Object value;
        if (primaryFlag) {
            Class<?> primaryType;
            Id id = fieldColumn.getId();
            Id.GenerationType type = id.strategy();
            value = type == Id.GenerationType.UUID ? UUID.randomUUID().toString() : (type == Id.GenerationType.AutoAlg ? ((primaryType = fieldColumn.getField().getType()) == String.class ? IdGenerator.hex() : Long.valueOf(IdGenerator.id())) : this.invokeFieldColumnValue(fieldColumn, entity));
            fieldColumn.setFieldValue(entity, value);
            value = this.invokeFieldColumnValue(fieldColumn, entity);
        } else {
            value = this.invokeFieldColumnValue(fieldColumn, entity);
        }
        return value;
    }

    <E> Object invokeFieldColumnValue(FieldColumn fieldColumn, E entity) {
        Object fieldValue = fieldColumn.getFieldValue(entity);
        TypeTransformer typeTransformer = fieldColumn.getTypeTransformer();
        if (typeTransformer != null) {
            return typeTransformer.fromJavaField(fieldValue);
        }
        return fieldValue;
    }

    public boolean existField(String field) {
        return this.fieldColumnMapping.containsKey(field);
    }

    boolean existPrimary() {
        return this.primary != null;
    }

    boolean isUsePlaceholderOnInsert() {
        return this.usePlaceholderOnInsert;
    }

    SqlExecuteContext createContext(String apiName) {
        return SqlExecuteContext.of(apiName, this.disableLog);
    }
}

