/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONCustomMapper;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONL;
import io.github.wycst.wast.json.JSONNode;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONReader;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONTypeMapper;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONValidator;
import io.github.wycst.wast.json.JSONValue;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.UTF8CharSource;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JSON
extends JSONGeneral {
    public static Object parse(String json, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return JSONDefaultParser.parse(json, readOptions);
    }

    public static <T> T parseAs(String json, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return (T)JSONDefaultParser.parse(json, readOptions);
    }

    public static <T> T parseNumberAs(String json, Class<T> targetClass, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        Number value = (Number)JSON.parseAs(json, readOptions);
        return (T)ObjectUtils.toTypeNumber(value, targetClass);
    }

    public static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseMap(json, mapCls, readOptions);
    }

    public static Map parseObject(String json, ReadOption ... readOptions) {
        return JSONDefaultParser.parseMap(json, LinkedHashMap.class, readOptions);
    }

    public static JSONNode parseNode(String json, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return JSONNode.parse(json, readOptions);
    }

    public static Collection parseCollection(String json, Class<? extends Collection> collectionCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseCollection(json, collectionCls, readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(buf, readOptions);
    }

    public static Object parse(byte[] bytes, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(bytes, 0, bytes.length)) {
                return JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, null, readOptions);
            }
            return JSONDefaultParser.parseInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, null, readOptions);
        }
        return JSONDefaultParser.parseInternal(null, bytes, 0, bytes.length, null, readOptions);
    }

    public static Object parse(byte[] bytes, boolean ascii, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            if (ascii) {
                return JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, null, readOptions);
            }
            return JSONDefaultParser.parseInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, null, readOptions);
        }
        return JSONDefaultParser.parseInternal(null, bytes, 0, bytes.length, null, readOptions);
    }

    public static Object parse(String json, Class<?> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return JSON.parseInternal((CharSource)charSource, bytes, actualType, null, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, 0, chars.length, actualType, null, readOptions);
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return JSON.parseInternal(null, chars, 0, chars.length, actualType, null, readOptions);
    }

    public static <T> T parseObject(String json, Class<T> actualType) {
        if (json == null) {
            return null;
        }
        JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                AsciiStringSource charSource = new AsciiStringSource(json);
                return JSON.parseObjectInternalWithoutOptions(deserializer, (CharSource)charSource, bytes, actualType);
            }
            char[] chars = json.toCharArray();
            return JSON.parseObjectInternalWithoutOptions(deserializer, (CharSource)UTF16ByteArraySource.of(json), chars, actualType);
        }
        return JSON.parseObjectInternalWithoutOptions(deserializer, null, (char[])JSONUnsafe.getStringValue(json), actualType);
    }

    public static <T> T parseObject(String json, Class<T> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                AsciiStringSource charSource = new AsciiStringSource(json);
                return JSON.parseObjectInternal(deserializer, (CharSource)charSource, bytes, actualType, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parseObjectInternal(deserializer, (CharSource)UTF16ByteArraySource.of(json), chars, actualType, readOptions);
        }
        return JSON.parseObjectInternal(deserializer, null, (char[])JSONUnsafe.getStringValue(json), actualType, readOptions);
    }

    public static <T> T parseObject(String json, Class<T> actualType, JSONCustomMapper customMapper, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        try {
            return customMapper.parseCustomObject(json, actualType, readOptions);
        }
        catch (Throwable throwable) {
            throw new JSONException("custom error for " + actualType, throwable);
        }
    }

    public static <T> T parseObject(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == buf.length) {
                AsciiStringSource charSource = new AsciiStringSource(json);
                return JSON.parseObjectInternal(typeDeserializer, (CharSource)charSource, bytes, actualType, readOptions);
            }
            return JSON.parseObjectInternal(typeDeserializer, (CharSource)UTF16ByteArraySource.of(json), buf, actualType, readOptions);
        }
        return JSON.parseObjectInternal(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parseObject(byte[] buf, Class<T> actualType) {
        JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(buf, 0, buf.length)) {
                return JSON.parseObjectInternalWithoutOptions(deserializer, (CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType);
            }
            return JSON.parseObjectInternalWithoutOptions(deserializer, (CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType);
        }
        return JSON.parseObjectInternalWithoutOptions(deserializer, null, buf, actualType);
    }

    public static <T> T parseObject(byte[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(buf, 0, buf.length)) {
                return JSON.parseObjectInternal(typeDeserializer, (CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, readOptions);
            }
            return JSON.parseObjectInternal(typeDeserializer, (CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, readOptions);
        }
        return JSON.parseObjectInternal(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parseObject(byte[] buf, boolean ascii, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            if (ascii) {
                return JSON.parseObjectInternal(typeDeserializer, (CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, readOptions);
            }
            return JSON.parseObjectInternal(typeDeserializer, (CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, readOptions);
        }
        return JSON.parseObjectInternal(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parse(String json, Type type, ReadOption ... readOptions) {
        if (type instanceof Class) {
            return (T)JSON.parse(json, (Class)type, readOptions);
        }
        GenericParameterizedType genericParameterizedType = GenericParameterizedType.of(type);
        if (genericParameterizedType == null) {
            throw new JSONException("not supported type " + type);
        }
        return JSON.parse(json, genericParameterizedType, readOptions);
    }

    public static List parseNdJson(String json, ReadOption ... readOptions) {
        return JSONL.parseNdJson(json, JSONTypeDeserializer.ANY, readOptions);
    }

    public static List parseNdJson(InputStream is, ReadOption ... readOptions) {
        return JSONL.parseNdJson(StringUtils.fromStream(is), JSONTypeDeserializer.ANY, readOptions);
    }

    public static <T> List<T> parseNdJson(String json, Class<T> actualType, ReadOption ... readOptions) {
        return JSONL.parseNdJson(json, JSONTypeDeserializer.getTypeDeserializer(actualType), readOptions);
    }

    public static String toNdJsonString(Collection collection, WriteOption ... writeOptions) {
        JSONConfig jsonConfig = JSONConfig.config(writeOptions);
        JSONWriter content = JSONWriter.forStringWriter(jsonConfig);
        try {
            JSONL.writeNdJsonTo(content, collection, jsonConfig);
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
        finally {
            content.reset();
            jsonConfig.clear();
        }
    }

    public static void writeNdJsonTo(Collection collection, OutputStream os, WriteOption ... writeOptions) {
        JSON.writeNdJsonTo(collection, os, EnvUtils.CHARSET_DEFAULT, writeOptions);
    }

    public static void writeNdJsonTo(Collection collection, OutputStream os, Charset charset, WriteOption ... writeOptions) {
        JSONConfig jsonConfig = JSONConfig.config(writeOptions);
        JSONWriter streamWriter = JSONWriter.forStreamWriter(charset, jsonConfig);
        try {
            JSONL.writeNdJsonTo(streamWriter, collection, jsonConfig);
            streamWriter.toOutputStream(os);
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
        finally {
            streamWriter.reset();
            jsonConfig.clear();
        }
    }

    public static <T> T translateTo(Object source, Class<T> actualType, ReadOption ... readOptions) {
        return JSON.parseObject(JSON.toJsonString(source), actualType, readOptions);
    }

    public static <T> T cloneObject(Object source, ReadOption ... readOptions) {
        return (T)JSON.parseObject(JSON.toJsonString(source), source.getClass(), readOptions);
    }

    private static <T> T parseObjectInternalWithoutOptions(JSONTypeDeserializer deserializer, CharSource charSource, char[] buf, Class<T> actualType) {
        int fromIndex = 0;
        int toIndex = buf.length;
        while (buf[fromIndex] <= ' ') {
            ++fromIndex;
        }
        JSONParseContext parseContext = new JSONParseContext();
        parseContext.toIndex = buf.length;
        try {
            GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType(actualType);
            Object object = deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, '\u0000', parseContext);
            return (T)object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    private static <T> T parseObjectInternal(final JSONTypeDeserializer deserializer, final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType(actualType);
                return deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> T parseObjectInternalWithoutOptions(JSONTypeDeserializer deserializer, CharSource charSource, byte[] buf, Class<T> actualType) {
        int fromIndex = 0;
        int toIndex = buf.length;
        while (buf[fromIndex] <= 32) {
            ++fromIndex;
        }
        JSONParseContext parseContext = new JSONParseContext();
        parseContext.toIndex = buf.length;
        try {
            GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType(actualType);
            Object object = deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, (byte)0, parseContext);
            return (T)object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    private static <T> T parseObjectInternal(final JSONTypeDeserializer deserializer, final CharSource charSource, byte[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType(actualType);
                return deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static <T> T parse(String json, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSON.parseInternal((CharSource)AsciiStringSource.of(json), bytes, genericParameterizedType, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, genericParameterizedType, readOptions);
        }
        return JSON.parseInternal(null, (char[])JSONUnsafe.getStringValue(json), genericParameterizedType, readOptions);
    }

    public static <T> T parse(char[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == buf.length) {
                return JSON.parseInternal((CharSource)AsciiStringSource.of(json), bytes, genericParameterizedType, readOptions);
            }
            return JSON.parseInternal((CharSource)UTF16ByteArraySource.of(json), buf, genericParameterizedType, readOptions);
        }
        return JSON.parseInternal(null, buf, genericParameterizedType, readOptions);
    }

    public static <T> T parse(byte[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(buf, 0, buf.length)) {
                return JSON.parseInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, genericParameterizedType, readOptions);
            }
            return JSON.parseInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(buf)), buf, genericParameterizedType, readOptions);
        }
        return JSON.parseInternal(null, buf, genericParameterizedType, readOptions);
    }

    public static <T> List<T> parseArray(String json, Class<T> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSON.parseArrayInternal((CharSource)AsciiStringSource.of(json), bytes, actualType, readOptions);
            }
            return JSON.parseArrayInternal((CharSource)UTF16ByteArraySource.of(json), json.toCharArray(), actualType, readOptions);
        }
        return JSON.parseArrayInternal(null, (char[])JSONUnsafe.getStringValue(json), actualType, readOptions);
    }

    public static <T> List<T> parseArray(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == buf.length) {
                return JSON.parseArrayInternal((CharSource)AsciiStringSource.of(json), bytes, actualType, readOptions);
            }
            return JSON.parseArrayInternal((CharSource)UTF16ByteArraySource.of(json), buf, actualType, readOptions);
        }
        return JSON.parseArrayInternal(null, buf, actualType, readOptions);
    }

    public static Object parse(char[] buf, Class<?> actualType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == buf.length) {
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return JSON.parseInternal((CharSource)charSource, bytes, actualType, null, readOptions);
            }
            return JSON.parseInternal((CharSource)UTF16ByteArraySource.of(json), buf, 0, buf.length, actualType, null, readOptions);
        }
        return JSON.parseInternal(null, buf, 0, buf.length, actualType, null, readOptions);
    }

    public static Object parse(char[] buf, int fromIndex, int toIndex, Class<?> actualType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            int len = toIndex - fromIndex;
            String json = new String(buf, fromIndex, len);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == len) {
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return JSON.parseInternal((CharSource)charSource, bytes, actualType, null, readOptions);
            }
            return JSON.parseInternal((CharSource)UTF16ByteArraySource.of(json), buf, fromIndex, toIndex, actualType, null, readOptions);
        }
        return JSON.parseInternal(null, buf, fromIndex, toIndex, actualType, null, readOptions);
    }

    public static Object parse(byte[] buf, Class<?> actualType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(buf, 0, buf.length)) {
                return JSON.parseInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, null, readOptions);
            }
            return JSON.parseInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(buf)), buf, actualType, null, readOptions);
        }
        return JSON.parseInternal(null, buf, actualType, null, readOptions);
    }

    public static Object parseToObject(String json, Object instance, ReadOption ... readOptions) {
        if (instance == null || json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (json.length() == bytes.length) {
                return JSON.parseToObjectInternal((CharSource)AsciiStringSource.of(json), bytes, instance, readOptions);
            }
            return JSON.parseToObjectInternal((CharSource)UTF16ByteArraySource.of(json), json.toCharArray(), instance, readOptions);
        }
        return JSON.parseToObjectInternal(null, (char[])JSONUnsafe.getStringValue(json), instance, readOptions);
    }

    public static <E> Object parseToList(String json, Collection instance, Class<E> actualType, ReadOption ... readOptions) {
        if (instance == null || json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (json.length() == bytes.length) {
                return JSON.parseToListInternal((CharSource)AsciiStringSource.of(json), bytes, instance, actualType, readOptions);
            }
            return JSON.parseToListInternal((CharSource)UTF16ByteArraySource.of(json), json.toCharArray(), instance, actualType, readOptions);
        }
        return JSON.parseToListInternal(null, (char[])JSONUnsafe.getStringValue(json), instance, actualType, readOptions);
    }

    private static <T> T parseInternal(final CharSource charSource, char[] buf, final GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(genericParameterizedType.getActualType());
                return deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> T parseInternal(final CharSource charSource, byte[] buf, final GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(genericParameterizedType.getActualType());
                return deserializer.deserialize(charSource, buf, fromIndex, genericParameterizedType, null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parseInternal(final CharSource charSource, char[] buf, int fromIndex, int toIndex, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, fromIndex, toIndex, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                char beginChar = buf[fromIndex];
                switch (beginChar) {
                    case '[': {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType(actualType);
                return typeDeserializer.deserialize(charSource, buf, fromIndex, type, defaultValue, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parseInternal(final CharSource charSource, byte[] buf, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                byte beginByte = buf[fromIndex];
                switch (beginByte) {
                    case 91: {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType(actualType);
                return typeDeserializer.deserialize(charSource, buf, fromIndex, type, defaultValue, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> List<T> parseArrayInternal(final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (List)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserialize(charSource, buf, fromIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> List<T> parseArrayInternal(final CharSource charSource, byte[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (List)JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserialize(charSource, buf, fromIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parseToObjectInternal(final CharSource charSource, char[] buf, final Object instance, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                if (instance instanceof Map) {
                    return JSONTypeDeserializer.MAP.deserialize(charSource, buf, fromIndex, GenericParameterizedType.DefaultMap, instance, '\u0000', jsonParseContext);
                }
                Class<?> actualType = instance.getClass();
                JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = deserializer.getGenericParameterizedType(actualType);
                return deserializer.deserialize(charSource, buf, fromIndex, type, instance, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parseToObjectInternal(final CharSource charSource, byte[] buf, final Object instance, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                if (instance instanceof Map) {
                    return JSONTypeDeserializer.MAP.deserialize(charSource, buf, fromIndex, GenericParameterizedType.DefaultMap, instance, (byte)0, jsonParseContext);
                }
                Class<?> actualType = instance.getClass();
                JSONTypeDeserializer deserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = deserializer.getGenericParameterizedType(actualType);
                return deserializer.deserialize(charSource, buf, fromIndex, type, instance, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    private static <E> Object parseToListInternal(final CharSource charSource, char[] buf, final Collection instance, final Class<E> actualType, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, GenericParameterizedType.collectionType(instance.getClass(), actualType), (Object)instance, jsonParseContext);
            }
        }, readOptions);
    }

    private static <E> Object parseToListInternal(final CharSource charSource, byte[] buf, final Collection instance, final Class<E> actualType, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, GenericParameterizedType.collectionType(instance.getClass(), actualType), (Object)instance, jsonParseContext);
            }
        }, readOptions);
    }

    private static Object deserialize(char[] buf, int fromIndex, int toIndex, Deserializer deserializer, ReadOption ... readOptions) {
        JSONParseContext parseContext = new JSONParseContext();
        try {
            char beginChar = '\u0000';
            while ((beginChar = buf[fromIndex]) <= ' ') {
                ++fromIndex;
            }
            while (buf[toIndex - 1] <= ' ') {
                --toIndex;
            }
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.toIndex = toIndex;
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSON.clearCommentAndWhiteSpaces(buf, fromIndex + 1, parseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, parseContext);
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSON.clearCommentAndWhiteSpaces(buf, endIndex + 1, parseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    private static Object deserialize(byte[] buf, int fromIndex, int toIndex, Deserializer deserializer, ReadOption ... readOptions) {
        JSONParseContext parseContext = new JSONParseContext();
        try {
            byte beginByte;
            while ((beginByte = buf[fromIndex]) <= 32) {
                ++fromIndex;
            }
            while (buf[toIndex - 1] <= 32) {
                --toIndex;
            }
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.toIndex = toIndex;
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSON.clearCommentAndWhiteSpaces(buf, fromIndex + 1, parseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, parseContext);
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSON.clearCommentAndWhiteSpaces(buf, endIndex + 1, parseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    public static Object read(byte[] bytes, ReadOption ... readOptions) {
        return JSON.parse(bytes, readOptions);
    }

    public static Object read(InputStream is, ReadOption ... readOptions) throws IOException {
        if (is == null) {
            return null;
        }
        return JSON.read(is, (long)is.available(), readOptions);
    }

    private static Object read(InputStream is, long size, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            char[] buf = JSON.readOnceInputStream(is, (int)size);
            return JSON.parse(buf, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.read();
    }

    public static <T> T read(InputStream is, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(is, Integer.MAX_VALUE, actualType, readOptions);
    }

    private static <T> T read(InputStream is, long size, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            if (size == 0L) {
                return null;
            }
            char[] buf = JSON.readOnceInputStream(is, (int)size);
            return (T)JSON.parse(buf, actualType, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return (T)jsonReader.readAsResult((GenericParameterizedType)GenericParameterizedType.actualType(actualType));
    }

    public static <T> T read(File file, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read((InputStream)new FileInputStream(file), Integer.MAX_VALUE, actualType, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(url, actualType, false, -1, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, boolean forceStreamMode, int timeout, ReadOption ... readOptions) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (timeout > 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        conn.connect();
        return JSON.read(conn.getInputStream(), forceStreamMode ? Integer.MAX_VALUE : (long)conn.getContentLength(), actualType, readOptions);
    }

    public static <T> T read(File file, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(file);
        jsonReader.setOptions(readOptions);
        return (T)jsonReader.readAsResult((GenericParameterizedType)genericType);
    }

    public static <T> T read(InputStream is, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(is);
        jsonReader.setOptions(readOptions);
        return (T)jsonReader.readAsResult((GenericParameterizedType)genericType);
    }

    public static String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, new JSONConfig(), 0);
    }

    public static String toJsonString(Object obj, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JSONConfig jsonConfig = new JSONConfig();
        JSONOptions.writeOptions(options, jsonConfig);
        return JSON.stringify(obj, jsonConfig, 0);
    }

    public static String toPrettifyJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, JSONConfig.config(WriteOption.FormatOutColonSpace), 0);
    }

    public static String prettifyJsonString(String json) {
        if (json == null) {
            return null;
        }
        return JSON.stringify(JSON.parse(json, new ReadOption[0]), JSONConfig.config(WriteOption.FormatOutColonSpace), 0);
    }

    public static byte[] toJsonBytes(Object obj, WriteOption ... options) {
        return JSON.toJsonBytes(obj, Charset.defaultCharset(), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toJsonBytes(Object obj, Charset charset, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JSONConfig jsonConfig = JSONConfig.config(options);
        JSONWriter stringWriter = JSONWriter.forBytesWriter(charset, jsonConfig);
        try {
            JSON.writeToJSONWriter(obj, stringWriter, jsonConfig);
            byte[] byArray = stringWriter.toBytes();
            return byArray;
        }
        finally {
            stringWriter.reset();
        }
    }

    public static String toJsonString(Object obj, JSONConfig jsonConfig) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, jsonConfig, 0);
    }

    private static String stringify(Object obj, JSONConfig jsonConfig, int indentLevel) {
        JSONWriter content = JSONWriter.forStringWriter(jsonConfig);
        try {
            JSONTypeSerializer.getTypeSerializer(obj.getClass()).serialize(obj, content, jsonConfig, indentLevel);
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
        finally {
            content.reset();
            jsonConfig.clear();
        }
    }

    public static void writeJsonTo(Object object, File file, WriteOption ... options) {
        try {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            JSON.writeJsonTo(object, (OutputStream)new FileOutputStream(file), EnvUtils.CHARSET_DEFAULT, options);
        }
        catch (FileNotFoundException e) {
            throw new JSONException("file not found", e);
        }
    }

    public static void writeJsonTo(Object object, OutputStream os, WriteOption ... options) {
        JSON.writeJsonTo(object, os, EnvUtils.CHARSET_DEFAULT, options);
    }

    public static void writeJsonTo(Object object, OutputStream os, Charset charset, WriteOption ... options) {
        JSONConfig jsonConfig = JSONConfig.config(options);
        JSONWriter streamWriter = JSONWriter.forStreamWriter(charset, jsonConfig);
        try {
            JSON.writeToJSONWriter(object, streamWriter, jsonConfig);
            streamWriter.toOutputStream(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            streamWriter.reset();
        }
    }

    public static void writeJsonTo(Object object, Writer writer, WriteOption ... options) {
        JSONConfig jsonConfig = JSONConfig.config(options);
        JSONWriter jsonWriter = JSONWriter.forStringWriter(jsonConfig);
        try {
            JSON.writeToJSONWriter(object, jsonWriter, jsonConfig);
            jsonWriter.writeTo(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            jsonWriter.reset();
        }
    }

    public static void writeSuperLargeJsonTo(Object object, OutputStream os, WriteOption ... options) {
        JSON.writeToJSONWriter(object, JSONWriter.wrap(new OutputStreamWriter(os, EnvUtils.CHARSET_DEFAULT)), JSONConfig.config(options));
    }

    public static void writeSuperLargeJsonTo(Object object, OutputStream os, Charset charset, WriteOption ... options) {
        JSON.writeToJSONWriter(object, JSONWriter.wrap(new OutputStreamWriter(os, charset)), JSONConfig.config(options));
    }

    public static void writeSuperLargeJsonTo(Object object, Writer writer, WriteOption ... options) {
        JSON.writeToJSONWriter(object, JSONWriter.wrap(writer), JSONConfig.config(options));
    }

    public static String toJsonString(Object obj, JSONCustomMapper customizedMapper, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JSONConfig jsonConfig = JSONConfig.config(options);
        if (customizedMapper == null) {
            return JSON.stringify(obj, jsonConfig, 0);
        }
        return JSON.stringify(obj, jsonConfig, 0, customizedMapper);
    }

    public static String toPrettifyJsonString(Object obj, JSONCustomMapper customizedMapper) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, JSONConfig.config(WriteOption.FormatOutColonSpace), 0, customizedMapper);
    }

    public static String toJsonString(Object obj, JSONConfig jsonConfig, JSONCustomMapper customMapper) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, jsonConfig, 0, customMapper);
    }

    public static void writeJsonTo(Object object, OutputStream os, JSONCustomMapper customMapper, WriteOption ... options) {
        JSON.writeJsonTo(object, os, EnvUtils.CHARSET_DEFAULT, customMapper, options);
    }

    public static void writeJsonTo(Object object, OutputStream os, Charset charset, JSONCustomMapper customMapper, WriteOption ... options) {
        JSONConfig jsonConfig = JSONConfig.config(options);
        JSONWriter streamWriter = JSONWriter.forStreamWriter(charset, jsonConfig);
        try {
            JSON.writeToJSONWriter(object, streamWriter, jsonConfig, customMapper);
            streamWriter.toOutputStream(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            streamWriter.reset();
        }
    }

    public static void writeJsonTo(Object object, Writer writer, JSONCustomMapper customMapper, WriteOption ... options) {
        JSONConfig jsonConfig = JSONConfig.config(options);
        JSONWriter jsonWriter = JSONWriter.forStringWriter(jsonConfig);
        try {
            JSON.writeToJSONWriter(object, jsonWriter, jsonConfig, customMapper);
            jsonWriter.writeTo(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            jsonWriter.reset();
        }
    }

    static void writeToJSONWriter(Object object, JSONWriter writer, JSONConfig jsonConfig) {
        if (object != null) {
            try {
                JSONTypeSerializer.getTypeSerializer(object.getClass()).serialize(object, writer, jsonConfig, 0);
                writer.flush();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            finally {
                jsonConfig.clear();
                if (jsonConfig.autoCloseStream) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    static void writeToJSONWriter(Object object, JSONWriter writer, JSONConfig jsonConfig, JSONCustomMapper customizedMapper) {
        if (object != null) {
            try {
                customizedMapper.serializeCustomized(object, writer, jsonConfig, 0);
                writer.flush();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            finally {
                jsonConfig.clear();
                if (jsonConfig.autoCloseStream) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static String stringify(Object obj, JSONConfig jsonConfig, int indentLevel, JSONCustomMapper customizedMapper) {
        JSONWriter content = JSONWriter.forStringWriter(jsonConfig);
        try {
            customizedMapper.serializeCustomized(obj, content, jsonConfig, indentLevel);
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
        finally {
            content.reset();
            jsonConfig.clear();
        }
    }

    public static boolean validate(String json, ReadOption ... readOptions) {
        if (json == null) {
            return false;
        }
        return JSONValidator.validate(json, readOptions);
    }

    public static boolean validate(char[] buf, ReadOption ... readOptions) {
        return JSONValidator.validate(buf, readOptions);
    }

    public static boolean validate(byte[] buf, ReadOption ... readOptions) {
        return JSONValidator.validate(buf, readOptions);
    }

    public static synchronized void registerTypeDeserializer(Class<?> type, JSONTypeDeserializer typeDeserializer) {
        type.getClass();
        if (JSONTypeDeserializer.isBuiltInType(type)) {
            throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
        }
        JSONTypeDeserializer.putTypeDeserializer(typeDeserializer, type);
    }

    public static synchronized void registerTypeSerializer(Class<?> type, JSONTypeSerializer typeSerializer) {
        type.getClass();
        if (JSONTypeSerializer.isBuiltInType(type)) {
            throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
        }
        JSONTypeSerializer.putTypeSerializer(typeSerializer, type);
    }

    public static <T> void registerTypeMapper(Class<T> type, JSONTypeMapper<T> mapper) {
        JSON.registerTypeMapper(type, mapper, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void registerTypeMapper(Class<T> type, JSONTypeMapper<T> mapper, boolean ignoreIfExist) {
        type.getClass();
        Class<T> clazz = type;
        synchronized (clazz) {
            if (JSONTypeDeserializer.isBuiltInType(type)) {
                if (!ignoreIfExist) {
                    throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
                }
            } else {
                JSONTypeDeserializer.registerTypeDeserializer(JSON.buildCustomizedDeserializer(mapper), type);
            }
            if (JSONTypeSerializer.isBuiltInType(type)) {
                if (!ignoreIfExist) {
                    throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for class " + type);
                }
            } else {
                JSONTypeSerializer.registerTypeSerializer(JSON.buildCustomizedSerializer(mapper), type);
            }
        }
    }

    public static void disableJIT() {
        ENABLE_JIT = false;
    }

    static <T> JSONTypeSerializer buildCustomizedSerializer(final JSONTypeMapper<T> mapper) {
        return new JSONTypeSerializer(){

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                Object baseValue;
                JSONValue<?> result = mapper.writeAs(value, jsonConfig);
                if (result == null || (baseValue = result.value) == null) {
                    writer.writeNull();
                } else {
                    JSONTypeSerializer typeSerializer = 13.getTypeSerializer(baseValue.getClass());
                    typeSerializer.serialize(baseValue, writer, jsonConfig, indent);
                }
            }

            @Override
            protected void serializeCustomized(Object value, JSONWriter writer, JSONConfig jsonConfig, int indentLevel, JSONCustomMapper customizedMapper) throws Exception {
                Object baseValue;
                JSONValue<?> result = mapper.writeAs(value, jsonConfig);
                if (result == null || (baseValue = result.value) == null) {
                    writer.writeNull();
                } else if (baseValue instanceof Map) {
                    MAP.serializeCustomized(baseValue, writer, jsonConfig, indentLevel, customizedMapper);
                } else if (baseValue instanceof List) {
                    COLLECTION.serializeCustomized(baseValue, writer, jsonConfig, indentLevel, customizedMapper);
                } else {
                    JSONTypeSerializer typeSerializer = 13.getTypeSerializer(baseValue.getClass());
                    typeSerializer.serialize(baseValue, writer, jsonConfig, indentLevel);
                }
            }
        };
    }

    static <E> JSONTypeDeserializer buildCustomizedDeserializer(final JSONTypeMapper<E> typeMapper) {
        return new JSONTypeDeserializer(){

            @Override
            protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
                Object value = ANY.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
                return typeMapper.readOf(value);
            }

            @Override
            protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                Object value = ANY.deserialize(charSource, bytes, fromIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
                return typeMapper.readOf(value);
            }
        };
    }

    static {
        if (EnvUtils.JDK_8_PLUS) {
            try {
                Class.forName("io.github.wycst.wast.json.JSONTemporalExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static abstract class Deserializer {
        Deserializer() {
        }

        Object deserialize(char[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }

        Object deserialize(byte[] buf, int fromIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

