/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class JSONL
extends JSONGeneral {
    JSONL() {
    }

    static List parseNdJson(String json, JSONTypeDeserializer typeDeserializer, ReadOption[] readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONL.parseNdJson(typeDeserializer, (CharSource)AsciiStringSource.of(json), bytes, JSONParseContext.of(readOptions));
            }
            char[] chars = json.toCharArray();
            return JSONL.parseNdJson(typeDeserializer, (CharSource)UTF16ByteArraySource.of(json), chars, JSONParseContext.of(readOptions));
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return JSONL.parseNdJson(typeDeserializer, null, chars, JSONParseContext.of(readOptions));
    }

    static List parseNdJson(JSONTypeDeserializer typeDeserializer, CharSource source, byte[] bytes, JSONParseContext parseContext) {
        int toIndex;
        int fromIndex = 0;
        parseContext.toIndex = toIndex = bytes.length;
        parseContext.multiple = true;
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            while (true) {
                byte b;
                if (fromIndex < toIndex && ((b = bytes[fromIndex]) <= 32 || b == 44)) {
                    ++fromIndex;
                    continue;
                }
                if (fromIndex == toIndex) break;
                Object result = typeDeserializer.deserialize(source, bytes, fromIndex, GenericParameterizedType.AnyType, null, (byte)0, parseContext);
                results.add(result);
                fromIndex = parseContext.endIndex + 1;
            }
            return results;
        }
        catch (Exception e) {
            String errorContextTextAt = JSONL.createErrorContextText(bytes, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", " + errorContextTextAt, e);
        }
    }

    static List parseNdJson(JSONTypeDeserializer typeDeserializer, CharSource source, char[] chars, JSONParseContext parseContext) {
        int toIndex;
        int fromIndex = 0;
        parseContext.toIndex = toIndex = chars.length;
        parseContext.multiple = true;
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            while (true) {
                char ch;
                if (fromIndex < toIndex && ((ch = chars[fromIndex]) <= ' ' || ch == ',')) {
                    ++fromIndex;
                    continue;
                }
                if (fromIndex == toIndex) break;
                Object result = typeDeserializer.deserialize(source, chars, fromIndex, GenericParameterizedType.AnyType, null, ',', parseContext);
                results.add(result);
                fromIndex = parseContext.endIndex + 1;
            }
            return results;
        }
        catch (Exception e) {
            String errorContextTextAt = JSONL.createErrorContextText(chars, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + " " + errorContextTextAt, e);
        }
    }

    static void writeNdJsonTo(JSONWriter content, Collection collection, JSONConfig jsonConfig) {
        try {
            int indentLevel = 0;
            Class<?> firstClass = null;
            JSONTypeSerializer firstSerializer = null;
            for (Object object : collection) {
                JSONTypeSerializer typeSerializer;
                if (object == null) continue;
                Class<?> objectClass = object.getClass();
                if (firstClass == null) {
                    firstClass = objectClass;
                    typeSerializer = firstSerializer = JSONTypeSerializer.getTypeSerializer(objectClass);
                } else {
                    typeSerializer = objectClass == firstClass ? firstSerializer : JSONTypeSerializer.getTypeSerializer(objectClass);
                }
                typeSerializer.serialize(object, content, jsonConfig, indentLevel);
                if (!(content.endsWith(125) || content.endsWith(93) || content.endsWith(34))) {
                    content.writeJSONToken(',');
                }
                content.writeJSONToken('\n');
            }
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
    }
}

