/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONNode;

public abstract class JSONNodeCollector<T> {
    public static final JSONNodeCollector<JSONNode> DEFAULT = new JSONNodeCollector<JSONNode>(){

        @Override
        public JSONNode map(JSONNode node) {
            return node;
        }
    };
    public static final JSONNodeCollector<Object> ANY = new JSONNodeCollector<Object>(){

        @Override
        public Object map(JSONNode node) {
            return node.any();
        }
    };

    public final JSONNodeCollector self() {
        return this;
    }

    public abstract T map(JSONNode var1);

    public static final <T> JSONNodeCollector<T> of(final Class<T> targetClass) {
        targetClass.getClass();
        return new JSONNodeCollector<T>(){

            @Override
            public T map(JSONNode node) {
                return node.getValue(targetClass);
            }
        };
    }

    public JSONNodeCollector onlyCollectLeaf() {
        return this instanceof LeafWrapImpl ? this : new LeafWrapImpl(this);
    }

    public boolean filter(JSONNode node) {
        return true;
    }

    static class LeafWrapImpl<T>
    extends JSONNodeCollector<T> {
        final JSONNodeCollector<T> collector;

        LeafWrapImpl(JSONNodeCollector<T> collector) {
            this.collector = collector;
        }

        @Override
        public T map(JSONNode node) {
            return this.collector.map(node);
        }

        @Override
        public boolean filter(JSONNode node) {
            if (!node.leaf) {
                return false;
            }
            return this.collector.filter(node);
        }
    }
}

