/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.json.JSONNode;
import java.util.HashMap;
import java.util.List;

public abstract class JSONNodePathFilter {
    static final EvaluateEnvironment EVALUATE_ENVIRONMENT = EvaluateEnvironment.create();
    static final List<String> CONTEXT_VARS = CollectionUtils.listOf("$", "self", "parent", "this");

    public abstract boolean doFilter(JSONNode var1);

    public static final JSONNodePathFilter condition(String condition) {
        return new ExpressionFilterImpl(condition);
    }

    public static final JSONNodePathFilter expression(Expression expression) {
        return new ExpressionFilterImpl(expression);
    }

    static {
        EVALUATE_ENVIRONMENT.setAllowVariableNull(true);
    }

    static final class ExpressionFilterImpl
    extends JSONNodePathFilter {
        final Expression expression;
        final String cacheStr;
        final boolean shouldNewContext;

        ExpressionFilterImpl(String condition) {
            this.expression = Expression.parse(condition);
            this.cacheStr = "[" + condition + "]";
            this.shouldNewContext = this.checkShouldNewContext();
        }

        public ExpressionFilterImpl(Expression expression) {
            this.expression = expression;
            this.cacheStr = "[" + expression.getSource() + "]";
            this.shouldNewContext = this.checkShouldNewContext();
        }

        private boolean checkShouldNewContext() {
            List<String> vars = this.expression.getRootVariables();
            for (String var : CONTEXT_VARS) {
                if (!vars.contains(var)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean doFilter(JSONNode node) {
            Object evalResult;
            HashMap<String, Object> context;
            Object any = node.any();
            if (node.isObject()) {
                context = (HashMap<String, Object>)any;
                if (this.shouldNewContext) {
                    HashMap<String, Object> newContext = new HashMap<String, Object>(context);
                    if (!context.containsKey("$")) {
                        newContext.put("$", node.root.any());
                    }
                    if (!context.containsKey("self")) {
                        newContext.put("self", any);
                    }
                    if (!context.containsKey("parent")) {
                        newContext.put("parent", node.parent);
                    }
                    if (!context.containsKey("this")) {
                        newContext.put("this", node);
                    }
                    context = newContext;
                }
            } else {
                context = new HashMap<String, Object>();
                context.put("$", node.root.any());
                context.put("self", any);
                context.put("this", node);
                context.put("parent", node.parent);
            }
            if ((evalResult = this.expression.evaluate(context, EVALUATE_ENVIRONMENT)) instanceof Boolean) {
                return (Boolean)evalResult;
            }
            return evalResult != null && !evalResult.equals(0);
        }

        public String toString() {
            return this.cacheStr;
        }
    }
}

