/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.annotations.JsonProperty;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

final class JSONPojoSerializerCodeGen {
    static final String IMPORT_CODE_TEXT = "import io.github.wycst.wast.json.JSONConfig;\nimport io.github.wycst.wast.json.JSONPojoFieldSerializer;\nimport io.github.wycst.wast.json.JSONPojoStructure;\n\nimport io.github.wycst.wast.json.JSONWriter;\n\n";
    static final AtomicLong SEQ = new AtomicLong(1L);

    JSONPojoSerializerCodeGen() {
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printSource, boolean runtime) {
        Class<?> pojoClass = jsonPojoStructure.getSourceClass();
        String simpleName = pojoClass.getSimpleName();
        String canonicalName = pojoClass.getCanonicalName();
        String genClassName = "__JPS_" + simpleName + "_" + IdGenerator.hex();
        String packageName = pojoClass.getPackage().getName();
        StringBuilder codeBuilder = new StringBuilder(2048);
        codeBuilder.append("package ").append(packageName).append(";\n\n");
        codeBuilder.append(IMPORT_CODE_TEXT);
        if (!runtime) {
            codeBuilder.append("/**\n");
            codeBuilder.append(" * pojo serializer \n");
            codeBuilder.append(" * @Date " + new GregorianDate() + "\n");
            codeBuilder.append(" * @Created by code generator\n");
            codeBuilder.append(" */\n");
        }
        codeBuilder.append("public final class ").append(genClassName).append(" extends io.github.wycst.wast.json.JSONPojoSerializer<").append(canonicalName).append("> {\n\n");
        StringBuilder fieldsDefinitionBuilder = new StringBuilder(64);
        StringBuilder fieldSetBuilder = new StringBuilder(64);
        StringBuilder compactHeaderBuilder = new StringBuilder(1024);
        StringBuilder compactBodyBuilder = new StringBuilder(1024);
        StringBuilder fmatOutHeaderBuilder = new StringBuilder(1024);
        StringBuilder fmatOutBodyBuilder = new StringBuilder(1024);
        if (!jsonPojoStructure.isForceUseFields()) {
            compactHeaderBuilder.append("\t\tif(jsonConfig.isUseFields()) {\n");
            compactHeaderBuilder.append("\t\t\tsuper.serializePojoCompact(entity, writer, jsonConfig, indentLevel);\n");
            compactHeaderBuilder.append("\t\t\treturn;\n");
            compactHeaderBuilder.append("\t\t}\n");
            fmatOutHeaderBuilder.append("\t\tif(jsonConfig.isUseFields()) {\n");
            fmatOutHeaderBuilder.append("\t\t\tsuper.serializePojoFormatOut(entity, writer, jsonConfig, indentLevel);\n");
            fmatOutHeaderBuilder.append("\t\t\treturn;\n");
            fmatOutHeaderBuilder.append("\t\t}\n");
        }
        compactHeaderBuilder.append("\t\tboolean isEmptyFlag = !checkWriteClassName(jsonConfig.isWriteClassName(), writer, pojoClass, false, indentLevel, jsonConfig);\n");
        fmatOutHeaderBuilder.append("\t\tboolean isEmptyFlag = !checkWriteClassName(jsonConfig.isWriteClassName(), writer, pojoClass, true, indentLevel, jsonConfig);\n");
        fmatOutHeaderBuilder.append("\t\tint indentPlus = indentLevel + 1;\n");
        fmatOutHeaderBuilder.append("\t\tboolean formatOutColonSpace = jsonConfig.formatOutColonSpace;\n");
        JSONPojoFieldSerializer[] fieldSerializerUseMethods = jsonPojoStructure.getFieldSerializers(false);
        fieldsDefinitionBuilder.append("\n");
        StringBuilder fieldNameTempBuilder = new StringBuilder();
        boolean appendFieldSerializersFlag = false;
        boolean appendUnCamelCaseToUnderlineFlag = false;
        if (fieldSerializerUseMethods.length > 0) {
            int fieldIndex = 0;
            boolean ensureNotEmptyFlag = false;
            for (JSONPojoFieldSerializer fieldSerializer : fieldSerializerUseMethods) {
                boolean useUnsafe;
                String underlineName;
                boolean firstFlag = fieldIndex == 0;
                GetterInfo getterInfo = fieldSerializer.getterInfo;
                String name = getterInfo.getName();
                boolean nameEqualUnderlineName = name.equals(underlineName = getterInfo.getUnderlineName());
                if (!nameEqualUnderlineName) {
                    appendUnCamelCaseToUnderlineFlag = true;
                }
                boolean primitive = getterInfo.isPrimitive();
                Class<?> returnType = getterInfo.getReturnType();
                String returnTypeName = returnType.getName().intern();
                boolean accessFlag = getterInfo.isAccess() && Modifier.isPublic(returnType.getModifiers());
                boolean isBoolean = returnType == Boolean.TYPE;
                String fieldSerializerName = name + "UseMethodSerializer";
                String fieldKey = fieldSerializer.getName();
                String valueVar = "__" + fieldKey;
                byte[] bytes = valueVar.getBytes();
                boolean isFieldNameAscii = bytes.length == valueVar.length();
                long[] longs = null;
                long[] longsWithComma = null;
                long[] longsWithCommaBoolFalse = null;
                int[] ints = null;
                int[] intsWithComma = null;
                int[] intsWithCommaBoolFalse = null;
                int fieldNameTokenLength = 0;
                int fieldNameTokenBoolFalseLength = 0;
                long[] longsFormatOut = null;
                int[] intsFormatOut = null;
                int fieldNameFormatOutTokenLength = 0;
                boolean bl = useUnsafe = runtime && isFieldNameAscii;
                if (useUnsafe) {
                    fieldNameTempBuilder.setLength(0);
                    fieldNameTempBuilder.append(",\"").append(fieldKey).append("\":");
                    longsFormatOut = UnsafeHelper.getCharLongs(fieldNameTempBuilder.substring(1));
                    intsFormatOut = UnsafeHelper.getByteInts(fieldNameTempBuilder.substring(1));
                    fieldNameFormatOutTokenLength = fieldNameTempBuilder.length() - 1;
                    if (isBoolean) {
                        fieldNameTempBuilder.append("true");
                    }
                    fieldNameTokenLength = fieldNameTempBuilder.length();
                    fieldNameTokenBoolFalseLength = fieldNameTokenLength + 1;
                    longs = isBoolean ? UnsafeHelper.getCharLongs(fieldNameTempBuilder.substring(1)) : longsFormatOut;
                    longsWithComma = UnsafeHelper.getCharLongs(fieldNameTempBuilder.toString());
                    ints = isBoolean ? UnsafeHelper.getByteInts(fieldNameTempBuilder.substring(1)) : intsFormatOut;
                    intsWithComma = UnsafeHelper.getByteInts(fieldNameTempBuilder.toString());
                    if (isBoolean) {
                        fieldNameTempBuilder.setLength(fieldNameTempBuilder.length() - 4);
                        fieldNameTempBuilder.append("false");
                        longsWithCommaBoolFalse = UnsafeHelper.getCharLongs(fieldNameTempBuilder.toString());
                        intsWithCommaBoolFalse = UnsafeHelper.getByteInts(fieldNameTempBuilder.toString());
                    }
                }
                if (accessFlag) {
                    long l3;
                    int i2;
                    int i1;
                    long l2;
                    long l1;
                    int len;
                    int i;
                    boolean remOne;
                    int total;
                    compactBodyBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = entity." + getterInfo.generateCode() + ";\n");
                    fmatOutBodyBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = entity." + getterInfo.generateCode() + ";\n");
                    JSONPojoSerializerCodeGen.generateSerializeFieldFormatOutCode(ensureNotEmptyFlag, primitive, fieldSerializerName, fieldKey, valueVar, nameEqualUnderlineName, underlineName, useUnsafe, longsFormatOut, intsFormatOut, fieldNameFormatOutTokenLength, returnType, fieldSerializer, runtime, fmatOutBodyBuilder);
                    if (primitive) {
                        if (firstFlag) {
                            if (isBoolean) {
                                compactBodyBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":true\");\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":false\");\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t}\n");
                            } else {
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        int arrLength = longs.length;
                                        boolean bl2 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                    compactBodyBuilder.append("\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    compactBodyBuilder.append("\t\t}\n");
                                }
                                if (returnType == Double.TYPE) {
                                    compactBodyBuilder.append("\t\twriter.writeDouble(" + valueVar + ");\n");
                                } else if (returnType == Float.TYPE) {
                                    compactBodyBuilder.append("\t\twriter.writeFloat(" + valueVar + ");\n");
                                } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                    compactBodyBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                                } else {
                                    compactBodyBuilder.append("\t\twriter.writeJSONChar(" + valueVar + ");\n");
                                }
                            }
                        } else if (isBoolean) {
                            if (ensureNotEmptyFlag) {
                                compactBodyBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl3 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":true\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl4 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":true\");\n");
                                    }
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenBoolFalseLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithCommaBoolFalse.length;
                                        boolean bl5 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithCommaBoolFalse[i];
                                                l2 = longsWithCommaBoolFalse[i + 1];
                                                i1 = intsWithCommaBoolFalse[i];
                                                i2 = intsWithCommaBoolFalse[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithCommaBoolFalse[i] + "L, " + intsWithCommaBoolFalse[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":false\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenBoolFalseLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithCommaBoolFalse.length;
                                        boolean bl6 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithCommaBoolFalse[i];
                                                l2 = longsWithCommaBoolFalse[i + 1];
                                                i1 = intsWithCommaBoolFalse[i];
                                                i2 = intsWithCommaBoolFalse[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithCommaBoolFalse[i] + "L, " + intsWithCommaBoolFalse[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":false\");\n");
                                    }
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t}\n");
                            } else {
                                compactBodyBuilder.append("\t\tif(isEmptyFlag) {\n");
                                compactBodyBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        int arrLength = longs.length;
                                        boolean bl7 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":true\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":false\");\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t\t}\n");
                                compactBodyBuilder.append("\t\t} else {\n");
                                compactBodyBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl8 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":true\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    compactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":false\");\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    compactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t\t}\n");
                                compactBodyBuilder.append("\t\t}\n");
                            }
                        } else {
                            if (ensureNotEmptyFlag) {
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl9 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl10 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                    compactBodyBuilder.append("\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    compactBodyBuilder.append("\t\t}\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\tif(isEmptyFlag) {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        int arrLength = longs.length;
                                        boolean bl11 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        int arrLength = longs.length;
                                        boolean bl12 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl13 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        int arrLength = longsWithComma.length;
                                        boolean bl14 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                    }
                                    compactBodyBuilder.append("\t\t\t} else {\n");
                                    compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    compactBodyBuilder.append("\t\t\t}\n");
                                }
                                compactBodyBuilder.append("\t\t}\n");
                            }
                            if (returnType == Double.TYPE) {
                                compactBodyBuilder.append("\t\twriter.writeDouble(" + valueVar + ");\n");
                            } else if (returnType == Float.TYPE) {
                                compactBodyBuilder.append("\t\twriter.writeFloat(" + valueVar + ");\n");
                            } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                compactBodyBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                            } else {
                                compactBodyBuilder.append("\t\twriter.writeJSONChar(" + valueVar + ");\n");
                            }
                        }
                        ensureNotEmptyFlag = true;
                    } else {
                        compactBodyBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                        if (firstFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    int arrLength = longs.length;
                                    boolean bl15 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    int arrLength = longs.length;
                                    boolean bl16 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                }
                                compactBodyBuilder.append("\t\t\t} else {\n");
                                compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                compactBodyBuilder.append("\t\t\t}\n");
                            }
                            compactBodyBuilder.append("\t\t\tisEmptyFlag = false;\n");
                        } else if (ensureNotEmptyFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    int arrLength = longsWithComma.length;
                                    boolean bl17 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    int arrLength = longsWithComma.length;
                                    boolean bl18 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                }
                                compactBodyBuilder.append("\t\t\t} else {\n");
                                compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                compactBodyBuilder.append("\t\t\t}\n");
                            }
                        } else {
                            compactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                            compactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    int arrLength = longs.length;
                                    boolean bl19 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    int arrLength = longs.length;
                                    boolean bl20 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                                }
                                compactBodyBuilder.append("\t\t\t\t} else {\n");
                                compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                compactBodyBuilder.append("\t\t\t\t}\n");
                            }
                            compactBodyBuilder.append("\t\t\t} else {\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    int arrLength = longsWithComma.length;
                                    boolean bl21 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    int arrLength = longsWithComma.length;
                                    boolean bl22 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            compactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        compactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        compactBodyBuilder.append("\t\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                                }
                                compactBodyBuilder.append("\t\t\t\t} else {\n");
                                compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                compactBodyBuilder.append("\t\t\t\t}\n");
                            }
                            compactBodyBuilder.append("\t\t\t}\n");
                        }
                        boolean useSerializerInvokeFlag = false;
                        if (returnType == String.class) {
                            if (runtime) {
                                if (EnvUtils.JDK_9_PLUS) {
                                    compactBodyBuilder.append("\t\t\twriter.writeJSONStringBytes(" + valueVar + ", (byte[]) getStringValue(" + valueVar + "));\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\twriter.writeJSONChars(getChars(" + valueVar + "));\n");
                                }
                            } else {
                                compactBodyBuilder.append("\t\t\twriter.writeJSONString(" + valueVar + ");\n");
                            }
                        } else if (returnType == Double.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeDouble(" + valueVar + ");\n");
                        } else if (returnType == Float.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeFloat(" + valueVar + ");\n");
                        } else if (returnType == Character.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeJSONChar(" + valueVar + ");\n");
                        } else if (returnType == Long.class || returnType == Integer.class || returnType == Short.class || returnType == Byte.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeLong(" + valueVar + ");\n");
                        } else if (returnType == BigDecimal.class) {
                            compactBodyBuilder.append("\t\t\twriter.write(" + valueVar + ".toString());\n");
                        } else if (returnType == BigInteger.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeBigInteger(" + valueVar + ");\n");
                        } else if (returnType == String[].class) {
                            compactBodyBuilder.append("\t\t\twriter.writeStringArray(" + valueVar + ");\n");
                        } else if (returnType == double[].class) {
                            compactBodyBuilder.append("\t\t\twriter.writeDoubleArray(" + valueVar + ");\n");
                        } else if (returnType == long[].class) {
                            compactBodyBuilder.append("\t\t\twriter.writeLongArray(" + valueVar + ");\n");
                        } else if (fieldSerializer.isStringCollection()) {
                            compactBodyBuilder.append("\t\t\twriter.writeStringCollection(" + valueVar + ");\n");
                        } else if (returnType == UUID.class) {
                            compactBodyBuilder.append("\t\t\twriter.writeUUID(" + valueVar + ");\n");
                        } else if (returnTypeName == "java.time.Instant") {
                            JsonProperty jsonProperty = fieldSerializer.getJsonProperty();
                            if (jsonProperty == null || jsonProperty.pattern().length() == 0 && !jsonProperty.asTimestamp()) {
                                compactBodyBuilder.append("\t\t\twriter.writeJSONInstant(" + valueVar + ".getEpochSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                compactBodyBuilder.append("\t\t\twriter.writeJSONTimeWithNano(" + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDate") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                compactBodyBuilder.append("\t\t\twriter.writeJSONLocalDate(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDateTime") {
                            JsonProperty jsonProperty = fieldSerializer.getJsonProperty();
                            if (jsonProperty == null || jsonProperty.pattern().length() == 0 && !jsonProperty.asTimestamp()) {
                                compactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), \"\");\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.ZonedDateTime" || returnTypeName == "java.time.OffsetDateTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                if (returnTypeName == "java.time.ZonedDateTime") {
                                    compactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getZone().getId());\n");
                                } else {
                                    compactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getOffset().getId());\n");
                                }
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else {
                            useSerializerInvokeFlag = true;
                        }
                        if (useSerializerInvokeFlag) {
                            if (!appendFieldSerializersFlag) {
                                appendFieldSerializersFlag = true;
                                fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                            }
                            fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                            fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                            compactBodyBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                        }
                        compactBodyBuilder.append("\t\t}\n");
                    }
                } else {
                    if (!appendFieldSerializersFlag) {
                        appendFieldSerializersFlag = true;
                        fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                    }
                    fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                    fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                    compactBodyBuilder.append("\t\tObject " + valueVar + " = invokeValue(" + fieldSerializerName + ", entity);\n");
                    if (Modifier.isPublic(returnType.getModifiers())) {
                        if (EnvUtils.JDK_7_BELOW) {
                            fmatOutBodyBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = invokeValue(" + fieldSerializerName + ", entity, " + returnType.getCanonicalName() + ".class);\n");
                        } else {
                            fmatOutBodyBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = (" + returnType.getCanonicalName() + ") invokeValue(" + fieldSerializerName + ", entity);\n");
                        }
                    } else {
                        fmatOutBodyBuilder.append("\t\tObject " + valueVar + " = invokeValue(" + fieldSerializerName + ", entity);\n");
                    }
                    JSONPojoSerializerCodeGen.generateSerializeFieldFormatOutCode(ensureNotEmptyFlag, primitive, fieldSerializerName, fieldKey, valueVar, nameEqualUnderlineName, underlineName, useUnsafe, longsFormatOut, intsFormatOut, fieldNameFormatOutTokenLength, returnType, fieldSerializer, runtime, fmatOutBodyBuilder);
                    compactBodyBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                    if (firstFlag) {
                        if (nameEqualUnderlineName) {
                            compactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                        } else {
                            compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                            compactBodyBuilder.append("\t\t\t} else {\n");
                            compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                            compactBodyBuilder.append("\t\t\t}\n");
                        }
                        compactBodyBuilder.append("\t\t\tisEmptyFlag = false;\n");
                    } else if (ensureNotEmptyFlag) {
                        if (nameEqualUnderlineName) {
                            compactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                        } else {
                            compactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                            compactBodyBuilder.append("\t\t\t} else {\n");
                            compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                            compactBodyBuilder.append("\t\t\t}\n");
                        }
                    } else if (nameEqualUnderlineName) {
                        compactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        compactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        compactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t} else {\n");
                        compactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t}\n");
                    } else {
                        compactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        compactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t\t} else {\n");
                        compactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t\t}\n");
                        compactBodyBuilder.append("\t\t\t} else {\n");
                        compactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + fieldKey + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t\t} else {\n");
                        compactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                        compactBodyBuilder.append("\t\t\t\t}\n");
                        compactBodyBuilder.append("\t\t\t}\n");
                    }
                    compactBodyBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                    compactBodyBuilder.append("\t\t}\n");
                    if (primitive) {
                        ensureNotEmptyFlag = true;
                    }
                }
                compactBodyBuilder.append("\n");
                fmatOutBodyBuilder.append("\n");
                ++fieldIndex;
            }
            if (ensureNotEmptyFlag) {
                fmatOutBodyBuilder.append("\t\twriteFormatOutSymbols(writer, indentLevel, jsonConfig);\n");
            } else {
                fmatOutBodyBuilder.append("\t\tif (!isEmptyFlag) {\n");
                fmatOutBodyBuilder.append("\t\t\twriteFormatOutSymbols(writer, indentLevel, jsonConfig);\n");
                fmatOutBodyBuilder.append("\t\t}\n");
            }
        }
        if (appendUnCamelCaseToUnderlineFlag) {
            compactHeaderBuilder.append("\t\tboolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();\n\n");
            fmatOutHeaderBuilder.append("\t\tboolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();\n\n");
        } else {
            compactHeaderBuilder.append("\n");
            fmatOutHeaderBuilder.append("\n");
        }
        if (!runtime) {
            // empty if block
        }
        codeBuilder.append("\tprotected ").append(genClassName).append("(JSONPojoStructure pojoStructure) {\n");
        codeBuilder.append("\t\tsuper(pojoStructure);\n");
        codeBuilder.append((CharSequence)fieldSetBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append((CharSequence)fieldsDefinitionBuilder).append("\n");
        codeBuilder.append("\tpublic void serializePojoCompact(").append(canonicalName).append(" entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {\n\n");
        codeBuilder.append((CharSequence)compactHeaderBuilder);
        codeBuilder.append((CharSequence)compactBodyBuilder);
        codeBuilder.append("\t}\n\n");
        codeBuilder.append("\tpublic void serializePojoFormatOut(").append(canonicalName).append(" entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {\n\n");
        codeBuilder.append((CharSequence)fmatOutHeaderBuilder);
        codeBuilder.append((CharSequence)fmatOutBodyBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append("}\n");
        codeBuilder.append("\n");
        String code = codeBuilder.toString();
        if (printSource) {
            System.out.println(code);
        }
        return new JavaSourceObject(packageName, genClassName, code);
    }

    private static void generateSerializeFieldFormatOutCode(boolean ensureNotEmptyFlag, boolean primitive, String fieldSerializerName, String fieldKey, String valueVar, boolean nameEqualUnderlineName, String underlineName, boolean useUnsafe, long[] longsFormatOut, int[] intsFormatOut, int fieldNameFormatOutTokenLength, Class<?> returnType, JSONPojoFieldSerializer fieldSerializer, boolean runtime, StringBuilder fmatOutBodyBuilder) {
        boolean remOnef;
        int arrLengthf;
        int totalf;
        String tabFlag;
        boolean checkNullFlag = !primitive;
        String string = tabFlag = checkNullFlag ? "\t" : "";
        if (checkNullFlag) {
            fmatOutBodyBuilder.append("\t\tif(" + valueVar + " != null) {\n");
        }
        if (ensureNotEmptyFlag) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONToken(',');\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteFormatOutSymbols(writer, indentPlus, jsonConfig);\n");
        } else {
            fmatOutBodyBuilder.append(tabFlag).append("\t\tif(isEmptyFlag) {\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t\tisEmptyFlag = false;\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t} else {\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriter.writeJSONToken(',');\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t} \n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteFormatOutSymbols(writer, indentPlus, jsonConfig);\n");
        }
        if (nameEqualUnderlineName) {
            if (useUnsafe) {
                totalf = fieldNameFormatOutTokenLength;
                arrLengthf = longsFormatOut.length;
                boolean bl = remOnef = (totalf & 3) == 1;
                if (remOnef) {
                    --arrLengthf;
                }
                for (int i = 0; i < arrLengthf; ++i) {
                    int len;
                    if (i + 1 < arrLengthf) {
                        len = totalf > 8 ? 8 : totalf;
                        long l1 = longsFormatOut[i];
                        long l2 = longsFormatOut[i + 1];
                        int i1 = intsFormatOut[i];
                        int i2 = intsFormatOut[i + 1];
                        long l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                        fmatOutBodyBuilder.append(tabFlag).append("\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                        totalf -= 8;
                        ++i;
                        continue;
                    }
                    len = totalf > 4 ? 4 : totalf;
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriteMemory(writer, " + longsFormatOut[i] + "L, " + intsFormatOut[i] + ", " + len + ");\n");
                    totalf -= 4;
                }
                if (remOnef) {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONToken(':');\n");
                }
            } else {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
            }
        } else {
            fmatOutBodyBuilder.append(tabFlag).append("\t\tif(unCamelCaseToUnderline) {\n");
            if (useUnsafe) {
                totalf = fieldNameFormatOutTokenLength;
                arrLengthf = longsFormatOut.length;
                boolean bl = remOnef = (totalf & 3) == 1;
                if (remOnef) {
                    --arrLengthf;
                }
                for (int i = 0; i < arrLengthf; ++i) {
                    int len;
                    if (i + 1 < arrLengthf) {
                        len = totalf > 8 ? 8 : totalf;
                        long l1 = longsFormatOut[i];
                        long l2 = longsFormatOut[i + 1];
                        int i1 = intsFormatOut[i];
                        int i2 = intsFormatOut[i + 1];
                        long l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                        fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                        totalf -= 8;
                        ++i;
                        continue;
                    }
                    len = totalf > 4 ? 4 : totalf;
                    fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriteMemory(writer, " + longsFormatOut[i] + "L, " + intsFormatOut[i] + ", " + len + ");\n");
                    totalf -= 4;
                }
                if (remOnef) {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriter.writeJSONToken(':');\n");
                }
            } else {
                fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriter.write(\"\\\"" + fieldKey + "\\\":\");\n");
            }
            fmatOutBodyBuilder.append(tabFlag).append("\t\t} else {\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
            fmatOutBodyBuilder.append(tabFlag).append("\t\t}\n");
        }
        fmatOutBodyBuilder.append(tabFlag).append("\t\tif(formatOutColonSpace) {\n");
        fmatOutBodyBuilder.append(tabFlag).append("\t\t\twriter.writeJSONToken(' ');\n");
        fmatOutBodyBuilder.append(tabFlag).append("\t\t}\n");
        boolean useSerializerInvokeFlag = false;
        String returnTypeName = returnType.getName().intern();
        if (returnType == String.class) {
            if (runtime) {
                if (EnvUtils.JDK_9_PLUS) {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONStringBytes(" + valueVar + ", (byte[]) getStringValue(" + valueVar + "));\n");
                } else {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONChars(getChars(" + valueVar + "));\n");
                }
            } else {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONString(" + valueVar + ");\n");
            }
        } else if (returnType == Double.class || returnType == Double.TYPE) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeDouble(" + valueVar + ");\n");
        } else if (returnType == Float.class || returnType == Float.TYPE) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeFloat(" + valueVar + ");\n");
        } else if (returnType == Character.class || returnType == Character.TYPE) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONChar(" + valueVar + ");\n");
        } else if (returnType == Long.class || returnType == Integer.class || returnType == Short.class || returnType == Byte.class || returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeLong(" + valueVar + ");\n");
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.write(String.valueOf(" + valueVar + "));\n");
        } else if (returnType == BigDecimal.class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.write(" + valueVar + ".toString());\n");
        } else if (returnType == BigInteger.class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeBigInteger(" + valueVar + ");\n");
        } else if (returnType == String[].class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteStringArrayFormatOut(writer, " + valueVar + ", jsonConfig, indentPlus);\n");
        } else if (returnType == double[].class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteDoubleArrayFormatOut(writer, " + valueVar + ", jsonConfig, indentPlus);\n");
        } else if (returnType == long[].class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteLongArrayFormatOut(writer, " + valueVar + ", jsonConfig, indentPlus);\n");
        } else if (fieldSerializer.isStringCollection()) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriteStringCollectionFormatOut(writer, " + valueVar + ", jsonConfig, indentPlus);\n");
        } else if (returnType == UUID.class) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeUUID(" + valueVar + ");\n");
        } else if (returnTypeName == "java.time.Instant") {
            JsonProperty jsonProperty = fieldSerializer.getJsonProperty();
            if (jsonProperty == null || jsonProperty.pattern().length() == 0 && !jsonProperty.asTimestamp()) {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONInstant(" + valueVar + ".getEpochSecond(), " + valueVar + ".getNano());\n");
            } else {
                useSerializerInvokeFlag = true;
            }
        } else if (returnTypeName == "java.time.LocalTime") {
            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONTimeWithNano(" + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano());\n");
            } else {
                useSerializerInvokeFlag = true;
            }
        } else if (returnTypeName == "java.time.LocalDate") {
            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONLocalDate(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth());\n");
            } else {
                useSerializerInvokeFlag = true;
            }
        } else if (returnTypeName == "java.time.LocalDateTime") {
            JsonProperty jsonProperty = fieldSerializer.getJsonProperty();
            if (jsonProperty == null || jsonProperty.pattern().length() == 0 && !jsonProperty.asTimestamp()) {
                fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), \"\");\n");
            } else {
                useSerializerInvokeFlag = true;
            }
        } else if (returnTypeName == "java.time.ZonedDateTime" || returnTypeName == "java.time.OffsetDateTime") {
            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                if (returnTypeName == "java.time.ZonedDateTime") {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getZone().getId());\n");
                } else {
                    fmatOutBodyBuilder.append(tabFlag).append("\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getOffset().getId());\n");
                }
            } else {
                useSerializerInvokeFlag = true;
            }
        } else {
            useSerializerInvokeFlag = true;
        }
        if (useSerializerInvokeFlag) {
            fmatOutBodyBuilder.append(tabFlag).append("\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, indentPlus);\n");
        }
        if (checkNullFlag) {
            fmatOutBodyBuilder.append("\t\t}\n");
        }
    }
}

