/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.JSONPojoFieldDeserializer;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONValueMatcher;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.annotations.JsonTypeSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class JSONPojoStructure {
    private static final Map<Class<?>, JSONPojoStructure> OBJECT_STRUCTURE_WARPPERS = new ConcurrentHashMap();
    private final ClassStrucWrap classStrucWrap;
    private ClassStrucWrap.ClassWrapperType classWrapperType;
    private final GenericParameterizedType genericType;
    final JSONValueMatcher<JSONPojoFieldDeserializer> fieldDeserializerMatcher;
    private final List<JSONPojoFieldDeserializer> fieldDeserializers;
    private JSONPojoFieldSerializer[] getterMethodSerializers;
    private JSONPojoFieldSerializer[] getterFieldSerializers;
    private boolean forceUseFields;
    private JsonTypeSetting jsonTypeSetting;
    volatile boolean fieldDeserializersInitialized;
    volatile boolean fieldSerializersInitialized;
    private final boolean supportedJavaBeanConvention;
    private final boolean enableJIT;

    private JSONPojoStructure(ClassStrucWrap classStrucWrap) {
        classStrucWrap.getClass();
        this.classStrucWrap = classStrucWrap;
        this.classWrapperType = classStrucWrap.getClassWrapperType();
        this.forceUseFields = classStrucWrap.isForceUseFields();
        this.jsonTypeSetting = (JsonTypeSetting)classStrucWrap.getDeclaredAnnotation(JsonTypeSetting.class);
        List<GetterInfo> getterInfos = classStrucWrap.getGetterInfos();
        ArrayList<JSONPojoFieldSerializer> fieldSerializers = new ArrayList<JSONPojoFieldSerializer>();
        HashMap<String, JSONPojoFieldSerializer> fieldSerializerHashMap = new HashMap<String, JSONPojoFieldSerializer>();
        for (GetterInfo getterInfo : getterInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            JSONPojoFieldSerializer fieldSerializer = new JSONPojoFieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
            fieldSerializerHashMap.put(name, fieldSerializer);
        }
        this.getterMethodSerializers = fieldSerializers.toArray(new JSONPojoFieldSerializer[fieldSerializers.size()]);
        fieldSerializers.clear();
        List<GetterInfo> getterByFieldInfos = classStrucWrap.getGetterInfos(true);
        for (GetterInfo getterInfo : getterByFieldInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            JSONPojoFieldSerializer fieldSerializer = new JSONPojoFieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
        }
        this.getterFieldSerializers = fieldSerializers.toArray(new JSONPojoFieldSerializer[fieldSerializers.size()]);
        this.supportedJavaBeanConvention = this.checkJavaBeanConvention(fieldSerializerHashMap);
        this.genericType = GenericParameterizedType.actualType(classStrucWrap.getSourceClass());
        Set<String> set = classStrucWrap.setterNames();
        HashMap<String, JSONPojoFieldDeserializer> fieldDeserializerHashMap = new HashMap<String, JSONPojoFieldDeserializer>();
        for (String setterName : set) {
            SetterInfo setterInfo = classStrucWrap.getSetterInfo(setterName);
            JsonProperty jsonProperty = (JsonProperty)setterInfo.getAnnotation(JsonProperty.class);
            String name = setterName;
            boolean priority = name.equals(setterInfo.getName());
            if (jsonProperty != null) {
                if (!jsonProperty.deserialize()) continue;
                String mapperName = jsonProperty.name().trim();
                if (mapperName.length() > 0) {
                    name = mapperName;
                    priority = true;
                }
            }
            JSONPojoFieldDeserializer fieldDeserializer = new JSONPojoFieldDeserializer(name, setterInfo, jsonProperty);
            fieldDeserializer.setPriority(priority);
            fieldDeserializerHashMap.put(name, fieldDeserializer);
        }
        this.fieldDeserializers = new ArrayList(fieldDeserializerHashMap.values());
        this.fieldDeserializerMatcher = JSONValueMatcher.build(fieldDeserializerHashMap);
        this.enableJIT = this.jsonTypeSetting != null && this.jsonTypeSetting.enableJIT();
    }

    private boolean checkJavaBeanConvention(Map<String, JSONPojoFieldSerializer> fieldSerializerHashMap) {
        return !this.classStrucWrap.isPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitializedFieldSerializers() {
        if (this.fieldSerializersInitialized) {
            return;
        }
        JSONPojoStructure jSONPojoStructure = this;
        synchronized (jSONPojoStructure) {
            if (this.fieldSerializersInitialized) {
                return;
            }
            for (JSONPojoFieldSerializer fieldSerializer : this.getterMethodSerializers) {
                fieldSerializer.initSerializer();
            }
            for (JSONPojoFieldSerializer fieldSerializer : this.getterFieldSerializers) {
                fieldSerializer.initSerializer();
            }
            this.fieldSerializersInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitializedFieldDeserializers() {
        if (this.fieldDeserializersInitialized) {
            return;
        }
        JSONPojoStructure jSONPojoStructure = this;
        synchronized (jSONPojoStructure) {
            if (this.fieldDeserializersInitialized) {
                return;
            }
            for (JSONPojoFieldDeserializer fieldDeserializer : this.fieldDeserializers) {
                fieldDeserializer.initDeserializer();
            }
            this.fieldDeserializersInitialized = true;
        }
    }

    public Class<?> getSourceClass() {
        return this.classStrucWrap.getSourceClass();
    }

    public boolean isRecord() {
        return this.classStrucWrap.isRecord();
    }

    public boolean isTemporal() {
        return this.classStrucWrap.isTemporal();
    }

    public int getFieldCount() {
        return this.classStrucWrap.getFieldCount();
    }

    public ClassStrucWrap.ClassWrapperType getClassWrapperType() {
        return this.classWrapperType;
    }

    public Object[] createConstructorArgs() {
        return this.classStrucWrap.createConstructorArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONPojoStructure get(Class<?> pojoClass) {
        if (pojoClass == null) {
            throw new IllegalArgumentException("pojoClass is null");
        }
        JSONPojoStructure pojoStructure = OBJECT_STRUCTURE_WARPPERS.get(pojoClass);
        if (pojoStructure != null) {
            return pojoStructure;
        }
        Class<?> clazz = pojoClass;
        synchronized (clazz) {
            if (OBJECT_STRUCTURE_WARPPERS.containsKey(pojoClass)) {
                return OBJECT_STRUCTURE_WARPPERS.get(pojoClass);
            }
            ClassStrucWrap wrapper = ClassStrucWrap.get(pojoClass);
            if (wrapper == null) {
                throw new IllegalArgumentException("pojoClass " + pojoClass + " is not supported !");
            }
            pojoStructure = new JSONPojoStructure(wrapper);
            OBJECT_STRUCTURE_WARPPERS.put(pojoClass, pojoStructure);
        }
        return pojoStructure;
    }

    public Object newInstance() throws Exception {
        return this.classStrucWrap.newInstance();
    }

    public Object newInstance(Object[] constructorArgs) throws Exception {
        return this.classStrucWrap.newInstance(constructorArgs);
    }

    public GenericParameterizedType getGenericType() {
        return this.genericType;
    }

    public boolean isAssignableFromMap() {
        return this.classStrucWrap.isAssignableFromMap();
    }

    public JSONPojoFieldSerializer[] getFieldSerializers(boolean useFields) {
        return useFields || this.forceUseFields ? this.getterFieldSerializers : this.getterMethodSerializers;
    }

    public boolean isPrivate() {
        return this.classStrucWrap.isPrivate();
    }

    public boolean isPublic() {
        return this.classStrucWrap.isPublic();
    }

    public boolean isForceUseFields() {
        return this.forceUseFields;
    }

    public boolean isSupportedJavaBeanConvention() {
        return this.supportedJavaBeanConvention;
    }

    public boolean isSupportedJIT() {
        return this.isSupportedJavaBeanConvention() && this.isPublic() && this.enableJIT;
    }
}

