/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.json.JSONReaderHookExact;
import io.github.wycst.wast.json.JSONReaderHookExactComplex;
import io.github.wycst.wast.json.JSONReaderHookExactLeaf;
import io.github.wycst.wast.json.JSONReaderHookRegular;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class JSONReaderHook {
    private boolean abored;
    protected List<Object> results = new ArrayList<Object>();
    private String filterRegular;

    public void setFilterRegular(String ... pathRegularSegments) {
        this.filterRegular = JSONReaderHook.buildRegular(pathRegularSegments);
    }

    public void clearFilterRegular(String ... pathRegularSegments) {
        this.filterRegular = null;
    }

    static final String buildRegular(String ... pathRegularSegments) {
        StringBuilder regularBuilder = new StringBuilder();
        int i = 0;
        for (String pathRegularSegment : pathRegularSegments) {
            if (i++ > 0) {
                regularBuilder.append("(");
            }
            regularBuilder.append("\\/");
            regularBuilder.append(pathRegularSegment);
        }
        while (--i > 0) {
            regularBuilder.append(")?");
        }
        return regularBuilder.toString();
    }

    protected GenericParameterizedType getParameterizedType(String path) {
        return null;
    }

    protected boolean filter(String path, int type) {
        if (this.filterRegular == null) {
            return true;
        }
        return path == "" || path.matches(this.filterRegular);
    }

    @Deprecated
    protected Object created(String path, int type) throws Exception {
        return null;
    }

    protected Map createdMap(String path) {
        return null;
    }

    protected Collection createdCollection(String path) {
        return null;
    }

    protected abstract void parseValue(String var1, Object var2, Object var3, int var4, String var5, int var6) throws Exception;

    public void reset() {
        if (this.results != null) {
            this.results.clear();
        }
        this.abored = false;
    }

    protected void onCompleted(Object result) {
    }

    protected final void abort() {
        this.abored = true;
    }

    protected final boolean isAbored() {
        return this.abored;
    }

    protected boolean isAboredOnParsed(Object value, String path, int type) {
        return false;
    }

    public static final JSONReaderHook regularPath(String regular) {
        return new JSONReaderHookRegular(regular);
    }

    public static final JSONReaderHook regularPath(String regular, boolean onlyLeaf) {
        return new JSONReaderHookRegular(regular, onlyLeaf);
    }

    public static final JSONReaderHook exactPath(String exactPath) {
        return new JSONReaderHookExact(exactPath);
    }

    public static final JSONReaderHook exactPathAs(String exactPath, Class<?> actualType) {
        return JSONReaderHook.exactPathAs(exactPath, GenericParameterizedType.actualType(actualType));
    }

    public static final JSONReaderHook exactPathAs(String exactPath, GenericParameterizedType parameterizedType) {
        ReflectConsts.ClassCategory classCategory = parameterizedType.getActualClassCategory();
        switch (classCategory) {
            case ANY: {
                return new JSONReaderHookExact(exactPath);
            }
            case ArrayCategory: 
            case CollectionCategory: 
            case MapCategory: 
            case ObjectCategory: {
                return new JSONReaderHookExactComplex(exactPath, parameterizedType);
            }
        }
        return new JSONReaderHookExactLeaf(exactPath, parameterizedType);
    }

    public final List<Object> getResults() {
        return this.results;
    }

    public final <E> E first() {
        return (E)(this.results.isEmpty() ? null : this.results.get(0));
    }
}

