/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONUnsafe;

public class JSONUtil {
    JSONUtil() {
    }

    static final long getQuoteOrBackslashMask(char[] buf, int offset, long quoteMask) {
        long v64 = JSONUnsafe.UNSAFE.getLong(buf, JSONUnsafe.CHAR_ARRAY_OFFSET + (long)(offset << 1));
        return (v64 ^ quoteMask) + 0x1000100010001L & (v64 ^ 0xFFA3FFA3FFA3FFA3L) + 0x1000100010001L & 0x8000800080008000L;
    }

    public int ensureIndexOfQuoteOrBackslashChar(char[] buf, int offset, char quote, long quoteMask) {
        char c;
        int limit32 = buf.length - 32;
        if (offset <= limit32) {
            do {
                int r32;
                long result;
                if ((result = JSONUtil.getQuoteOrBackslashMask(buf, offset, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L && (result = JSONUtil.getQuoteOrBackslashMask(buf, offset += 4, quoteMask)) == -9223231297218904064L) {
                    offset += 4;
                    continue;
                }
                if (EnvUtils.BIG_ENDIAN) {
                    result = Long.reverseBytes(result);
                }
                if ((r32 = (int)result) == -2147450880) {
                    offset += result == 0x800080008000L ? 3 : 2;
                } else if (r32 == 32768) {
                    ++offset;
                }
                char c2 = buf[offset];
                if (c2 == quote || c2 == '\\') {
                    return offset;
                }
                ++offset;
            } while (offset <= limit32);
        }
        while ((c = buf[offset]) != quote && c != '\\') {
            ++offset;
        }
        return offset;
    }

    static final long getQuoteOrBackslashOrUTF8Mask(byte[] buf, int offset, long quoteMask) {
        long v64 = JSONUnsafe.UNSAFE.getLong(buf, JSONUnsafe.BYTE_ARRAY_OFFSET + (long)offset);
        return (v64 ^ quoteMask) + 0x101010101010101L & (v64 ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L;
    }

    static final int offsetTokenBytes(long result) {
        if (EnvUtils.BIG_ENDIAN) {
            result = Long.reverseBytes(result);
        }
        int offset = 0;
        int r32 = (int)result;
        if (r32 == -2139062144) {
            offset += 4;
            r32 = (int)(result >> 32);
        }
        switch (r32) {
            case 0x808080: {
                return offset + 3;
            }
            case -2147450752: 
            case 32896: {
                return offset + 2;
            }
            case -2147483520: 
            case -2139094912: 
            case 128: 
            case 0x800080: {
                return offset + 1;
            }
        }
        return offset;
    }

    public int ensureIndexOfQuoteOrBackslashOrUTF8Byte(byte[] buf, int offset, int quote, long quoteMask) {
        byte c;
        boolean limitFlag;
        int limit32 = buf.length - 32;
        long result = 0L;
        boolean bl = limitFlag = offset <= limit32;
        if (bl && (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset, quoteMask)) == -9187201950435737472L && (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) == -9187201950435737472L && (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) == -9187201950435737472L && (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) == -9187201950435737472L) {
            offset += 8;
            while (true) {
                boolean bl2 = limitFlag = offset <= limit32;
                if (!bl2 || (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset, quoteMask)) != -9187201950435737472L || (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) != -9187201950435737472L || (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) != -9187201950435737472L || (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset += 8, quoteMask)) != -9187201950435737472L) break;
                offset += 8;
            }
        }
        if (limitFlag) {
            return offset + JSONUtil.offsetTokenBytes(result);
        }
        int limit8 = buf.length - 8;
        while ((limitFlag = offset <= limit8) && (result = JSONUtil.getQuoteOrBackslashOrUTF8Mask(buf, offset, quoteMask)) == -9187201950435737472L) {
            offset += 8;
        }
        if (limitFlag) {
            return offset + JSONUtil.offsetTokenBytes(result);
        }
        while ((c = buf[offset]) != quote && c != 92 && c >= 0) {
            ++offset;
        }
        return offset;
    }

    public int indexOf(String source, byte[] buf, int beginIndex, int token) {
        return source.indexOf(token, beginIndex);
    }

    static final boolean isNoneEscaped8Bytes(byte[] buf, int offset) {
        long value = JSONUnsafe.UNSAFE.getLong(buf, JSONUnsafe.BYTE_ARRAY_OFFSET + (long)offset);
        return (value + 0x6060606060606060L & (value ^ 0xDDDDDDDDDDDDDDDDL) + 0x101010101010101L & (value ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L) == -9187201950435737472L;
    }

    public int toNoEscapeOffset(byte[] buf, int offset) {
        if (JSONUtil.isNoneEscaped8Bytes(buf, offset) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8)) {
            offset += 8;
            int limit = buf.length - 32;
            while (offset <= limit && JSONUtil.isNoneEscaped8Bytes(buf, offset) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8) && JSONUtil.isNoneEscaped8Bytes(buf, offset += 8)) {
                offset += 8;
            }
        }
        return offset;
    }

    static final boolean isNoneEscaped4Chars(char[] buf, int offset) {
        long value = JSONUnsafe.getLong(buf, offset);
        return (value + 9214505439794855904L & (value ^ 0xFFDDFFDDFFDDFFDDL) + 0x1000100010001L & (value ^ 0xFFA3FFA3FFA3FFA3L) + 0x1000100010001L & 0x8000800080008000L) == -9223231297218904064L;
    }

    public final int toNoEscapeOffset(char[] buf, int offset) {
        if (JSONUtil.isNoneEscaped4Chars(buf, offset) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4)) {
            offset += 4;
            int limit = buf.length - 16;
            while (offset <= limit && JSONUtil.isNoneEscaped4Chars(buf, offset) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4) && JSONUtil.isNoneEscaped4Chars(buf, offset += 4)) {
                offset += 4;
            }
        }
        return offset;
    }
}

