/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.Arrays;

final class JSONValidator
extends JSONGeneral {
    JSONValidator() {
    }

    static boolean validate(String json, ReadOption[] readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONValidator.validate((CharSource)AsciiStringSource.of(json), bytes, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONValidator.validate((CharSource)UTF16ByteArraySource.of(json), chars, readOptions);
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return JSONValidator.validate(null, chars, readOptions);
    }

    static boolean validate(char[] buf, ReadOption[] readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONValidator.validate((CharSource)AsciiStringSource.of(json), bytes, readOptions);
            }
            return JSONValidator.validate((CharSource)UTF16ByteArraySource.of(json), buf, readOptions);
        }
        return JSONValidator.validate(null, buf, readOptions);
    }

    public static boolean validate(byte[] buf, ReadOption[] readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            return JSONValidator.validate((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(buf)), buf, readOptions);
        }
        return JSONValidator.validate(null, buf, readOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validate(CharSource source, char[] chars, ReadOption ... readOptions) {
        int fromIndex;
        int toIndex = chars.length;
        char beginChar = '\u0000';
        for (fromIndex = 0; fromIndex < toIndex && (beginChar = chars[fromIndex]) <= ' '; ++fromIndex) {
        }
        while (toIndex > fromIndex && chars[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext parseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.validate = true;
        try {
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONValidator.clearCommentAndWhiteSpaces(chars, fromIndex + 1, parseContext);
                beginChar = chars[fromIndex];
            }
            boolean validate = true;
            switch (beginChar) {
                case '{': {
                    validate = JSONTypeDeserializer.MAP.validate(source, chars, fromIndex, toIndex, '\u0000', parseContext);
                    break;
                }
                case '[': {
                    validate = JSONTypeDeserializer.COLLECTION.validate(source, chars, fromIndex, toIndex, '\u0000', parseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(source, chars, fromIndex, beginChar, parseContext);
                    break;
                }
                default: {
                    try {
                        switch (beginChar) {
                            case 't': {
                                JSONTypeDeserializer.parseTrue(chars, fromIndex, parseContext);
                                break;
                            }
                            case 'f': {
                                JSONTypeDeserializer.parseFalse(chars, fromIndex, parseContext);
                                break;
                            }
                            case 'n': {
                                JSONTypeDeserializer.parseNull(chars, fromIndex, parseContext);
                                break;
                            }
                            default: {
                                char[] numBuf = Arrays.copyOfRange(chars, fromIndex, toIndex + 1);
                                numBuf[numBuf.length - 1] = 44;
                                JSONTypeDeserializer.NUMBER_SKIPPER.deserialize(source, numBuf, 0, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, ',', parseContext);
                                toIndex = numBuf.length - 1;
                            }
                        }
                        if (parseContext.validateFail) {
                            boolean numBuf = false;
                            return numBuf;
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            if (!validate) {
                boolean throwable = false;
                return throwable;
            }
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = chars[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSONValidator.clearCommentAndWhiteSpaces(chars, endIndex + 1, parseContext);
                }
            }
            boolean bl = endIndex == toIndex - 1;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            parseContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validate(CharSource source, byte[] bytes, ReadOption ... readOptions) {
        int fromIndex;
        int toIndex = bytes.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = bytes[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && bytes[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext parseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.validate = true;
        try {
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSONValidator.clearCommentAndWhiteSpaces(bytes, fromIndex + 1, parseContext);
                beginByte = bytes[fromIndex];
            }
            boolean validate = true;
            switch (beginByte) {
                case 123: {
                    validate = JSONTypeDeserializer.MAP.validate(source, bytes, fromIndex, toIndex, (byte)0, parseContext);
                    break;
                }
                case 91: {
                    validate = JSONTypeDeserializer.COLLECTION.validate(source, bytes, fromIndex, toIndex, (byte)0, parseContext);
                    break;
                }
                case 34: 
                case 39: {
                    JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(source, bytes, fromIndex, beginByte, parseContext);
                    break;
                }
                default: {
                    try {
                        switch (beginByte) {
                            case 116: {
                                JSONTypeDeserializer.parseTrue(bytes, fromIndex, parseContext);
                                break;
                            }
                            case 102: {
                                JSONTypeDeserializer.parseFalse(bytes, fromIndex, parseContext);
                                break;
                            }
                            case 110: {
                                JSONTypeDeserializer.parseNull(bytes, fromIndex, parseContext);
                                break;
                            }
                            default: {
                                byte[] numBuf = Arrays.copyOfRange(bytes, fromIndex, toIndex + 1);
                                numBuf[numBuf.length - 1] = 44;
                                JSONTypeDeserializer.NUMBER_SKIPPER.deserialize(source, numBuf, 0, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)44, parseContext);
                                toIndex = numBuf.length - 1;
                            }
                        }
                        if (parseContext.validateFail) {
                            boolean numBuf = false;
                            return numBuf;
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            if (!validate) {
                boolean throwable = false;
                return throwable;
            }
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex) {
                    char c = (char)bytes[++endIndex];
                    commentStart = c;
                    if (c <= ' ') continue;
                }
                if (commentStart == 47) {
                    endIndex = JSONValidator.clearCommentAndWhiteSpaces(bytes, endIndex + 1, parseContext);
                }
            }
            boolean bl = endIndex == toIndex - 1;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            parseContext.clear();
        }
    }
}

