/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.LocalTime;

public class TemporalLocalTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalTime.of(generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalTime.of(generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeDefault(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        char c2;
        int i = offset;
        char c1 = buf[i];
        boolean isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            hour = TemporalLocalTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            hour = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            minute = TemporalLocalTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            minute = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            second = TemporalLocalTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            second = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int nanoOfSecond = 0;
        char c = buf[i];
        if (c == '.') {
            int cnt = 9;
            while ((isDigitFlag = NumberUtils.isDigit(c = buf[++i])) && NumberUtils.isDigit(c1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + TemporalLocalTimeDeserializer.twoDigitsValue(c, c1);
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = c1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return LocalTime.of(hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c1 + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefault(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        byte b2;
        int i = offset;
        byte b1 = buf[i];
        boolean isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            hour = TemporalLocalTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            hour = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            minute = TemporalLocalTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            minute = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            second = TemporalLocalTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            second = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int nanoOfSecond = 0;
        byte c = buf[i];
        if (c == 46) {
            int val;
            int cnt = 9;
            ++i;
            while ((val = TemporalLocalTimeDeserializer.digits2Bytes(buf, i)) != -1) {
                i += 2;
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + val;
            }
            c = buf[i];
            if (NumberUtils.isDigit(c)) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = buf[++i];
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return LocalTime.of(hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return LocalTime.parse(value);
    }
}

