/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.yaml.YamlNode;
import io.github.wycst.wast.yaml.YamlParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class YamlDocument
extends YamlParser {
    private boolean multiple;
    private YamlNode root;
    private List<YamlNode> yamlNodeList;

    private YamlDocument() {
    }

    public static YamlDocument parse(String yaml) {
        return YamlDocument.parse(YamlDocument.getChars(yaml));
    }

    public static YamlDocument parse(char[] source) {
        int length = source.length;
        char lastChar = source[source.length - 1];
        if (lastChar != '\n') {
            source = Arrays.copyOf(source, length + 1);
            source[length] = 10;
        }
        YamlDocument yamlDocument = new YamlDocument();
        yamlDocument.source = source;
        yamlDocument.parseYamlRoot(0);
        return yamlDocument;
    }

    public static YamlDocument read(InputStream is) throws IOException {
        return YamlDocument.parse(IOUtils.readAsChars(is));
    }

    public static YamlDocument read(InputStream is, Charset charset) throws IOException {
        return YamlDocument.parse(IOUtils.readAsChars(is, charset));
    }

    public static YamlDocument read(File yamlFile) throws IOException {
        return YamlDocument.read(new FileInputStream(yamlFile));
    }

    public static YamlDocument read(URL url) throws IOException {
        return YamlDocument.read(url, YamlDocument.class);
    }

    @Override
    protected void parseYamlRoot(int offset) {
        YamlNode yamlRoot = new YamlNode();
        if (this.root == null) {
            this.root = yamlRoot;
        } else {
            this.multiple = true;
            if (this.yamlNodeList == null) {
                this.yamlNodeList = new ArrayList<YamlNode>();
                this.yamlNodeList.add(this.root);
            }
            this.yamlNodeList.add(yamlRoot);
        }
        ArrayList<YamlNode> yamlNodes = new ArrayList<YamlNode>();
        this.parseNodes(yamlNodes, offset, this.source.length);
        yamlRoot.buildYamlTree(yamlNodes);
    }

    public static <T> T parse(String yamlStr, Class<T> actualType) {
        YamlDocument yamlDocument = YamlDocument.parse(yamlStr);
        return yamlDocument.getRoot().toEntity(actualType);
    }

    public static <T> T parse(char[] buf, Class<T> actualType) {
        YamlDocument yamlDocument = YamlDocument.parse(buf);
        return yamlDocument.getRoot().toEntity(actualType);
    }

    public static <T> T read(byte[] bytes, Class<T> actualType) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            return YamlDocument.read((InputStream)bais, actualType);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> T read(File file, Class<T> actualType) throws IOException {
        return YamlDocument.read((InputStream)new FileInputStream(file), actualType);
    }

    public static <T> T read(URL url, Class<T> actualType) throws IOException {
        return YamlDocument.read(url, actualType, -1);
    }

    public static <T> T read(URL url, Class<T> actualType, int timeout) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (timeout > 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        conn.connect();
        return YamlDocument.read(conn.getInputStream(), actualType);
    }

    private static <T> T read(InputStream is, Class<T> actualType) throws IOException {
        return YamlDocument.read(is).toEntity(actualType);
    }

    public static Properties loadProperties(InputStream is) throws IOException {
        return YamlDocument.read(is).toProperties();
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public YamlNode getRoot() {
        return this.root;
    }

    public List<YamlNode> getYamlNodeList() {
        return this.yamlNodeList;
    }

    public <T> T toEntity(Class<T> actualType) {
        if (actualType == YamlDocument.class) {
            return (T)this;
        }
        if (actualType == YamlNode.class) {
            return (T)this.getRoot();
        }
        return this.getRoot().toEntity(actualType);
    }

    public Map toMap() {
        return this.getRoot().toMap();
    }

    public Properties toProperties() {
        return this.getRoot().toProperties();
    }

    public void writeTo(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        this.writeTo(new FileWriter(file));
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeTo(new OutputStreamWriter(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        try {
            if (this.multiple) {
                for (YamlNode rootNode : this.yamlNodeList) {
                    rootNode.writeTo(writer);
                    writer.write("---");
                }
            } else {
                this.root.writeTo(writer);
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public String toYamlString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }
}

