/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.AbstractMultiGeometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import io.github.wycst.wast.common.beans.geo.Polygon;
import java.util.ArrayList;
import java.util.List;

public class MultiPolygon
extends AbstractMultiGeometry {
    List<Polygon> elements = new ArrayList<Polygon>();

    public MultiPolygon() {
        super(GeometryType.MULTIPOLYGON);
    }

    public void add(Polygon polygon) {
        this.elements.add(polygon);
    }

    public void addAll(Polygon ... polygons) {
        for (Polygon polygon : polygons) {
            this.elements.add(polygon);
        }
    }

    public void addAll(List<Polygon> polygons) {
        this.elements.addAll(polygons);
    }

    public Polygon removeAt(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(Polygon polygon) {
        return this.elements.remove(polygon);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(");
        int deleteDotIndex = -1;
        for (Polygon polygon : this.elements) {
            polygon.appendBody(builder);
            builder.append(",");
            deleteDotIndex = builder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            builder.deleteCharAt(deleteDotIndex);
        }
        builder.append(")");
    }

    @Override
    protected void readElement(char[] chars, GeometryContext geometryContext) {
        Polygon polygon = new Polygon();
        polygon.readBody(chars, geometryContext);
        this.add(polygon);
    }

    public List<Polygon> getElements() {
        return this.elements;
    }

    public void setElements(List<Polygon> elements) {
        this.elements = elements;
    }
}

