/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.Geometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;

public class Point
extends Geometry {
    Number x;
    Number y;

    public Point() {
        this(0, 0);
    }

    public Point(Number x, Number y) {
        super(GeometryType.POINT);
        this.x = x;
        this.y = y;
    }

    public static Point of(Number x, Number y) {
        return new Point(x, y);
    }

    public Number getX() {
        return this.x;
    }

    public void setX(Number x) {
        this.x = x;
    }

    public Number getY() {
        return this.y;
    }

    public void setY(Number y) {
        this.y = y;
    }

    @Override
    void readBody(char[] chars, GeometryContext geometryContext) {
        int offset = geometryContext.offset;
        while (chars[++offset] == ' ') {
        }
        geometryContext.offset = offset;
        Point.readPoint(chars, geometryContext);
        offset = geometryContext.offset;
        if (chars[offset] != ')') {
            throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected ')', actual '" + chars[offset] + "'");
        }
        this.x = geometryContext.x;
        this.y = geometryContext.y;
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(").append(this.x).append(" ").append(this.y).append(")");
    }
}

