/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.compiler;

import io.github.wycst.wast.common.compiler.JavaSourceObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryJavaFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    protected MemoryJavaFileObject(String className, JavaFileObject.Kind kind) {
        super(URI.create(className + kind.extension), kind);
    }

    public static MemoryJavaFileObject from(JavaSourceObject sourceObject) {
        return new MemoryJavaFileObject(sourceObject.canonicalName, JavaFileObject.Kind.SOURCE);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.outputStream;
    }

    public byte[] getBytes() {
        byte[] bytes = this.outputStream.toByteArray();
        this.outputStream.reset();
        return bytes;
    }
}

