/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.csv;

import io.github.wycst.wast.common.csv.CSV;
import io.github.wycst.wast.common.csv.CSVRow;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CSVTable {
    private final CSVRow columns;
    private final List<CSVRow> rows;

    CSVTable(List<CSVRow> csvRows) {
        this.columns = csvRows.get(0);
        this.rows = csvRows.subList(1, csvRows.size());
    }

    CSVTable() {
        this.columns = new CSVRow(this, new ArrayList<String>());
        this.rows = new ArrayList<CSVRow>();
    }

    CSVTable(String[] columnNames) {
        this.columns = new CSVRow(this, Arrays.asList(columnNames));
        this.rows = new ArrayList<CSVRow>();
    }

    public static CSVTable create() {
        return new CSVTable();
    }

    public static CSVTable create(String[] columnNames) {
        return new CSVTable(columnNames);
    }

    void setRows(List<CSVRow> csvRows) {
        if (csvRows.size() > 0) {
            this.rows.clear();
            CSVRow header = csvRows.get(0);
            List<CSVRow> dataRows = csvRows.subList(1, csvRows.size());
            this.columns.values = header.values;
            this.rows.addAll(dataRows);
        }
    }

    public void setColumnNames(String[] columnNames) {
        this.columns.values = Arrays.asList(columnNames);
    }

    public void setColumnNames(List<String> columnNames) {
        this.columns.values = columnNames;
    }

    public void addRow(List<String> values) {
        this.rows.add(new CSVRow(this, values));
    }

    public void set(int index, List<String> values) {
        this.rows.set(index, new CSVRow(this, values));
    }

    public void clearRows() {
        this.rows.clear();
    }

    public void removeAt(int index) {
        this.rows.remove(index);
    }

    public CSVRow getColumns() {
        return this.columns;
    }

    public List<CSVRow> getRows() {
        return this.rows;
    }

    public CSVRow getRow(int index) {
        return this.rows.get(index);
    }

    public int size() {
        return this.rows.size();
    }

    public int getColumnIndex(String column) {
        return this.columns.indexOf(column);
    }

    public <E> List<E> asEntityList(Class<E> eClass) {
        return this.asEntityList(eClass, null);
    }

    public <E> List<E> asEntityList(Class<E> eClass, Map<String, String> columnMapping) {
        ArrayList<E> list = new ArrayList<E>();
        for (CSVRow csvRow : this.rows) {
            list.add(csvRow.toBean(eClass, columnMapping));
        }
        return list;
    }

    public void setValue(int rowIndex, int columnIndex, String value) {
        this.rows.get(rowIndex).set(columnIndex, value);
    }

    public void writeTo(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.writeTo(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(OutputStream os) {
        this.writeTo(os, Charset.defaultCharset());
    }

    public void writeTo(OutputStream os, String charsetName) {
        this.writeTo(os, Charset.forName(charsetName));
    }

    void writeTo(OutputStream os, Charset charset) {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(os, charset));
        try {
            this.writeTo(bufferedWriter);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void writeTo(Appendable appendable) {
        try {
            CSV.writeRow(appendable, this.columns.values);
            for (CSVRow row : this.rows) {
                CSV.writeRow(appendable, row.values);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toCSVString() {
        StringBuilder builder = new StringBuilder();
        this.writeTo(builder);
        return builder.toString();
    }
}

