/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import java.util.Map;

abstract class EvaluatorContextBuilder {
    final ElInvoker invoke;
    final int variableCount;
    static final EvaluatorContextBuilder EMPTY = new EvaluatorContextBuilder(){

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            return EvaluatorContext.EMPTY;
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            return EvaluatorContext.EMPTY;
        }
    };

    EvaluatorContextBuilder() {
        this(null, 0);
    }

    EvaluatorContextBuilder(ElInvoker invoke, int variableCount) {
        this.invoke = invoke;
        this.variableCount = variableCount;
    }

    public abstract EvaluatorContext createEvaluatorContext(Object var1);

    public abstract EvaluatorContext createEvaluatorContext(Map var1);

    static final class SingleReusableImpl
    extends EvaluatorContextBuilder {
        public SingleReusableImpl(ElInvoker invoke) {
            super(invoke, 1);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            return new EvaluatorContext.SingleVariableImpl(this.invoke.invokeDirect(context));
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            return new EvaluatorContext.SingleVariableImpl(this.invoke.invokeDirect(context));
        }
    }

    static final class SingleReusableRootImpl
    extends EvaluatorContextBuilder {
        final ElVariableInvoker invoke;

        public SingleReusableRootImpl(ElVariableInvoker invoke) {
            this.invoke = invoke;
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            return new EvaluatorContext.SingleVariableImpl(this.invoke.invokeValue(context));
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            return new EvaluatorContext.SingleVariableImpl(context.get(this.invoke.key));
        }
    }

    static final class ReusablelessRootImpl
    extends EvaluatorContextBuilder {
        ReusablelessRootImpl() {
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            return new EvaluatorContext.ObjectRootImpl(context);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            return new EvaluatorContext.MapRootImpl(context);
        }
    }

    static final class SibbingRootReusableImpl
    extends EvaluatorContextBuilder {
        final ElVariableInvoker[] variableInvokers;

        public SibbingRootReusableImpl(ElVariableInvoker[] variableInvokers) {
            this.variableInvokers = variableInvokers;
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            for (ElVariableInvoker elVariableInvoker : this.variableInvokers) {
                variableValues[elVariableInvoker.index] = elVariableInvoker.invokeValue(context);
            }
            return new EvaluatorContext(variableValues);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            for (ElVariableInvoker elVariableInvoker : this.variableInvokers) {
                variableValues[elVariableInvoker.index] = context.get(elVariableInvoker.key);
            }
            return new EvaluatorContext(variableValues);
        }
    }

    static final class SibbingTwinsRootReusableImpl
    extends SibbingTwinsReusableImpl {
        SibbingTwinsRootReusableImpl(ElVariableInvoker one, ElVariableInvoker other) {
            super(null, one, other);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            return new EvaluatorContext.TwinsImpl(this.one, this.one.invokeValue(context), this.other.invokeValue(context));
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            return new EvaluatorContext.TwinsImpl(this.one, context.get(this.one.key), context.get(this.other.key));
        }
    }

    static class SibbingTwinsReusableImpl
    extends EvaluatorContextBuilder {
        final ElVariableInvoker parent;
        final ElVariableInvoker one;
        final ElVariableInvoker other;

        SibbingTwinsReusableImpl(ElVariableInvoker parent, ElVariableInvoker one, ElVariableInvoker other) {
            this.parent = parent;
            this.one = one;
            this.other = other;
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            Object parentContext = this.parent.invokeDirect(context);
            return new EvaluatorContext.TwinsImpl(this.one, this.one.invokeCurrent(context, parentContext), this.other.invokeCurrent(context, parentContext));
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            Object parentContext = this.parent.invokeDirect(context);
            return new EvaluatorContext.TwinsImpl(this.one, this.one.invokeCurrent(context, parentContext), this.other.invokeCurrent(context, parentContext));
        }
    }

    static final class SibbingReusableImpl
    extends EvaluatorContextBuilder {
        final ElVariableInvoker parent;

        SibbingReusableImpl(ElVariableInvoker parent, ElInvoker invoke, int variableCount) {
            super(invoke, variableCount);
            this.parent = parent;
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            Object parentContext = this.parent.invokeDirect(context);
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            this.invoke.invokeCurrent(context, parentContext, variableValues);
            return new EvaluatorContext(variableValues);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            Object parentContext = this.parent.invokeDirect(context);
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            this.invoke.invokeCurrent(context, parentContext, variableValues);
            return new EvaluatorContext(variableValues);
        }
    }

    static final class GeneralReusableImpl
    extends EvaluatorContextBuilder {
        GeneralReusableImpl(ElInvoker invoke, int variableCount) {
            super(invoke, variableCount);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Object context) {
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            this.invoke.invoke(context, variableValues);
            return new EvaluatorContext(variableValues);
        }

        @Override
        public EvaluatorContext createEvaluatorContext(Map context) {
            Object[] variableValues = this.variableCount < 5 ? new Object[5] : new Object[this.variableCount];
            this.invoke.invoke(context, variableValues);
            return new EvaluatorContext(variableValues);
        }
    }
}

