/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import java.math.BigDecimal;
import java.math.BigInteger;

final class ExprCalculateUtils {
    ExprCalculateUtils() {
    }

    public static Number negate(Object value) {
        Number number = (Number)value;
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        return -number.doubleValue();
    }

    public static Object multiply(Object left, Object right, EvaluateEnvironment environment) {
        boolean isDouble;
        Number leftValue = (Number)left;
        Number rightValue = (Number)right;
        boolean isLeftBi = leftValue instanceof BigDecimal;
        boolean isRightBi = rightValue instanceof BigDecimal;
        if (isLeftBi || isRightBi) {
            BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
            BigDecimal rightBi = isRightBi ? (BigDecimal)rightValue : BigDecimal.valueOf(rightValue.doubleValue());
            return leftBi.multiply(rightBi, environment.mathContext);
        }
        boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
        if (isDouble) {
            return leftValue.doubleValue() * rightValue.doubleValue();
        }
        return leftValue.longValue() * rightValue.longValue();
    }

    public static Object divide(Object left, Object right, EvaluateEnvironment environment) {
        boolean isDouble;
        Number leftValue = (Number)left;
        Number rightValue = (Number)right;
        boolean isLeftBi = leftValue instanceof BigDecimal;
        boolean isRightBi = rightValue instanceof BigDecimal;
        if (isLeftBi || isRightBi) {
            BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
            BigDecimal rightBi = isRightBi ? (BigDecimal)rightValue : BigDecimal.valueOf(rightValue.doubleValue());
            return leftBi.divide(rightBi, environment.mathContext);
        }
        boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
        if (isDouble) {
            return leftValue.doubleValue() / rightValue.doubleValue();
        }
        return leftValue.longValue() / rightValue.longValue();
    }

    public static Object mod(Object left, Object right, EvaluateEnvironment environment) {
        boolean isDouble;
        Number leftValue = (Number)left;
        Number rightValue = (Number)right;
        boolean isLeftBi = leftValue instanceof BigDecimal;
        boolean isRightBi = rightValue instanceof BigDecimal;
        if (isLeftBi || isRightBi) {
            BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
            BigDecimal rightBi = isRightBi ? (BigDecimal)rightValue : BigDecimal.valueOf(rightValue.doubleValue());
            return leftBi.remainder(rightBi, environment.mathContext);
        }
        boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
        if (isDouble) {
            return leftValue.doubleValue() % rightValue.doubleValue();
        }
        return leftValue.longValue() % rightValue.longValue();
    }

    public static Object pow(Object left, Object right, EvaluateEnvironment environment) {
        boolean isDouble;
        Number leftValue = (Number)left;
        Number rightValue = (Number)right;
        boolean isLeftBi = leftValue instanceof BigDecimal;
        if (isLeftBi) {
            BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
            int n = rightValue.intValue();
            return leftBi.pow(n, environment.mathContext);
        }
        boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
        if (isDouble) {
            return Math.pow(leftValue.doubleValue(), rightValue.doubleValue());
        }
        return Math.pow(leftValue.longValue(), rightValue.longValue());
    }

    public static Object plus(Object left, Object right, EvaluateEnvironment environment) {
        if (left instanceof Number && right instanceof Number) {
            boolean isDouble;
            Number leftValue = (Number)left;
            Number rightValue = (Number)right;
            boolean isLeftBi = leftValue instanceof BigDecimal;
            boolean isRightBi = rightValue instanceof BigDecimal;
            if (isLeftBi || isRightBi) {
                BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
                BigDecimal rightBi = isRightBi ? (BigDecimal)rightValue : BigDecimal.valueOf(rightValue.doubleValue());
                return leftBi.add(rightBi, environment.mathContext);
            }
            boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
            if (isDouble) {
                return leftValue.doubleValue() + rightValue.doubleValue();
            }
            return leftValue.longValue() + rightValue.longValue();
        }
        if (environment.isAllowVariableNull()) {
            return left + String.valueOf(right);
        }
        if (left instanceof CharSequence) {
            return left.toString() + right;
        }
        if (right instanceof CharSequence) {
            return left + right.toString();
        }
        return left.toString() + right.toString();
    }

    public static Object subtract(Object left, Object right, EvaluateEnvironment environment) {
        boolean isDouble;
        Number leftValue = (Number)left;
        Number rightValue = (Number)right;
        boolean isLeftBi = leftValue instanceof BigDecimal;
        boolean isRightBi = rightValue instanceof BigDecimal;
        if (isLeftBi || isRightBi) {
            BigDecimal leftBi = isLeftBi ? (BigDecimal)leftValue : BigDecimal.valueOf(leftValue.doubleValue());
            BigDecimal rightBi = isRightBi ? (BigDecimal)rightValue : BigDecimal.valueOf(rightValue.doubleValue());
            return leftBi.subtract(rightBi, environment.mathContext);
        }
        boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
        if (isDouble) {
            return leftValue.doubleValue() - rightValue.doubleValue();
        }
        return leftValue.longValue() - rightValue.longValue();
    }

    public static Object or(Object left, Object right) {
        if (left instanceof Number) {
            return ((Number)left).longValue() | ((Number)right).longValue();
        }
        return (Boolean)left | (Boolean)right;
    }

    public static Object and(Object left, Object right) {
        if (left instanceof Number) {
            return ((Number)left).longValue() & ((Number)right).longValue();
        }
        return (Boolean)left & (Boolean)right;
    }

    public static Object xor(Object left, Object right) {
        if (left instanceof Number) {
            return ((Number)left).longValue() ^ ((Number)right).longValue();
        }
        return (Boolean)left ^ (Boolean)right;
    }
}

