/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.CompilerExpression;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Expression {
    public static final Expression parse(String expr) {
        return new ExprParser(expr);
    }

    public static final ExprParser find(String expr, int offset) {
        return new ExprParser(expr, offset);
    }

    public static Expression compile(String expr) {
        return CompilerExpression.compile(expr);
    }

    public static Expression compile(String expr, CompilerEnvironment environment) {
        return CompilerExpression.compile(expr, environment);
    }

    public static Expression compile(String expr, CompilerEnvironment environment, CompilerExpression.Coder coder) {
        return CompilerExpression.compile(expr, environment, coder);
    }

    public static final Object eval(String expr, EvaluateEnvironment evaluateEnvironment) {
        return Expression.parse(expr).evaluate(evaluateEnvironment);
    }

    public static final Object evalParameters(String expr, Object ... params) {
        return Expression.parse(expr).evaluateParameters(params);
    }

    public static final <T> T evalParameters(String expr, Class<T> targetClass, Object ... params) {
        return ObjectUtils.toType(Expression.parse(expr).evaluateParameters(params), targetClass);
    }

    public Object evaluateParameters(Object ... params) {
        throw new UnsupportedOperationException();
    }

    public Object evaluateParameters(EvaluateEnvironment evaluateEnvironment, Object ... params) {
        throw new UnsupportedOperationException();
    }

    public static final <T> T evalResult(String expr, EvaluateEnvironment evaluateEnvironment, Class<T> targetClass) {
        return ObjectUtils.toType(Expression.parse(expr).evaluate(evaluateEnvironment), targetClass);
    }

    public static final Object eval(String expr) {
        return Expression.parse(expr).evaluate();
    }

    public static final <T> T evalResult(String expr, Class<T> targetClass) {
        return Expression.parse(expr).evaluateResult(targetClass);
    }

    public static final Object eval(String expr, Object context) {
        return Expression.parse(expr).evaluate(context);
    }

    public static final Object eval(String expr, Map context) {
        return Expression.parse(expr).evaluate(context);
    }

    public static final Object eval(String expr, Object context, EvaluateEnvironment evaluateEnvironment) {
        return Expression.parse(expr).evaluate(context, evaluateEnvironment);
    }

    public static final Object[] eval(String[] exprs, Object context) {
        if (exprs == null) {
            return null;
        }
        Object[] objects = new Object[exprs.length];
        int i = 0;
        for (String expr : exprs) {
            objects[i++] = Expression.parse(expr).evaluate(context);
        }
        return objects;
    }

    public static final <T> List<T> evalResult(String[] exprs, Object context, Class<T> targetClass) {
        if (exprs == null) {
            return null;
        }
        ArrayList<T> objects = new ArrayList<T>(exprs.length);
        boolean i = false;
        for (String expr : exprs) {
            objects.add(Expression.parse(expr).evaluateResult(context, targetClass));
        }
        return objects;
    }

    public static final <T> T evalResult(String expr, Object context, Class<T> targetClass) {
        return Expression.parse(expr).evaluateResult(context, targetClass);
    }

    public abstract Object evaluate();

    public abstract Object evaluate(Map var1);

    public abstract Object evaluate(Object var1);

    public abstract Object evaluate(Map var1, long var2);

    public abstract Object evaluate(Object var1, long var2);

    public abstract Object evaluate(EvaluateEnvironment var1);

    public abstract Object evaluate(Map var1, EvaluateEnvironment var2);

    public abstract Object evaluate(Object var1, EvaluateEnvironment var2);

    public final <T> T evaluateResult(Class<T> targetClass) {
        return ObjectUtils.toType(this.evaluate(), targetClass);
    }

    public final <T> T evaluateResult(Object context, Class<T> targetClass) {
        return ObjectUtils.toType(this.evaluate(context), targetClass);
    }

    public final <T> T evaluateResult(Map context, Class<T> targetClass) {
        return ObjectUtils.toType(this.evaluate(context), targetClass);
    }

    public final <T> T evaluateResult(Object context, Class<T> targetClass, long timeout) {
        return ObjectUtils.toType(this.evaluate(context, timeout), targetClass);
    }

    public final <T> T evaluateResult(Map context, Class<T> targetClass, long timeout) {
        return ObjectUtils.toType(this.evaluate(context, timeout), targetClass);
    }

    public final <T> T evaluateParametersResult(Class<T> targetClass, Object ... parameters) {
        return ObjectUtils.toType(this.evaluateParameters(parameters), targetClass);
    }

    public static final String renderTemplate(String template, Object context) {
        return Expression.renderTemplate(template, "${", "}", context);
    }

    public static final String renderTemplate(String template, String prefix, String suffix, Object context) {
        if (template == null || prefix == null || suffix == null) {
            return null;
        }
        int prefixLen = prefix.length();
        int suffixLen = suffix.length();
        if (prefixLen == 0 || suffixLen == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder();
        char[] buffers = Expression.getChars(template);
        int length = buffers.length;
        int fromIndex = 0;
        int suffixIndex = template.indexOf(suffix);
        int prefixIndex = -1;
        while (suffixIndex > 0) {
            prefixIndex = template.lastIndexOf(prefix, suffixIndex - 1);
            if (prefixIndex > fromIndex - 1) {
                builder.append(buffers, fromIndex, prefixIndex - fromIndex);
                ExprParser exprParser = new ExprParser(buffers, prefixIndex + prefixLen, suffixIndex - prefixIndex - prefixLen);
                builder.append(exprParser.evaluate(context));
                fromIndex = suffixIndex + suffixLen;
                suffixIndex = template.indexOf(suffix, fromIndex);
                continue;
            }
            suffixIndex = template.indexOf(suffix, suffixIndex + suffixLen);
        }
        if (fromIndex < length) {
            builder.append(buffers, fromIndex, length - fromIndex);
        }
        return builder.toString();
    }

    protected static final char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    public List<String> getVariables() {
        throw new UnsupportedOperationException();
    }

    public List<String> getRootVariables() {
        throw new UnsupportedOperationException();
    }

    public String getSource() {
        throw new UnsupportedOperationException();
    }
}

