/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CollectionUtils {
    public static List listOf(Object ... elements) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : elements) {
            list.add(element);
        }
        return list;
    }

    public static Set setOf(Object ... elements) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T> int indexOf(T[] arr, T obj) {
        return CollectionUtils.indexOf(arr, obj, 0);
    }

    public static <T> int indexOf(T[] arr, T obj, int fromIndex) {
        if (arr == null || obj == null) {
            return -1;
        }
        for (int i = fromIndex; i < arr.length; ++i) {
            T e = arr[i];
            if (e != obj && !obj.equals(e)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] arr, T obj, int fromIndex, int toIndex) {
        if (arr == null || obj == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            T e = arr[i];
            if (e != obj && !obj.equals(e)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] arr, int j) {
        return CollectionUtils.indexOf(arr, j, 0);
    }

    public static int indexOf(int[] arr, int j, int fromIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < arr.length; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] arr, int j, int fromIndex, int toIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] arr, char j) {
        return CollectionUtils.indexOf(arr, j, 0, arr.length);
    }

    public static int indexOf(char[] arr, char j, int fromIndex) {
        return CollectionUtils.indexOf(arr, j, fromIndex, arr.length);
    }

    public static int indexOf(char[] arr, char j, int fromIndex, int toIndex) {
        if (arr == null) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (arr[i] != j) continue;
            return i;
        }
        return -1;
    }

    public static Object arrayValueAt(Object arr, int index) {
        if (index == -1) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
        Class<?> arrCls = arr.getClass();
        if (!arrCls.isArray()) {
            throw new UnsupportedOperationException("Non array object do not support get value by index");
        }
        Class<?> componentType = arrCls.getComponentType();
        ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
        if (primitiveType != null) {
            return primitiveType.elementAt(arr, index);
        }
        Object[] objects = (Object[])arr;
        return objects[index];
    }

    public static boolean isCollection(Object target) {
        if (target == null) {
            return false;
        }
        if (target.getClass().isArray()) {
            return true;
        }
        return target instanceof Collection;
    }

    public static boolean contains(Object[] arr, Object obj) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        return CollectionUtils.indexOf(arr, obj) > -1;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static int getSize(Object target) {
        if (target == null) {
            return 0;
        }
        if (target instanceof Collection) {
            return ((Collection)target).size();
        }
        if (target instanceof Object[]) {
            return ((Object[])target).length;
        }
        return Array.getLength(target);
    }

    public static Object getElement(Object target, int index) {
        if (target == null) {
            return null;
        }
        Object[] arr = null;
        if (target instanceof Collection) {
            if (target instanceof List) {
                return ((List)target).get(index);
            }
            arr = ((Collection)target).toArray();
        } else if (arr instanceof Object[]) {
            arr = (Object[])target;
        } else {
            try {
                return CollectionUtils.arrayValueAt(target, index);
            }
            catch (RuntimeException throwable) {
                throw new UnsupportedOperationException("Non array object do not support get value by index, " + target.getClass());
            }
        }
        return arr[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setElement(Object target, int index, Object value) {
        if (target == null) {
            return;
        }
        if (target instanceof Collection) {
            if (!(target instanceof List)) throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u96c6\u5408\u8d4b\u503c\u64cd\u4f5c");
            ((List)target).set(index, value);
            return;
        } else {
            Object[] arr = (Object[])target;
            arr[index] = value;
        }
    }

    public static Object toArray(Collection collection, Class<?> componentType) {
        componentType.getClass();
        Object array = Array.newInstance(componentType, collection.size());
        int k = 0;
        ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
        if (primitiveType != null) {
            for (Object obj : collection) {
                primitiveType.setElementAt(array, k++, obj);
            }
        } else {
            Object[] objects = (Object[])array;
            for (Object obj : collection) {
                objects[k++] = obj;
            }
        }
        return array;
    }

    public static void clear(Object[] values) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            values[i] = null;
        }
    }
}

