/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.beans.DateParser;
import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.exceptions.TypeNotMatchExecption;
import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.InvokeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ObjectUtils
extends InvokeUtils {
    public static boolean contains(Object target, String key) {
        target.getClass();
        if (target instanceof Map) {
            return ((Map)target).containsKey(key);
        }
        ClassStrucWrap classStrucWrap = ClassStrucWrap.get(target.getClass());
        List<GetterInfo> getterInfos = classStrucWrap.getGetterInfos();
        for (GetterInfo getterInfo : getterInfos) {
            if (!getterInfo.getName().equals(key.trim())) continue;
            return true;
        }
        return false;
    }

    public static <E> E getContext(Object context, String exprKey, Class<E> clazz) {
        Object result = ObjectUtils.get(context, exprKey);
        if (result == null || clazz == null) {
            return (E)result;
        }
        if (ObjectUtils.isInstance(clazz, result)) {
            return (E)result;
        }
        throw new ClassCastException(result.getClass().getName() + " cannot be cast to " + clazz.getName());
    }

    public static <E> E get(Object target, String key, Class<E> clazz) {
        Object result = ObjectUtils.get(target, key);
        if (result == null) {
            return null;
        }
        try {
            return (E)result;
        }
        catch (Throwable throwable) {
            throw new TypeNotMatchExecption(" type is not match, expect " + clazz + ", but get " + result.getClass());
        }
    }

    public static Object get(Object target, String key) {
        if (target == null) {
            return null;
        }
        key = key.trim();
        if (target instanceof Map) {
            Map mapTarget = (Map)target;
            Object value = mapTarget.get(key);
            if (value != null) {
                return value;
            }
            int dotIndex = key.indexOf(46);
            if (dotIndex == -1) {
                return null;
            }
            String topKey = key.substring(0, dotIndex);
            String nextKey = key.substring(dotIndex + 1);
            Object nextTarget = mapTarget.get(topKey);
            return ObjectUtils.get(nextTarget, nextKey);
        }
        int dotIndex = key.indexOf(46);
        if (dotIndex > -1) {
            String topKey = key.substring(0, dotIndex);
            String nextKey = key.substring(dotIndex + 1);
            Object nextTarget = ObjectUtils.get(target, topKey);
            return ObjectUtils.get(nextTarget, nextKey);
        }
        if (CollectionUtils.isCollection(target)) {
            if ("size".equals(key) || "length".equals(key)) {
                return CollectionUtils.getSize(target);
            }
            if (key.startsWith("[") && key.endsWith("]")) {
                return CollectionUtils.getElement(target, Integer.parseInt(key.substring(1, key.length() - 1)));
            }
            throw new TypeNotMatchExecption("context property '" + key + "' is invalid ");
        }
        return ObjectUtils.getObjectFieldValue(target, key);
    }

    public static Object getAttrValue(Object target, String field) {
        if (target == null) {
            return null;
        }
        field.getClass();
        if (target instanceof Map) {
            return ((Map)target).get(field);
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(target.getClass());
        switch (classCategory) {
            case ObjectCategory: {
                return ObjectUtils.getObjectFieldValue(target, field);
            }
            case CollectionCategory: 
            case ArrayCategory: {
                if ("size".equals(field) || "length".equals(field)) {
                    return CollectionUtils.getSize(target);
                }
                if (field.startsWith("[") && field.endsWith("]")) {
                    return CollectionUtils.getElement(target, Integer.parseInt(field.substring(1, field.length() - 1)));
                }
                throw new TypeNotMatchExecption("context property '" + field + "' is invalid ");
            }
        }
        return null;
    }

    public static Object getObjectFieldValue(Object target, String field) {
        ClassStrucWrap classStrucWrap = ClassStrucWrap.get(target.getClass());
        GetterInfo getterInfo = classStrucWrap.getGetterInfo(field);
        if (getterInfo != null) {
            return getterInfo.invoke(target);
        }
        return null;
    }

    public static void set(Object target, String key, Object value) {
        ObjectUtils.set(target, key, value, false);
    }

    public static void set(Object target, String key, Object value, boolean createIfMapNull) {
        if (target == null) {
            return;
        }
        key = key.trim();
        int dotIndex = key.indexOf(46);
        if (target instanceof Map) {
            Map mapTarget = (Map)target;
            if (mapTarget.containsKey(key)) {
                mapTarget.put(key, value);
            } else if (dotIndex > -1) {
                String topKey = key.substring(0, dotIndex);
                String nextKey = key.substring(dotIndex + 1);
                Object nextTarget = mapTarget.get(topKey);
                if (createIfMapNull && nextTarget == null) {
                    nextTarget = new LinkedHashMap();
                    mapTarget.put(topKey, nextTarget);
                }
                ObjectUtils.set(nextTarget, nextKey, value, createIfMapNull);
            } else {
                mapTarget.put(key, value);
            }
        } else if (dotIndex > -1) {
            String topKey = key.substring(0, dotIndex);
            String nextKey = key.substring(dotIndex + 1);
            Object nextTarget = ObjectUtils.get(target, topKey);
            ObjectUtils.set(nextTarget, nextKey, value, createIfMapNull);
        } else {
            if (CollectionUtils.isCollection(target)) {
                if (key.startsWith("[") && key.endsWith("]")) {
                    CollectionUtils.setElement(target, Integer.parseInt(key.substring(1, key.length() - 1)), value);
                }
                throw new TypeNotMatchExecption("context property '" + key + "' is invalid ");
            }
            ClassStrucWrap classStrucWrap = ClassStrucWrap.get(target.getClass());
            SetterInfo setterInfo = classStrucWrap.getSetterInfo(key);
            if (setterInfo != null) {
                ObjectUtils.invokeSet(setterInfo, target, ObjectUtils.toType(value, setterInfo.getParameterType()));
            }
        }
    }

    public static Object[] get(Object target, List<String> keys) {
        Object[] values = new Object[keys.size()];
        int index = 0;
        for (String key : keys) {
            values[index++] = ObjectUtils.get(target, key);
        }
        return values;
    }

    public static Map<String, Object> toMap(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Map) {
            return (Map)target;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ClassStrucWrap classStrucWrap = ClassStrucWrap.get(target.getClass());
        List<GetterInfo> getterInfos = classStrucWrap.getGetterInfos();
        for (GetterInfo getterInfo : getterInfos) {
            map.put(getterInfo.getName(), ObjectUtils.invokeGet(getterInfo, target));
        }
        return map;
    }

    public static List<String> getNonEmptyFields(Object target) {
        return ObjectUtils.getNonEmptyFields(target, new String[0]);
    }

    public static List<String> getNonEmptyFields(Object target, String ... excludeKeys) {
        if (target == null) {
            return null;
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (target instanceof Map) {
            Map map = (Map)target;
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (key == null) continue;
                String field = key.toString();
                Object val = entry.getValue();
                if (val == null || val.equals("") || CollectionUtils.contains(excludeKeys, field)) continue;
                fields.add(field);
            }
        } else {
            ClassStrucWrap classStrucWrap = ClassStrucWrap.get(target.getClass());
            List<GetterInfo> getterInfos = classStrucWrap.getGetterInfos();
            for (GetterInfo getterInfo : getterInfos) {
                String name;
                Object val = getterInfo.invoke(target);
                if (val == null || val.equals("") || Number.class.isInstance(val) && val.toString().equals("0") || CollectionUtils.contains(excludeKeys, name = getterInfo.getName())) continue;
                fields.add(name);
            }
        }
        return fields;
    }

    public static boolean methodWeakEquals(Method source, Method target) {
        Class<?>[] params2;
        if (!source.getName().equals(target.getName())) {
            return false;
        }
        if (!source.getReturnType().equals(target.getReturnType())) {
            return false;
        }
        Class<?>[] params1 = source.getParameterTypes();
        if (params1.length == (params2 = target.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Iterable<Object> getIterable(Object context, String key) {
        Object target = ObjectUtils.get(context, key);
        if (target == null) {
            throw new TypeNotMatchExecption("context property '" + key + "' is null or not iterable ");
        }
        if (target instanceof Iterable) {
            return (Iterable)target;
        }
        if (target.getClass().isArray()) {
            Object[] array = (Object[])target;
            return Arrays.asList(array);
        }
        throw new TypeNotMatchExecption("context property '" + key + "' is not array or iterable ");
    }

    public static Number toTypeNumber(Number value, Class<?> numberType) {
        value.getClass();
        if (numberType.isInstance(value) || numberType == Object.class || numberType == Number.class) {
            return value;
        }
        if (numberType == Double.class || numberType == Double.TYPE) {
            return value.doubleValue();
        }
        if (numberType == Long.class || numberType == Long.TYPE) {
            return value.longValue();
        }
        if (numberType == Integer.class || numberType == Integer.TYPE) {
            return value.intValue();
        }
        if (numberType == Float.class || numberType == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (numberType == Short.class || numberType == Short.TYPE) {
            return value.shortValue();
        }
        if (numberType == Byte.class || numberType == Byte.TYPE) {
            return value.byteValue();
        }
        if (numberType == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (numberType == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (numberType == AtomicInteger.class) {
            return new AtomicInteger(value.intValue());
        }
        if (numberType == AtomicLong.class) {
            return new AtomicLong(value.longValue());
        }
        return null;
    }

    public static boolean isInstance(Class<?> valueClass, Object value) {
        if (valueClass.isPrimitive()) {
            valueClass = ReflectConsts.PrimitiveType.getWrap(valueClass);
        }
        return valueClass.isInstance(value);
    }

    public static <E> E toType(Object value, Class<E> valueClass, ReflectConsts.ClassCategory classCategory) {
        if (value == null || valueClass == null) {
            return (E)value;
        }
        if (ObjectUtils.isInstance(valueClass, value)) {
            return (E)value;
        }
        return ObjectUtils.toTypeByClassCategory(value, valueClass, classCategory);
    }

    public static <E> E toType(Object value, Class<E> valueClass) {
        if (value == null || valueClass == null) {
            return (E)value;
        }
        if (ObjectUtils.isInstance(valueClass, value)) {
            return (E)value;
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(valueClass);
        return ObjectUtils.toTypeByClassCategory(value, valueClass, classCategory);
    }

    private static <E> E toTypeByClassCategory(Object value, Class<E> valueClass, ReflectConsts.ClassCategory classCategory) {
        switch (classCategory) {
            case CharSequence: {
                if (valueClass != String.class) break;
                if (value instanceof Date) {
                    return (E)new GregorianDate(((Date)value).getTime()).format();
                }
                if (value instanceof byte[]) {
                    return (E)new String((byte[])value);
                }
                return (E)value.toString();
            }
            case NumberCategory: {
                boolean isNumber = value instanceof Number;
                if (isNumber) {
                    Number numValue = (Number)value;
                    return (E)ObjectUtils.toTypeNumber(numValue, valueClass);
                }
                if (valueClass == Double.class || valueClass == Double.TYPE) {
                    Double numValue = Double.parseDouble(value.toString());
                    return (E)numValue;
                }
                if (valueClass == Float.class || valueClass == Float.TYPE) {
                    Float numValue = Float.valueOf(Float.parseFloat(value.toString()));
                    return (E)numValue;
                }
                Number numValue = valueClass == BigDecimal.class ? new BigDecimal(value.toString()) : (valueClass == BigInteger.class ? new BigInteger(value.toString()) : Long.valueOf(Long.parseLong(value.toString())));
                return (E)ObjectUtils.toTypeNumber(numValue, valueClass);
            }
            case BoolCategory: {
                if (value == Boolean.TRUE || value == Boolean.FALSE) {
                    return (E)value;
                }
                if (value instanceof Number) {
                    Boolean bool = ((Number)value).intValue() != 0;
                    return (E)bool;
                }
                String stringValue = value.toString().toLowerCase();
                if (stringValue.equals("true") || stringValue.equals("yes") || stringValue.equals("on")) {
                    return (E)Boolean.TRUE;
                }
                if (!stringValue.equals("false") && !stringValue.equals("no") && !stringValue.equals("off")) break;
                return (E)Boolean.FALSE;
            }
            case DateCategory: {
                String dateValue = value.toString();
                long time = DateParser.parseTime(dateValue);
                if (valueClass == Date.class) {
                    return (E)new Date(time);
                }
                if (valueClass == Timestamp.class) {
                    return (E)new Timestamp(time);
                }
                try {
                    Constructor<E> constructor = valueClass.getDeclaredConstructor(Long.TYPE);
                    UnsafeHelper.setAccessible(constructor);
                    return constructor.newInstance(time);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException("not supported for date type " + valueClass);
                }
            }
            case EnumCategory: {
                if (value instanceof Number) {
                    Class<E> enumCls = valueClass;
                    Enum[] values = (Enum[])enumCls.getEnumConstants();
                    int index = ((Number)value).intValue();
                    Enum enumValue = index < values.length ? values[index] : null;
                    return (E)enumValue;
                }
                return Enum.valueOf(valueClass, value.toString());
            }
            case Binary: {
                if (value instanceof String) {
                    return (E)((String)value).getBytes();
                }
            }
            case ANY: {
                return (E)value;
            }
            case ObjectCategory: {
                ClassStrucWrap structureWrapper = ClassStrucWrap.get(valueClass);
                if (!structureWrapper.isTemporal()) break;
                break;
            }
        }
        return null;
    }
}

