/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public final class ReflectUtils {
    public static Type[] getActualTypes(Class<?> targetClass) {
        Type type = targetClass.getGenericSuperclass();
        int i = 0;
        while (type instanceof Class) {
            type = ((Class)type).getGenericSuperclass();
            if (i++ <= 10) continue;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] types = parameterizedType.getActualTypeArguments();
            return types;
        }
        return null;
    }

    public static Class<?> getActualType(Class<?> targetClass) {
        Type[] types = ReflectUtils.getActualTypes(targetClass);
        if (types != null && types.length > 0 && types[0] instanceof Class) {
            return (Class)types[0];
        }
        return null;
    }

    public static Class<?> getImplementActualType(Class<?> targetClass) {
        Type[] typeArray;
        int n;
        int n2;
        Type[] implementTypes = targetClass.getGenericInterfaces();
        if (implementTypes.length == 0) {
            Class parentCls = (Class)targetClass.getGenericSuperclass();
            implementTypes = parentCls.getGenericInterfaces();
        }
        if ((n2 = 0) < (n = (typeArray = implementTypes).length)) {
            ParameterizedType parameterizedType;
            Type[] types;
            Type implementType = typeArray[n2];
            if (implementType instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)implementType).getActualTypeArguments()) != null && types.length > 0 && types[0] instanceof Class) {
                return (Class)types[0];
            }
            return null;
        }
        return null;
    }

    public static Class<?> getCollectionActualParamType(Method method, Class<?> parameterType) {
        if (Collection.class.isAssignableFrom(parameterType)) {
            ParameterizedType pt;
            Type genericType = method.getGenericParameterTypes()[0];
            if (genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments()[0] instanceof Class) {
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                return genericClazz;
            }
            return Object.class;
        }
        if (parameterType.isArray()) {
            return parameterType.getComponentType();
        }
        return null;
    }

    public static Object invoke(Object invoker, String methodName, Object[] params) throws Exception {
        Class<?> invokerCls = invoker.getClass();
        ClassStrucWrap classStrucWrap = ClassStrucWrap.get(invokerCls);
        return classStrucWrap.invokePublic(invoker, methodName, params);
    }
}

