/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.RegexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static String join(String delimiter, Object ... arr) {
        if (arr == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = ",";
        }
        StringBuilder builder = new StringBuilder();
        boolean appendDelimiterFlag = false;
        for (Object val : arr) {
            if (appendDelimiterFlag) {
                builder.append(delimiter);
            } else {
                appendDelimiterFlag = true;
            }
            builder.append(val);
        }
        return builder.toString();
    }

    public static String getCamelCase(String columnName) {
        return StringUtils.getCamelCase(columnName, false);
    }

    public static String getCamelCase(String columnName, boolean upperCaseFirstChar) {
        char firstAppendChar;
        if (columnName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = UnsafeHelper.getChars(columnName);
        boolean upperCaseFlag = false;
        for (char ch : chars) {
            char appendChar;
            boolean isLowerCase;
            if (ch == '_') {
                upperCaseFlag = true;
                continue;
            }
            boolean bl = isLowerCase = ch >= 'a' && ch <= 'z';
            if (upperCaseFlag) {
                appendChar = isLowerCase ? (char)(ch - 32) : ch;
                upperCaseFlag = false;
            } else {
                appendChar = ch >= 'A' && ch <= 'Z' ? (char)(ch + 32) : ch;
            }
            builder.append(appendChar);
        }
        if (upperCaseFirstChar && (firstAppendChar = builder.charAt(0)) >= 'a' && firstAppendChar <= 'z') {
            builder.setCharAt(0, (char)(firstAppendChar - 32));
        }
        return builder.toString();
    }

    public static String camelCaseToSymbol(String camelCase) {
        return StringUtils.camelCaseToSymbol(camelCase, "_");
    }

    public static String camelCaseToSymbol(String camelCase, String symbol) {
        return StringUtils.camelCaseToSymbol(camelCase, symbol, false);
    }

    public static String camelCaseToSymbol(String camelCase, String symbol, boolean firstSymbol) {
        if (camelCase == null) {
            return null;
        }
        char[] chars = UnsafeHelper.getChars(camelCase);
        StringBuilder builder = new StringBuilder();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch >= 'A' && ch <= 'Z') {
                if (firstSymbol || i != 0) {
                    builder.append(symbol);
                }
                builder.append((char)(ch + 32));
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String regexGroupExprReplace(String source, String groupRegex, String prefix, Object context) {
        List<String> groups = RegexUtils.getMatcherGroups(source, groupRegex, false);
        HashSet<String> hashGroups = new HashSet<String>(groups);
        String result = source;
        if (hashGroups != null && hashGroups.size() > 0) {
            for (String group : hashGroups) {
                Object value = ObjectUtils.get(context, group.trim());
                if (value == null) continue;
                result = result.replace(prefix + "{" + group + "}", value.toString());
            }
        }
        return result;
    }

    public static String replacePlaceholder(String message, String placeholder, Object ... parameters) {
        int parameterCount;
        if (StringUtils.isEmpty(placeholder) || parameters == null || (parameterCount = parameters.length) == 0) {
            return message;
        }
        int placeholderIndex = -1;
        placeholderIndex = message.indexOf(placeholder);
        if (placeholderIndex == -1) {
            return message;
        }
        StringBuilder buffer = new StringBuilder();
        int fromIndex = 0;
        int placeholderLen = placeholder.length();
        int i = 0;
        while (placeholderIndex > -1) {
            buffer.append(message, fromIndex, placeholderIndex);
            if (i < parameterCount) {
                buffer.append(parameters[i++]);
            } else {
                buffer.append(placeholder);
            }
            fromIndex = placeholderIndex + placeholderLen;
            placeholderIndex = message.indexOf(placeholder, fromIndex);
        }
        if (fromIndex < message.length()) {
            buffer.append(message, fromIndex, message.length());
        }
        return buffer.toString();
    }

    public static String replaceGroupRegex(String message, Object context) {
        return StringUtils.replaceGroupRegex(message, "[$][{](.*?)[}]", context);
    }

    public static String replaceGroupRegex(String message, Object context, boolean emptyIfNull) {
        return StringUtils.replaceGroupRegex(message, "[$][{]([ ]*[0-9a-zA-Z_.$]+[ ]*)[}]", context, emptyIfNull);
    }

    public static String replaceGroupRegex(String message, String groupRegex, Object context) {
        return StringUtils.replaceGroupRegex(message, groupRegex, context, false);
    }

    public static String replaceGroupRegex(String message, String groupRegex, Object context, boolean emptyIfNull) {
        if (StringUtils.isEmpty(groupRegex) || context == null) {
            return message;
        }
        if (groupRegex.indexOf(")") <= groupRegex.indexOf("(") || groupRegex.indexOf("(") == -1) {
            return message;
        }
        StringBuilder buffer = new StringBuilder();
        Pattern pattern = RegexUtils.getPattern(groupRegex);
        Matcher matcher = pattern.matcher(message);
        int beginIndex = 0;
        while (matcher.find()) {
            int newBeginIndex = matcher.start(0);
            if (message.charAt(newBeginIndex - 1) == '\\') {
                buffer.append(message, beginIndex, newBeginIndex - 1);
                buffer.append(matcher.group(0));
            } else {
                String key = matcher.group(1).trim();
                buffer.append(message, beginIndex, newBeginIndex);
                Object value = ObjectUtils.get(context, key);
                if (value != null || !emptyIfNull) {
                    buffer.append(value);
                }
            }
            beginIndex = matcher.end(0);
        }
        buffer.append(message, beginIndex, message.length());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThrowableContent(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
        finally {
            pw.close();
        }
    }

    public static String escapeHtml(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("&", "&amp;");
        value = value.replaceAll("[<](.*?)[>]", "&lt;$1&gt;").replaceAll("[(](.*?)[)]", "&#40;$1&#41;");
        value = value.replaceAll("=([ ]*)\"", "=$1&quot;");
        value = value.replace("'", "&#39;").replace(" ", "&nbsp;");
        return value;
    }

    public static String htmlUnescape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("&#39;", "'").replace("&nbsp;", " ");
        value = value.replaceAll("=([ ]*)&quot;", "=$1\"");
        value = value.replaceAll("&lt;(.*?)&gt;", "<$1>").replaceAll("&#40;(.*?)&#41;", "($1)");
        value = value.replace("&amp;", "&");
        return value;
    }

    public static boolean contains(String[] arr, String element) {
        if (arr == null || element == null) {
            return false;
        }
        for (String str : arr) {
            if (!element.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String formatMappingPath(String ... paths) {
        StringBuilder pathBuffer = new StringBuilder("/");
        for (String path : paths) {
            if (path == null || path.length() == 0) continue;
            pathBuffer.append(path);
            if (path.endsWith("/")) continue;
            pathBuffer.append("/");
        }
        String path = pathBuffer.toString().trim();
        if (path.indexOf("\\") > -1) {
            path = path.replace("\\", "/");
        }
        path = path.replaceAll("(/)+", "$1");
        return path;
    }

    public static String fromResource(String resource) {
        if (resource == null) {
            return null;
        }
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        InputStream is = StringUtils.class.getResourceAsStream(resource);
        return StringUtils.fromStream(is);
    }

    public static String fromStream(InputStream is) {
        return StringUtils.fromStream(is, Charset.defaultCharset());
    }

    public static String fromStream(InputStream is, String charsetName) {
        return StringUtils.fromStream(is, Charset.forName(charsetName));
    }

    public static String fromStream(InputStream is, Charset charset) {
        try {
            byte[] bytes = IOUtils.readBytes(is);
            return new String(bytes, charset);
        }
        catch (IOException e) {
            return null;
        }
    }
}

