/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.connection;

import io.github.wycst.wast.jdbc.connection.ConnectionWraper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionWraperUtils {
    private static final ThreadLocal<Map<Object, ConnectionWraper>> connectionWrapersOfThread = new ThreadLocal();

    static void bindConnectionWraper(ConnectionWraper wraper, Object key) {
        Map<Object, ConnectionWraper> connectionWrapers = connectionWrapersOfThread.get();
        if (connectionWrapers == null) {
            connectionWrapers = new HashMap<Object, ConnectionWraper>();
            connectionWrapersOfThread.set(connectionWrapers);
        }
        connectionWrapers.put(key, wraper);
    }

    static ConnectionWraper currentConnectionWraper(Object key) {
        Map<Object, ConnectionWraper> connectionWrapers = connectionWrapersOfThread.get();
        if (connectionWrapers == null) {
            return null;
        }
        return connectionWrapers.get(key);
    }

    public static void commitAll() throws SQLException {
        Map<Object, ConnectionWraper> connectionWrapers = connectionWrapersOfThread.get();
        if (connectionWrapers == null) {
            return;
        }
        for (ConnectionWraper wraper : connectionWrapers.values()) {
            Connection conn = wraper.getConnection();
            if (conn == null || conn.isClosed()) continue;
            conn.commit();
            conn.setAutoCommit(true);
            wraper.close();
        }
    }

    public static void rollbackAll() throws SQLException {
        Map<Object, ConnectionWraper> connectionWrapers = connectionWrapersOfThread.get();
        if (connectionWrapers == null) {
            return;
        }
        for (ConnectionWraper wraper : connectionWrapers.values()) {
            Connection conn = wraper.getConnection();
            if (conn == null || conn.isClosed()) continue;
            conn.rollback();
            conn.setAutoCommit(true);
            wraper.close();
        }
    }

    public static void doReset() {
        Map<Object, ConnectionWraper> connectionWrapers = connectionWrapersOfThread.get();
        if (connectionWrapers == null) {
            return;
        }
        for (ConnectionWraper wraper : connectionWrapers.values()) {
            wraper.clear();
        }
        connectionWrapers.clear();
    }

    public static Map<Object, ConnectionWraper> getCurrentConnectionWrapers() {
        return connectionWrapersOfThread.get();
    }

    public static void reBindAll(Map<Object, ConnectionWraper> connectionWrapers) {
        Map<Object, ConnectionWraper> currentConnectionWrapers = connectionWrapersOfThread.get();
        if (currentConnectionWrapers == null) {
            currentConnectionWrapers = new HashMap<Object, ConnectionWraper>();
            connectionWrapersOfThread.set(currentConnectionWrapers);
        }
        currentConnectionWrapers.clear();
        if (connectionWrapers != null) {
            currentConnectionWrapers.putAll(connectionWrapers);
        }
    }
}

