/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.dialect;

import io.github.wycst.wast.jdbc.dialect.Dialect;
import io.github.wycst.wast.jdbc.dialect.DialectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySqlDialect
extends DialectImpl
implements Dialect {
    protected static final String SQL_END_SYMBOL = ";";

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsBackquote() {
        return true;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        String limit;
        sql = sql.trim();
        boolean hasSqlEndSymbol = sql.endsWith(SQL_END_SYMBOL);
        StringBuilder builder = new StringBuilder(sql.length() + 10);
        builder.append(sql);
        String string = limit = hasOffset ? " limit ?,? " : " limit ? ";
        if (hasSqlEndSymbol) {
            builder.insert(builder.length() - 1, limit);
        } else {
            builder.append(limit);
        }
        return builder.toString();
    }

    @Override
    public String getLimitString(String sql, long offset, int limit) {
        sql = sql.trim();
        boolean hasSqlEndSymbol = sql.endsWith(SQL_END_SYMBOL);
        StringBuilder builder = new StringBuilder(sql.length() + 10);
        builder.append(sql);
        if (hasSqlEndSymbol) {
            builder.delete(builder.length() - SQL_END_SYMBOL.length(), builder.length());
        }
        if (offset > 0L) {
            builder.append(" limit ").append(offset).append(',').append(limit);
        } else {
            builder.append(" limit ").append(limit);
        }
        if (hasSqlEndSymbol) {
            builder.append(SQL_END_SYMBOL);
        }
        return builder.toString();
    }

    @Override
    public PreparedStatement prepareStatement(Connection conn, String sql, int type, int resultSetConcurrency) throws SQLException {
        if (type > -1 && resultSetConcurrency > -1) {
            PreparedStatement statement = conn.prepareStatement(sql, type, resultSetConcurrency);
            if (type == 1003 && resultSetConcurrency == 1007) {
                statement.setFetchSize(Integer.MIN_VALUE);
            }
            return statement;
        }
        if (type == 1) {
            return conn.prepareStatement(sql, type);
        }
        return conn.prepareStatement(sql);
    }
}

