/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import io.github.wycst.wast.jdbc.commands.OperationSqlExecuteCommand;
import io.github.wycst.wast.jdbc.commands.SqlExecuteCall;
import io.github.wycst.wast.jdbc.connection.ConnectionManager;
import io.github.wycst.wast.jdbc.connection.ConnectionWraper;
import io.github.wycst.wast.jdbc.connection.DefaultConnectionManager;
import io.github.wycst.wast.jdbc.dialect.ClickHouseDialect;
import io.github.wycst.wast.jdbc.dialect.DefaultDialect;
import io.github.wycst.wast.jdbc.dialect.Dialect;
import io.github.wycst.wast.jdbc.dialect.GbaseDialect;
import io.github.wycst.wast.jdbc.dialect.MySqlDialect;
import io.github.wycst.wast.jdbc.dialect.OracleDialect;
import io.github.wycst.wast.jdbc.dialect.PageDialectAgent;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.EntityExecuter;
import io.github.wycst.wast.jdbc.executer.SqlExecuteContext;
import io.github.wycst.wast.jdbc.executer.SqlExecuterProperties;
import io.github.wycst.wast.jdbc.executer.SqlFunctionType;
import io.github.wycst.wast.jdbc.executer.TemplateSqlExecuter;
import io.github.wycst.wast.jdbc.interceptor.SqlInterceptor;
import io.github.wycst.wast.jdbc.query.QueryExecutor;
import io.github.wycst.wast.jdbc.query.page.Page;
import io.github.wycst.wast.jdbc.util.SqlUtil;
import io.github.wycst.wast.jdbc.util.StreamCursor;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultSqlExecuter {
    static final Log log = LogFactory.getLog(DefaultSqlExecuter.class);
    final String uid = IdGenerator.hex();
    private final SqlExecuterProperties executerProperties;
    private DataSource dataSource;
    private boolean useSpringTransactionManager = false;
    private ConnectionManager connectionManager;
    private final QueryExecutor queryExecutor = new QueryExecutor();
    private Dialect dialect;
    private PageDialectAgent pageDialectAgent;
    private String databaseProductName;
    boolean supportBatchInsert;
    boolean clickHouse;
    boolean mysql;
    boolean gbase;
    String[] sqlTemplates = new String[SqlFunctionType.values().length];
    private TemplateSqlExecuter templateExecutor = new TemplateSqlExecuter(this);
    private EntityExecuter entityExecuter = new EntityExecuter(this);
    private SqlInterceptor sqlInterceptor;
    static final ThreadLocal<Boolean> DISABLE_LOG_FLAG_TL = new ThreadLocal();

    public DefaultSqlExecuter() {
        this(new SqlExecuterProperties());
    }

    public DefaultSqlExecuter(SqlExecuterProperties executerProperties) {
        this.executerProperties = executerProperties == null ? new SqlExecuterProperties() : executerProperties;
    }

    public void setDataSource(DataSource dataSource) {
        dataSource.getClass();
        if (dataSource != this.dataSource) {
            this.dataSource = dataSource;
            this.initDefaultConnectionManager();
            this.initialDialect();
        }
    }

    public void setSqlInterceptor(SqlInterceptor sqlInterceptor) {
        this.sqlInterceptor = sqlInterceptor;
    }

    public void setPageDialectAgent(PageDialectAgent pageDialectAgent) {
        this.pageDialectAgent = pageDialectAgent;
        if (this.dialect != null) {
            this.dialect.setPageDialectAgent(pageDialectAgent);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void initDefaultConnectionManager() {
        if (this.connectionManager == null) {
            this.connectionManager = new DefaultConnectionManager(this.dataSource);
        }
    }

    public TemplateSqlExecuter getTemplateExecutor() {
        return this.templateExecutor;
    }

    public EntityExecuter getEntityExecuter() {
        return this.entityExecuter;
    }

    public void setUseSpringTransactionManager(boolean useSpringTransactionManager) {
        this.useSpringTransactionManager = useSpringTransactionManager;
        this.doCreateSpringConnectionManager();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private ConnectionManager currentConnectionManager() {
        if (this.connectionManager == null) {
            throw new NullPointerException("ConnectionManager error, Please set the datasource or connectionManager !");
        }
        return this.connectionManager;
    }

    private void doCreateSpringConnectionManager() {
        if (this.useSpringTransactionManager) {
            try {
                Class<?> connectionManagerCls = Class.forName("io.github.wycst.wast.jdbc.spring.connection.SpringConnectionManager");
                Constructor<?> constructor = connectionManagerCls.getConstructor(DataSource.class);
                constructor.setAccessible(true);
                this.connectionManager = (ConnectionManager)constructor.newInstance(this.dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void setBatchSize(int batchSize) {
        this.executerProperties.setBatchSize(batchSize);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.executerProperties.setQueryTimeout(queryTimeout);
    }

    public int getBatchSize() {
        return this.executerProperties.getBatchSize();
    }

    public void clear() {
        this.currentConnectionManager().clear();
    }

    public void beginTransaction() {
        this.currentConnectionManager().beginTransaction();
    }

    public void commitTransaction() {
        this.commitTransaction(true);
    }

    public void commitTransaction(boolean closeConnection) {
        this.currentConnectionManager().commitTransaction(closeConnection);
    }

    public void endTransaction() {
        this.currentConnectionManager().endTransaction();
    }

    public void rollbackTransaction() {
        this.rollbackTransaction(true);
    }

    public void rollbackTransaction(boolean closeConnection) {
        this.currentConnectionManager().rollbackTransaction(closeConnection);
    }

    protected ConnectionWraper getConnectionWraper() {
        return this.currentConnectionManager().getConnectionWraper();
    }

    Dialect getDialect() {
        return this.dialect;
    }

    public final String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public final String getUid() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialDialect() {
        Connection physicalConn = null;
        try {
            String databaseProductName;
            physicalConn = this.dataSource.getConnection();
            DatabaseMetaData dmd = physicalConn.getMetaData();
            this.databaseProductName = databaseProductName = dmd.getDatabaseProductName();
            boolean supportBatchInsert = false;
            boolean clickHouse = false;
            boolean mysql = false;
            boolean gbase = false;
            if (databaseProductName != null) {
                String upperName = databaseProductName.toUpperCase();
                mysql = upperName.indexOf("MYSQL") > -1;
                if (mysql) {
                    this.dialect = new MySqlDialect();
                } else if (upperName.indexOf("ORACLE") > -1) {
                    this.dialect = new OracleDialect();
                } else {
                    clickHouse = upperName.indexOf("CLICKHOUSE") > -1;
                    if (clickHouse) {
                        this.dialect = new ClickHouseDialect();
                        this.sqlTemplates[SqlFunctionType.UPDATE_BY_ID.ordinal()] = "ALTER TABLE %s UPDATE %s WHERE %s = %s";
                        this.sqlTemplates[SqlFunctionType.UPDATE_BY_PARAMS.ordinal()] = "ALTER TABLE %s t UPDATE %s %s";
                        this.sqlTemplates[SqlFunctionType.DELETE_BY_ID.ordinal()] = "ALTER TABLE %s DELETE WHERE %s = %s";
                        this.sqlTemplates[SqlFunctionType.DELETE_BY_PARAMS.ordinal()] = "ALTER TABLE %s DELETE %s";
                    } else {
                        gbase = upperName.indexOf("GBASE") > -1;
                        this.dialect = gbase ? new GbaseDialect() : new DefaultDialect(this.pageDialectAgent);
                    }
                }
                supportBatchInsert = mysql || clickHouse;
            }
            this.clickHouse = clickHouse;
            this.mysql = mysql;
            this.gbase = gbase;
            this.supportBatchInsert = supportBatchInsert;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (physicalConn != null) {
                try {
                    physicalConn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected Connection getConnection() {
        return this.getConnectionWraper().getConnection();
    }

    public boolean isShowSql() {
        if (this.isDevelopment()) {
            return true;
        }
        return this.executerProperties.getShowSql() == Boolean.TRUE;
    }

    public void setShowSql(boolean showSql) {
        this.executerProperties.setShowSql(showSql);
    }

    public boolean isFormatSql() {
        return this.executerProperties.getFormatSql() == Boolean.TRUE;
    }

    public void setFormatSql(boolean formatSql) {
        this.executerProperties.setFormatSql(formatSql);
    }

    public boolean isShowParameters() {
        if (this.isDevelopment()) {
            return true;
        }
        return this.executerProperties.getShowParameters() == Boolean.TRUE;
    }

    public void setDevelopment(boolean development) {
        this.executerProperties.setDevelopment(development);
    }

    public boolean isDevelopment() {
        return this.executerProperties.getDevelopment() == Boolean.TRUE;
    }

    public void setShowSqlParameters(boolean showSqlParameters) {
        this.executerProperties.setShowParameters(showSqlParameters);
    }

    private <E> E execute(OperationSqlExecuteCommand<E> command, String sql, Object params, SqlExecuteContext executeContext) {
        List paramList;
        boolean success;
        long beginMillis;
        ConnectionWraper wraper;
        block13: {
            wraper = this.getConnectionWraper();
            List entity = null;
            beginMillis = System.currentTimeMillis();
            success = false;
            try {
                if (this.sqlInterceptor != null) {
                    this.sqlInterceptor.before(sql, params, executeContext);
                }
                if (!executeContext.disableLog) {
                    if (this.isShowSql() && sql != null) {
                        log.info("sql: {}", sql);
                    }
                    if (this.isShowParameters() && params != null) {
                        paramList = this.getParamList(params);
                        log.info("parameters: {}", paramList);
                    }
                }
                entity = (List)command.doExecute(wraper);
                success = true;
                paramList = entity;
                if (this.sqlInterceptor == null) break block13;
                this.sqlInterceptor.after(sql, params, executeContext.result(entity));
            }
            catch (Throwable e) {
                try {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new SqlExecuteException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (this.sqlInterceptor != null) {
                        this.sqlInterceptor.after(sql, params, executeContext.result(entity));
                    }
                    if (this.isDevelopment()) {
                        long endMillis = System.currentTimeMillis();
                        log.info("api:[{}], exec: {}ms, success: {}", executeContext.apiName, endMillis - beginMillis, success);
                    }
                    if (wraper != null && wraper.autoClose() && command.closeable()) {
                        this.connectionManager.closeConnection(wraper);
                    }
                    throw throwable;
                }
            }
        }
        if (this.isDevelopment()) {
            long endMillis = System.currentTimeMillis();
            log.info("api:[{}], exec: {}ms, success: {}", executeContext.apiName, endMillis - beginMillis, success);
        }
        if (wraper != null && wraper.autoClose() && command.closeable()) {
            this.connectionManager.closeConnection(wraper);
        }
        return (E)paramList;
    }

    private List getParamList(Object params) {
        List<Object> paramList = null;
        if (params instanceof Object[]) {
            Object[] paramArr = (Object[])params;
            paramList = Arrays.asList(paramArr);
        } else if (params instanceof List) {
            List list = (List)params;
            paramList = new ArrayList<Object>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object param = list.get(i);
                if (param instanceof Object[]) {
                    Object[] p = (Object[])param;
                    paramList.add(Arrays.asList(p));
                    continue;
                }
                paramList.add(param);
            }
        } else {
            paramList = Arrays.asList(params);
        }
        return paramList;
    }

    public <E> void executePipelined(SqlExecuteCall<E> sqlExecuteCall) {
        ConnectionWraper wraper = this.getConnectionWraper();
        try {
            sqlExecuteCall.execute(wraper.getConnection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (wraper != null && wraper.autoClose()) {
                this.connectionManager.closeConnection(wraper);
            }
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, Object[] params) throws SQLException {
        return this.prepareStatement(conn, sql, params, -1, -1);
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, Object[] params, int type, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.dialect.prepareStatement(conn, sql, type, resultSetConcurrency);
        if (params != null && params.length > 0) {
            int index = 1;
            for (Object param : params) {
                this.dialect.setParameter(ps, index++, param);
            }
        }
        ps.setQueryTimeout(this.executerProperties.getQueryTimeout());
        return ps;
    }

    public Serializable insert(String sql, boolean returnGeneratedKeys, Object ... params) {
        return this.insert(sql, returnGeneratedKeys, SqlExecuteContext.of("insert"), params);
    }

    final Serializable insertWithContext(final String sql, final boolean returnGeneratedKeys, SqlExecuteContext context, final Object ... params) {
        return this.execute(new OperationSqlExecuteCommand<Serializable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Serializable doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                Statement statement = null;
                try {
                    ResultSet generatedKeys;
                    statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, returnGeneratedKeys ? 1 : -1, -1);
                    int effect = statement.executeUpdate();
                    wraper.addInfluencingRows(effect);
                    Serializable generateKey = null;
                    if (returnGeneratedKeys && (generatedKeys = statement.getGeneratedKeys()) != null) {
                        if (generatedKeys.next()) {
                            generateKey = (Serializable)generatedKeys.getObject(1);
                        }
                        generatedKeys.close();
                    }
                    Serializable serializable = generateKey;
                    return serializable;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }, sql, params, context);
    }

    public int update(String sql, Object ... params) {
        return this.updateWithContext(sql, SqlExecuteContext.of("update"), params);
    }

    final int updateWithContext(final String sql, SqlExecuteContext context, final Object ... params) {
        return this.execute(new OperationSqlExecuteCommand<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                Statement statement = null;
                try {
                    statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params);
                    int effect = statement.executeUpdate();
                    wraper.addInfluencingRows(effect);
                    Integer n = effect;
                    return n;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }, sql, params, context);
    }

    public void updateCollection(String sql, List<Object[]> dataList) {
        this.updateCollectionWithContext(sql, dataList, SqlExecuteContext.of("updateCollection"));
    }

    final void updateCollectionWithContext(final String sql, final List<Object[]> dataList, SqlExecuteContext context) {
        this.execute(new OperationSqlExecuteCommand<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                boolean isTransaction = wraper.isTransaction();
                if (!isTransaction && conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                Statement statement = null;
                try {
                    statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, null);
                    int rowIndex = 0;
                    for (Object[] values : dataList) {
                        int index = 1;
                        for (Object value : values) {
                            DefaultSqlExecuter.this.dialect.setParameter((PreparedStatement)statement, index++, value);
                        }
                        statement.addBatch();
                        if (++rowIndex % DefaultSqlExecuter.this.getBatchSize() != 0) continue;
                        statement.executeBatch();
                        if (!isTransaction) {
                            conn.commit();
                        }
                        statement.clearBatch();
                    }
                    statement.executeBatch();
                    if (!isTransaction) {
                        conn.commit();
                        conn.setAutoCommit(true);
                    }
                    statement.clearBatch();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                return 0;
            }
        }, sql, dataList, context);
    }

    public Object queryValue(String sql, Object ... params) {
        return this.queryValue(sql, Object.class, params);
    }

    public <E> E queryValue(String sql, Class<E> valueClass, Object ... params) {
        return this.queryValueWithContext(sql, valueClass, SqlExecuteContext.of("queryValue"), params);
    }

    <E> E queryValueWithContext(final String sql, final Class<E> valueClass, SqlExecuteContext context, final Object ... params) {
        return this.execute(new OperationSqlExecuteCommand<E>(){

            @Override
            public E doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, 1004, 1007);
                return DefaultSqlExecuter.this.queryExecutor.queryValue(valueClass, statement);
            }
        }, sql, params, context);
    }

    public Map queryMap(String sql, Object ... params) {
        return this.queryObject(sql, Map.class, params);
    }

    public <E> E queryObject(String sql, Class<E> cls, Object ... params) {
        return this.queryObjectWithContext(sql, cls, SqlExecuteContext.of("queryObject"), params);
    }

    final <E> E queryObjectWithContext(final String sql, final Class<E> cls, SqlExecuteContext executeContext, final Object ... params) {
        return this.execute(new OperationSqlExecuteCommand<E>(){

            @Override
            public E doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, 1004, 1007);
                return DefaultSqlExecuter.this.queryExecutor.queryObject(cls, statement);
            }
        }, sql, params, executeContext);
    }

    public <E> E queryUniqueObject(String sql, Class<E> cls, Object ... params) {
        return this.queryUniqueObjectWithContext(sql, cls, SqlExecuteContext.of("queryUniqueObject"), params);
    }

    final <E> E queryUniqueObjectWithContext(final String sql, final Class<E> cls, SqlExecuteContext context, final Object ... params) {
        return this.execute(new OperationSqlExecuteCommand<E>(){

            @Override
            public E doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, 1004, 1007);
                return DefaultSqlExecuter.this.queryExecutor.queryUniqueObject(cls, statement);
            }
        }, sql, params, context);
    }

    public <E> List<E> queryList(String sql, Class<E> cls, Object ... params) {
        return this.queryListWithContext(sql, cls, SqlExecuteContext.of("queryList"), params);
    }

    <E> List<E> queryListWithContext(final String sql, final Class<E> cls, SqlExecuteContext context, final Object ... params) {
        return (List)this.execute(new OperationSqlExecuteCommand<List<E>>(){

            @Override
            public List<E> doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, 1004, 1007);
                return DefaultSqlExecuter.this.queryExecutor.queryList(cls, statement);
            }
        }, sql, params, context);
    }

    public <E> StreamCursor<E> queryStream(String sql, Class<E> cls, Object ... params) {
        return this.queryStreamWithContext(sql, cls, SqlExecuteContext.of("queryStream"), params);
    }

    final <E> StreamCursor<E> queryStreamWithContext(final String sql, final Class<E> cls, SqlExecuteContext context, final Object ... params) {
        return (StreamCursor)this.execute(new OperationSqlExecuteCommand<StreamCursor<E>>(){

            @Override
            public StreamCursor<E> doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = DefaultSqlExecuter.this.prepareStatement(conn, sql, params, 1003, 1007);
                return DefaultSqlExecuter.this.queryExecutor.queryStreamCursor(cls, statement, conn);
            }

            @Override
            public boolean closeable() {
                return false;
            }
        }, sql, params, context);
    }

    public List<Map> queryList(String sql, Object ... params) {
        return this.queryList(sql, Map.class, params);
    }

    public String getLimitSql(String sql, long offset, int pageSize) {
        return this.dialect.getLimitString(sql, offset, pageSize);
    }

    private <E> void queryPage(Page page, String sql, Class<E> cls, Object ... params) {
        String queryLimitSql = this.getLimitSql(sql, page.getOffset(), page.getPageSize());
        List<E> rows = this.queryList(queryLimitSql, cls, params);
        page.setRows(rows);
        String queryTotalSql = SqlUtil.getTotalSql(sql);
        long total = this.queryValue(queryTotalSql, Long.TYPE, params);
        page.setTotal(total);
    }

    public <E> void queryPage(Page<E> page, String sql, Object ... params) {
        Class<E> cls = page.actualType();
        this.queryPage(page, sql, cls == null ? Map.class : cls, params);
    }

    public <E> Page<E> queryPage(String sql, long pageNum, int limit, Class<E> cls, Object ... params) {
        Page<E> page = Page.pageInstance(cls);
        page.setPage(pageNum);
        page.setPageSize(limit);
        this.queryPage(page, sql, cls == null ? Map.class : cls, params);
        return page;
    }

    public Page<Map> queryPage(String sql, long pageNum, int limit, Object ... params) {
        return this.queryPage(sql, pageNum, limit, Map.class, params);
    }

    public boolean isSupportBatchInsert() {
        return this.supportBatchInsert;
    }

    public void close() {
        this.clear();
    }

    public int executeUpdate(final String sql) {
        return this.execute(new OperationSqlExecuteCommand<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                PreparedStatement statement = null;
                try {
                    statement = conn.prepareStatement(sql);
                    Integer n = statement.executeUpdate();
                    return n;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }, sql, null, SqlExecuteContext.of("executeUpdate"));
    }

    public void executeScript(InputStream is) throws IOException {
        final List<String> sqlList = SqlUtil.readSqlScripts(is);
        this.execute(new OperationSqlExecuteCommand<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doExecute(ConnectionWraper wraper) throws SQLException {
                Connection conn = wraper.getConnection();
                Statement statement = null;
                try {
                    statement = conn.createStatement();
                    for (String sql : sqlList) {
                        if (DefaultSqlExecuter.this.isShowSql()) {
                            log.info("\n{}", sql);
                        }
                        statement.addBatch(sql);
                    }
                    statement.executeBatch();
                    Integer n = 0;
                    return n;
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }, null, null, SqlExecuteContext.of("executeScript"));
    }

    public boolean isClickHouse() {
        return this.clickHouse;
    }

    public boolean isMysql() {
        return this.mysql;
    }

    public boolean isGbase() {
        return this.gbase;
    }
}

