/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.EntitySqlMapping;
import io.github.wycst.wast.jdbc.executer.SqlType;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import java.io.Serializable;
import java.util.List;

class EntityHandler {
    EntitySqlMapping entitySqlMapping;

    EntityHandler(EntitySqlMapping entitySqlMapping) {
        this.entitySqlMapping = entitySqlMapping;
    }

    <E> E getById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        String selectSql = this.entitySqlMapping.getSelectSql();
        if (selectSql == null) {
            throw new OqlParematerException("configuration error: " + entityCls + " may not have a column defined @Id, please check the annotation configuration");
        }
        return sqlExecuter.queryObjectWithContext(selectSql, entityCls, this.entitySqlMapping.createContext("EntityExecuter#getById"), id);
    }

    <E> int deleteById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        String sqlStringFormat = sqlExecuter.sqlTemplates[SqlType.DELETE.ordinal()];
        Sql sqlObject = this.entitySqlMapping.getDeleteSqlObject(sqlStringFormat, id);
        if (sqlObject == null) {
            throw new OqlParematerException("configuration error: " + entityCls + " may not have a column defined @Id, please check the annotation configuration");
        }
        return sqlExecuter.updateWithContext(sqlObject.getFormalSql(), this.entitySqlMapping.createContext("EntityExecuter#deleteById"), sqlObject.getParamValues());
    }

    <E> int updateEntity(DefaultSqlExecuter sqlExecuter, E entity) {
        String sqlStringFormat = sqlExecuter.sqlTemplates[SqlType.UPDATE.ordinal()];
        Sql sqlObject = this.entitySqlMapping.getUpdateSqlObject(sqlStringFormat, entity);
        if (sqlObject == null) {
            throw new OqlParematerException("configuration error: " + this.entitySqlMapping.getEntityClass() + " may not have a column defined @Id, please check the annotation configuration");
        }
        return sqlExecuter.updateWithContext(sqlObject.getFormalSql(), this.entitySqlMapping.createContext("EntityExecuter#update"), sqlObject.getParamValues());
    }

    <E> void afterUpdate(DefaultSqlExecuter sqlExecuter, E entity) {
    }

    void afterBatchDelete() {
    }

    <E> List<E> executeQueryBy(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Object params) {
        Sql sqlObject = this.entitySqlMapping.getSelectSqlObject(params);
        return sqlExecuter.queryListWithContext(sqlObject.getFormalSql(), entityCls, this.entitySqlMapping.createContext("EntityExecuter#queryBy"), sqlObject.getParamValues());
    }
}

