/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.ClassUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.annotations.CascadeFetch;
import io.github.wycst.wast.jdbc.annotations.Column;
import io.github.wycst.wast.jdbc.annotations.Id;
import io.github.wycst.wast.jdbc.annotations.Join;
import io.github.wycst.wast.jdbc.annotations.JoinField;
import io.github.wycst.wast.jdbc.annotations.MapperClass;
import io.github.wycst.wast.jdbc.annotations.Table;
import io.github.wycst.wast.jdbc.annotations.Transient;
import io.github.wycst.wast.jdbc.exception.EntityException;
import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.executer.CacheableEntityHandler;
import io.github.wycst.wast.jdbc.executer.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.executer.EntitySqlMapping;
import io.github.wycst.wast.jdbc.executer.FieldColumn;
import io.github.wycst.wast.jdbc.executer.JoinColumn;
import io.github.wycst.wast.jdbc.executer.JoinEntityMapping;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityManagementFactory {
    private String entityScanPackages;
    private final Map<Class<?>, EntitySqlMapping> entitySqlMappings = new HashMap();
    static final EntityManagementFactory Default = new EntityManagementFactory();
    static final List<String> MysqlDatabaseKeyWords = Arrays.asList("table", "column", "describe", "order", "asc", "desc", "current_date", "terminated", "by", "cursor", "distinct", "explain", "fulltext", "mod", "xor", "range", "limit", "rename");

    private EntityManagementFactory() {
    }

    public static EntityManagementFactory defaultManagementFactory() {
        return Default;
    }

    public EntityManagementFactory setEntityScanPackages(String entityScanPackages) {
        this.entityScanPackages = entityScanPackages;
        return this;
    }

    public final EntityManagementFactory init() {
        this.checkScanPackages();
        this.scanEntitys();
        return this;
    }

    private void checkScanPackages() {
        if (StringUtils.isEmpty(this.entityScanPackages)) {
            throw new EntityException("Entity scan packages not specified, setEntityScanPackages(arg0) should be call before invoke init() ");
        }
    }

    private Collection<Field> getEntityFields(Class<?> entityCls) {
        Class<?> parentClass;
        Field[] fields;
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        for (Field field : fields = entityCls.getDeclaredFields()) {
            fieldMap.put(field.getName(), field);
        }
        for (parentClass = entityCls.getSuperclass(); parentClass != null && !parentClass.isAnnotationPresent(MapperClass.class); parentClass = parentClass.getSuperclass()) {
        }
        if (parentClass != null) {
            for (Field field : parentClass.getDeclaredFields()) {
                if (fieldMap.containsKey(field.getName())) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap.values();
    }

    /*
     * WARNING - void declaration
     */
    public void scanPackages(String ... scanPackages) {
        String fieldName;
        Set<Class<?>> entityClsSet = ClassUtils.findClasses(scanPackages, Object.class, Table.class, false);
        HashMap entityJoinFields = new HashMap();
        for (Class<?> clazz : entityClsSet) {
            void var11_13;
            if (clazz.isAnnotationPresent(MapperClass.class)) {
                throw new EntityException(" Entity Class " + clazz + " AnnotationPresent[MapperClass] are not allowed ! ");
            }
            Table table = clazz.getAnnotation(Table.class);
            String tableName = table.name().trim();
            String schame = table.schame();
            if (StringUtils.isEmpty(tableName)) {
                tableName = StringUtils.camelCaseToSymbol(clazz.getSimpleName());
            }
            if (StringUtils.isNotEmpty(schame)) {
                tableName = schame + "." + tableName;
            }
            LinkedHashMap<String, FieldColumn> fieldColumnMapping = new LinkedHashMap<String, FieldColumn>();
            LinkedHashMap joinEntityMappings = new LinkedHashMap();
            Object var11_14 = null;
            Collection<Field> fields = this.getEntityFields(clazz);
            ClassStrucWrap classStrucWrap = ClassStrucWrap.get(clazz);
            HashMap<String, JoinField> joinFields = new HashMap<String, JoinField>();
            ArrayList<CascadeFetchMapping> cascadeFetchMappings = new ArrayList<CascadeFetchMapping>();
            for (Field field : fields) {
                Join join;
                String columnName;
                if (field.getAnnotation(Transient.class) != null || !classStrucWrap.containsSetterKey(fieldName = field.getName())) continue;
                SetterInfo setterInfo = classStrucWrap.getSetterInfo(fieldName);
                GetterInfo getterInfo = classStrucWrap.getGetterInfo(fieldName);
                if (field.getAnnotation(JoinField.class) != null) {
                    joinFields.put(fieldName, field.getAnnotation(JoinField.class));
                    continue;
                }
                if (field.isAnnotationPresent(CascadeFetch.class)) {
                    Class<?> actualType;
                    int fieldTypeValue = 0;
                    Class<?> targetEntityClass = null;
                    Class<?> fieldType = field.getType();
                    if (entityClsSet.contains(fieldType)) {
                        fieldTypeValue = 1;
                        targetEntityClass = fieldType;
                    } else if (List.class.isAssignableFrom(fieldType) && entityClsSet.contains(actualType = setterInfo.getActualTypeArgument())) {
                        fieldTypeValue = 2;
                        targetEntityClass = actualType;
                    }
                    if (targetEntityClass != null) {
                        CascadeFetch cascadeFetch = field.getAnnotation(CascadeFetch.class);
                        CascadeFetchMapping cascadeFetchMapping = new CascadeFetchMapping(targetEntityClass, field, fieldTypeValue, cascadeFetch);
                        cascadeFetchMappings.add(cascadeFetchMapping);
                        continue;
                    }
                    throw new EntityException(" Entity " + clazz + " " + field + " annotationPresent @CascadeFetch but the field type is not be an entity or the list generic is not an entity type");
                }
                Column column = field.getAnnotation(Column.class);
                if (column != null) {
                    columnName = column.name();
                    if (StringUtils.isEmpty(columnName)) {
                        columnName = StringUtils.camelCaseToSymbol(fieldName);
                    }
                } else {
                    columnName = StringUtils.camelCaseToSymbol(fieldName);
                }
                FieldColumn fieldColumn = new FieldColumn(field, column, columnName, setterInfo, getterInfo);
                fieldColumnMapping.put(fieldName, fieldColumn);
                if (field.getAnnotation(Id.class) != null) {
                    FieldColumn fieldColumn2 = fieldColumn;
                    Id id = field.getAnnotation(Id.class);
                    fieldColumn2.setId(id);
                    fieldColumn2.setPrimary(true);
                }
                if ((join = field.getAnnotation(Join.class)) == null) continue;
                Class<?> target = join.target();
                if (!entityClsSet.contains(target)) {
                    throw new EntityException(" Entity Class " + clazz + " , field " + field + " Annotation@Join target class " + target + " is not a Table Entity");
                }
                String fieldKey = join.field();
                JoinEntityMapping joinEntityMapping = (JoinEntityMapping)joinEntityMappings.get(target);
                if (joinEntityMapping == null) {
                    joinEntityMapping = new JoinEntityMapping();
                    joinEntityMappings.put(target, joinEntityMapping);
                }
                joinEntityMapping.getJoinOnFieldKeys().put(fieldName, fieldKey);
            }
            if (joinFields.size() > 0) {
                entityJoinFields.put(clazz, joinFields);
            }
            EntitySqlMapping entitySqlMapping = new EntitySqlMapping(clazz, tableName, fieldColumnMapping, (FieldColumn)var11_13, joinEntityMappings, cascadeFetchMappings, table);
            this.entitySqlMappings.put(clazz, entitySqlMapping);
        }
        for (Map.Entry entry : entityJoinFields.entrySet()) {
            EntitySqlMapping targetEntitySqlMapping;
            Class entityCls = (Class)entry.getKey();
            Map joinFields = (Map)entry.getValue();
            EntitySqlMapping entitySqlMapping = this.entitySqlMappings.get(entityCls);
            Map<Class<?>, JoinEntityMapping> joinEntityMappings = entitySqlMapping.getJoinEntityMappings();
            for (Map.Entry<Class<?>, JoinEntityMapping> entry2 : joinEntityMappings.entrySet()) {
                Class<?> joinClass = entry2.getKey();
                JoinEntityMapping joinEntityMapping = entry2.getValue();
                Map<String, String> joinOnFieldKeys = joinEntityMapping.getJoinOnFieldKeys();
                targetEntitySqlMapping = this.entitySqlMappings.get(joinClass);
                for (Map.Entry<String, String> joinFiledEntry : joinOnFieldKeys.entrySet()) {
                    fieldName = joinFiledEntry.getKey();
                    String joinFieldName = joinFiledEntry.getValue();
                    String columnName = entitySqlMapping.getFieldColumnMapping().get(fieldName).getColumnName();
                    String joinColumnName = targetEntitySqlMapping.getFieldColumnMapping().get(joinFieldName).getColumnName();
                    joinEntityMapping.getJoinOnColumnKeys().put(columnName, joinColumnName);
                }
            }
            for (Map.Entry<Class<Object>, JoinEntityMapping> entry3 : joinFields.entrySet()) {
                String fieldName2 = (String)((Object)entry3.getKey());
                JoinField joinField = (JoinField)((Object)entry3.getValue());
                Class<?> target = joinField.target();
                if (!entityClsSet.contains(target)) {
                    throw new EntityException(" Entity Class '" + entityCls + "' , field '" + fieldName2 + "' annotation@JoinField target class '" + target + "' is not a Table Entity");
                }
                targetEntitySqlMapping = this.entitySqlMappings.get(target);
                if (!joinEntityMappings.containsKey(target)) {
                    throw new EntityException(" Entity Class " + entityCls + " , field " + fieldName2 + " with annotation@JoinField target class '" + target + "' has not targetClass by annotation@Join to mapping the conditions of the relation table");
                }
                JoinEntityMapping joinEntityMapping = joinEntityMappings.get(target);
                joinEntityMapping.setTableName(targetEntitySqlMapping.getTableName());
                JoinColumn joinColumn = new JoinColumn(joinField);
                joinColumn.setFieldName(fieldName2);
                String joinFieldName = joinField.field();
                Map<String, FieldColumn> targetFieldColumnMapping = targetEntitySqlMapping.getFieldColumnMapping();
                if (!targetFieldColumnMapping.containsKey(joinFieldName)) {
                    throw new EntityException(" Entity Class " + entityCls + " , field " + fieldName2 + " annotation@JoinField field '" + joinFieldName + "' has not a field at class " + target);
                }
                FieldColumn fieldColumn = targetFieldColumnMapping.get(joinFieldName);
                joinColumn.setJoinFieldColumn(fieldColumn);
                joinEntityMapping.getJoinColumns().add(joinColumn);
            }
            entitySqlMapping.init();
        }
    }

    private void scanEntitys() {
        this.entitySqlMappings.clear();
        this.scanPackages(this.entityScanPackages.split(","));
    }

    public void clear() {
        this.entitySqlMappings.clear();
    }

    public void clearCaches(Class<?> ... entityClassList) {
        for (Class<?> entityCls : entityClassList) {
            EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
            if (!entitySqlMapping.isCacheable()) continue;
            entitySqlMapping.getCacheableEntityHandler().resetCaches();
        }
    }

    public void clearAllCaches() {
        for (EntitySqlMapping entitySqlMapping : this.entitySqlMappings.values()) {
            if (!entitySqlMapping.isCacheable()) continue;
            CacheableEntityHandler cacheableEntityHandler = (CacheableEntityHandler)entitySqlMapping.getEntityHandler();
            cacheableEntityHandler.resetCaches();
        }
    }

    public void clearExpiredCaches() {
        for (EntitySqlMapping entitySqlMapping : this.entitySqlMappings.values()) {
            if (!entitySqlMapping.isCacheable()) continue;
            CacheableEntityHandler cacheableEntityHandler = (CacheableEntityHandler)entitySqlMapping.getEntityHandler();
            cacheableEntityHandler.clearExpiredCaches();
        }
    }

    public boolean existEntity(Class<?> entityCls) {
        return this.entitySqlMappings.containsKey(entityCls);
    }

    public EntitySqlMapping getEntitySqlMapping(Class entityCls) {
        return this.entitySqlMappings.get(entityCls);
    }

    public void checkEntityClass(Class<?> entityCls) {
        entityCls.getClass();
        if (!this.existEntity(entityCls)) {
            throw new OqlParematerException(entityCls + " not included in object SQL management, please check entity scanning configuration");
        }
    }
}

