/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.generator;

import io.github.wycst.wast.jdbc.generator.GeneratorTable;
import io.github.wycst.wast.jdbc.generator.GeneratorTableOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GeneratorContext {
    private String outFilePath;
    private boolean zip;
    private String basePackage;
    private String entityPackage;
    private String[] tableNames;
    private String deletePrefixAsEntity;
    private boolean useLombok;
    private boolean overwrite;
    private String author = "";
    private boolean generateController;
    private boolean generateService;
    private boolean generateViews;
    private Map<String, GeneratorTableOption> tableOptions;
    private List<GeneratorTable> generatorTables;

    public String getOutFilePath() {
        return this.outFilePath;
    }

    public void setOutFilePath(String outFilePath) {
        this.outFilePath = outFilePath;
    }

    public boolean isZip() {
        return this.zip;
    }

    public void setZip(boolean zip) {
        this.zip = zip;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getEntityPackage() {
        return this.entityPackage;
    }

    public void setEntityPackage(String entityPackage) {
        this.entityPackage = entityPackage;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(String[] tableNames) {
        this.tableNames = tableNames;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Map<String, GeneratorTableOption> getTableOptions() {
        return this.tableOptions;
    }

    public void setTableOptions(Map<String, GeneratorTableOption> tableOptions) {
        this.tableOptions = tableOptions;
    }

    public String getDeletePrefixAsEntity() {
        return this.deletePrefixAsEntity;
    }

    public void setDeletePrefixAsEntity(String deletePrefixAsEntity) {
        this.deletePrefixAsEntity = deletePrefixAsEntity;
    }

    public List<GeneratorTable> getGeneratorTables() {
        return this.generatorTables;
    }

    public void setGeneratorTables(List<GeneratorTable> generatorTables) {
        this.generatorTables = generatorTables;
    }

    public boolean isUseLombok() {
        return this.useLombok;
    }

    public void setUseLombok(boolean useLombok) {
        this.useLombok = useLombok;
    }

    public boolean isGenerateController() {
        return this.generateController;
    }

    public void setGenerateController(boolean generateController) {
        this.generateController = generateController;
    }

    public boolean isGenerateService() {
        return this.generateService;
    }

    public void setGenerateService(boolean generateService) {
        this.generateService = generateService;
    }

    public boolean isGenerateViews() {
        return this.generateViews;
    }

    public void setGenerateViews(boolean generateViews) {
        this.generateViews = generateViews;
    }

    public void writeFile() throws IOException {
        List<GeneratorTable> generatorTables = this.getGeneratorTables();
        generatorTables.getClass();
        File dir = new File(this.outFilePath);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (dir.isFile()) {
            throw new RuntimeException("\u76ee\u5f55\u4f5c\u4e3a\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
        }
        File file = new File(this.outFilePath + "/generator.zip");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zos = new ZipOutputStream(fileOutputStream);
        if (this.isZip()) {
            String basePackageDir;
            String string = basePackageDir = this.basePackage == null ? "java/" : "java/" + this.basePackage.replace(".", "/");
            if (!basePackageDir.endsWith("/")) {
                basePackageDir = basePackageDir + "/";
            }
            for (GeneratorTable generatorTable : generatorTables) {
                String entityCode = generatorTable.getEntityCode();
                String controllerCode = generatorTable.getControllerCode();
                String serviceInfCode = generatorTable.getServiceInfCode();
                String serviceImplCode = generatorTable.getServiceImplCode();
                String apiJsCode = generatorTable.getApiJsCode();
                String vueCode = generatorTable.getVueCode();
                ZipEntry entityEntry = new ZipEntry(basePackageDir + "entitys/" + generatorTable.getEntityName() + ".java");
                zos.putNextEntry(entityEntry);
                zos.write(entityCode.getBytes());
                zos.closeEntry();
                if (this.isGenerateController()) {
                    ZipEntry controllerEntry = new ZipEntry(basePackageDir + "controllers/" + generatorTable.getUpperCaseModuleName() + "Controller.java");
                    zos.putNextEntry(controllerEntry);
                    zos.write(controllerCode.getBytes());
                    zos.closeEntry();
                }
                if (this.isGenerateService()) {
                    ZipEntry serviceInfEntry = new ZipEntry(basePackageDir + "services/I" + generatorTable.getUpperCaseModuleName() + "Service.java");
                    zos.putNextEntry(serviceInfEntry);
                    zos.write(serviceInfCode.getBytes());
                    zos.closeEntry();
                    ZipEntry serviceImplEntry = new ZipEntry(basePackageDir + "services/impls/" + generatorTable.getUpperCaseModuleName() + "ServiceImpl.java");
                    zos.putNextEntry(serviceImplEntry);
                    zos.write(serviceImplCode.getBytes());
                    zos.closeEntry();
                }
                if (!this.isGenerateViews()) continue;
                ZipEntry apiJsEntry = new ZipEntry("vue/apis/" + generatorTable.getLowerCaseModuleName() + ".js");
                zos.putNextEntry(apiJsEntry);
                zos.write(apiJsCode.getBytes());
                zos.closeEntry();
                ZipEntry vueEntry = new ZipEntry("vue/views/" + generatorTable.getUpperCaseModuleName() + ".vue");
                zos.putNextEntry(vueEntry);
                zos.write(vueCode.getBytes());
                zos.closeEntry();
            }
            zos.close();
        }
    }
}

