/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.transaction;

import io.github.wycst.wast.jdbc.transaction.TransactionPoint;

public class TransactionUtils {
    private static ThreadLocal<TransactionPoint> transactionPointOfThread = new ThreadLocal();
    private static ThreadLocal<Boolean> transactionActiveOfThread = new ThreadLocal();

    public static TransactionPoint currentTransactionPoint() {
        return transactionPointOfThread.get();
    }

    public static boolean isTransactionActive() {
        Boolean active = transactionActiveOfThread.get();
        return active == Boolean.TRUE;
    }

    public static void setTransactionActive(boolean active) {
        transactionActiveOfThread.set(active);
    }

    public static void bindTransactionPoint(TransactionPoint currentTransactionPoint) {
        transactionPointOfThread.set(currentTransactionPoint);
    }

    public static void doReset() {
        TransactionUtils.setTransactionActive(false);
        transactionPointOfThread.set(null);
    }
}

