/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONTypeMapper;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JSONCustomMapper {
    final Map<Class<?>, JSONTypeSerializer> customSerializerMap = new ConcurrentHashMap();
    final Map<Class<?>, JSONTypeMapper> typeMapperMap = new ConcurrentHashMap();

    public <E> void register(Class<E> pojoClsss, JSONTypeMapper<E> typeMapper) {
        this.register(pojoClsss, typeMapper, true, true);
    }

    public <E> void register(Class<E> pojoClsss, JSONTypeMapper<E> typeMapper, boolean customSerialize, boolean customDeserialize) {
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(pojoClsss);
        if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
            throw new IllegalArgumentException("custom only supported pojo class, but " + pojoClsss);
        }
        if (customSerialize) {
            this.customSerializerMap.put(pojoClsss, JSON.buildCustomizedSerializer(typeMapper));
        }
        if (customDeserialize) {
            this.typeMapperMap.put(pojoClsss, typeMapper);
        }
    }

    JSONTypeSerializer getCustomizedSerializer(Class<?> pojoClass) {
        JSONTypeSerializer typeSerializer = this.customSerializerMap.get(pojoClass);
        if (typeSerializer != null) {
            return typeSerializer;
        }
        return JSONTypeSerializer.getTypeSerializer(pojoClass);
    }

    void serializeCustomized(Object obj, JSONWriter content, JSONConfig jsonConfig, int indentLevel) throws Exception {
        this.getCustomizedSerializer(obj.getClass()).serializeCustomized(obj, content, jsonConfig, indentLevel, this);
    }

    <T> T parseCustomObject(String json, Class<T> actualType, ReadOption[] readOptions) throws Exception {
        JSONTypeMapper typeMapper = this.typeMapperMap.get(actualType);
        if (typeMapper == null) {
            return JSON.parseObject(json, actualType, readOptions);
        }
        Object result = JSONDefaultParser.parse(json, readOptions);
        return typeMapper.readOf(result);
    }
}

