/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JSONDefaultParser
extends JSONGeneral {
    public static Object parse(String json, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(json), bytes, 0, bytes.length, null, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONDefaultParser.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, 0, chars.length, null, readOptions);
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return JSONDefaultParser.parseInternal(null, chars, 0, chars.length, null, readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == buf.length) {
                return JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(json), bytes, 0, bytes.length, null, readOptions);
            }
            return JSONDefaultParser.parseInternal((CharSource)UTF16ByteArraySource.of(json), buf, 0, buf.length, null, readOptions);
        }
        return JSONDefaultParser.parseInternal(null, buf, 0, buf.length, null, readOptions);
    }

    static Object parse(char[] buf, int offset, int len, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            String json = new String(buf, offset, len);
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(json), bytes, 0, bytes.length, null, readOptions);
            }
            char[] chars = len == buf.length ? buf : json.toCharArray();
            return JSONDefaultParser.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, 0, chars.length, null, readOptions);
        }
        return JSONDefaultParser.parseInternal(null, buf, offset, len, null, readOptions);
    }

    static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return (Map)JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(json), bytes, 0, bytes.length, (Object)JSONDefaultParser.createMapInstance(mapCls), readOptions);
            }
            char[] chars = json.toCharArray();
            return (Map)JSONDefaultParser.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, 0, chars.length, (Object)JSONDefaultParser.createMapInstance(mapCls), readOptions);
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return (Map)JSONDefaultParser.parseInternal(null, chars, 0, chars.length, (Object)JSONDefaultParser.createMapInstance(mapCls), readOptions);
    }

    static Collection parseCollection(String json, Class<? extends Collection> listCls, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json);
            if (bytes.length == json.length()) {
                return (Collection)JSONDefaultParser.parseInternal((CharSource)AsciiStringSource.of(json), bytes, 0, bytes.length, (Object)JSONDefaultParser.createCollectionInstance(listCls), readOptions);
            }
            char[] chars = json.toCharArray();
            return (Collection)JSONDefaultParser.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, 0, chars.length, (Object)JSONDefaultParser.createCollectionInstance(listCls), readOptions);
        }
        char[] chars = (char[])JSONUnsafe.getStringValue(json);
        return (Collection)JSONDefaultParser.parseInternal(null, chars, 0, chars.length, (Object)JSONDefaultParser.createCollectionInstance(listCls), readOptions);
    }

    static Object parseInternal(CharSource source, char[] buf, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        char beginChar;
        try {
            while ((beginChar = buf[fromIndex]) <= ' ') {
                ++fromIndex;
            }
            while (buf[toIndex - 1] <= ' ') {
                --toIndex;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("Syntax error, not supported empty source");
        }
        JSONParseContext parseContext = new JSONParseContext();
        try {
            Object result;
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.toIndex = toIndex;
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, fromIndex + 1, parseContext);
                beginChar = buf[fromIndex];
            }
            block4 : switch (beginChar) {
                case '{': {
                    result = JSONDefaultParser.parseJSONObject(source, buf, fromIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, parseContext);
                    break;
                }
                case '[': {
                    result = JSONDefaultParser.parseJSONArray(source, buf, fromIndex, defaultValue == null ? new ArrayList(10) : (Collection)defaultValue, parseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    result = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, buf, fromIndex, beginChar, null, parseContext);
                    break;
                }
                default: {
                    try {
                        switch (beginChar) {
                            case 't': {
                                result = JSONTypeDeserializer.parseTrue(buf, fromIndex, parseContext);
                                break block4;
                            }
                            case 'f': {
                                result = JSONTypeDeserializer.parseFalse(buf, fromIndex, parseContext);
                                break block4;
                            }
                            case 'n': {
                                result = JSONTypeDeserializer.parseNull(buf, fromIndex, parseContext);
                                break block4;
                            }
                        }
                        char[] numBuf = Arrays.copyOfRange(buf, fromIndex, toIndex + 1);
                        numBuf[numBuf.length - 1] = 44;
                        toIndex = numBuf.length - 1;
                        result = JSONTypeDeserializer.NUMBER.deserialize(source, numBuf, 0, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, ',', parseContext);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable instanceof JSONException ? (JSONException)throwable : new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                    }
                }
            }
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, endIndex + 1, parseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(buf, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSONDefaultParser.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    static Collection parseJSONArray(CharSource source, char[] buf, int fromIndex, Collection list, JSONParseContext parseContext) throws Exception {
        char ch;
        int i = fromIndex;
        block8: while (true) {
            if ((ch = buf[++i]) <= ' ') {
                continue;
            }
            if (parseContext.allowComment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            if (ch == ']') {
                if (list.size() > 0 && !parseContext.allowLastEndComma) {
                    throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                }
                parseContext.endIndex = i;
                return list;
            }
            switch (ch) {
                case '{': {
                    Object value = JSONDefaultParser.parseJSONObject(source, buf, i, new LinkedHashMap(10), parseContext);
                    list.add(value);
                    i = parseContext.endIndex;
                    break;
                }
                case '[': {
                    Object value = JSONDefaultParser.parseJSONArray(source, buf, i, new ArrayList(10), parseContext);
                    list.add(value);
                    i = parseContext.endIndex;
                    break;
                }
                case '\"': 
                case '\'': {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, buf, i, ch, null, parseContext);
                    list.add(value);
                    i = parseContext.endIndex;
                    break;
                }
                case 'n': {
                    Object value = JSONTypeDeserializer.parseNull(buf, i, parseContext);
                    i = parseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 't': {
                    Object value = JSONTypeDeserializer.parseTrue(buf, i, parseContext);
                    i = parseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 'f': {
                    Object value = JSONTypeDeserializer.parseFalse(buf, i, parseContext);
                    i = parseContext.endIndex;
                    list.add(value);
                    break;
                }
                default: {
                    char next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, ']', parseContext);
                    i = parseContext.endIndex;
                    list.add(value);
                    if ((next = buf[++i]) != ']') continue block8;
                    parseContext.endIndex = i;
                    return list;
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (parseContext.allowComment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            if (ch != ',') break;
        }
        if (ch == ']') {
            parseContext.endIndex = i;
            return list;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(CharSource source, char[] buf, int fromIndex, Map instance, JSONParseContext parseContext) throws Exception {
        char ch;
        int i = fromIndex;
        boolean empty = true;
        boolean allowomment = parseContext.allowComment;
        boolean disableCacheMapKey = parseContext.disableCacheMapKey;
        block8: while (true) {
            Object key;
            if ((ch = buf[++i]) <= ' ') {
                continue;
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            int fieldKeyFrom = i;
            if (ch == '\"') {
                key = disableCacheMapKey ? (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, buf, i, '\"', null, parseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, '\"', parseContext);
                i = parseContext.endIndex;
                empty = false;
                ++i;
            } else {
                if (ch == '}') {
                    if (!empty && !parseContext.allowLastEndComma) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return instance;
                }
                if (ch == '\'') {
                    if (!parseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                    while (i + 1 < parseContext.toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                } else if (parseContext.allowUnquotedFieldNames) {
                    while (i + 1 < parseContext.toIndex && buf[++i] != ':') {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                } else {
                    int j = i++;
                    boolean isNullKey = false;
                    key = null;
                    if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                        isNullKey = true;
                        ++i;
                    }
                    if (!isNullKey) {
                        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, j);
                        throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            if (ch != ':') throw new JSONException("Syntax error, at pos " + i + ", unexpected '" + ch + "', token ':' is expected.");
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            switch (ch) {
                case '{': {
                    Object value = JSONDefaultParser.parseJSONObject(source, buf, i, new LinkedHashMap(10), parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case '[': {
                    Object value = JSONDefaultParser.parseJSONArray(source, buf, i, new ArrayList(10), parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case '\"': 
                case '\'': {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, buf, i, ch, null, parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 'n': {
                    Object value = JSONTypeDeserializer.parseNull(buf, i, parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 't': {
                    Object value = JSONTypeDeserializer.parseTrue(buf, i, parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 'f': {
                    Object value = JSONTypeDeserializer.parseFalse(buf, i, parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                default: {
                    char next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, '}', parseContext);
                    i = parseContext.endIndex;
                    instance.put(key, value);
                    if ((next = buf[++i]) != '}') continue block8;
                    parseContext.endIndex = i;
                    return instance;
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            if (ch != ',') break;
        }
        if (ch == '}') {
            parseContext.endIndex = i;
            return instance;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
    }

    static String parseMapKeyByCache(char[] buf, int from, char endCh, JSONParseContext jsonParseContext) {
        long hashValue;
        int beginIndex;
        int i = beginIndex = from + 1;
        JSONCharArrayWriter writer = null;
        boolean escape = false;
        boolean ascii = true;
        while (true) {
            char ch;
            hashValue = 92L;
            while ((ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
                if (ch > '\u00ff') {
                    hashValue = hashValue << 16 | (long)ch;
                    ascii = false;
                    continue;
                }
                hashValue = hashValue << 8 | (long)ch;
            }
            if (ch != '\\') break;
            if (writer == null) {
                writer = JSONDefaultParser.getContextWriter(jsonParseContext);
            }
            escape = true;
            if (i > beginIndex) {
                writer.write(buf, beginIndex, i - beginIndex);
            }
            i = beginIndex = JSONDefaultParser.escapeNextChars(buf, buf[i + 1], i, writer);
        }
        jsonParseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.write(buf, beginIndex, len);
            return writer.toString();
        }
        if (ascii && len <= 8) {
            return jsonParseContext.getCacheEightCharsKey(buf, beginIndex, len, hashValue);
        }
        return jsonParseContext.getCacheKey(buf, beginIndex, len, hashValue);
    }

    static Object parseInternal(CharSource source, byte[] bytes, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        byte beginByte;
        try {
            while ((beginByte = bytes[fromIndex]) <= 32) {
                ++fromIndex;
            }
            while (bytes[toIndex - 1] <= 32) {
                --toIndex;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("Syntax error, not supported empty source");
        }
        JSONParseContext parseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.toIndex = toIndex;
        try {
            Object result;
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, fromIndex + 1, parseContext);
                beginByte = bytes[fromIndex];
            }
            block4 : switch (beginByte) {
                case 123: {
                    result = JSONDefaultParser.parseJSONObject(source, bytes, fromIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, parseContext);
                    break;
                }
                case 91: {
                    result = JSONDefaultParser.parseJSONArray(source, bytes, fromIndex, defaultValue == null ? new ArrayList() : (Collection)defaultValue, parseContext);
                    break;
                }
                case 34: 
                case 39: {
                    result = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, fromIndex, beginByte, GenericParameterizedType.StringType, parseContext);
                    break;
                }
                default: {
                    try {
                        switch (beginByte) {
                            case 116: {
                                result = JSONTypeDeserializer.parseTrue(bytes, fromIndex, parseContext);
                                break block4;
                            }
                            case 102: {
                                result = JSONTypeDeserializer.parseFalse(bytes, fromIndex, parseContext);
                                break block4;
                            }
                            case 110: {
                                result = JSONTypeDeserializer.parseNull(bytes, fromIndex, parseContext);
                                break block4;
                            }
                        }
                        byte[] numBuf = Arrays.copyOfRange(bytes, fromIndex, toIndex + 1);
                        numBuf[numBuf.length - 1] = 44;
                        result = JSONTypeDeserializer.NUMBER.deserialize(source, numBuf, 0, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)44, parseContext);
                        toIndex = numBuf.length - 1;
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable instanceof JSONException ? (JSONException)throwable : new UnsupportedOperationException("Unsupported for begin character with '" + (char)beginByte + "'");
                    }
                }
            }
            int endIndex = parseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex) {
                    char c = (char)bytes[++endIndex];
                    commentStart = c;
                    if (c <= ' ') continue;
                }
                if (commentStart == 47) {
                    endIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, endIndex + 1, parseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, bytes.length - endIndex - 1);
                String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(bytes, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSONDefaultParser.handleCatchException((Throwable)ex, bytes, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            parseContext.clear();
        }
    }

    static Collection parseJSONArray(CharSource source, byte[] bytes, int fromIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        int i = fromIndex;
        block8: while (true) {
            if ((b = bytes[++i]) <= 32) {
                continue;
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            if (b == 93) {
                if (list.size() > 0 && !jsonParseContext.allowLastEndComma) {
                    throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                }
                jsonParseContext.endIndex = i;
                return list;
            }
            switch (b) {
                case 123: {
                    Object value = JSONDefaultParser.parseJSONObject(source, bytes, i, new LinkedHashMap(), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 91: {
                    Object value = JSONDefaultParser.parseJSONArray(source, bytes, i, new ArrayList(), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 34: 
                case 39: {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, i, b, GenericParameterizedType.StringType, jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 110: {
                    Object value = JSONTypeDeserializer.parseNull(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 116: {
                    Object value = JSONTypeDeserializer.parseTrue(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 102: {
                    Object value = JSONTypeDeserializer.parseFalse(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                default: {
                    byte next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, bytes, i, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)93, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    if ((next = bytes[++i]) != 93) continue block8;
                    jsonParseContext.endIndex = i;
                    return list;
                }
            }
            while ((b = bytes[++i]) <= 32) {
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            if (b != 44) break;
        }
        if (b == 93) {
            jsonParseContext.endIndex = i;
            return list;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + b + "', expected ',' or ']'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(CharSource source, byte[] bytes, int fromIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        boolean empty = true;
        boolean allowomment = jsonParseContext.allowComment;
        boolean disableCacheMapKey = jsonParseContext.disableCacheMapKey;
        int i = fromIndex;
        block8: while (true) {
            Object key;
            if ((b = bytes[++i]) <= 32) {
                continue;
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            int fieldKeyFrom = i;
            if (b == 34) {
                key = disableCacheMapKey ? JSONTypeDeserializer.parseMapKey(bytes, i, '\"', jsonParseContext) : JSONTypeDeserializer.parseMapKeyByCache(bytes, i, '\"', jsonParseContext);
                i = jsonParseContext.endIndex;
                empty = false;
                ++i;
            } else {
                if (b == 125) {
                    if (!empty && !jsonParseContext.allowLastEndComma) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return instance;
                }
                if (b == 39) {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                    while (i + 1 < jsonParseContext.toIndex && (bytes[++i] != 39 || bytes[i - 1] == 92)) {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(bytes, fieldKeyFrom, ++i, false);
                } else if (jsonParseContext.allowUnquotedFieldNames) {
                    while (i + 1 < jsonParseContext.toIndex && bytes[++i] != 58) {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(bytes, fieldKeyFrom, i, true);
                } else {
                    int j = i++;
                    boolean isNullKey = false;
                    key = null;
                    if (b == 110 && bytes[i] == 117 && bytes[++i] == 108 && bytes[++i] == 108) {
                        isNullKey = true;
                        ++i;
                    }
                    if (!isNullKey) {
                        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, j);
                        throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
            }
            while ((b = bytes[i]) <= 32) {
                ++i;
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            if (b != 58) throw new JSONException("Syntax error, at pos " + i + ", unexpected '" + (char)b + "', colon ':' is expected.");
            while ((b = bytes[++i]) <= 32) {
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            switch (b) {
                case 123: {
                    Object value = JSONDefaultParser.parseJSONObject(source, bytes, i, new LinkedHashMap(), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 91: {
                    Object value = JSONDefaultParser.parseJSONArray(source, bytes, i, new ArrayList(), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 34: 
                case 39: {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, i, b, GenericParameterizedType.StringType, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 110: {
                    Object value = JSONTypeDeserializer.parseNull(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 116: {
                    Object value = JSONTypeDeserializer.parseTrue(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 102: {
                    Object value = JSONTypeDeserializer.parseFalse(bytes, i, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                default: {
                    byte next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, bytes, i, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)125, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    if ((next = bytes[++i]) != 125) continue block8;
                    jsonParseContext.endIndex = i;
                    return instance;
                }
            }
            while ((b = bytes[++i]) <= 32) {
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, jsonParseContext);
                b = bytes[i];
            }
            if (b != 44) break;
        }
        if (b == 125) {
            jsonParseContext.endIndex = i;
            return instance;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)b + "', expected ',' or '}'");
    }
}

