/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.compiler.MemoryClassLoader;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ByteUtils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONImplInstCreator;
import io.github.wycst.wast.json.JSONKeyValueMap;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONSecureTrustedAccess;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONUtil;
import io.github.wycst.wast.json.JSONVmOptions;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

class JSONGeneral {
    static final char[] FORMAT_OUT_SYMBOL_TABS;
    static final char[] FORMAT_OUT_SYMBOL_SPACES;
    static final int FONT_INDENT2_INT32;
    static final short FONT_INDENT2_INT16;
    static final int FOTT_INDENT2_INT32 = 589833;
    static final short FOTT_INDENT2_INT16 = 2313;
    static final long FO_INDENT4_INT64;
    static final int FO_INDENT4_INT32;
    protected static final char[] EMPTY_ARRAY;
    protected static final char[] EMPTY_OBJECT;
    protected static final int TRUE_INT;
    protected static final long TRUE_LONG;
    protected static final int ALSE_INT;
    protected static final long ALSE_LONG;
    protected static final int NULL_INT;
    protected static final long NULL_LONG;
    protected static final byte ZERO = 0;
    protected static final byte COMMA = 44;
    protected static final byte DOUBLE_QUOTATION = 34;
    protected static final byte COLON_SIGN = 58;
    protected static final byte END_ARRAY = 93;
    protected static final byte END_OBJECT = 125;
    protected static final byte WHITE_SPACE = 32;
    protected static final byte ESCAPE_BACKSLASH = 92;
    protected static final long DOUBLE_QUOTE_MASK = -2459565876494606883L;
    protected static final long SINGLE_QUOTE_MASK = -2821266740684990248L;
    static final int TYPE_BIGDECIMAL = 1;
    static final int TYPE_BIGINTEGER = 2;
    static final int TYPE_FLOAT = 3;
    static final int TYPE_DOUBLE = 4;
    static final String[] ESCAPE_VALUES;
    static final boolean[] NO_ESCAPE_FLAGS;
    static final String[] MONTH_ABBR;
    static final int[] ESCAPE_CHARS;
    static final byte[] HEX_DIGITS_REVERSE;
    static final JSONKeyValueMap<String> KEY_32_TABLE;
    static final JSONKeyValueMap<String> KEY_8_TABLE;
    protected static final int DIRECT_READ_BUFFER_SIZE = 8192;
    static final Map<String, TimeZone> GMT_TIME_ZONE_MAP;
    public static final TimeZone ZERO_TIME_ZONE;
    static final ThreadLocal<char[]> CACHED_CHARS_36;
    static final ThreadLocal<double[]> DOUBLE_ARRAY_TL;
    static final ThreadLocal<long[]> LONG_ARRAY_TL;
    static final ThreadLocal<int[]> INT_ARRAY_TL;
    static final long[] EMPTY_LONGS;
    static final int[] EMPTY_INTS;
    static final double[] EMPTY_DOUBLES;
    static final String[] EMPTY_STRINGS;
    static final Map<Class<?>, JSONImplInstCreator> DEFAULT_IMPL_INST_CREATOR_MAP;
    protected static final JSONSecureTrustedAccess JSON_SECURE_TRUSTED_ACCESS;
    static final int[] TWO_DIGITS_VALUES;
    protected static final int[] THREE_DIGITS_MUL10;
    protected static final JSONUtil JSON_UTIL;
    protected static boolean ENABLE_JIT;
    protected static final boolean SUPPORTED_INTRINSIC_CANDIDATE;
    protected static final int COLLECTION_ARRAYLIST_TYPE = 1;
    protected static final int COLLECTION_HASHSET_TYPE = 2;
    protected static final int COLLECTION_OTHER_TYPE = 3;

    JSONGeneral() {
    }

    protected static final int twoDigitsValue(int h, int l) {
        return TWO_DIGITS_VALUES[h ^ (l & 0xF) << 4];
    }

    protected static final int getFourDigitsMask(byte[] buf, int offset) {
        int value = JSONUnsafe.getInt(buf, offset);
        return (value - 0x30303030 | value + 0x46464646) & 0x80808080;
    }

    protected static final int fourDigitsValue(byte[] buf, int offset) {
        int value = JSONUnsafe.getInt(buf, offset);
        int mask = (value - 0x30303030 | value + 0x46464646) & 0x80808080;
        if (mask == 0) {
            return THREE_DIGITS_MUL10[(buf[offset] & 0xF) << 8 | (buf[offset + 1] & 0xF) << 4 | buf[offset + 2] & 0xF] + buf[offset + 3];
        }
        return -1;
    }

    static final int skipDigits(byte[] buf, int offset) {
        int mask = JSONGeneral.getFourDigitsMask(buf, offset);
        if (mask == 0 && (mask = JSONGeneral.getFourDigitsMask(buf, offset += 4)) == 0) {
            offset += 4;
            while ((mask = JSONGeneral.getFourDigitsMask(buf, offset)) == 0 && (mask = JSONGeneral.getFourDigitsMask(buf, offset += 4)) == 0) {
                offset += 4;
            }
        }
        return offset + (EnvUtils.LITTLE_ENDIAN ? Integer.numberOfTrailingZeros(mask) >> 3 : Integer.numberOfLeadingZeros(mask) >> 3);
    }

    protected static final int fourDigitsValue(int i, int j, int k, int l) {
        return THREE_DIGITS_MUL10[i << 8 | j << 4 | k] + l;
    }

    public static String toEscapeString(int ch) {
        return String.format("\\u%04x", ch);
    }

    public static final <T> void registerImplCreator(Class<? extends T> parentClass, JSONImplInstCreator<T> creator) {
        DEFAULT_IMPL_INST_CREATOR_MAP.put(parentClass, creator);
    }

    static final JSONImplInstCreator getJSONImplInstCreator(Class<?> targetClass) {
        return DEFAULT_IMPL_INST_CREATOR_MAP.get(targetClass);
    }

    static final String getCacheKey(char[] buf, int offset, int len, long hashCode, JSONKeyValueMap<String> table) {
        if (len > 32) {
            return new String(buf, offset, len);
        }
        String value = table.getValue(buf, offset, offset + len, hashCode);
        if (value == null) {
            value = new String(buf, offset, len);
            table.putValue(value, hashCode, value);
        }
        return value;
    }

    static final String getCacheKey(byte[] bytes, int offset, int len, long hashCode, JSONKeyValueMap<String> table) {
        if (len > 32) {
            return new String(bytes, offset, len);
        }
        String value = table.getValue(bytes, offset, offset + len, hashCode);
        if (value == null) {
            value = new String(bytes, offset, len);
            table.putValue(value, hashCode, value);
        }
        return value;
    }

    static final String getCacheEightCharsKey(char[] buf, int offset, int len, long hashCode, JSONKeyValueMap<String> table) {
        String value = table.getValueByHash(hashCode);
        if (value == null) {
            value = new String(buf, offset, len);
            table.putExactHashValue(hashCode, value);
        }
        return value;
    }

    static final String getCacheEightBytesKey(byte[] bytes, int offset, int len, long hashCode, JSONKeyValueMap<String> table) {
        String value = table.getValueByHash(hashCode);
        if (value == null) {
            value = new String(bytes, offset, len);
            table.putExactHashValue(hashCode, value);
        }
        return value;
    }

    protected static final int parseInt2(char[] buf, int offset) throws NumberFormatException {
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i])) {
            return JSONGeneral.twoDigitsValue(c1, c2);
        }
        throw new NumberFormatException("2-digit parsing error: \"" + new String(buf, offset, 2));
    }

    protected static final int parseInt2(byte[] buf, int offset) throws NumberFormatException {
        byte c2;
        int i = offset;
        byte c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i])) {
            return JSONGeneral.twoDigitsValue(c1, c2);
        }
        throw new NumberFormatException("2-digit parsing error: \"" + new String(buf, offset, 2));
    }

    protected static final int parseInt4(char[] buf, int offset) throws NumberFormatException {
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            return JSONGeneral.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        }
        throw new NumberFormatException("4-digit parsing error: \"" + new String(buf, offset, 4));
    }

    protected static final int parseInt4(byte[] buf, int offset) throws NumberFormatException {
        byte c4;
        byte c3;
        byte c2;
        int i = offset;
        byte c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            return JSONGeneral.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        }
        throw new NumberFormatException("4-digit parsing error: \"" + new String(buf, offset, 4));
    }

    static int parseIntWithin3(byte[] bytes, int offset, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                byte b = bytes[offset];
                if (!NumberUtils.isDigit(b)) break;
                return b & 0xF;
            }
            case 2: {
                return JSONGeneral.parseInt2(bytes, offset);
            }
            case 3: {
                int i = offset;
                byte b1 = bytes[i];
                byte b2 = bytes[++i];
                byte b3 = bytes[++i];
                if (!NumberUtils.isDigit(b1) || !NumberUtils.isDigit(b2) || !NumberUtils.isDigit(b3)) break;
                return JSONGeneral.fourDigitsValue(0, b1 & 0xF, b2 & 0xF, b3);
            }
        }
        throw new NumberFormatException(n + "-digit parsing error: \"" + new String(bytes, offset, n));
    }

    static int parseIntWithin3(char[] buf, int offset, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                char c = buf[offset];
                if (!NumberUtils.isDigit(c)) break;
                return c & 0xF;
            }
            case 2: {
                return JSONGeneral.parseInt2(buf, offset);
            }
            case 3: {
                int i = offset;
                char c1 = buf[i];
                char c2 = buf[++i];
                char c3 = buf[++i];
                if (!NumberUtils.isDigit(c1) || !NumberUtils.isDigit(c2) || !NumberUtils.isDigit(c3)) break;
                return JSONGeneral.fourDigitsValue(0, c1 & 0xF, c2 & 0xF, c3);
            }
        }
        throw new NumberFormatException(n + "-digit parsing error: \"" + new String(buf, offset, n));
    }

    static final boolean isNoneEscaped4Bytes(int value) {
        int notBackslashMask = (value ^ 0xA3A3A3A3) + 0x1010101 & 0x80808080;
        if ((notBackslashMask & value + 0x5D5D5D5D) == -2139062144) {
            return true;
        }
        return (value + 0x60606060 & (value ^ 0xDDDDDDDD) + 0x1010101 & notBackslashMask) == -2139062144;
    }

    static final boolean isNoneEscaped8Bytes(long value) {
        long notBackslashMask = (value ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L;
        if ((notBackslashMask & value + 0x5D5D5D5D5D5D5D5DL) == -9187201950435737472L) {
            return true;
        }
        return (value + 0x6060606060606060L & (value ^ 0xDDDDDDDDDDDDDDDDL) + 0x101010101010101L & notBackslashMask & 0x8080808080808080L) == -9187201950435737472L;
    }

    static final boolean isNoneEscaped16Bytes(long v1, long v2) {
        long notBackslashMask = (v1 ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & (v2 ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L;
        if ((notBackslashMask & v1 + 0x5D5D5D5D5D5D5D5DL & v2 + 0x5D5D5D5D5D5D5D5DL) == -9187201950435737472L) {
            return true;
        }
        long ge32Mask = v1 + 0x6060606060606060L & v2 + 0x6060606060606060L;
        long notQuoteMask = (v1 ^ 0xDDDDDDDDDDDDDDDDL) + 0x101010101010101L & (v2 ^ 0xDDDDDDDDDDDDDDDDL) + 0x101010101010101L;
        return (ge32Mask & notQuoteMask & notBackslashMask) == -9187201950435737472L;
    }

    static final boolean isNoneEscaped4Chars(long value) {
        long mask = value + 9214505439794855904L & (value ^ 0xFFDDFFDDFFDDFFDDL) + 0x1000100010001L & (value ^ 0xFFA3FFA3FFA3FFA3L) + 0x1000100010001L;
        return (mask & 0x8000800080008000L) == -9223231297218904064L;
    }

    protected static final int escapeNextChars(char[] buf, char next, int escapeIndex, JSONCharArrayWriter writer) {
        if (next < ESCAPE_CHARS.length) {
            int escapeChar = ESCAPE_CHARS[next];
            if (escapeChar > -1) {
                writer.write((char)escapeChar);
                return escapeIndex + 2;
            }
            char c = JSONGeneral.hex4ToChar(buf, escapeIndex + 2);
            writer.write(c);
            return escapeIndex + 6;
        }
        writer.write(next);
        return escapeIndex + 2;
    }

    static final int escapeNextBytes(byte[] bytes, byte next, int escapeIndex, JSONCharArrayWriter writer) {
        if (next == 117) {
            try {
                long c64 = JSONGeneral.hex4ToLong(bytes, escapeIndex + 2);
                if (c64 > -1L) {
                    writer.write((char)c64);
                    return escapeIndex + 6;
                }
            }
            catch (Throwable c64) {
                // empty catch block
            }
            String errorContextTextAt = JSONGeneral.createErrorContextText(bytes, escapeIndex + 1);
            throw new JSONException("Syntax error, from pos " + (escapeIndex + 1) + ", context text by '" + errorContextTextAt + "', hex unicode parse error");
        }
        writer.write((char)ESCAPE_CHARS[next & 0xFF]);
        return escapeIndex + 2;
    }

    protected static final long hex4ToLong(int i1, int i2, int i3, int i4) {
        return JSONGeneral.hexToLong(i1) << 12 | JSONGeneral.hexToLong(i2) << 8 | JSONGeneral.hexToLong(i3) << 4 | JSONGeneral.hexToLong(i4);
    }

    protected static final long hexToLong(int c) {
        return HEX_DIGITS_REVERSE[c];
    }

    protected static char hex4ToChar(char[] buf, int offset) {
        try {
            long r = JSONGeneral.hex4ToLong(buf, offset);
            if (r > -1L) {
                return (char)r;
            }
        }
        catch (Throwable r) {
            // empty catch block
        }
        String errorContextTextAt = JSONGeneral.createErrorContextText(buf, offset - 1);
        throw new JSONException("Syntax error, from pos " + offset + ", context text by '" + errorContextTextAt + "', hex unicode parse error ");
    }

    protected static final long hex8ToLong(char[] buf, int offset) {
        return JSONGeneral.hexToLong(buf[offset]) << 28 | JSONGeneral.hexToLong(buf[offset + 1]) << 24 | JSONGeneral.hexToLong(buf[offset + 2]) << 20 | JSONGeneral.hexToLong(buf[offset + 3]) << 16 | JSONGeneral.hexToLong(buf[offset + 4]) << 12 | JSONGeneral.hexToLong(buf[offset + 5]) << 8 | JSONGeneral.hexToLong(buf[offset + 6]) << 4 | JSONGeneral.hexToLong(buf[offset + 7]);
    }

    protected static final long hex8ToLong(byte[] buf, int offset) {
        return JSONGeneral.hexToLong(buf[offset]) << 28 | JSONGeneral.hexToLong(buf[offset + 1]) << 24 | JSONGeneral.hexToLong(buf[offset + 2]) << 20 | JSONGeneral.hexToLong(buf[offset + 3]) << 16 | JSONGeneral.hexToLong(buf[offset + 4]) << 12 | JSONGeneral.hexToLong(buf[offset + 5]) << 8 | JSONGeneral.hexToLong(buf[offset + 6]) << 4 | JSONGeneral.hexToLong(buf[offset + 7]);
    }

    protected static final long hex4ToLong(byte[] buf, int offset) {
        return JSONGeneral.hexToLong(buf[offset]) << 12 | JSONGeneral.hexToLong(buf[offset + 1]) << 8 | JSONGeneral.hexToLong(buf[offset + 2]) << 4 | JSONGeneral.hexToLong(buf[offset + 3]);
    }

    protected static final long hex4ToLong(char[] buf, int offset) {
        return JSONGeneral.hexToLong(buf[offset]) << 12 | JSONGeneral.hexToLong(buf[offset + 1]) << 8 | JSONGeneral.hexToLong(buf[offset + 2]) << 4 | JSONGeneral.hexToLong(buf[offset + 3]);
    }

    static final java.util.Date matchDate(char[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int month;
        int year3;
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            char ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != '.' && ch != ' ') {
                if (ch != '+' && ch != '-' && ch != 'Z') continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = JSONGeneral.parseInt2(buf, from);
                        int minute = JSONGeneral.parseInt2(buf, from + 3);
                        int second = JSONGeneral.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    int hour = JSONGeneral.parseInt2(buf, from + 8);
                    int minute = JSONGeneral.parseInt2(buf, from + 10);
                    int second = JSONGeneral.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = JSONGeneral.parseIntWithin3(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year4) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = JSONGeneral.parseIntWithin3(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year5) {
                    return null;
                }
            }
            case 28: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month2 = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month2, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year6) {
                    return null;
                }
            }
        }
        if (len > 28) {
            try {
                year3 = JSONGeneral.parseInt4(buf, from);
                month = JSONGeneral.parseInt2(buf, from + 5);
                int day = JSONGeneral.parseInt2(buf, from + 8);
                int hour = JSONGeneral.parseInt2(buf, from + 11);
                int minute = JSONGeneral.parseInt2(buf, from + 14);
                int second = JSONGeneral.parseInt2(buf, from + 17);
                int millsecond = JSONGeneral.parseIntWithin3(buf, from + 20, 3);
                return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected static java.util.Date parseDateValueOfString(char[] buf, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 1: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    int hour = JSONGeneral.parseInt2(buf, from + 12);
                    int minute = JSONGeneral.parseInt2(buf, from + 15);
                    int second = JSONGeneral.parseInt2(buf, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 7);
                    int hour = JSONGeneral.parseInt2(buf, from + 9);
                    int minute = JSONGeneral.parseInt2(buf, from + 11);
                    int second = JSONGeneral.parseInt2(buf, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 4: {
                    TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
                    long time = dateTemplate.parseTime(buf, from + 1, to - from - 2, timeZone);
                    return JSONGeneral.parseDate(time, dateCls);
                }
            }
            return JSONGeneral.matchDate(buf, from + 1, to - 1, timezone, dateCls);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String dateSource = new String(buf, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    static final java.util.Date matchDate(byte[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int month;
        int year3;
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            byte ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != 46 && ch != 32) {
                if (ch != 43 && ch != 45 && ch != 90) continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = JSONGeneral.parseInt2(buf, from);
                        int minute = JSONGeneral.parseInt2(buf, from + 3);
                        int second = JSONGeneral.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    int hour = JSONGeneral.parseInt2(buf, from + 8);
                    int minute = JSONGeneral.parseInt2(buf, from + 10);
                    int second = JSONGeneral.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = JSONGeneral.parseIntWithin3(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year4) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = JSONGeneral.parseIntWithin3(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year5) {
                    return null;
                }
            }
            case 28: {
                try {
                    year3 = JSONGeneral.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month2 = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month2, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year6) {
                    return null;
                }
            }
        }
        if (len > 28) {
            try {
                year3 = JSONGeneral.parseInt4(buf, from);
                month = JSONGeneral.parseInt2(buf, from + 5);
                int day = JSONGeneral.parseInt2(buf, from + 8);
                int hour = JSONGeneral.parseInt2(buf, from + 11);
                int minute = JSONGeneral.parseInt2(buf, from + 14);
                int second = JSONGeneral.parseInt2(buf, from + 17);
                int millsecond = JSONGeneral.parseIntWithin3(buf, from + 20, 3);
                return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Object parseDateValueOfString(byte[] bytes, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 0: {
                    return JSONGeneral.matchDate(bytes, from + 1, to - 1, timezone, dateCls);
                }
                case 1: {
                    int year = JSONGeneral.parseInt4(bytes, from + 1);
                    int month = JSONGeneral.parseInt2(bytes, from + 6);
                    int day = JSONGeneral.parseInt2(bytes, from + 9);
                    int hour = JSONGeneral.parseInt2(bytes, from + 12);
                    int minute = JSONGeneral.parseInt2(bytes, from + 15);
                    int second = JSONGeneral.parseInt2(bytes, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = JSONGeneral.parseInt4(bytes, from + 1);
                    int month = JSONGeneral.parseInt2(bytes, from + 6);
                    int day = JSONGeneral.parseInt2(bytes, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = JSONGeneral.parseInt4(bytes, from + 1);
                    int month = JSONGeneral.parseInt2(bytes, from + 5);
                    int day = JSONGeneral.parseInt2(bytes, from + 7);
                    int hour = JSONGeneral.parseInt2(bytes, from + 9);
                    int minute = JSONGeneral.parseInt2(bytes, from + 11);
                    int second = JSONGeneral.parseInt2(bytes, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
            }
            TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
            long time = dateTemplate.parseTime(bytes, from + 1, to - from - 2, timeZone);
            return JSONGeneral.parseDate(time, dateCls);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            String dateSource = new String(bytes, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    protected static final int clearCommentAndWhiteSpaces(char[] buf, int beginIndex, JSONParseContext parseContext) {
        int i = beginIndex;
        int toIndex = parseContext.toIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected '/', position " + (beginIndex - 1));
        }
        char ch = buf[beginIndex];
        if (ch == '/') {
            while (i < toIndex && buf[i] != '\n') {
                ++i;
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            }
        } else if (ch == '*') {
            char prev = '\u0000';
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((ch = buf[++i]) == '/' && prev == '*') {
                    matched = true;
                    break;
                }
                prev = ch;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + beginIndex);
        }
        return i;
    }

    protected static int clearCommentAndWhiteSpaces(byte[] bytes, int beginIndex, JSONParseContext parseContext) {
        int i = beginIndex;
        int toIndex = parseContext.toIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected '/', position " + (beginIndex - 1));
        }
        byte b = bytes[beginIndex];
        if (b == 47) {
            while (i < toIndex && bytes[i] != 10) {
                ++i;
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(bytes, i + 1, parseContext);
            }
        } else if (b == 42) {
            byte prev = 0;
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((b = bytes[++i]) == 47 && prev == 42) {
                    matched = true;
                    break;
                }
                prev = b;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(bytes, i + 1, parseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected '" + (char)b + "', position " + beginIndex);
        }
        return i;
    }

    protected static final void writeFormatOutSymbols(JSONWriter content, int level, boolean formatOut, JSONConfig jsonConfig) throws IOException {
        if (formatOut && level > -1) {
            JSONGeneral.writeFormatOutSymbols(content, level, jsonConfig);
        }
    }

    protected static final void writeFormatOutSymbols(JSONWriter content, int level, JSONConfig jsonConfig) throws IOException {
        boolean formatIndentUseSpace = jsonConfig.isFormatIndentUseSpace();
        if (formatIndentUseSpace) {
            int totalSpaceNum;
            content.writeJSONToken('\n');
            if (level == 0) {
                return;
            }
            int symbolSpaceNum = FORMAT_OUT_SYMBOL_SPACES.length;
            for (totalSpaceNum = level * jsonConfig.getFormatIndentSpaceNum(); totalSpaceNum >= symbolSpaceNum; totalSpaceNum -= symbolSpaceNum) {
                content.write(FORMAT_OUT_SYMBOL_SPACES);
            }
            while (totalSpaceNum-- > 0) {
                content.write(32);
            }
        } else {
            char[] symbol = FORMAT_OUT_SYMBOL_TABS;
            int symbolLen = 11;
            if (level < 10) {
                switch (level) {
                    case 5: {
                        content.writeMemory(FO_INDENT4_INT64, FO_INDENT4_INT32, 4);
                        content.writeMemory2(589833, (short)2313, symbol, 1);
                        break;
                    }
                    case 4: {
                        content.writeMemory(FO_INDENT4_INT64, FO_INDENT4_INT32, 4);
                        content.writeJSONToken('\t');
                        break;
                    }
                    case 3: {
                        content.writeMemory(FO_INDENT4_INT64, FO_INDENT4_INT32, 4);
                        break;
                    }
                    case 2: {
                        content.writeJSONToken('\n');
                        content.writeMemory2(589833, (short)2313, symbol, 1);
                        break;
                    }
                    case 1: {
                        content.writeMemory2(FONT_INDENT2_INT32, FONT_INDENT2_INT16, symbol, 0);
                        break;
                    }
                    case 0: {
                        content.writeJSONToken('\n');
                        break;
                    }
                    default: {
                        content.write(symbol, 0, level + 1);
                        break;
                    }
                }
            } else {
                content.write(symbol);
                int appendTabLen = level - 10;
                while (appendTabLen-- > 0) {
                    content.write(9);
                }
            }
        }
    }

    private static int getMonthAbbrIndex(String monthAbbr) {
        int len = MONTH_ABBR.length;
        for (int i = 0; i < len; ++i) {
            if (!MONTH_ABBR[i].equals(monthAbbr)) continue;
            return i;
        }
        return -1;
    }

    private static java.util.Date parseDate(int year, int month, int day, int hour, int minute, int second, int millsecond, String timeZoneId, Class<? extends java.util.Date> dateCls) {
        TimeZone timeZone = JSONGeneral.getTimeZone(timeZoneId);
        long timeInMillis = GregorianDate.getTime(year, month, day, hour, minute, second, millsecond, timeZone);
        return JSONGeneral.parseDate(timeInMillis, dateCls);
    }

    static TimeZone getTimeZone(String timeZoneId) {
        if (timeZoneId != null && timeZoneId.trim().length() > 0) {
            TimeZone timeZone;
            if (GMT_TIME_ZONE_MAP.containsKey(timeZoneId)) {
                timeZone = GMT_TIME_ZONE_MAP.get(timeZoneId);
            } else {
                timeZone = timeZoneId.startsWith("GMT") ? TimeZone.getTimeZone(timeZoneId) : TimeZone.getTimeZone("GMT" + timeZoneId);
                if (timeZone != null && timeZone.getRawOffset() != 0) {
                    GMT_TIME_ZONE_MAP.put(timeZoneId, timeZone);
                }
            }
            return timeZone;
        }
        return UnsafeHelper.getDefaultTimeZone();
    }

    protected static java.util.Date parseDate(long timeInMillis, Class<? extends java.util.Date> dateCls) {
        if (dateCls == java.util.Date.class) {
            return new java.util.Date(timeInMillis);
        }
        if (dateCls == Date.class) {
            return new Date(timeInMillis);
        }
        if (dateCls == Timestamp.class) {
            return new Timestamp(timeInMillis);
        }
        try {
            Constructor<? extends java.util.Date> constructor = dateCls.getConstructor(Long.TYPE);
            UnsafeHelper.setAccessible(constructor);
            return constructor.newInstance(timeInMillis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static final Serializable parseKeyOfMap(char[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= ' ') {
                ++from;
            }
            while (to > from && buf[to - 1] <= ' ') {
                --to;
            }
            int count = to - from;
            if (count == 4) {
                long lv = JSONUnsafe.getLong(buf, from);
                if (lv == NULL_LONG) {
                    return null;
                }
                if (lv == TRUE_LONG) {
                    return Boolean.valueOf(true);
                }
            }
            if (count == 5 && buf[from] == 'f' && JSONUnsafe.getLong(buf, from + 1) == ALSE_LONG) {
                return Boolean.valueOf(false);
            }
            boolean numberFlag = true;
            int pointFlag = 0;
            for (int i = from; i < to; ++i) {
                char c = buf[i];
                if (c == '.') {
                    ++pointFlag;
                    continue;
                }
                if (i == from && c == '-' || NumberUtils.isDigit(c)) continue;
                numberFlag = false;
                break;
            }
            String result = new String(buf, from, count);
            if (numberFlag && pointFlag <= 1) {
                if (pointFlag == 1) {
                    return Double.valueOf(Double.parseDouble(result));
                }
                long val = Long.parseLong(result);
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    return Integer.valueOf((int)val);
                }
                return Long.valueOf(val);
            }
            return result;
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }

    static final Serializable parseKeyOfMap(byte[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= 32) {
                ++from;
            }
            while (to > from && buf[to - 1] <= 32) {
                --to;
            }
            int count = to - from;
            if (count == 4) {
                int iv = JSONUnsafe.getInt(buf, from);
                if (iv == NULL_INT) {
                    return null;
                }
                if (iv == TRUE_INT) {
                    return Boolean.valueOf(true);
                }
            }
            if (count == 5 && buf[from] == 102 && JSONUnsafe.getInt(buf, from + 1) == ALSE_INT) {
                return Boolean.valueOf(false);
            }
            boolean numberFlag = true;
            int pointFlag = 0;
            for (int i = from; i < to; ++i) {
                byte c = buf[i];
                if (c == 46) {
                    ++pointFlag;
                    continue;
                }
                if (i == from && c == 45 || NumberUtils.isDigit(c)) continue;
                numberFlag = false;
                break;
            }
            String result = new String(buf, from, count);
            if (numberFlag && pointFlag <= 1) {
                if (pointFlag == 1) {
                    return Double.valueOf(Double.parseDouble(result));
                }
                long val = Long.parseLong(result);
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    return Integer.valueOf((int)val);
                }
                return Long.valueOf(val);
            }
            return result;
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }

    protected static byte[] hexString2Bytes(char[] chars, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase(chars[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static byte[] hexString2Bytes(byte[] buf, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase((char)buf[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static final int digits2Bytes(byte[] buf, int offset) {
        return JSONUnsafe.UNSAFE_ENDIAN.digits2Bytes(buf, offset);
    }

    protected static final char[] readOnceInputStream(InputStream is, int maxLen) throws IOException {
        try {
            char[] buf = new char[maxLen];
            InputStreamReader streamReader = new InputStreamReader(is);
            int len = streamReader.read(buf);
            if (len != maxLen) {
                char[] tmp = new char[len];
                System.arraycopy(buf, 0, tmp, 0, len);
                buf = tmp;
            }
            streamReader.close();
            char[] cArray = buf;
            return cArray;
        }
        catch (RuntimeException rx) {
            throw rx;
        }
        finally {
            is.close();
        }
    }

    protected static final void handleCatchException(Throwable ex, char[] buf, int toIndex) {
        if (ex instanceof IndexOutOfBoundsException) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(buf, toIndex);
            throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.", ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    protected static final void handleCatchException(Throwable ex, byte[] bytes, int toIndex) {
        if (ex instanceof IndexOutOfBoundsException) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(bytes, toIndex);
            throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.", ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    protected static final int getPatternType(String pattern) {
        if (pattern != null) {
            if (pattern.equalsIgnoreCase("yyyy-MM-dd HH:mm:ss") || pattern.equalsIgnoreCase("yyyy/MM/dd HH:mm:ss") || pattern.equalsIgnoreCase("yyyy-MM-ddTHH:mm:ss")) {
                return 1;
            }
            if (pattern.equalsIgnoreCase("yyyy-MM-dd") || pattern.equalsIgnoreCase("yyyy/MM/dd")) {
                return 2;
            }
            if (pattern.equalsIgnoreCase("yyyyMMddHHmmss")) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    protected static final int getCollectionType(Class<?> actualType) {
        if (actualType == List.class || actualType == ArrayList.class || actualType.isAssignableFrom(ArrayList.class)) {
            return 1;
        }
        if (actualType == Set.class || actualType == HashSet.class || actualType.isAssignableFrom(HashSet.class)) {
            return 2;
        }
        return 3;
    }

    protected static final Collection createCollectionInstance(Class<?> collectionCls) {
        return JSONGeneral.createCollectionInstance(collectionCls, 0);
    }

    protected static final Collection createCollectionInstance(Class<?> collectionCls, int capacityIfSupported) {
        if (collectionCls.isInterface()) {
            if (collectionCls == List.class || collectionCls == Collection.class) {
                return new ArrayList(capacityIfSupported);
            }
            if (collectionCls == Set.class) {
                return new HashSet();
            }
            throw new UnsupportedOperationException("Unsupported for collection type '" + collectionCls + "', Please specify an implementation class");
        }
        if (collectionCls == HashSet.class) {
            return new HashSet();
        }
        if (collectionCls == Vector.class) {
            return new Vector();
        }
        if (collectionCls == ArrayList.class || collectionCls == Object.class) {
            return new ArrayList(capacityIfSupported);
        }
        try {
            return (Collection)collectionCls.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("create Collection instance error, class " + collectionCls);
        }
    }

    static final Map createMapInstance(GenericParameterizedType genericParameterizedType) {
        Class<?> mapCls = genericParameterizedType.getActualType();
        Map map = JSONGeneral.createCommonMapInstance(mapCls);
        if (map != null) {
            return map;
        }
        JSONImplInstCreator implInstCreator = JSONGeneral.getJSONImplInstCreator(mapCls);
        if (implInstCreator != null) {
            return (Map)implInstCreator.create(genericParameterizedType);
        }
        try {
            return (Map)UnsafeHelper.newInstance(mapCls);
        }
        catch (Exception e) {
            throw new JSONException("create map error for " + mapCls);
        }
    }

    static final Map createMapInstance(Class<? extends Map> mapCls) {
        Map map = JSONGeneral.createCommonMapInstance(mapCls);
        if (map != null) {
            return map;
        }
        try {
            return (Map)UnsafeHelper.newInstance(mapCls);
        }
        catch (Exception e) {
            throw new JSONException("create map error for " + mapCls);
        }
    }

    static final Map createCommonMapInstance(Class<? extends Map> targetCls) {
        Class<? extends Map> mapCls = targetCls;
        if (mapCls == Map.class || mapCls == null || mapCls == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == HashMap.class) {
            return new HashMap();
        }
        if (mapCls == Hashtable.class || mapCls == Dictionary.class) {
            return new Hashtable();
        }
        if (mapCls == AbstractMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == TreeMap.class || mapCls == SortedMap.class) {
            return new TreeMap();
        }
        return null;
    }

    protected static String createErrorContextText(char[] buf, int at) {
        try {
            int len = buf.length;
            char[] text = new char[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected static String createErrorContextText(byte[] bytes, int at) {
        try {
            int len = bytes.length;
            byte[] text = new byte[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(bytes, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(bytes, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected static final JSONCharArrayWriter getContextWriter(JSONParseContext parseContext) {
        JSONCharArrayWriter jsonWriter = parseContext.getContextWriter();
        if (jsonWriter == null) {
            jsonWriter = new JSONCharArrayWriter();
            parseContext.setContextWriter(jsonWriter);
        }
        return jsonWriter;
    }

    protected static final char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    protected static final Object getStringValue(String value) {
        return JSONUnsafe.getStringValue(value.toString());
    }

    protected static final boolean supportedIntrinsicCandidateTest() {
        if (!EnvUtils.JDK_16_PLUS) {
            return false;
        }
        if (JSONVmOptions.isIntrinsicCandidateDisabled()) {
            return false;
        }
        int c1 = 0;
        int c2 = 0;
        for (int k = 0; k < 1000; ++k) {
            int cnt = 10;
            int len = 256;
            byte[] buf = new byte[256];
            Arrays.fill(buf, (byte)97);
            buf[255] = 92;
            String text = new String(buf);
            int index = 0;
            long t0 = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                index = text.indexOf(92);
            }
            long t1 = System.nanoTime();
            long indexOfUse = t1 - t0;
            buf[index] = 92;
            t0 = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                index = JSONGeneral.indexOfCharCode(buf, 92, 0, 256);
            }
            t1 = System.nanoTime();
            long localUse = t1 - t0;
            buf[index] = 92;
            if (localUse < indexOfUse << 1) {
                ++c1;
                continue;
            }
            ++c2;
        }
        return c2 > c1 << 2;
    }

    private static int indexOfCharCode(byte[] value, int ch, int fromIndex, int max) {
        byte c = (byte)ch;
        for (int i = fromIndex; i < max; ++i) {
            if (value[i] != c) continue;
            return i;
        }
        return -1;
    }

    static {
        int j;
        int i;
        String[] availableIDs;
        int i2;
        FORMAT_OUT_SYMBOL_TABS = "\n\t\t\t\t\t\t\t\t\t\t".toCharArray();
        FORMAT_OUT_SYMBOL_SPACES = new char[32];
        FONT_INDENT2_INT32 = EnvUtils.BIG_ENDIAN ? 655369 : 589834;
        FONT_INDENT2_INT16 = (short)(EnvUtils.BIG_ENDIAN ? 2569 : 2314);
        FO_INDENT4_INT64 = EnvUtils.BIG_ENDIAN ? (long)FONT_INDENT2_INT32 << 32 | 0x90009L : 0x9000900000000L | (long)FONT_INDENT2_INT32;
        FO_INDENT4_INT32 = EnvUtils.BIG_ENDIAN ? FONT_INDENT2_INT16 << 16 | 0x909 : 0x9090000 | FONT_INDENT2_INT16;
        Arrays.fill(FORMAT_OUT_SYMBOL_SPACES, ' ');
        EMPTY_ARRAY = new char[]{'[', ']'};
        EMPTY_OBJECT = new char[]{'{', '}'};
        TRUE_INT = JSONUnsafe.getInt(new byte[]{116, 114, 117, 101}, 0);
        TRUE_LONG = JSONUnsafe.getLong(new char[]{'t', 'r', 'u', 'e'}, 0);
        ALSE_INT = JSONUnsafe.getInt(new byte[]{97, 108, 115, 101}, 0);
        ALSE_LONG = JSONUnsafe.getLong(new char[]{'a', 'l', 's', 'e'}, 0);
        NULL_INT = JSONUnsafe.getInt(new byte[]{110, 117, 108, 108}, 0);
        NULL_LONG = JSONUnsafe.getLong(new char[]{'n', 'u', 'l', 'l'}, 0);
        ESCAPE_VALUES = new String[256];
        NO_ESCAPE_FLAGS = new boolean[256];
        MONTH_ABBR = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        ESCAPE_CHARS = new int[160];
        HEX_DIGITS_REVERSE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
        KEY_32_TABLE = new JSONKeyValueMap(4096);
        KEY_8_TABLE = new JSONKeyValueMap(2048);
        for (i2 = 0; i2 < 160; ++i2) {
            JSONGeneral.ESCAPE_CHARS[i2] = i2;
        }
        JSONGeneral.ESCAPE_CHARS[110] = 10;
        JSONGeneral.ESCAPE_CHARS[114] = 13;
        JSONGeneral.ESCAPE_CHARS[116] = 9;
        JSONGeneral.ESCAPE_CHARS[98] = 8;
        JSONGeneral.ESCAPE_CHARS[102] = 12;
        JSONGeneral.ESCAPE_CHARS[117] = -1;
        GMT_TIME_ZONE_MAP = new ConcurrentHashMap<String, TimeZone>();
        ZERO_TIME_ZONE = TimeZone.getTimeZone("GMT+00:00");
        CACHED_CHARS_36 = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                return new char[36];
            }
        };
        DOUBLE_ARRAY_TL = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[32];
            }
        };
        LONG_ARRAY_TL = new ThreadLocal<long[]>(){

            @Override
            protected long[] initialValue() {
                return new long[32];
            }
        };
        INT_ARRAY_TL = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[32];
            }
        };
        EMPTY_LONGS = new long[0];
        EMPTY_INTS = new int[0];
        EMPTY_DOUBLES = new double[0];
        EMPTY_STRINGS = new String[0];
        DEFAULT_IMPL_INST_CREATOR_MAP = new ConcurrentHashMap();
        JSON_SECURE_TRUSTED_ACCESS = new JSONSecureTrustedAccess();
        TWO_DIGITS_VALUES = new int[256];
        THREE_DIGITS_MUL10 = new int[2560];
        for (i2 = 0; i2 < ESCAPE_VALUES.length; ++i2) {
            switch (i2) {
                case 10: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\n";
                    break;
                }
                case 9: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\t";
                    break;
                }
                case 13: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\r";
                    break;
                }
                case 8: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\b";
                    break;
                }
                case 12: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\f";
                    break;
                }
                case 34: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\\"";
                    break;
                }
                case 92: {
                    JSONGeneral.ESCAPE_VALUES[i2] = "\\\\";
                    break;
                }
                default: {
                    if (i2 >= 32) break;
                    JSONGeneral.ESCAPE_VALUES[i2] = JSONGeneral.toEscapeString(i2);
                }
            }
            JSONGeneral.NO_ESCAPE_FLAGS[i2] = i2 >= 32 && i2 != 34 && i2 != 92;
        }
        for (String availableID : availableIDs = TimeZone.getAvailableIDs()) {
            GMT_TIME_ZONE_MAP.put(availableID, TimeZone.getTimeZone(availableID));
        }
        TimeZone timeZone = ZERO_TIME_ZONE;
        GMT_TIME_ZONE_MAP.put("GMT+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("-00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+0", timeZone);
        GMT_TIME_ZONE_MAP.put("-0", timeZone);
        try {
            timeZone = TimeZone.getTimeZone("GMT+08:00");
            GMT_TIME_ZONE_MAP.put("+08:00", timeZone);
            GMT_TIME_ZONE_MAP.put("GMT+08:00", timeZone);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                JSONGeneral.TWO_DIGITS_VALUES[(i | 0x30) ^ j << 4] = i < 10 && j < 10 ? i * 10 + j : -1;
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    JSONGeneral.THREE_DIGITS_MUL10[i << 8 | j << 4 | k] = i * 1000 + j * 100 + k * 10 - 48;
                }
            }
        }
        JSONUtil envUtil = new JSONUtil();
        boolean enableVector = false;
        boolean supportedIntrinsicCandidate = false;
        if (EnvUtils.SUPPORTED_VECTOR && !JSONVmOptions.isIncubatorVectorDisabled()) {
            try {
                MemoryClassLoader memoryClassLoader = new MemoryClassLoader();
                Class<?> utilClass = memoryClassLoader.loadClass("io.github.wycst.wast.json.JSONUtilVectorImpl", ByteUtils.hexString2Bytes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
                JSONUtil vectorUtil = (JSONUtil)UnsafeHelper.newInstance(utilClass);
                enableVector = vectorUtil.isSupportVectorWellTest();
                if (enableVector) {
                    envUtil = vectorUtil;
                }
                System.out.println("# wast_json incubator.vector enabled -> " + enableVector);
            }
            catch (Throwable throwable) {}
        } else if (EnvUtils.JDK_16_PLUS) {
            try {
                supportedIntrinsicCandidate = JSONGeneral.supportedIntrinsicCandidateTest();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        JSON_UTIL = envUtil;
        ENABLE_JIT = !"true".equalsIgnoreCase(System.getProperty("wast.json.jit.disabled"));
        SUPPORTED_INTRINSIC_CANDIDATE = supportedIntrinsicCandidate;
        JSONGeneral.registerImplCreator(EnumSet.class, new JSONImplInstCreator<EnumSet>(){

            @Override
            public EnumSet create(GenericParameterizedType<EnumSet> parameterizedType) {
                Class<?> actualType = parameterizedType.getValueType().getActualType();
                return EnumSet.noneOf(actualType);
            }
        });
        JSONGeneral.registerImplCreator(EnumMap.class, new JSONImplInstCreator<EnumMap>(){

            @Override
            public EnumMap create(GenericParameterizedType<EnumMap> parameterizedType) {
                Class<?> mapKeyClass = parameterizedType.getMapKeyClass();
                return new EnumMap(mapKeyClass);
            }
        });
    }
}

