/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONNodeCollector;
import io.github.wycst.wast.json.JSONNodeContext;
import io.github.wycst.wast.json.JSONNodePath;
import io.github.wycst.wast.json.JSONNodePathCollector;
import io.github.wycst.wast.json.JSONNodePathCtx;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.UTF8CharSource;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JSONNode
implements Comparable<JSONNode> {
    final JSONNode root;
    final JSONNodeContext parseContext;
    JSONNode parent;
    final int beginIndex;
    int endIndex;
    String text;
    int offset;
    boolean completed;
    private Serializable path;
    Map<Serializable, JSONNode> fieldValues;
    JSONNode[] elementValues;
    int elementSize;
    int type;
    static final int OBJECT = 1;
    static final int ARRAY = 2;
    static final int STRING = 3;
    static final int NUMBER = 4;
    static final int BOOLEAN = 5;
    static final int NULL = 6;
    static final int EXPAND = 7;
    static final String[] TYPE_DESCS = new String[]{"", "object", "array", "string", "number", "boolean", "null", "expand"};
    boolean array;
    boolean leaf;
    Serializable value;
    Object any;
    boolean changed;
    JSONNodePathCtx collectCtx;

    static final void addFieldValue(Map<Serializable, JSONNode> fieldValues, Serializable key, JSONNode node) {
        node.path = key;
        fieldValues.put(key, node);
    }

    final String getParentAbsolutePath() {
        if (this.parent == this.root) {
            return "";
        }
        return this.parent == null ? "" : this.parent.getAbsolutePath();
    }

    public final Serializable getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (this == this.root) {
            return String.valueOf(this.path == null ? "" : this.path);
        }
        if (!this.changed || !this.parent.isArray()) {
            return this.getParentAbsolutePath() + '/' + (this.path == null ? "" : this.path);
        }
        return this.getParentAbsolutePath() + '/' + CollectionUtils.indexOf(this.parent.elementValues, this);
    }

    public final String toString() {
        int hv = this.hashCode();
        String absolutePath = this.getAbsolutePath();
        if (this.leaf) {
            if (this.type == 3) {
                return "JNode@" + Integer.toHexString(hv) + "{'" + absolutePath + "', " + TYPE_DESCS[this.type] + ", '" + this.value + "'}";
            }
            return "JNode@" + Integer.toHexString(hv) + "{'" + absolutePath + "', " + TYPE_DESCS[this.type] + ", " + this.value + "}";
        }
        return "JNode@" + Integer.toHexString(hv) + "{'" + absolutePath + "', " + TYPE_DESCS[this.type] + "}";
    }

    JSONNode(RootContext rootContext, JSONNodeContext parseContext) {
        this.parseContext = parseContext;
        this.root = this;
        this.beginIndex = rootContext.beginIndex;
        this.offset = rootContext.beginIndex;
        this.endIndex = rootContext.endIndex;
        this.type = rootContext.type;
        this.value = rootContext.leafValue;
        this.leaf = this.type > 2;
        this.array = this.type == 2;
        this.path = "/";
    }

    JSONNode(Map<Serializable, JSONNode> fieldValues, int beginIndex, int endIndex, JSONNodeContext parseContext, JSONNode root) {
        this.fieldValues = fieldValues;
        this.completed = true;
        this.array = false;
        this.leaf = false;
        this.type = 1;
        this.parseContext = parseContext;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.root = root == null ? this : root;
        this.path = "/";
    }

    JSONNode(Serializable value, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
        this.value = value;
        this.completed = true;
        this.array = false;
        this.leaf = true;
        this.parseContext = parseContext;
        this.root = rootNode;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    JSONNode(Serializable value, JSONNode rootNode) {
        this.value = value;
        this.completed = true;
        this.array = false;
        this.leaf = true;
        this.parseContext = null;
        this.root = rootNode;
        this.beginIndex = -1;
        this.endIndex = -1;
        this.type = 7;
    }

    JSONNode(int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
        this.offset = this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.parseContext = parseContext;
        this.root = rootNode == null ? this : rootNode;
        this.type = type;
        this.leaf = type > 2;
        this.array = type == 2;
        this.path = "/";
    }

    JSONNode(int beginIndex, JSONNodeContext parseContext, JSONNode root) {
        this.beginIndex = beginIndex;
        this.parseContext = parseContext;
        this.root = root;
        this.array = true;
        this.completed = true;
        this.leaf = false;
        this.type = 2;
    }

    static final RootContext buildRootContext(char[] buf, int beginIndex, int endIndex) {
        int type;
        char start = '\u0000';
        char end = '\u0000';
        while ((start = buf[beginIndex]) <= ' ') {
            ++beginIndex;
        }
        while ((end = buf[endIndex - 1]) <= ' ') {
            --endIndex;
        }
        Boolean leafValue = null;
        int len = endIndex - beginIndex;
        switch (start) {
            case '{': {
                if (end == '}') {
                    type = 1;
                    break;
                }
                throw new JSONException("Syntax error, expected '}' but " + end + ", input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case '[': {
                if (end == ']') {
                    type = 2;
                    break;
                }
                throw new JSONException("Syntax error, expected ']' but " + end + ", input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case '\"': 
            case '\'': {
                if (end == start) {
                    type = 3;
                    break;
                }
                throw new JSONException("Syntax error, expected '" + start + "' but '" + end + "', input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 't': {
                long unsafeValue;
                if (len == 4 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex)) == JSONGeneral.TRUE_LONG) {
                    type = 5;
                    leafValue = true;
                    break;
                }
                throw new JSONException("Syntax error, expected 'true' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 'f': {
                long unsafeValue;
                if (len == 5 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex + 1)) == JSONGeneral.ALSE_LONG) {
                    type = 5;
                    leafValue = false;
                    break;
                }
                throw new JSONException("Syntax error, expected 'false' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 'n': {
                long unsafeValue;
                if (len == 4 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex)) == JSONGeneral.NULL_LONG) {
                    type = 6;
                    leafValue = null;
                    break;
                }
                throw new JSONException("Syntax error, expected 'null' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            default: {
                type = 4;
            }
        }
        return new RootContext(beginIndex, endIndex, type, leafValue);
    }

    static final RootContext buildRootContext(byte[] buf, int beginIndex, int endIndex) {
        int type;
        byte start = 0;
        byte end = 0;
        while ((start = buf[beginIndex]) <= 32) {
            ++beginIndex;
        }
        while ((end = buf[endIndex - 1]) <= 32) {
            --endIndex;
        }
        Boolean leafValue = null;
        int len = endIndex - beginIndex;
        switch (start) {
            case 123: {
                if (end == 125) {
                    type = 1;
                    break;
                }
                throw new JSONException("Syntax error, expected '}' but " + (char)end + ", input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 91: {
                if (end == 93) {
                    type = 2;
                    break;
                }
                throw new JSONException("Syntax error, expected ']' but " + (char)end + ", input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 34: 
            case 39: {
                if (end == start) {
                    type = 3;
                    break;
                }
                throw new JSONException("Syntax error, expected '" + (char)start + "' but '" + (char)end + "', input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 116: {
                int unsafeValue;
                if (len == 4 && (unsafeValue = JSONUnsafe.getInt(buf, beginIndex)) == JSONGeneral.TRUE_INT) {
                    type = 5;
                    leafValue = true;
                    break;
                }
                throw new JSONException("Syntax error, expected 'true' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 102: {
                int unsafeValue;
                if (len == 5 && (unsafeValue = JSONUnsafe.getInt(buf, beginIndex + 1)) == JSONGeneral.ALSE_INT) {
                    type = 5;
                    leafValue = false;
                    break;
                }
                throw new JSONException("Syntax error, expected 'false' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            case 110: {
                int unsafeValue;
                if (len == 4 && (unsafeValue = JSONUnsafe.getInt(buf, beginIndex)) == JSONGeneral.NULL_INT) {
                    type = 6;
                    leafValue = null;
                    break;
                }
                throw new JSONException("Syntax error, expected 'null' but '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
            }
            default: {
                type = 4;
            }
        }
        return new RootContext(beginIndex, endIndex, type, leafValue);
    }

    private void updateArray(JSONNode[] elementValues, int elementSize) {
        this.elementValues = elementValues;
        this.elementSize = elementSize;
    }

    public static final JSONNode parse(String source, ReadOption ... readOptions) {
        return JSONNode.parseInternal(source, null, readOptions);
    }

    public static final JSONNode parse(String source, String path, ReadOption ... readOptions) {
        return JSONNode.parseInternal(source, path, readOptions);
    }

    public static final JSONNode parse(byte[] bytes, ReadOption ... readOptions) {
        return JSONNode.parse(bytes, null, readOptions);
    }

    public static final JSONNode parse(InputStream is, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            try {
                return JSONNode.parse(IOUtils.readBytes(is), null, readOptions);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return JSONNode.parse(StringUtils.fromStream(is), null, readOptions);
    }

    public static final JSONNode parse(byte[] bytes, String path, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        try {
            JSONNodeContext parseContext = new JSONNodeContext();
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.toIndex = bytes.length;
            B root = EnvUtils.JDK_9_PLUS ? (!EnvUtils.hasNegatives(bytes, 0, bytes.length) ? new B((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, parseContext) : new B((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, 0, bytes.length, parseContext)) : new B(null, bytes, 0, bytes.length, parseContext);
            if (path == null) {
                return root;
            }
            return root.get(path);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
    }

    static final JSONNode parseInternal(String source, String path, ReadOption ... readOptions) {
        if (source == null) {
            return null;
        }
        source = source.trim();
        try {
            JSONNode root;
            JSONNodeContext parseContext = new JSONNodeContext();
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.toIndex = source.length();
            if (EnvUtils.JDK_9_PLUS) {
                byte[] bytes = (byte[])JSONUnsafe.getStringValue(source);
                if (bytes.length == source.length()) {
                    root = new B((CharSource)AsciiStringSource.of(source), bytes, 0, bytes.length, parseContext);
                } else {
                    char[] chars = source.toCharArray();
                    root = new C((CharSource)UTF16ByteArraySource.of(source), chars, 0, chars.length, parseContext);
                }
            } else {
                char[] chars = (char[])JSONUnsafe.getStringValue(source);
                root = new C(null, chars, 0, chars.length, parseContext);
            }
            if (path == null) {
                return root;
            }
            return root.get(path);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
    }

    public static final JSONNode from(String json, String path, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json.toString());
            if (bytes.length == json.length()) {
                return JSONNode.parseInternal((CharSource)AsciiStringSource.of(json), bytes, JSONNodePath.parse(path), readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONNode.parseInternal((CharSource)UTF16ByteArraySource.of(json), chars, JSONNodePath.parse(path), readOptions);
        }
        return JSONNode.parseInternal(null, (char[])JSONUnsafe.getStringValue(json.toString()), JSONNodePath.parse(path), readOptions);
    }

    public static final JSONNode from(byte[] bytes, String path, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(bytes, 0, bytes.length)) {
                return JSONNode.parseInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, JSONNodePath.parse(path), readOptions);
            }
            return JSONNode.parseInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, JSONNodePath.parse(path), readOptions);
        }
        return JSONNode.parseInternal(null, bytes, JSONNodePath.parse(path), readOptions);
    }

    public static final <T> T from(String source, String path, Class<T> valueClass, ReadOption ... readOptions) {
        return JSONNode.from(source, path, readOptions).getValue(valueClass);
    }

    static final JSONNode parseInternal(CharSource charSource, char[] buf, JSONNodePath path, ReadOption ... readOptions) {
        int toIndex = buf.length;
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.toIndex = toIndex;
        if (path == null) {
            return new C(charSource, buf, 0, toIndex, parseContext);
        }
        return JSONNode.parseNode(charSource, buf, path, parseContext);
    }

    static final JSONNode parseInternal(CharSource charSource, byte[] buf, JSONNodePath path, ReadOption ... readOptions) {
        int toIndex = buf.length;
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.toIndex = toIndex;
        if (path == null) {
            return new B(charSource, buf, 0, toIndex, parseContext);
        }
        return JSONNode.parseNode(charSource, buf, path, parseContext);
    }

    public static final List<JSONNode> extract(String json, String xpath, ReadOption ... readOptions) {
        return JSONNode.extract(json, JSONNodePath.parse(xpath), JSONNodeCollector.DEFAULT, readOptions);
    }

    public static final List<JSONNode> extract(String json, JSONNodePath path, ReadOption ... readOptions) {
        return JSONNode.extract(json, path, JSONNodeCollector.DEFAULT, readOptions);
    }

    public static final <T> List<T> extract(String json, JSONNodePath path, JSONNodeCollector<T> nodeCollector, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json.toString());
            if (bytes.length == json.length()) {
                return JSONNode.extractInternal((CharSource)AsciiStringSource.of(json), bytes, path, nodeCollector, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONNode.extractInternal((CharSource)UTF16ByteArraySource.of(json), chars, path, nodeCollector, readOptions);
        }
        return JSONNode.extractInternal(null, (char[])JSONUnsafe.getStringValue(json.toString()), path, nodeCollector, readOptions);
    }

    public static final <T> List<T> extract(byte[] bytes, JSONNodePath path, JSONNodeCollector<T> nodeCollector, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(bytes, 0, bytes.length)) {
                return JSONNode.extractInternal((CharSource)AsciiStringSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, path, nodeCollector, readOptions);
            }
            return JSONNode.extractInternal((CharSource)UTF8CharSource.of(JSONUnsafe.createAsciiString(bytes)), bytes, path, nodeCollector, readOptions);
        }
        return JSONNode.extractInternal(null, bytes, path, nodeCollector, readOptions);
    }

    static List extractInternal(CharSource charSource, char[] buf, JSONNodePath path, JSONNodeCollector nodeCollector, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.toIndex = buf.length;
        parseContext.enableExtract(nodeCollector.self());
        JSONNode.parseNode(charSource, buf, path, parseContext);
        return parseContext.extractValues;
    }

    static List extractInternal(CharSource charSource, byte[] buf, JSONNodePath path, JSONNodeCollector nodeCollector, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.toIndex = buf.length;
        parseContext.enableExtract(nodeCollector.self());
        JSONNode.parseNode(charSource, buf, path, parseContext);
        return parseContext.extractValues;
    }

    private static JSONNode parseNode(CharSource charSource, char[] buf, JSONNodePath path, JSONNodeContext parseContext) {
        int toIndex = buf.length;
        try {
            int endIndex;
            JSONNode result;
            int fromIndex;
            char beginChar = '\u0000';
            for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
            }
            while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
                --toIndex;
            }
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONGeneral.clearCommentAndWhiteSpaces(buf, fromIndex + 1, (JSONParseContext)parseContext);
                beginChar = buf[fromIndex];
            }
            switch (beginChar) {
                case '{': {
                    result = JSONNode.parseObjectPathNode(charSource, buf, fromIndex, toIndex, path, path.head, true, parseContext);
                    break;
                }
                case '[': {
                    result = JSONNode.parseArrayPathNode(charSource, buf, fromIndex, toIndex, path, path.head, true, parseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    result = JSONNode.parseStringPathNode(charSource, buf, fromIndex, toIndex, beginChar, false, parseContext, null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported for begin character with '" + beginChar + "'");
                }
            }
            if (parseContext.validate && (endIndex = parseContext.endIndex) != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                throw new JSONException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at pos " + endIndex);
            }
            return result;
        }
        catch (Exception ex) {
            JSONGeneral.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
    }

    private static JSONNode parseNode(CharSource charSource, byte[] buf, JSONNodePath path, JSONNodeContext parseContext) {
        int toIndex = buf.length;
        try {
            int endIndex;
            JSONNode result;
            int fromIndex;
            byte beginByte = 0;
            for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
            }
            while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
                --toIndex;
            }
            if (parseContext.allowComment && beginByte == 47) {
                fromIndex = JSONGeneral.clearCommentAndWhiteSpaces(buf, fromIndex + 1, (JSONParseContext)parseContext);
                beginByte = buf[fromIndex];
            }
            switch (beginByte) {
                case 123: {
                    result = JSONNode.parseObjectPathNode(charSource, buf, fromIndex, toIndex, path, path.head, true, parseContext);
                    break;
                }
                case 91: {
                    result = JSONNode.parseArrayPathNode(charSource, buf, fromIndex, toIndex, path, path.head, true, parseContext);
                    break;
                }
                case 34: 
                case 39: {
                    result = JSONNode.parseStringPathNode(charSource, buf, fromIndex, beginByte, false, parseContext, null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported for begin character with '" + beginByte + "'");
                }
            }
            if (parseContext.validate && (endIndex = parseContext.endIndex) != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                throw new JSONException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at pos " + endIndex);
            }
            return result;
        }
        catch (Exception ex) {
            JSONGeneral.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
    }

    private static JSONNode parseObjectPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONNodePath nodePath, JSONNodePathCollector pathCollector, boolean returnIfMatched, JSONNodeContext parseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean allowComment = parseContext.allowComment;
        boolean extract = parseContext.extract;
        boolean isLastPathLevel = pathCollector.next == null;
        for (int i = beginIndex; i < toIndex; ++i) {
            String key;
            char ch;
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            if (ch == '\"') {
                key = JSONDefaultParser.parseMapKeyByCache(buf, i, '\"', parseContext);
                i = parseContext.endIndex + 1;
            } else {
                if (ch == '}') {
                    parseContext.endIndex = i;
                    return null;
                }
                if (ch == '\'') {
                    key = JSONDefaultParser.parseMapKeyByCache(buf, i, '\'', parseContext);
                    i = parseContext.endIndex + 1;
                } else {
                    int begin = i;
                    while (i + 1 < toIndex && buf[++i] != ':') {
                    }
                    key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            if (ch == ':') {
                boolean isClosingSymbol;
                JSONNode node;
                boolean returnValueIfMatched;
                int mr = pathCollector.matchedObjectField(key);
                boolean matched = mr > -1;
                boolean bl = returnValueIfMatched = mr == 1;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                    ch = buf[i];
                }
                boolean isSkipValue = !matched;
                switch (ch) {
                    case '{': {
                        if (isSkipValue || isLastPathLevel) {
                            JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                            node = isSkipValue ? null : new C(charSource, buf, i, parseContext.endIndex + 1, 1, parseContext, null);
                            break;
                        }
                        node = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                        break;
                    }
                    case '[': {
                        if (isSkipValue || isLastPathLevel) {
                            JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                            node = isSkipValue ? null : new C(charSource, buf, i, parseContext.endIndex + 1, 2, parseContext, null);
                            break;
                        }
                        node = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        node = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, ch, isSkipValue, parseContext, null);
                        break;
                    }
                    case 'n': {
                        node = JSONNode.parseNullPathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    case 't': {
                        node = JSONNode.parseBoolTruePathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    case 'f': {
                        node = JSONNode.parseBoolFalsePathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    default: {
                        node = JSONNode.parseNumberPathNode(charSource, buf, i, '}', isSkipValue, parseContext, null);
                    }
                }
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                    ch = buf[i];
                }
                parseContext.endIndex = i;
                boolean skipNext = false;
                if (matched) {
                    if (extract) {
                        if (isLastPathLevel) {
                            parseContext.extractValue(node);
                        }
                        if (returnValueIfMatched) {
                            if (returnIfMatched) {
                                return null;
                            }
                            skipNext = true;
                        }
                    } else {
                        return node;
                    }
                }
                boolean bl2 = isClosingSymbol = ch == '}';
                if (ch == ',' || isClosingSymbol) {
                    if (isClosingSymbol) {
                        return null;
                    }
                    if (!skipNext) continue;
                    JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                    return null;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
        }
        throw new JSONException("Syntax error, the closing symbol '}' is not found ");
    }

    private static JSONNode parseObjectPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONNodePath nodePath, JSONNodePathCollector pathCollector, boolean returnIfMatched, JSONNodeContext parseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean allowComment = parseContext.allowComment;
        boolean extract = parseContext.extract;
        boolean isLastPathLevel = pathCollector.next == null;
        for (int i = beginIndex; i < toIndex; ++i) {
            String key;
            byte b;
            while ((b = buf[i]) <= 32) {
                ++i;
            }
            if (allowComment && b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                b = buf[i];
            }
            if (b == 34) {
                key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, '\"', parseContext);
                i = parseContext.endIndex + 1;
            } else {
                if (b == 125) {
                    parseContext.endIndex = i;
                    return null;
                }
                if (b == 39) {
                    key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, '\'', parseContext);
                    i = parseContext.endIndex + 1;
                } else {
                    int begin = i;
                    while (i + 1 < toIndex && buf[++i] != 58) {
                    }
                    key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                }
            }
            while ((b = buf[i]) <= 32) {
                ++i;
            }
            if (allowComment && b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                b = buf[i];
            }
            if (b == 58) {
                boolean isClosingSymbol;
                JSONNode node;
                boolean returnValueIfMatched;
                int mr = pathCollector.matchedObjectField(key);
                boolean matched = mr > -1;
                boolean bl = returnValueIfMatched = mr == 1;
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                    b = buf[i];
                }
                boolean isSkipValue = !matched;
                switch (b) {
                    case 123: {
                        if (isSkipValue || isLastPathLevel) {
                            JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                            node = isSkipValue ? null : new B(charSource, buf, i, parseContext.endIndex + 1, 1, parseContext, null);
                            break;
                        }
                        node = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                        break;
                    }
                    case 91: {
                        if (isSkipValue || isLastPathLevel) {
                            JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                            node = isSkipValue ? null : new B(charSource, buf, i, parseContext.endIndex + 1, 2, parseContext, null);
                            break;
                        }
                        node = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                        break;
                    }
                    case 34: 
                    case 39: {
                        node = JSONNode.parseStringPathNode(charSource, buf, i, b, isSkipValue, parseContext, null);
                        break;
                    }
                    case 110: {
                        node = JSONNode.parseNullPathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    case 116: {
                        node = JSONNode.parseBoolTruePathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    case 102: {
                        node = JSONNode.parseBoolFalsePathNode(charSource, buf, i, parseContext, null);
                        break;
                    }
                    default: {
                        node = JSONNode.parseNumberPathNode(charSource, buf, i, (byte)125, isSkipValue, parseContext, null);
                    }
                }
                i = parseContext.endIndex;
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                    b = buf[i];
                }
                parseContext.endIndex = i;
                boolean skipNext = false;
                if (matched) {
                    if (extract) {
                        if (isLastPathLevel) {
                            parseContext.extractValue(node);
                        }
                        if (returnValueIfMatched) {
                            if (returnIfMatched) {
                                return null;
                            }
                            skipNext = true;
                        }
                    } else {
                        return node;
                    }
                }
                boolean bl2 = isClosingSymbol = b == 125;
                if (b == 44 || isClosingSymbol) {
                    if (isClosingSymbol) {
                        return null;
                    }
                    if (!skipNext) continue;
                    JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                    return null;
                }
                throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
            }
            throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
        }
        throw new JSONException("Syntax error, the closing symbol '}' is not found ");
    }

    private static JSONNode parseArrayPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONNodePath nodePath, JSONNodePathCollector pathCollector, boolean returnIfMatched, JSONNodeContext parseContext) throws Exception {
        boolean isLastPathLevel;
        int beginIndex = fromIndex + 1;
        boolean allowComment = parseContext.allowComment;
        boolean extract = parseContext.extract;
        int elementIndex = 0;
        int size = -1;
        boolean bl = isLastPathLevel = pathCollector.next == null;
        if (pathCollector.preparedSize()) {
            JSONTypeDeserializer.COLLECTION.skip(charSource, buf, fromIndex, (JSONParseContext)parseContext);
            size = parseContext.elementSize;
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            JSONNode node;
            char ch;
            boolean returnValueIfMatched;
            int mr;
            boolean matched = (mr = pathCollector.matchedArrayIndex(elementIndex++, size)) > -1;
            boolean bl2 = returnValueIfMatched = mr == 1;
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            if (ch == ']') {
                parseContext.endIndex = i;
                return null;
            }
            boolean isSkipValue = !matched;
            switch (ch) {
                case '{': {
                    if (isSkipValue || isLastPathLevel) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                        node = isSkipValue ? null : new C(charSource, buf, i, parseContext.endIndex + 1, 1, parseContext, null);
                        break;
                    }
                    node = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                    break;
                }
                case '[': {
                    if (isSkipValue || isLastPathLevel) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                        node = isSkipValue ? null : new C(charSource, buf, i, parseContext.endIndex + 1, 2, parseContext, null);
                        break;
                    }
                    node = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    node = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, ch, isSkipValue, parseContext, null);
                    break;
                }
                case 'n': {
                    node = JSONNode.parseNullPathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                case 't': {
                    node = JSONNode.parseBoolTruePathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                case 'f': {
                    node = JSONNode.parseBoolFalsePathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                default: {
                    node = JSONNode.parseNumberPathNode(charSource, buf, i, ']', isSkipValue, parseContext, null);
                }
            }
            i = parseContext.endIndex;
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            parseContext.endIndex = i;
            boolean skipNext = false;
            if (matched) {
                if (extract) {
                    if (isLastPathLevel) {
                        parseContext.extractValue(node);
                    }
                    if (returnValueIfMatched) {
                        if (returnIfMatched) {
                            return null;
                        }
                        skipNext = true;
                    }
                } else {
                    return node;
                }
            }
            boolean bl3 = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                if (isEnd) {
                    return null;
                }
                if (!skipNext) continue;
                JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                return null;
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", missing ',' or '}'");
        }
        throw new JSONException("Syntax error, the closing symbol ']' is not found ");
    }

    private static JSONNode parseArrayPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONNodePath nodePath, JSONNodePathCollector pathCollector, boolean returnIfMatched, JSONNodeContext parseContext) throws Exception {
        boolean isLastPathLevel;
        int beginIndex = fromIndex + 1;
        boolean allowComment = parseContext.allowComment;
        boolean extract = parseContext.extract;
        int elementIndex = 0;
        int size = -1;
        boolean bl = isLastPathLevel = pathCollector.next == null;
        if (pathCollector.preparedSize()) {
            JSONTypeDeserializer.COLLECTION.skip(charSource, buf, fromIndex, (JSONParseContext)parseContext);
            size = parseContext.elementSize;
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            JSONNode node;
            byte ch;
            boolean returnValueIfMatched;
            int mr;
            boolean matched = (mr = pathCollector.matchedArrayIndex(elementIndex++, size)) > -1;
            boolean bl2 = returnValueIfMatched = mr == 1;
            while ((ch = buf[i]) <= 32) {
                ++i;
            }
            if (allowComment && ch == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            if (ch == 93) {
                parseContext.endIndex = i;
                return null;
            }
            boolean isSkipValue = !matched;
            switch (ch) {
                case 123: {
                    if (isSkipValue || isLastPathLevel) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, (JSONParseContext)parseContext);
                        node = isSkipValue ? null : new B(charSource, buf, i, parseContext.endIndex + 1, 1, parseContext, null);
                        break;
                    }
                    node = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                    break;
                }
                case 91: {
                    if (isSkipValue || isLastPathLevel) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                        node = isSkipValue ? null : new B(charSource, buf, i, parseContext.endIndex + 1, 2, parseContext, null);
                        break;
                    }
                    node = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, nodePath, pathCollector.next, returnIfMatched && returnValueIfMatched, parseContext);
                    break;
                }
                case 34: 
                case 39: {
                    node = JSONNode.parseStringPathNode(charSource, buf, i, ch, isSkipValue, parseContext, null);
                    break;
                }
                case 110: {
                    node = JSONNode.parseNullPathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                case 116: {
                    node = JSONNode.parseBoolTruePathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                case 102: {
                    node = JSONNode.parseBoolFalsePathNode(charSource, buf, i, parseContext, null);
                    break;
                }
                default: {
                    node = JSONNode.parseNumberPathNode(charSource, buf, i, (byte)93, isSkipValue, parseContext, null);
                }
            }
            i = parseContext.endIndex;
            while (i + 1 < toIndex && (ch = buf[++i]) <= 32) {
            }
            if (allowComment && ch == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)parseContext);
                ch = buf[i];
            }
            parseContext.endIndex = i;
            boolean skipNext = false;
            if (matched) {
                if (extract) {
                    if (isLastPathLevel) {
                        parseContext.extractValue(node);
                    }
                    if (returnValueIfMatched) {
                        if (returnIfMatched) {
                            return null;
                        }
                        skipNext = true;
                    }
                } else {
                    return node;
                }
            }
            boolean bl3 = isEnd = ch == 93;
            if (ch == 44 || isEnd) {
                if (isEnd) {
                    return null;
                }
                if (!skipNext) continue;
                JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, (JSONParseContext)parseContext);
                return null;
            }
            throw new JSONException("Syntax error, unexpected '" + (char)ch + "', position " + i + ", missing ',' or '}'");
        }
        throw new JSONException("Syntax error, the closing symbol ']' is not found ");
    }

    private static JSONNode parseStringPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, boolean skipValue, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, endToken, (JSONParseContext)parseContext);
            return null;
        }
        String value = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, endToken, GenericParameterizedType.StringType, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new C(charSource, (Serializable)((Object)value), buf, fromIndex, endIndex + 1, 3, parseContext, rootNode);
    }

    private static JSONNode parseStringPathNode(CharSource charSource, byte[] buf, int fromIndex, byte endToken, boolean skipValue, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, endToken, (JSONParseContext)parseContext);
            return null;
        }
        String value = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, endToken, GenericParameterizedType.StringType, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new B(charSource, (Serializable)((Object)value), buf, fromIndex, endIndex + 1, 3, parseContext, rootNode);
    }

    static JSONNode parseNullPathNode(CharSource charSource, char[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseNull(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new C(charSource, null, buf, fromIndex, endIndex + 1, 6, parseContext, rootNode);
    }

    static JSONNode parseNullPathNode(CharSource charSource, byte[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseNull(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new B(charSource, null, buf, fromIndex, endIndex + 1, 6, parseContext, rootNode);
    }

    static JSONNode parseBoolTruePathNode(CharSource charSource, char[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseTrue(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new C(charSource, Boolean.valueOf(true), buf, fromIndex, endIndex + 1, 5, parseContext, rootNode);
    }

    static JSONNode parseBoolTruePathNode(CharSource charSource, byte[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseTrue(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new B(charSource, Boolean.valueOf(true), buf, fromIndex, endIndex + 1, 5, parseContext, rootNode);
    }

    static JSONNode parseBoolFalsePathNode(CharSource charSource, char[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseFalse(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new C(charSource, Boolean.valueOf(false), buf, fromIndex, endIndex + 1, 5, parseContext, rootNode);
    }

    static JSONNode parseBoolFalsePathNode(CharSource charSource, byte[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseFalse(buf, fromIndex, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new B(charSource, Boolean.valueOf(false), buf, fromIndex, endIndex + 1, 5, parseContext, rootNode);
    }

    static JSONNode parseNumberPathNode(CharSource charSource, char[] buf, int fromIndex, char endToken, boolean skipValue, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, (JSONParseContext)parseContext);
            return null;
        }
        Number value = (Number)JSONTypeDeserializer.NUMBER.deserialize(charSource, buf, fromIndex, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, endToken, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new C(charSource, value, buf, fromIndex, endIndex + 1, 4, parseContext, rootNode);
    }

    static JSONNode parseNumberPathNode(CharSource charSource, byte[] buf, int fromIndex, byte endToken, boolean skipValue, JSONNodeContext parseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, (JSONParseContext)parseContext);
            return null;
        }
        Number value = (Number)JSONTypeDeserializer.NUMBER.deserialize(charSource, buf, fromIndex, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, endToken, (JSONParseContext)parseContext);
        int endIndex = parseContext.endIndex;
        return new B(charSource, value, buf, fromIndex, endIndex + 1, 4, parseContext, rootNode);
    }

    public final JSONNode root() {
        return this.root;
    }

    public final void loadAll() {
        block4: {
            block3: {
                if (!this.completed) {
                    this.completeNode(false, false);
                }
                if (!this.array) break block3;
                for (int i = 0; i < this.elementSize; ++i) {
                    this.elementValues[i].loadAll();
                }
                break block4;
            }
            if (this.type != 1) break block4;
            for (JSONNode node : this.fieldValues.values()) {
                node.loadAll();
            }
        }
    }

    public static <T> T first(String source, String xpath, Class<T> targetClass, ReadOption ... options) {
        List<JSONNode> nodes = JSONNode.collect(source, xpath, options);
        return nodes.get(0).getValue(targetClass);
    }

    public static <T> T firstIfEmpty(String source, String xpath, Class<T> targetClass, T defaultVal, ReadOption ... options) {
        List<JSONNode> nodes = JSONNode.collect(source, xpath, options);
        if (nodes.size() > 0) {
            return nodes.get(0).getValue(targetClass);
        }
        return defaultVal;
    }

    public static <T> T last(String source, String xpath, Class<T> targetClass, ReadOption ... options) {
        List<JSONNode> nodes = JSONNode.collect(source, xpath, options);
        return nodes.get(nodes.size() - 1).getValue(targetClass);
    }

    public static final List<JSONNode> collect(String json, String xpath, ReadOption ... options) {
        return JSONNode.collect(json, JSONNodePath.parse(xpath), JSONNodeCollector.DEFAULT, options);
    }

    public static final List<JSONNode> collect(byte[] bytes, String xpath, ReadOption ... options) {
        return JSONNode.collect(bytes, JSONNodePath.parse(xpath), JSONNodeCollector.DEFAULT, options);
    }

    public static final List<JSONNode> collect(byte[] bytes, JSONNodePath path, ReadOption ... options) {
        return JSONNode.collect(bytes, path, JSONNodeCollector.DEFAULT, options);
    }

    public static final List<JSONNode> collect(String json, JSONNodePath path, ReadOption ... options) {
        return JSONNode.collect(json, path, JSONNodeCollector.DEFAULT, options);
    }

    public static final <T> List<T> collect(String json, String xpath, JSONNodeCollector<T> collector, ReadOption ... options) {
        return JSONNode.collect(json, JSONNodePath.parse(xpath), collector, options);
    }

    public static final <T> List<T> collect(String json, JSONNodePath path, JSONNodeCollector<T> nodeCollector, ReadOption ... options) {
        path.head.self();
        if (path.supportedExtract) {
            return JSONNode.extract(json, path, nodeCollector, options);
        }
        JSONNodePathCollector head = path.head;
        if (head.isSupportedExtract()) {
            JSONNodePath extractPath = JSONNodePath.create();
            extractPath.next(head.clone());
            JSONNodePathCollector tail = head.next;
            while (tail.isSupportedExtract()) {
                extractPath.next(tail.clone());
                if (tail.next == null) break;
                tail = tail.next;
            }
            ArrayList results = new ArrayList();
            JSONNodePathCtx pathCtx = path.newCollectCtx();
            List<JSONNode> extractNodes = JSONNode.extract(json, extractPath, options);
            for (JSONNode node : extractNodes) {
                tail.collect(node, results, nodeCollector, pathCtx);
            }
            return results;
        }
        JSONNode root = JSONNode.parse(json, options);
        root.ensureCompleted(false, false);
        return path.collect(root, nodeCollector);
    }

    public static final <T> List<T> collect(byte[] bytes, JSONNodePath path, JSONNodeCollector<T> nodeCollector, ReadOption ... options) {
        path.head.self();
        if (path.supportedExtract) {
            return JSONNode.extract(bytes, path, nodeCollector, options);
        }
        JSONNodePathCollector head = path.head;
        if (head.isSupportedExtract()) {
            JSONNodePath extractPath = JSONNodePath.create();
            extractPath.next(head.clone());
            JSONNodePathCollector tail = head.next;
            while (tail.isSupportedExtract()) {
                extractPath.next(tail.clone());
                if (tail.next == null) break;
                tail = tail.next;
            }
            ArrayList results = new ArrayList();
            JSONNodePathCtx pathCtx = path.newCollectCtx();
            List<JSONNode> extractNodes = JSONNode.extract(bytes, extractPath, JSONNodeCollector.DEFAULT, options);
            for (JSONNode node : extractNodes) {
                tail.collect(node, results, nodeCollector, pathCtx);
            }
            return results;
        }
        JSONNode root = JSONNode.parse(bytes, options);
        root.ensureCompleted(false, false);
        return path.collect(root, nodeCollector);
    }

    public final List<JSONNode> collect(String xpath) {
        return JSONNodePath.parse(xpath).collect(this, JSONNodeCollector.DEFAULT);
    }

    public final List<JSONNode> collect(JSONNodePath path) {
        return path.collect(this, JSONNodeCollector.DEFAULT);
    }

    public final List<JSONNode> all(boolean leaf) {
        return JSONNodePath.ALL.collect(this, leaf ? JSONNodeCollector.DEFAULT.onlyCollectLeaf() : JSONNodeCollector.DEFAULT);
    }

    public final List<Object> collectAs(JSONNodePath path) {
        return path.collect(this, JSONNodeCollector.ANY);
    }

    public final <T> List<T> collectAs(JSONNodePath path, JSONNodeCollector<T> collector) {
        return path.collect(this, collector);
    }

    public final JSONNode getByPaths(Serializable ... paths) {
        if (paths.length == 0) {
            return this;
        }
        try {
            return this.getByPaths(paths, 0, paths.length);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    final JSONNode getByPaths(Serializable[] paths, int offset, int endIndex) {
        JSONNode node;
        if (this.leaf) {
            return null;
        }
        Serializable path = paths[offset++];
        if (this.array) {
            if (!(path instanceof Integer)) {
                return null;
            }
            int i = (Integer)path;
            if (i < 0) {
                this.ensureCompleted(true);
                if ((i += this.elementSize) < 0 || i >= this.elementSize) {
                    return null;
                }
                node = this.elementValues[i];
            } else {
                node = this.getElementAt(i);
            }
        } else if (path instanceof String) {
            node = this.getFieldNodeAt((String)((Object)path));
        } else {
            return null;
        }
        if (node == null) {
            return null;
        }
        if (offset == endIndex) {
            return node;
        }
        return node.getByPaths(paths, offset, endIndex);
    }

    public final JSONNode get(String path) {
        if (path == null) {
            return this;
        }
        int splitIndex = path.indexOf(47, 0);
        if (splitIndex == -1) {
            return this.getChild(path);
        }
        path = path.trim();
        Object stringValue = JSONGeneral.getStringValue(path);
        if (EnvUtils.JDK_9_PLUS) {
            if (path.length() == ((byte[])stringValue).length) {
                return this.get(path, (byte[])stringValue, 0, path.length());
            }
            return this.get(path, path.toCharArray(), 0, path.length());
        }
        return this.get(path, (char[])stringValue, 0, path.length());
    }

    private JSONNode get(String path, char[] pathChars, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return this;
        }
        char beginChar = pathChars[beginIndex];
        if (beginChar == '/') {
            return this.root.get(path, pathChars, beginIndex + 1, endIndex);
        }
        if (this.leaf) {
            return null;
        }
        int splitIndex = path.indexOf(47, beginIndex + 1);
        if (splitIndex == -1) {
            return this.getPathNode(path, pathChars, beginIndex, endIndex - beginIndex);
        }
        JSONNode childNode = this.getPathNode(path, pathChars, beginIndex, splitIndex - beginIndex);
        if (childNode != null) {
            return childNode.get(path, pathChars, splitIndex + 1, endIndex);
        }
        return null;
    }

    private JSONNode get(String path, byte[] pathBytes, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return this;
        }
        byte begin = pathBytes[beginIndex];
        if (begin == 47) {
            return this.root.get(path, pathBytes, beginIndex + 1, endIndex);
        }
        if (this.leaf) {
            return null;
        }
        int splitIndex = path.indexOf(47, beginIndex + 1);
        if (splitIndex == -1) {
            return this.getPathNode(path, pathBytes, beginIndex, endIndex - beginIndex);
        }
        JSONNode childNode = this.getPathNode(path, pathBytes, beginIndex, splitIndex - beginIndex);
        if (childNode != null) {
            return childNode.get(path, pathBytes, splitIndex + 1, endIndex);
        }
        return null;
    }

    public final Collection<Serializable> keyNames() {
        if (this.array) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.completeNode(true, false);
        }
        return this.fieldValues.keySet();
    }

    private JSONNode getPathNode(String path, char[] pathChars, int offset, int len) {
        if (this.array) {
            int i = offset;
            int end = offset + len;
            try {
                int index = 0;
                do {
                    char ch;
                    if (!NumberUtils.isDigit(ch = pathChars[i++])) {
                        throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, end) + "'");
                    }
                    index = (index << 3) + (index << 1) + (ch & 0xF);
                } while (i < end);
                return this.elementSize > index || this.completed ? this.elementValues[index] : this.parseArrayAt(index, true, false);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, end) + "'");
            }
        }
        String field = this.matchFieldName(pathChars, offset, len);
        return this.getFieldNodeAt(field);
    }

    private JSONNode getPathNode(String path, byte[] pathBytes, int offset, int len) {
        if (this.array) {
            int i = offset;
            int end = offset + len;
            try {
                int index = 0;
                do {
                    byte ch;
                    if (!NumberUtils.isDigit(ch = pathBytes[i++])) {
                        throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, end) + "'");
                    }
                    index = (index << 3) + (index << 1) + (ch & 0xF);
                } while (i < end);
                return this.elementSize > index || this.completed ? this.elementValues[index] : this.parseArrayAt(index, true, false);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, end) + "'");
            }
        }
        String field = this.matchFieldName(pathBytes, offset, len);
        return this.getFieldNodeAt(field);
    }

    private String matchFieldName(char[] chars, int offset, int len) {
        long hashValue = 92L;
        boolean ascii = true;
        for (int i = 0; i < len; ++i) {
            char ch = chars[offset + i];
            if (ch > '\u00ff') {
                hashValue = hashValue << 16 | (long)ch;
                ascii = false;
                continue;
            }
            hashValue = hashValue << 8 | (long)ch;
        }
        if (ascii && len <= 8) {
            return this.parseContext.getCacheEightCharsKey(chars, offset, len, hashValue);
        }
        return this.parseContext.getCacheKey(chars, offset, len, hashValue);
    }

    private String matchFieldName(byte[] bytes, int offset, int len) {
        long hashValue = 92L;
        for (int i = 0; i < len; ++i) {
            byte ch = bytes[offset + i];
            hashValue = hashValue << 8 | (long)ch;
        }
        if (len <= 8) {
            return this.parseContext.getCacheEightBytesKey(bytes, offset, len, hashValue);
        }
        return this.parseContext.getCacheKey(bytes, offset, len, hashValue);
    }

    final JSONNode getFieldNodeAt(String field) {
        if (this.fieldValues != null) {
            JSONNode node = this.fieldValues.get(field);
            if (node != null) {
                return node;
            }
        } else {
            this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(8);
        }
        if (this.completed) {
            return null;
        }
        return this.parseObjectField(field, true, false);
    }

    public final JSONNode getChild(String field) {
        if (this.type == 1) {
            return this.getFieldNodeAt(field);
        }
        if (this.array) {
            int index;
            try {
                index = Integer.parseInt(field);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("input not a number string: '" + field + '\'');
            }
            this.parseElementTo(index);
            if (index < 0) {
                index += this.elementSize;
            }
            return this.elementValues[index];
        }
        throw new UnsupportedOperationException();
    }

    private JSONNode getPathNode(String field) {
        if (this.array) {
            int index;
            int length = field.length();
            try {
                index = JSONNode.readArrayIndex(field, 0, length);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException(" field '" + field + " is mismatch array index ");
            }
            if (index > -1) {
                return this.getElementAt(index);
            }
            throw new IllegalArgumentException(" key '" + field + " is mismatch array index ");
        }
        return this.getFieldNodeAt(field);
    }

    protected static int readArrayIndex(String buf, int offset, int len) {
        int i;
        if (len == 0) {
            return -1;
        }
        int value = 0;
        int n = i + len;
        for (i = offset; i < n; ++i) {
            char ch = buf.charAt(i);
            int d = NumberUtils.digitDecimal(ch);
            if (d < 0) {
                if (ch <= ' ') continue;
                throw new IllegalArgumentException("mismatch array index: \"" + buf.substring(offset, offset + len) + "\"");
            }
            value = value * 10 + d;
        }
        return value;
    }

    static boolean matchJSONKey(CharSource charSource, byte[] buf, int offset, byte[] keyBytes, JSONNodeContext parseContext) {
        if (keyBytes != null) {
            int endIndex;
            int i;
            int beginIndex = offset + 1;
            int fieldLength = keyBytes.length;
            boolean matched = true;
            for (i = 0; i < fieldLength; ++i) {
                if (keyBytes[i] == buf[beginIndex + i]) continue;
                matched = false;
                break;
            }
            if (matched && buf[endIndex = fieldLength + beginIndex] == 34) {
                parseContext.endIndex = endIndex;
                return true;
            }
            try {
                JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, beginIndex + i, (byte)34, (JSONParseContext)parseContext);
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new JSONException(e);
            }
            return false;
        }
        try {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, offset + 1, (byte)34, (JSONParseContext)parseContext);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new JSONException(e);
        }
        return false;
    }

    public void closeExtractMode() {
        this.parseContext.extract = false;
    }

    JSONNode parseObjectField(String fieldName, boolean lazy, boolean createObj) {
        return null;
    }

    final void addElementNode(JSONNode node) {
        if (this.elementValues == null) {
            this.elementValues = new JSONNode[8];
        } else if (this.elementSize == this.elementValues.length) {
            JSONNode[] tmp = this.elementValues;
            this.elementValues = new JSONNode[this.elementSize << 1];
            System.arraycopy(tmp, 0, this.elementValues, 0, tmp.length);
        }
        node.path = Integer.valueOf(this.elementSize);
        this.elementValues[this.elementSize++] = node;
    }

    public final JSONNode getElementAt(int index) {
        if (this.elementSize > index) {
            return this.elementValues[index];
        }
        if (this.completed) {
            return null;
        }
        if (this.array) {
            return this.parseArrayAt(index, true, false);
        }
        throw new UnsupportedOperationException("element at " + index);
    }

    final void parseElementTo(int index) {
        if (index < 0) {
            if (!this.completed) {
                this.parseArrayAt(-1, true, false);
            }
        } else if (!(this.completed || this.elementSize > index && index != -1)) {
            this.parseArrayAt(index, true, false);
        }
    }

    public final int getElementCount() {
        if (this.array) {
            if (this.completed) {
                return this.elementSize;
            }
            this.parseArrayAt(-1, true, false);
            return this.elementSize;
        }
        return -1;
    }

    public final JSONNode parent() {
        return this.parent;
    }

    public final <E> E getPathValue(String path, Class<E> clazz) {
        JSONNode jsonNode = this.get(path);
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.getValue(clazz);
    }

    public final <E> E getChildValue(String name, Class<E> eClass) {
        JSONNode jsonNode = this.getPathNode(name);
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.array) {
            if (eClass == String.class) {
                return (E)jsonNode.source();
            }
            throw new UnsupportedOperationException("not matched " + eClass);
        }
        return jsonNode.getValue(eClass);
    }

    public final String getStringValue() {
        return this.getValue(String.class);
    }

    public final Serializable getValue() {
        if (this.value != null) {
            return this.value;
        }
        return (Serializable)this.getValue(null);
    }

    public final Object any() {
        if (this.leaf) {
            return this.value;
        }
        if (!this.changed && this.any != null) {
            return this.any;
        }
        this.ensureCompleted(false, true);
        if (this.array) {
            ArrayList<Object> list = new ArrayList<Object>(this.elementSize);
            for (int i = 0; i < this.elementSize; ++i) {
                JSONNode node = this.elementValues[i];
                list.add(node.leaf ? node.value : node.any());
            }
            this.any = list;
            return this.any;
        }
        LinkedHashMap<Serializable, Object> map = new LinkedHashMap<Serializable, Object>(this.fieldValues.size());
        Set<Map.Entry<Serializable, JSONNode>> entrySet = this.fieldValues.entrySet();
        for (Map.Entry<Serializable, JSONNode> entry : entrySet) {
            JSONNode node = entry.getValue();
            map.put(entry.getKey(), node.leaf ? node.value : node.any());
        }
        this.any = map;
        return this.any;
    }

    public final <E> E getValue(Class<E> eClass) {
        if (this.leaf) {
            if (eClass == null || this.type == 6) {
                return (E)this.value;
            }
            if (eClass.isPrimitive()) {
                return ObjectUtils.toType(this.value, eClass);
            }
            if (eClass.isInstance(this.value)) {
                return (E)this.value;
            }
            if (eClass == String.class) {
                return (E)this.getText();
            }
            if (eClass == char[].class) {
                return (E)this.getText().toCharArray();
            }
            if (eClass == byte[].class) {
                String text = this.getText();
                if (this.parseContext.byteArrayFromHexString) {
                    return (E)this.hexString2Bytes();
                }
                return (E)Base64Utils.decode(text);
            }
            if (Enum.class.isAssignableFrom(eClass)) {
                if (this.type == 3) {
                    Class<E> enumCls = eClass;
                    return Enum.valueOf(enumCls, (String)((Object)this.value));
                }
                if (this.value instanceof Integer) {
                    int index = (Integer)this.value;
                    E[] enumConstants = eClass.getEnumConstants();
                    if (index > -1 && index < enumConstants.length) {
                        return eClass.getEnumConstants()[index];
                    }
                    return null;
                }
                throw new JSONException("source [" + this.source() + "] cannot convert to Enum '" + eClass + "");
            }
            try {
                E result = ObjectUtils.toType(this.source(), eClass);
                if (result != null) {
                    return result;
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(eClass);
                if (typeDeserializer != null) {
                    return (E)typeDeserializer.valueOf(this.value != null ? String.valueOf(this.value) : this.source(), eClass);
                }
            }
            catch (Throwable result) {
                // empty catch block
            }
            return null;
        }
        if (this.array) {
            if (eClass == null || eClass == Object.class) {
                return (E)this.toCollection(ArrayList.class, Object.class);
            }
            if (eClass.isArray()) {
                return this.toArray(eClass);
            }
            if (Collection.class.isAssignableFrom(eClass)) {
                return (E)this.toCollection(eClass, Object.class);
            }
            throw new UnsupportedOperationException("array node not supported " + eClass);
        }
        if (eClass != null && (eClass.isEnum() || eClass.isPrimitive() || eClass.isArray())) {
            String msg = "source '" + this.source() + "' not supported to type " + eClass;
            throw new UnsupportedOperationException(msg);
        }
        return this.toBean(eClass);
    }

    public final Map asMap() {
        return (Map)this.any();
    }

    public final List asList() {
        return (List)this.any();
    }

    public final <E> Map<?, E> asMap(Class<? extends Map> eClass, Class<E> valueCls) {
        return this.toBean(eClass, valueCls);
    }

    public final <E> E toBean(Class<E> eClass) {
        return this.toBean(eClass, null);
    }

    final <E> E toBean(Class<E> eClass, Class actualCls) {
        boolean isMapInstance;
        Object instance;
        if (eClass == String.class) {
            return (E)this.source();
        }
        if (this.leaf) {
            throw new UnsupportedOperationException("leaf value not supported " + eClass);
        }
        ClassStrucWrap strucWrap = null;
        if (eClass == null || eClass == Object.class || eClass == Map.class || eClass == LinkedHashMap.class) {
            instance = new LinkedHashMap();
            isMapInstance = true;
        } else {
            strucWrap = ClassStrucWrap.get(eClass);
            if (strucWrap == null) {
                if (this.array && Collection.class.isAssignableFrom(eClass)) {
                    return (E)this.toCollection(eClass, actualCls);
                }
                throw new UnsupportedOperationException("object node not supported " + eClass);
            }
            isMapInstance = strucWrap.isAssignableFromMap();
            try {
                instance = !isMapInstance ? strucWrap.newInstance() : eClass.newInstance();
            }
            catch (Throwable throwable) {
                throw new JSONException("create instance error.", throwable);
            }
        }
        if (!this.completed) {
            this.completeNode(false, false);
        }
        for (Map.Entry<Serializable, JSONNode> entry : this.fieldValues.entrySet()) {
            Object value;
            Serializable key = entry.getKey();
            JSONNode childNode = entry.getValue();
            if (isMapInstance) {
                Map map = (Map)instance;
                Object value2 = childNode.array ? childNode.toCollection(ArrayList.class, Object.class) : childNode.getValue(actualCls);
                map.put(key, value2);
                continue;
            }
            String fieldName = key.toString();
            SetterInfo setterInfo = strucWrap.getSetterInfo(fieldName);
            if (setterInfo == null) continue;
            Class<?> parameterType = setterInfo.getParameterType();
            GenericParameterizedType parameterizedType = setterInfo.getGenericParameterizedType();
            if (childNode.array) {
                Class<Object> entityClass = parameterizedType.getValueType() == null ? Object.class : parameterizedType.getValueType().getActualType();
                value = childNode.toCollection(parameterizedType.getActualType(), entityClass);
            } else {
                value = childNode.getValue(parameterType);
            }
            JSONGeneral.JSON_SECURE_TRUSTED_ACCESS.set(setterInfo, instance, value);
        }
        return (E)instance;
    }

    public final <E> List<E> toList(Class<E> entityClass) {
        return (List)this.toCollection(ArrayList.class, entityClass);
    }

    public final <E> E toArray(Class<E> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new JSONException(arrayClass + " is not an array class");
        }
        return (E)this.toCollection(arrayClass, arrayClass.getComponentType());
    }

    public final Object toCollection(Class<?> collectionCls, Class<?> entityClass) {
        collectionCls.getClass();
        if (!this.completed) {
            this.completeNode(false, false);
        }
        Collection collection = null;
        boolean isArrayCls = collectionCls.isArray();
        boolean primitive = entityClass.isPrimitive();
        Object arrayObj = null;
        if (isArrayCls) {
            arrayObj = Array.newInstance(entityClass, this.elementSize);
        } else {
            collection = JSONGeneral.createCollectionInstance(collectionCls, this.elementSize);
        }
        for (int i = 0; i < this.elementSize; ++i) {
            JSONNode node = this.elementValues[i];
            Object result = node.array ? (entityClass.isArray() ? node.toCollection(entityClass, entityClass.getComponentType()) : node.toCollection(ArrayList.class, Object.class)) : node.getValue(entityClass);
            if (isArrayCls) {
                if (primitive) {
                    Array.set(arrayObj, i, result);
                    continue;
                }
                ((Object[])arrayObj)[i] = result;
                continue;
            }
            collection.add(result);
        }
        return isArrayCls ? arrayObj : collection;
    }

    final void ensureCompleted(boolean lazy) {
        this.ensureCompleted(lazy, false);
    }

    final void ensureCompleted(boolean lazy, boolean createObj) {
        if (!this.completed) {
            this.completeNode(lazy, createObj);
        }
    }

    private void completeNode(boolean lazy, boolean createObj) {
        if (this.array) {
            this.parseArrayAt(-1, lazy, createObj);
        } else {
            if (this.fieldValues == null) {
                this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(8);
            }
            this.parseObjectField(null, lazy, createObj);
        }
    }

    public double max(String field) {
        if (this.array) {
            List list = this.asList();
            double maxNum = Double.MIN_VALUE;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object element;
                Object val = element = iterator.next();
                if (element instanceof Map) {
                    if (field == null) {
                        return 0.0;
                    }
                    val = ObjectUtils.get(element, field);
                }
                if (!(val instanceof Number)) continue;
                maxNum = Math.max(maxNum, ((Number)val).doubleValue());
            }
            return maxNum;
        }
        return 0.0;
    }

    public double min(String field) {
        if (this.array) {
            List list = this.asList();
            double maxNum = Double.MAX_VALUE;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object element;
                Object val = element = iterator.next();
                if (element instanceof Map) {
                    if (field == null) {
                        return 0.0;
                    }
                    val = ObjectUtils.get(element, field);
                }
                if (!(val instanceof Number)) continue;
                maxNum = Math.min(maxNum, ((Number)val).doubleValue());
            }
            return maxNum;
        }
        return 0.0;
    }

    public double avg(String field) {
        if (this.array) {
            List list = this.asList();
            double total = 0.0;
            if (list.size() == 0) {
                return 0.0;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object element;
                Object val = element = iterator.next();
                if (element instanceof Map) {
                    if (field == null) {
                        return 0.0;
                    }
                    val = ObjectUtils.get(element, field);
                }
                if (!(val instanceof Number)) continue;
                total += ((Number)val).doubleValue();
            }
            return total / (double)list.size();
        }
        return 0.0;
    }

    public final double max() {
        return this.max(null);
    }

    public final double min() {
        return this.min(null);
    }

    public final double avg() {
        return this.avg(null);
    }

    public final boolean isArray() {
        return this.array;
    }

    public final boolean isObject() {
        return this.type == 1;
    }

    public final boolean isNull() {
        return this.type == 6;
    }

    public final boolean isNumber() {
        return this.type == 4;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public final int getType() {
        return this.type;
    }

    @Override
    public final int compareTo(JSONNode o) {
        Serializable value = this.value;
        Serializable o1 = o.value;
        if (value instanceof Number && o1 instanceof Number) {
            Double v1 = ((Number)value).doubleValue();
            Double v2 = ((Number)o1).doubleValue();
            return v1.compareTo(v2);
        }
        if (value instanceof String && o1 instanceof String) {
            return ((String)((Object)value)).compareTo((String)((Object)o1));
        }
        if (value instanceof Comparable && o1 instanceof Comparable) {
            if (value.getClass() == o1.getClass()) {
                return ((Comparable)((Object)value)).compareTo(o1);
            }
            String v1 = value.toString();
            String v2 = o1.toString();
            return v1.compareTo(v2);
        }
        return 0;
    }

    private void writeTo(StringBuilder builder) {
        if (!this.changed) {
            this.writeSourceTo(builder);
            return;
        }
        builder.append(JSON.toJsonString(this.any()));
    }

    private static void writeStringTo(String leafValue, StringBuilder content) {
        int len = leafValue.length();
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = leafValue.charAt(i);
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
            int length = i - beginIndex;
            if (length > 0) {
                content.append(leafValue, beginIndex, i);
            }
            content.append(escapeStr);
            beginIndex = i + 1;
        }
        content.append(leafValue, beginIndex, len);
    }

    public final void setPathValue(String path, Serializable value) {
        JSONNode node = this.get(path);
        if (node != null) {
            node.setValue(value);
        }
    }

    public final void setChildValue(String field, Serializable value) {
        this.setChildValue(field, value, false);
    }

    public final void setChildValue(String field, Serializable value, boolean createIfNotExist) {
        if (this.leaf) {
            return;
        }
        JSONNode node = this.getChild(field);
        if (node != null) {
            node.setValue(value);
        } else if (createIfNotExist) {
            this.newChildValue(field, value);
        }
    }

    final void newChildValue(String field, Serializable value) {
        D newChild = new D(value, this.root);
        newChild.parent = this;
        if (this.array) {
            this.addElementNode(newChild);
        } else {
            JSONNode.addFieldValue(this.fieldValues, (Serializable)((Object)field), newChild);
        }
        this.handleChange();
    }

    public final void removeElementAt(int index) {
        if (!this.array) {
            throw new UnsupportedOperationException();
        }
        if (index >= this.elementSize || index < 0) {
            throw new IndexOutOfBoundsException(" length: " + this.elementSize + ", to remove index at " + index);
        }
        if (!this.completed) {
            this.completeNode(true, false);
        }
        int newLen = this.elementSize - 1;
        JSONNode[] newElementNodes = new JSONNode[newLen];
        System.arraycopy(this.elementValues, 0, newElementNodes, 0, index);
        System.arraycopy(this.elementValues, index + 1, newElementNodes, index, newLen - index);
        this.elementSize = newLen;
        this.handleChange();
    }

    public final JSONNode removeField(String field) {
        JSONNode removeNode;
        if (this.type != 1) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.completeNode(true, false);
        }
        if ((removeNode = this.fieldValues.remove(field)) != null) {
            this.handleChange();
        }
        return removeNode;
    }

    public final void setValue(Serializable value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        this.leaf = true;
        this.updateType();
        this.handleChange();
    }

    final void updateType() {
        if (this.value == null) {
            this.type = 6;
        } else if (this.value instanceof Number) {
            this.type = 4;
        } else if (this.value instanceof Boolean) {
            this.type = 5;
        } else if (this.value instanceof String) {
            this.type = 3;
            this.text = (String)((Object)this.value);
        } else {
            this.type = 7;
        }
    }

    public final void clear() {
        if (this.array) {
            for (JSONNode ele : this.elementValues) {
                if (ele == null) continue;
                ele.clear();
            }
        } else {
            for (JSONNode ele : this.fieldValues.values()) {
                ele.clear();
            }
        }
        this.text = null;
        this.value = null;
        this.elementValues = null;
        this.fieldValues = null;
        this.clearSource();
    }

    JSONNode parseArrayAt(int index, boolean lazy, boolean createObj) {
        return null;
    }

    JSONNode parseValueNode(int beginIndex, char endChar, boolean lazy, boolean createObj) throws Exception {
        return null;
    }

    public String getText() {
        return null;
    }

    byte[] hexString2Bytes() {
        return new byte[0];
    }

    public String source() {
        return null;
    }

    void writeSourceTo(StringBuilder stringBuilder) {
    }

    protected void clearSource() {
    }

    final void handleChange() {
        if (this.parent != null) {
            this.parent.handleChange();
        }
        this.changed = true;
        this.any = null;
    }

    public void writeTo(Writer writer) {
        this.writeTo(writer, true);
    }

    public void writeTo(Writer writer, boolean close) {
        try {
            writer.write(this.toJsonString(true));
            writer.flush();
            if (close) {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toJsonString() {
        return this.toJsonString(false);
    }

    public final String toJsonString(boolean rewrite) {
        if (rewrite) {
            return JSON.toJsonString(this.any());
        }
        if (!this.changed) {
            return this.source();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeTo(stringBuilder);
        return stringBuilder.toString();
    }

    static class B
    extends JSONNode {
        CharSource charSource;
        byte[] buf;

        B(CharSource charSource, byte[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(B.buildRootContext(buf, beginIndex, endIndex), parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, Map<Serializable, JSONNode> fieldValues, byte[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext, JSONNode root) {
            super(fieldValues, beginIndex, endIndex, parseContext, root);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, Serializable leafValue, byte[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(leafValue, beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, byte[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, byte[] buf, int fromIndex, JSONNodeContext parseContext, JSONNode root) {
            super(fromIndex, parseContext, root);
            this.charSource = charSource;
            this.buf = buf;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                if (this.type == 3) {
                    this.text = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(this.charSource, this.buf, this.beginIndex, 34, GenericParameterizedType.StringType, (JSONParseContext)this.parseContext);
                    this.value = this.text;
                } else {
                    return this.source();
                }
            }
            return this.text;
        }

        @Override
        public String source() {
            if (this.value != null && this.type != 3) {
                return String.valueOf(this.value);
            }
            if (this.type > 3) {
                if (this.text == null) {
                    String source;
                    this.text = source = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
                }
                return this.text;
            }
            return new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        void writeSourceTo(StringBuilder stringBuilder) {
            stringBuilder.append(new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex));
        }

        @Override
        byte[] hexString2Bytes() {
            return JSONGeneral.hexString2Bytes(this.buf, this.beginIndex + 1, this.endIndex - this.beginIndex - 2);
        }

        @Override
        JSONNode parseObjectField(String fieldName, boolean lazy, boolean createObj) {
            if (this.completed) {
                return (JSONNode)this.fieldValues.get(fieldName);
            }
            boolean allowComment = this.parseContext.allowComment;
            boolean extract = this.parseContext.extract;
            boolean stored = !extract || !lazy;
            byte[] fieldNameBytes = !stored && fieldName != null ? JSONUnsafe.getStringUTF8Bytes(fieldName) : null;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean skipValue;
                boolean matched;
                byte b;
                while ((b = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    b = this.buf[i];
                }
                int fieldKeyFrom = i;
                String key = null;
                if (b == 34) {
                    if (stored) {
                        key = JSONTypeDeserializer.parseMapKeyByCache(this.buf, i, '\"', this.parseContext);
                        matched = fieldName != null && fieldName.equals(key);
                        skipValue = false;
                    } else {
                        matched = B.matchJSONKey(this.charSource, this.buf, i, fieldNameBytes, this.parseContext);
                        skipValue = !matched;
                    }
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (b == 125) {
                        this.offset = i;
                        this.completed = true;
                        return null;
                    }
                    if (b == 39) {
                        while (i + 1 < this.endIndex && (this.buf[++i] != 39 || this.buf[i - 1] == 92)) {
                        }
                        key = (String)((Object)JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, ++i, false));
                    } else {
                        while (i + 1 < this.endIndex && this.buf[++i] != 58) {
                        }
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, i, true));
                    }
                    matched = fieldName != null && fieldName.equals(key);
                    boolean bl = skipValue = !stored && !matched;
                }
                while ((b = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    b = this.buf[i];
                }
                if (b == 58) {
                    boolean isClosingSymbol;
                    while ((b = this.buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    }
                    JSONNode node = null;
                    try {
                        if (skipValue) {
                            JSONTypeDeserializer.ANY.skip(this.charSource, this.buf, i, (byte)125, (JSONParseContext)this.parseContext);
                        } else {
                            node = this.parseValueNode(i, '}', lazy, createObj);
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof JSONException) {
                            throw (JSONException)throwable;
                        }
                        throw new JSONException(throwable.getMessage(), throwable);
                    }
                    i = this.parseContext.endIndex;
                    while ((b = this.buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                        b = this.buf[i];
                    }
                    boolean bl = isClosingSymbol = b == 125;
                    if (b == 44 || isClosingSymbol) {
                        if (stored) {
                            B.addFieldValue(this.fieldValues, (Serializable)((Object)key), node);
                            this.offset = i;
                            if (isClosingSymbol) {
                                this.completed = true;
                            }
                        }
                        if (!matched) continue;
                        return node;
                    }
                    throw new JSONException("Syntax error, unexpected '" + (char)b + "', position " + i);
                }
                throw new JSONException("Syntax error, unexpected '" + (char)b + "', position " + i);
            }
            return null;
        }

        private JSONNode completeObjectNode(CharSource charSource, byte[] buf, int fromIndex, boolean createObj) throws Exception {
            int beginIndex = fromIndex + 1;
            int toIndex = this.endIndex;
            boolean allowComment = this.parseContext.allowComment;
            LinkedHashMap<Serializable, JSONNode> fieldValues = new LinkedHashMap<Serializable, JSONNode>();
            B objectNode = new B(charSource, fieldValues, buf, fromIndex, -1, this.parseContext, this.root);
            LinkedHashMap<String, Object> map = null;
            if (createObj) {
                objectNode.any = map = new LinkedHashMap<String, Object>();
            }
            for (int i = beginIndex; i < this.endIndex; ++i) {
                String key;
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    b = buf[i];
                }
                if (b == 34) {
                    key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, '\"', this.parseContext);
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (b == 125) {
                        this.parseContext.endIndex = i++;
                        objectNode.endIndex = i;
                        return objectNode;
                    }
                    if (b == 39) {
                        key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, '\'', this.parseContext);
                        i = this.parseContext.endIndex + 1;
                    } else {
                        int begin = i;
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    b = buf[i];
                }
                if (b == 58) {
                    boolean isClosingSymbol;
                    JSONNode node;
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                        b = buf[i];
                    }
                    try {
                        node = this.parseValueNode(i, '}', false, createObj);
                        node.parent = objectNode;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof JSONException) {
                            throw (JSONException)throwable;
                        }
                        throw new JSONException(throwable.getMessage(), throwable);
                    }
                    i = this.parseContext.endIndex;
                    B.addFieldValue(fieldValues, (Serializable)((Object)key), node);
                    if (createObj) {
                        map.put(key, node.any());
                    }
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                        b = buf[i];
                    }
                    boolean bl = isClosingSymbol = b == 125;
                    if (b == 44 || isClosingSymbol) {
                        if (fieldValues != null) {
                            B.addFieldValue(fieldValues, (Serializable)((Object)key), node);
                        }
                        if (!isClosingSymbol) continue;
                        this.parseContext.endIndex = i++;
                        objectNode.endIndex = i;
                        return objectNode;
                    }
                    throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
                }
                throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
            }
            throw new JSONException("Syntax error, the closing symbol '}' is not found ");
        }

        private JSONNode completeArrayNode(CharSource charSource, byte[] buf, int fromIndex, boolean createObj) throws Exception {
            int beginIndex = fromIndex + 1;
            int toIndex = this.endIndex;
            JSONNode[] elementValues = new JSONNode[8];
            int elementSize = 0;
            boolean allowComment = this.parseContext.allowComment;
            B arrayNode = new B(charSource, buf, fromIndex, this.parseContext, this.root);
            ArrayList<Object> list = null;
            if (createObj) {
                arrayNode.any = list = new ArrayList<Object>();
            }
            for (int i = beginIndex; i < toIndex; ++i) {
                boolean isEnd;
                JSONNode node;
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    this.parseContext.endIndex = i++;
                    arrayNode.endIndex = i;
                    ((JSONNode)arrayNode).updateArray(elementValues, elementSize);
                    return arrayNode;
                }
                try {
                    node = this.parseValueNode(i, ']', false, createObj);
                    node.parent = arrayNode;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                node.path = Integer.valueOf(elementSize);
                if (elementSize >= elementValues.length) {
                    elementValues = Arrays.copyOf(elementValues, elementValues.length << 1);
                }
                elementValues[elementSize++] = node;
                if (createObj) {
                    list.add(node.any());
                }
                while (i + 1 < toIndex && (b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    b = buf[i];
                }
                boolean bl = isEnd = b == 93;
                if (b == 44 || isEnd) {
                    if (!isEnd) continue;
                    this.parseContext.endIndex = i++;
                    arrayNode.endIndex = i;
                    ((JSONNode)arrayNode).updateArray(elementValues, elementSize);
                    return arrayNode;
                }
                throw new JSONException("Syntax error, unexpected '" + b + "', position " + i + ", missing ',' or '}'");
            }
            throw new JSONException("Syntax error, the closing symbol ']' is not found ");
        }

        @Override
        JSONNode parseValueNode(int beginIndex, char endChar, boolean lazy, boolean createObj) throws Exception {
            JSONNode node;
            byte ch = this.buf[beginIndex];
            switch (ch) {
                case 123: {
                    if (lazy) {
                        JSONTypeDeserializer.MAP.skip(this.charSource, this.buf, beginIndex, (JSONParseContext)this.parseContext);
                        node = new B(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 1, this.parseContext, this.root);
                        break;
                    }
                    node = this.completeObjectNode(this.charSource, this.buf, beginIndex, createObj);
                    break;
                }
                case 91: {
                    if (lazy) {
                        JSONTypeDeserializer.COLLECTION.skip(this.charSource, this.buf, beginIndex, (JSONParseContext)this.parseContext);
                        node = new B(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 2, this.parseContext, this.root);
                        break;
                    }
                    node = this.completeArrayNode(this.charSource, this.buf, beginIndex, createObj);
                    break;
                }
                case 34: 
                case 39: {
                    node = JSONNode.parseStringPathNode(this.charSource, this.buf, beginIndex, ch, false, this.parseContext, this.root);
                    break;
                }
                case 110: {
                    node = B.parseNullPathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                case 116: {
                    node = B.parseBoolTruePathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                case 102: {
                    node = B.parseBoolFalsePathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                default: {
                    node = B.parseNumberPathNode(this.charSource, this.buf, beginIndex, (byte)endChar, false, this.parseContext, this.root);
                }
            }
            node.parent = this;
            return node;
        }

        @Override
        JSONNode parseArrayAt(int index, boolean lazy, boolean createObj) {
            boolean allowComment = this.parseContext.allowComment;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isEnd;
                JSONNode node;
                byte ch;
                while ((ch = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch == 93) {
                    this.offset = i;
                    this.completed = true;
                    return null;
                }
                boolean matchedIndex = index > -1 && index == this.elementSize;
                try {
                    node = this.parseValueNode(i, ']', lazy, createObj);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl = isEnd = ch == 93;
                if (ch == 44 || isEnd) {
                    this.addElementNode(node);
                    if (isEnd) {
                        this.completed = true;
                    }
                    if (!matchedIndex) continue;
                    return node;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", missing ',' or '}'");
            }
            return null;
        }

        @Override
        protected void clearSource() {
            this.buf = null;
            this.charSource = null;
        }
    }

    static final class C
    extends JSONNode {
        CharSource charSource;
        char[] buf;

        C(CharSource charSource, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(C.buildRootContext(buf, beginIndex, endIndex), parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, char[] buf, int beginIndex, JSONNodeContext parseContext, JSONNode root) {
            super(beginIndex, parseContext, root);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, Map<Serializable, JSONNode> fieldValues, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext, JSONNode root) {
            super(fieldValues, beginIndex, endIndex, parseContext, root);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, Serializable leafValue, char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(leafValue, beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                if (this.type == 3) {
                    this.text = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(this.charSource, this.buf, this.beginIndex, '\"', GenericParameterizedType.StringType, (JSONParseContext)this.parseContext);
                    this.value = this.text;
                } else {
                    return this.source();
                }
            }
            return this.text;
        }

        @Override
        public String source() {
            if (this.value != null && this.type != 3) {
                return String.valueOf(this.value);
            }
            if (this.type > 3) {
                if (this.text == null) {
                    String source;
                    this.text = source = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
                }
                return this.text;
            }
            return new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        void writeSourceTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        byte[] hexString2Bytes() {
            return JSONGeneral.hexString2Bytes(this.buf, this.beginIndex + 1, this.endIndex - this.beginIndex - 2);
        }

        @Override
        JSONNode parseObjectField(String fieldName, boolean lazy, boolean createObj) {
            if (this.completed) {
                return (JSONNode)this.fieldValues.get(fieldName);
            }
            boolean allowComment = this.parseContext.allowComment;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                String key;
                char ch;
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    key = JSONDefaultParser.parseMapKeyByCache(this.buf, i, '\"', this.parseContext);
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (ch == '}') {
                        this.offset = i;
                        this.completed = true;
                        return null;
                    }
                    if (ch == '\'') {
                        while (i + 1 < this.endIndex && (this.buf[++i] != '\'' || this.buf[i - 1] == '\\')) {
                        }
                        key = (String)((Object)JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, ++i, false));
                    } else {
                        while (i + 1 < this.endIndex && this.buf[++i] != ':') {
                        }
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, i, true));
                    }
                }
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch == ':') {
                    boolean isClosingSymbol;
                    JSONNode node;
                    boolean matchedField;
                    boolean bl = matchedField = fieldName != null && fieldName.equals(key);
                    while ((ch = this.buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                        ch = this.buf[i];
                    }
                    try {
                        node = this.parseValueNode(i, '}', lazy, createObj);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof JSONException) {
                            throw (JSONException)throwable;
                        }
                        throw new JSONException(throwable.getMessage(), throwable);
                    }
                    i = this.parseContext.endIndex;
                    while ((ch = this.buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                        ch = this.buf[i];
                    }
                    this.offset = i;
                    boolean bl2 = isClosingSymbol = ch == '}';
                    if (ch == ',' || isClosingSymbol) {
                        C.addFieldValue(this.fieldValues, (Serializable)((Object)key), node);
                        if (isClosingSymbol) {
                            this.completed = true;
                        }
                        if (!matchedField) continue;
                        return node;
                    }
                    throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            }
            return null;
        }

        private JSONNode completeObjectNode(CharSource charSource, char[] buf, int fromIndex, boolean createObj) throws Exception {
            int beginIndex = fromIndex + 1;
            int toIndex = this.endIndex;
            boolean allowComment = this.parseContext.allowComment;
            LinkedHashMap<Serializable, JSONNode> fieldValues = new LinkedHashMap<Serializable, JSONNode>();
            C objectNode = new C(charSource, fieldValues, buf, fromIndex, -1, this.parseContext, this.root);
            LinkedHashMap<String, Object> map = null;
            if (createObj) {
                objectNode.any = map = new LinkedHashMap<String, Object>();
            }
            for (int i = beginIndex; i < toIndex; ++i) {
                String key;
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = buf[i];
                }
                if (ch == '\"') {
                    key = JSONDefaultParser.parseMapKeyByCache(buf, i, '\"', this.parseContext);
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (ch == '}') {
                        this.parseContext.endIndex = i++;
                        objectNode.endIndex = i;
                        return objectNode;
                    }
                    if (ch == '\'') {
                        key = JSONDefaultParser.parseMapKeyByCache(buf, i, '\'', this.parseContext);
                        i = this.parseContext.endIndex + 1;
                    } else {
                        int begin = i;
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = buf[i];
                }
                if (ch == ':') {
                    boolean isClosingSymbol;
                    JSONNode node;
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                        ch = buf[i];
                    }
                    try {
                        node = this.parseValueNode(i, '}', false, createObj);
                        node.parent = objectNode;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof JSONException) {
                            throw (JSONException)throwable;
                        }
                        throw new JSONException(throwable.getMessage(), throwable);
                    }
                    i = this.parseContext.endIndex;
                    C.addFieldValue(fieldValues, (Serializable)((Object)key), node);
                    if (createObj) {
                        map.put(key, node.any());
                    }
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                        ch = buf[i];
                    }
                    boolean bl = isClosingSymbol = ch == '}';
                    if (ch == ',' || isClosingSymbol) {
                        if (!isClosingSymbol) continue;
                        this.parseContext.endIndex = i++;
                        objectNode.endIndex = i;
                        return objectNode;
                    }
                    throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            }
            throw new JSONException("Syntax error, the closing symbol '}' is not found ");
        }

        private JSONNode completeArrayNode(CharSource charSource, char[] buf, int fromIndex, boolean createObj) throws Exception {
            int beginIndex = fromIndex + 1;
            int toIndex = this.endIndex;
            JSONNode[] elementValues = new JSONNode[8];
            int elementSize = 0;
            boolean allowComment = this.parseContext.allowComment;
            C arrayNode = new C(charSource, buf, fromIndex, this.parseContext, this.root);
            ArrayList<Object> list = null;
            if (createObj) {
                arrayNode.any = list = new ArrayList<Object>();
            }
            for (int i = beginIndex; i < toIndex; ++i) {
                boolean isEnd;
                JSONNode node;
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    this.parseContext.endIndex = i++;
                    arrayNode.endIndex = i;
                    ((JSONNode)arrayNode).updateArray(elementValues, elementSize);
                    return arrayNode;
                }
                try {
                    node = this.parseValueNode(i, ']', false, createObj);
                    node.parent = arrayNode;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                node.path = Integer.valueOf(elementSize);
                if (elementSize >= elementValues.length) {
                    elementValues = Arrays.copyOf(elementValues, elementValues.length << 1);
                }
                elementValues[elementSize++] = node;
                if (createObj) {
                    list.add(node.any());
                }
                while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = buf[i];
                }
                boolean bl = isEnd = ch == ']';
                if (ch == ',' || isEnd) {
                    if (!isEnd) continue;
                    this.parseContext.endIndex = i++;
                    arrayNode.endIndex = i;
                    ((JSONNode)arrayNode).updateArray(elementValues, elementSize);
                    return arrayNode;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", missing ',' or '}'");
            }
            throw new JSONException("Syntax error, the closing symbol ']' is not found ");
        }

        @Override
        JSONNode parseValueNode(int beginIndex, char endChar, boolean lazy, boolean createObj) throws Exception {
            JSONNode node;
            char ch = this.buf[beginIndex];
            switch (ch) {
                case '{': {
                    if (lazy) {
                        JSONTypeDeserializer.MAP.skip(this.charSource, this.buf, beginIndex, (JSONParseContext)this.parseContext);
                        node = new C(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 1, this.parseContext, this.root);
                        break;
                    }
                    node = this.completeObjectNode(this.charSource, this.buf, beginIndex, createObj);
                    break;
                }
                case '[': {
                    if (lazy) {
                        JSONTypeDeserializer.COLLECTION.skip(this.charSource, this.buf, beginIndex, (JSONParseContext)this.parseContext);
                        node = new C(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 2, this.parseContext, this.root);
                        break;
                    }
                    node = this.completeArrayNode(this.charSource, this.buf, beginIndex, createObj);
                    break;
                }
                case '\"': 
                case '\'': {
                    node = JSONNode.parseStringPathNode(this.charSource, this.buf, beginIndex, this.endIndex, ch, false, this.parseContext, this.root);
                    break;
                }
                case 'n': {
                    node = C.parseNullPathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                case 't': {
                    node = C.parseBoolTruePathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                case 'f': {
                    node = C.parseBoolFalsePathNode(this.charSource, this.buf, beginIndex, this.parseContext, this.root);
                    break;
                }
                default: {
                    node = C.parseNumberPathNode(this.charSource, this.buf, beginIndex, endChar, false, this.parseContext, this.root);
                }
            }
            node.parent = this;
            return node;
        }

        @Override
        JSONNode parseArrayAt(int index, boolean lazy, boolean createObj) {
            boolean allowComment = this.parseContext.allowComment;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isEnd;
                JSONNode node;
                char ch;
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch == ']') {
                    this.offset = i;
                    this.completed = true;
                    return null;
                }
                boolean matchedIndex = index > -1 && index == this.elementSize;
                try {
                    node = this.parseValueNode(i, ']', lazy, createObj);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = JSONGeneral.clearCommentAndWhiteSpaces(this.buf, i + 1, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl = isEnd = ch == ']';
                if (ch == ',' || isEnd) {
                    this.addElementNode(node);
                    if (isEnd) {
                        this.completed = true;
                    }
                    if (!matchedIndex) continue;
                    return node;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", missing ',' or '}'");
            }
            return null;
        }

        @Override
        protected void clearSource() {
            this.buf = null;
            this.charSource = null;
        }
    }

    static final class D
    extends JSONNode {
        D(Serializable value, JSONNode root) {
            super(value, root);
        }
    }

    static final class RootContext {
        final int beginIndex;
        final int endIndex;
        final int type;
        Serializable leafValue;

        public RootContext(int beginIndex, int endIndex, int type, Serializable leafValue) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.type = type;
            this.leafValue = leafValue;
        }
    }
}

