/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONKeyValueMap;
import io.github.wycst.wast.json.JSONNode;
import io.github.wycst.wast.json.JSONNodeCollector;
import io.github.wycst.wast.json.JSONParseContext;
import java.util.ArrayList;
import java.util.List;

public final class JSONNodeContext
extends JSONParseContext {
    public boolean extract;
    public List extractValues;
    JSONNodeCollector collector;
    private JSONKeyValueMap<String> KEY_32_TABLE;
    static final JSONKeyValueMap<String> GLOBAL_KEY_8_TABLE = new JSONKeyValueMap(2048);

    JSONNodeContext() {
        this.allowLastEndComma = true;
        this.allowSingleQuotes = true;
        this.allowUnquotedFieldNames = true;
    }

    @Override
    JSONCharArrayWriter getContextWriter() {
        if (this.writer == null) {
            this.writer = new JSONCharArrayWriter(256);
        } else {
            this.writer.clear();
        }
        return this.writer;
    }

    static String getString(char[] chars, int offset, int len) {
        if (len <= 8) {
            long h = 0L;
            for (int i = 0; i < len; ++i) {
                char c = chars[offset + i];
                if (c > '\u00ff') {
                    return new String(chars, offset, len);
                }
                h = h << 8 | (long)c;
            }
            String val = GLOBAL_KEY_8_TABLE.getValueByHash(h);
            if (val == null) {
                val = new String(chars, offset, len);
                GLOBAL_KEY_8_TABLE.putExactHashValue(h, val);
            }
            return val;
        }
        return new String(chars, offset, len);
    }

    void extractValue(JSONNode value) {
        if (this.collector.filter(value)) {
            this.extractValues.add(this.collector.map(value));
        }
    }

    void enableExtract(JSONNodeCollector nodeCollector) {
        this.collector = nodeCollector;
        this.extract = true;
        this.extractValues = new ArrayList();
    }

    public void reset() {
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCacheKeys() {
        JSONKeyValueMap<String> jSONKeyValueMap = GLOBAL_KEY_8_TABLE;
        synchronized (jSONKeyValueMap) {
            GLOBAL_KEY_8_TABLE.reset();
        }
    }

    @Override
    protected JSONKeyValueMap<String> getTable32() {
        if (this.KEY_32_TABLE == null) {
            this.KEY_32_TABLE = new JSONKeyValueMap(128, new JSONKeyValueMap.EntryNode[128]);
        }
        return this.KEY_32_TABLE;
    }

    @Override
    protected JSONKeyValueMap<String> getTable8() {
        return GLOBAL_KEY_8_TABLE;
    }
}

