/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.json.JSONNode;
import io.github.wycst.wast.json.JSONNodeCollector;
import io.github.wycst.wast.json.JSONNodePathCtx;
import io.github.wycst.wast.json.JSONNodePathFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class JSONNodePathCollector {
    protected Serializable path;
    protected boolean recursive;
    JSONNodePathCollector next;
    JSONNodePathFilter filter;

    public JSONNodePathCollector() {
        this(null);
    }

    public JSONNodePathCollector(Serializable path) {
        this.path = path;
    }

    final JSONNodePathCollector self() {
        return this;
    }

    final boolean isSupportedExtract() {
        return !this.recursive && this.filter == null;
    }

    public final JSONNodePathCollector recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public final JSONNodePathCollector filter(JSONNodePathFilter filter) {
        this.filter = filter;
        return this;
    }

    public static final JSONNodePathCollector filter(String condition) {
        return JSONNodePathCollector.any().filter(JSONNodePathFilter.condition(condition));
    }

    public final JSONNodePathCollector condition(String condition) {
        return this.filter(JSONNodePathFilter.condition(condition));
    }

    public final JSONNodePathCollector condition(Expression expression) {
        return this.filter(JSONNodePathFilter.expression(expression));
    }

    public final boolean leafPath() {
        return this.next == null;
    }

    protected abstract boolean matched(int var1, int var2, JSONNode var3);

    protected abstract boolean matched(String var1, JSONNode var2);

    protected final boolean doFilter(JSONNode target) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.doFilter(target);
    }

    final <T> void addIfRecord(JSONNode node, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCtx) {
        if (node.collectCtx != collectCtx && collector.filter(node)) {
            node.collectCtx = collectCtx;
            results.add(collector.map(node));
        }
    }

    protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
        if (parentNode.leaf) {
            return;
        }
        parentNode.ensureCompleted(!this.recursive);
        boolean leafPath = this.leafPath();
        if (parentNode.array) {
            int size = parentNode.elementSize;
            for (int i = 0; i < size; ++i) {
                JSONNode value = parentNode.elementValues[i];
                if (this.matched(i, size, value) && this.doFilter(value)) {
                    if (leafPath) {
                        this.addIfRecord(value, results, collector, collectCx);
                    } else {
                        this.next.collect(value, results, collector, collectCx);
                    }
                }
                if (!this.recursive) continue;
                this.collect(value, results, collector, collectCx);
            }
        } else {
            Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
            Set<Map.Entry<Serializable, JSONNode>> entrySet = fieldValues.entrySet();
            for (Map.Entry<Serializable, JSONNode> entry : entrySet) {
                JSONNode value;
                String field = (String)((Object)entry.getKey());
                if (this.matched(field, value = entry.getValue()) && this.doFilter(value)) {
                    if (leafPath) {
                        this.addIfRecord(value, results, collector, collectCx);
                    } else {
                        this.next.collect(value, results, collector, collectCx);
                    }
                }
                if (!this.recursive) continue;
                this.collect(value, results, collector, collectCx);
            }
        }
    }

    JSONNodePathCollector cloneCurrent() {
        return this;
    }

    public final JSONNodePathCollector clone() {
        JSONNodePathCollector pathCollector = this.cloneCurrent();
        pathCollector.recursive = this.recursive;
        pathCollector.filter = this.filter;
        return pathCollector;
    }

    final JSONNodePathCollector chainable(JSONNodePathCollector prev) {
        JSONNodePathCollector cloneFragment;
        prev.next = cloneFragment = this.clone();
        return prev;
    }

    public final String toString() {
        String result;
        String pathStr = this.toPathString();
        String string = result = this.recursive ? "//" + pathStr : "/" + pathStr;
        if (this.filter != null) {
            result = result + this.filter.toString();
        }
        return result;
    }

    protected String toPathString() {
        return "";
    }

    protected int matchedObjectField(String key) {
        return -1;
    }

    protected boolean preparedSize() {
        return false;
    }

    protected int matchedArrayIndex(int index, int size) {
        return -1;
    }

    public static final JSONNodePathCollector any() {
        return new AnyPathImpl();
    }

    public static final JSONNodePathCollector exact(Serializable path) {
        return new ExactImpl(path);
    }

    public static final JSONNodePathCollector prefix(Serializable path) {
        return new PrefixImpl(path);
    }

    public static final JSONNodePathCollector suffix(Serializable path) {
        return new SuffixImpl(path);
    }

    public static final JSONNodePathCollector contains(Serializable path) {
        return new ContainsImpl(path);
    }

    public static final JSONNodePathCollector regular(String path) {
        return new RegularImpl(path);
    }

    public static final JSONNodePathCollector ge(int index) {
        return new GEImpl(index);
    }

    public static final JSONNodePathCollector le(int index) {
        return new LEImpl(index);
    }

    public static final JSONNodePathCollector range(int from, int to) {
        return new RangeImpl(from, to);
    }

    public static final JSONNodePathCollector indexs(Integer ... indexs) {
        return new DiscreteIndexImpl(indexs);
    }

    static final class DiscreteIndexImpl
    extends PathInternalImpl {
        final Integer[] indexs;
        final boolean preparedSize;
        final int maxPositiveIndex;

        public DiscreteIndexImpl(Integer[] indexs) {
            this.indexs = indexs;
            boolean preparedSize = false;
            int maxIndex = 0;
            for (Integer index : indexs) {
                if (index < 0) {
                    preparedSize = true;
                    continue;
                }
                maxIndex = Math.max(maxIndex, index);
            }
            this.preparedSize = preparedSize;
            this.maxPositiveIndex = maxIndex;
        }

        @Override
        protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
            if (parentNode.leaf) {
                return;
            }
            boolean leafPath = this.leafPath();
            if (this.recursive) {
                parentNode.ensureCompleted(false);
                if (parentNode.array) {
                    int size = parentNode.elementSize;
                    for (int i = 0; i < size; ++i) {
                        JSONNode value = parentNode.elementValues[i];
                        if (this.matched(i, size) && this.doFilter(value)) {
                            if (leafPath) {
                                this.addIfRecord(value, results, collector, collectCx);
                            } else {
                                this.next.collect(value, results, collector, collectCx);
                            }
                            if (!collectCx.greedy) continue;
                        }
                        this.collect(value, results, collector, collectCx);
                    }
                } else {
                    Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
                    for (JSONNode value : fieldValues.values()) {
                        this.collect(value, results, collector, collectCx);
                    }
                }
            } else {
                for (Integer index : this.indexs) {
                    JSONNode value = parentNode.getElementAt(index);
                    if (value == null) continue;
                    if (leafPath) {
                        this.addIfRecord(value, results, collector, collectCx);
                        continue;
                    }
                    this.next.collect(value, results, collector, collectCx);
                }
            }
        }

        protected boolean matched(int i, int size) {
            for (Integer index : this.indexs) {
                if (index != i && index + size != i) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            if (!this.preparedSize && index == this.maxPositiveIndex) {
                return 1;
            }
            return this.matched(index, size) ? 0 : -1;
        }

        @Override
        protected boolean preparedSize() {
            return this.preparedSize;
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new DiscreteIndexImpl(this.indexs);
        }

        @Override
        protected String toPathString() {
            return '[' + StringUtils.join(",", this.indexs) + ']';
        }
    }

    static final class RangeImpl
    extends ArrayNodeImpl {
        final int from;
        final int to;
        final boolean preparedSize;

        public RangeImpl(int from, int to) {
            this.from = from;
            this.to = to;
            this.preparedSize = from < 0 || to < 0;
        }

        @Override
        public int from(int size) {
            if (this.from < 0) {
                return Math.max(this.from + size, 0);
            }
            return this.from;
        }

        @Override
        public int to(int size) {
            if (this.to < 0) {
                return this.to + size + 1;
            }
            return Math.min(this.to + 1, size);
        }

        @Override
        protected boolean matched(int index, int size) {
            int startIndex = this.from < 0 ? this.from + size : this.from;
            int endIndex = this.to < 0 ? this.to + size : this.to;
            return index >= startIndex && index <= endIndex;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            boolean rec;
            int startIndex = this.from < 0 ? this.from + size : this.from;
            int endIndex = this.to < 0 ? this.to + size : this.to;
            boolean bl = rec = index >= startIndex && index <= endIndex;
            if (rec) {
                return index == endIndex ? 1 : 0;
            }
            return -1;
        }

        @Override
        protected boolean preparedSize() {
            return this.preparedSize;
        }

        @Override
        public void parse(JSONNode parentNode) {
            parentNode.parseElementTo(this.to < 0 ? -1 : this.to);
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new RangeImpl(this.from, this.to);
        }

        @Override
        protected String toPathString() {
            return this.from + "~" + this.to;
        }
    }

    static final class LEImpl
    extends ArrayNodeImpl {
        final int maxIndexValue;
        final boolean preparedSize;

        public LEImpl(int maxIndexValue) {
            this.maxIndexValue = maxIndexValue;
            this.preparedSize = maxIndexValue < 0;
        }

        @Override
        public int to(int size) {
            return this.maxIndexValue < 0 ? this.maxIndexValue + size + 1 : Math.min(this.maxIndexValue + 1, size);
        }

        @Override
        protected boolean preparedSize() {
            return this.preparedSize;
        }

        @Override
        protected boolean matched(int index, int size) {
            int targetIndex = this.maxIndexValue;
            if (targetIndex < 0) {
                targetIndex += size;
            }
            return index <= targetIndex;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            int mv;
            int n = mv = this.maxIndexValue > 0 ? this.maxIndexValue : this.maxIndexValue + size;
            if (index == mv) {
                return 1;
            }
            return index < this.maxIndexValue ? 0 : -1;
        }

        @Override
        public void parse(JSONNode parentNode) {
            parentNode.parseElementTo(this.maxIndexValue);
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new LEImpl(this.maxIndexValue);
        }

        @Override
        protected String toPathString() {
            return String.valueOf(this.maxIndexValue) + '-';
        }
    }

    static final class GEImpl
    extends ArrayNodeImpl {
        final int minIndexValue;
        final boolean preparedSize;

        public GEImpl(int minIndexValue) {
            this.minIndexValue = minIndexValue;
            this.preparedSize = minIndexValue < 0;
        }

        @Override
        public int from(int size) {
            return this.minIndexValue < 0 ? Math.max(this.minIndexValue + size, 0) : this.minIndexValue;
        }

        @Override
        protected boolean matched(int index, int size) {
            int targetIndex = this.minIndexValue < 0 ? this.minIndexValue + size : this.minIndexValue;
            return index >= targetIndex;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            return this.matched(index, size) ? 0 : -1;
        }

        @Override
        protected boolean preparedSize() {
            return this.preparedSize;
        }

        @Override
        public void parse(JSONNode parentNode) {
            parentNode.parseElementTo(-1);
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new GEImpl(this.minIndexValue);
        }

        @Override
        protected String toPathString() {
            return String.valueOf(this.minIndexValue) + '+';
        }
    }

    static final class RegularImpl
    extends ObjectNodeImpl {
        final Pattern pattern;

        public RegularImpl(String path) {
            this(Pattern.compile(path), (Serializable)((Object)path));
        }

        RegularImpl(Pattern pattern, Serializable path) {
            super(path);
            this.pattern = pattern;
        }

        @Override
        protected boolean matched(String field, String path) {
            try {
                return this.pattern.matcher(field).matches();
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @Override
        protected int matchedObjectField(String key) {
            try {
                return this.pattern.matcher(key).matches() ? 0 : -1;
            }
            catch (Throwable throwable) {
                return -1;
            }
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new RegularImpl(this.pattern, this.path);
        }

        @Override
        protected String toPathString() {
            return '(' + String.valueOf(this.path) + ')';
        }
    }

    static final class ContainsImpl
    extends ObjectNodeImpl {
        public ContainsImpl(Serializable path) {
            super(path);
        }

        @Override
        protected boolean matched(String field, String path) {
            return field.contains(path);
        }

        @Override
        protected int matchedObjectField(String key) {
            return key.contains((String)((Object)this.path)) ? 0 : -1;
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new ContainsImpl(this.path);
        }

        @Override
        protected String toPathString() {
            return "*" + this.path + "*";
        }
    }

    static final class SuffixImpl
    extends ObjectNodeImpl {
        public SuffixImpl(Serializable path) {
            super(path);
        }

        @Override
        protected boolean matched(String field, String path) {
            return field.endsWith(path);
        }

        @Override
        protected int matchedObjectField(String key) {
            return key.endsWith((String)((Object)this.path)) ? 0 : -1;
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new SuffixImpl(this.path);
        }

        @Override
        protected String toPathString() {
            return "*" + this.path;
        }
    }

    static final class PrefixImpl
    extends ObjectNodeImpl {
        public PrefixImpl(Serializable path) {
            super(path);
        }

        @Override
        protected boolean matched(String field, String path) {
            return field.startsWith(path);
        }

        @Override
        protected int matchedObjectField(String key) {
            return key.startsWith((String)((Object)this.path)) ? 0 : -1;
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new PrefixImpl(this.path);
        }

        @Override
        protected String toPathString() {
            return this.path + "*";
        }
    }

    static abstract class ArrayNodeImpl
    extends PathInternalImpl {
        ArrayNodeImpl() {
        }

        public abstract void parse(JSONNode var1);

        public int from(int size) {
            return 0;
        }

        public int to(int size) {
            return size;
        }

        protected abstract boolean matched(int var1, int var2);

        @Override
        protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
            block11: {
                block10: {
                    if (parentNode.leaf) {
                        return;
                    }
                    boolean leafPath = this.leafPath();
                    if (!parentNode.array) break block10;
                    if (this.recursive) {
                        parentNode.ensureCompleted(false);
                        int size = parentNode.elementSize;
                        for (int i = 0; i < size; ++i) {
                            JSONNode value = parentNode.elementValues[i];
                            if (this.matched(i, size) && this.doFilter(value)) {
                                if (leafPath) {
                                    this.addIfRecord(value, results, collector, collectCx);
                                } else {
                                    this.next.collect(value, results, collector, collectCx);
                                }
                                if (!collectCx.greedy) continue;
                            }
                            this.collect(value, results, collector, collectCx);
                        }
                    } else {
                        this.parse(parentNode);
                        int size = parentNode.elementSize;
                        int to = this.to(size);
                        for (int i = this.from(size); i < to; ++i) {
                            JSONNode value = parentNode.elementValues[i];
                            if (!this.matched(i, size) || !this.doFilter(value)) continue;
                            if (leafPath) {
                                this.addIfRecord(value, results, collector, collectCx);
                                continue;
                            }
                            this.next.collect(value, results, collector, collectCx);
                        }
                    }
                    break block11;
                }
                if (!this.recursive) break block11;
                parentNode.ensureCompleted(false);
                Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
                for (JSONNode value : fieldValues.values()) {
                    this.collect(value, results, collector, collectCx);
                }
            }
        }
    }

    static abstract class ObjectNodeImpl
    extends PathInternalImpl {
        public ObjectNodeImpl(Serializable path) {
            super(path);
        }

        protected abstract boolean matched(String var1, String var2);

        @Override
        protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
            block7: {
                block6: {
                    if (parentNode.leaf) {
                        return;
                    }
                    String str = this.path.toString().trim();
                    boolean leafPath = this.leafPath();
                    if (!parentNode.isObject()) break block6;
                    parentNode.ensureCompleted(!this.recursive);
                    Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
                    Set<Map.Entry<Serializable, JSONNode>> entrySet = fieldValues.entrySet();
                    for (Map.Entry<Serializable, JSONNode> entry : entrySet) {
                        String field = entry.getKey().toString();
                        JSONNode value = entry.getValue();
                        if (this.matched(field, str) && this.doFilter(value)) {
                            if (leafPath) {
                                this.addIfRecord(value, results, collector, collectCx);
                            } else {
                                this.next.collect(value, results, collector, collectCx);
                            }
                            if (!collectCx.greedy) continue;
                        }
                        if (!this.recursive) continue;
                        this.collect(value, results, collector, collectCx);
                    }
                    break block7;
                }
                if (!this.recursive) break block7;
                parentNode.ensureCompleted(false);
                int size = parentNode.elementSize;
                for (int i = 0; i < size; ++i) {
                    JSONNode value = parentNode.elementValues[i];
                    this.collect(value, results, collector, collectCx);
                }
            }
        }
    }

    static final class ExactImpl
    extends PathInternalImpl {
        final boolean preparedSize;

        public ExactImpl(Serializable path) {
            super(path);
            this.preparedSize = path instanceof Integer && (Integer)path < 0;
        }

        @Override
        protected int matchedObjectField(String key) {
            return this.path.toString().equals(key) ? 1 : -1;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            if (this.path instanceof Integer) {
                int val = (Integer)this.path;
                if (val < 0) {
                    val += size;
                }
                return val == index ? 1 : -1;
            }
            return -1;
        }

        @Override
        protected boolean preparedSize() {
            return this.preparedSize;
        }

        @Override
        protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
            if (parentNode.leaf) {
                return;
            }
            boolean leafPath = this.leafPath();
            if (this.recursive) {
                parentNode.ensureCompleted(false, false);
                if (parentNode.array) {
                    int index;
                    int size = parentNode.elementSize;
                    int n = index = this.path instanceof Integer ? (Integer)this.path : size;
                    if (index < 0) {
                        index += size;
                    }
                    for (int i = 0; i < size; ++i) {
                        JSONNode value = parentNode.elementValues[i];
                        if (i == index && this.doFilter(value)) {
                            if (leafPath) {
                                this.addIfRecord(value, results, collector, collectCx);
                            } else {
                                this.next.collect(value, results, collector, collectCx);
                            }
                            if (!collectCx.greedy) continue;
                        }
                        this.collect(value, results, collector, collectCx);
                    }
                } else {
                    Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
                    Set<Map.Entry<Serializable, JSONNode>> entrySet = fieldValues.entrySet();
                    for (Map.Entry<Serializable, JSONNode> entry : entrySet) {
                        String field = (String)((Object)entry.getKey());
                        JSONNode value = entry.getValue();
                        if (field.equals(this.path.toString()) && this.doFilter(value)) {
                            if (leafPath) {
                                this.addIfRecord(value, results, collector, collectCx);
                            } else {
                                this.next.collect(value, results, collector, collectCx);
                            }
                            if (!collectCx.greedy) continue;
                        }
                        this.collect(value, results, collector, collectCx);
                    }
                }
            } else {
                JSONNode target;
                if (parentNode.array) {
                    if (!(this.path instanceof Integer)) {
                        return;
                    }
                    int index = (Integer)this.path;
                    if (index < 0) {
                        parentNode.ensureCompleted(true);
                        index += parentNode.elementSize;
                    }
                    target = parentNode.getElementAt(index);
                } else {
                    target = parentNode.getFieldNodeAt(this.path.toString());
                }
                if (target == null) {
                    return;
                }
                if (this.doFilter(target)) {
                    if (leafPath) {
                        this.addIfRecord(target, results, collector, collectCx);
                    } else {
                        this.next.collect(target, results, collector, collectCx);
                    }
                }
            }
        }

        @Override
        protected String toPathString() {
            return String.valueOf(this.path);
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new ExactImpl(this.path);
        }
    }

    static final class AnyPathImpl
    extends PathInternalImpl {
        AnyPathImpl() {
        }

        @Override
        protected int matchedObjectField(String key) {
            return 0;
        }

        @Override
        protected int matchedArrayIndex(int index, int size) {
            return 0;
        }

        @Override
        protected <T> void collect(JSONNode parentNode, Collection<T> results, JSONNodeCollector<T> collector, JSONNodePathCtx collectCx) {
            if (parentNode.leaf) {
                return;
            }
            parentNode.ensureCompleted(!this.recursive);
            boolean leafPath = this.leafPath();
            if (parentNode.array) {
                int size = parentNode.elementSize;
                for (int i = 0; i < size; ++i) {
                    JSONNode value = parentNode.elementValues[i];
                    if (this.doFilter(value)) {
                        if (leafPath) {
                            this.addIfRecord(value, results, collector, collectCx);
                            if (!this.recursive) continue;
                            this.collect(value, results, collector, collectCx);
                            continue;
                        }
                        this.next.collect(value, results, collector, collectCx);
                        continue;
                    }
                    if (!this.recursive) continue;
                    this.collect(value, results, collector, collectCx);
                }
            } else {
                Map<Serializable, JSONNode> fieldValues = parentNode.fieldValues;
                for (JSONNode value : fieldValues.values()) {
                    if (this.doFilter(value)) {
                        if (leafPath) {
                            this.addIfRecord(value, results, collector, collectCx);
                            if (!this.recursive) continue;
                            this.collect(value, results, collector, collectCx);
                            continue;
                        }
                        this.next.collect(value, results, collector, collectCx);
                        continue;
                    }
                    if (!this.recursive) continue;
                    this.collect(value, results, collector, collectCx);
                }
            }
        }

        @Override
        protected String toPathString() {
            return "*";
        }

        @Override
        JSONNodePathCollector cloneCurrent() {
            return new AnyPathImpl();
        }
    }

    static abstract class PathInternalImpl
    extends JSONNodePathCollector {
        public PathInternalImpl(Serializable path) {
            super(path);
        }

        public PathInternalImpl() {
        }

        @Override
        protected final boolean matched(int index, int size, JSONNode target) {
            return false;
        }

        @Override
        protected final boolean matched(String field, JSONNode target) {
            return false;
        }
    }
}

