/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONKeyValueMap;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.options.ReadOption;

public class JSONParseContext {
    public int endIndex;
    int endToken;
    JSONCharArrayWriter writer;
    public boolean byteArrayFromHexString;
    public boolean unknownEnumAsNull;
    public boolean allowSingleQuotes;
    public boolean allowUnquotedFieldNames;
    public boolean allowComment;
    public boolean allowLastEndComma;
    public boolean useDefaultFieldInstance;
    public boolean useBigDecimalAsDefault;
    public boolean disableCacheMapKey;
    public boolean unMatchedEmptyAsNull;
    public boolean strictMode;
    int toIndex;
    boolean multiple;
    boolean escape = true;
    int escapeOffset = -1;
    private String[] strings;
    protected int elementSize;
    boolean validate;
    boolean validateFail;

    JSONParseContext() {
    }

    static JSONParseContext of(ReadOption[] readOptions) {
        JSONParseContext parseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, parseContext);
        return parseContext;
    }

    void setIgnoreEscapeCheck() {
        this.escape = false;
    }

    void setContextWriter(JSONCharArrayWriter writer) {
        this.writer = writer;
    }

    JSONCharArrayWriter getContextWriter() {
        if (this.writer != null) {
            this.writer.clear();
        }
        return this.writer;
    }

    String[] getContextStrings() {
        if (this.strings == null) {
            this.strings = new String[32];
        }
        return this.strings;
    }

    void clear() {
        if (this.writer != null) {
            this.writer.reset();
            this.writer = null;
        }
        this.strings = null;
    }

    final boolean checkEscapeBackslashJDK16(String input, int fromIndex, int endIndex) {
        if (!this.escape || endIndex < this.escapeOffset) {
            return false;
        }
        if (fromIndex > this.escapeOffset) {
            this.escapeOffset = input.indexOf(92, fromIndex);
            boolean bl = this.escape = this.escapeOffset > -1;
            if (!this.escape) {
                return false;
            }
        }
        return endIndex > this.escapeOffset;
    }

    final int getEscapeOffset() {
        return this.escapeOffset;
    }

    protected JSONKeyValueMap<String> getTable32() {
        return JSONGeneral.KEY_32_TABLE;
    }

    protected JSONKeyValueMap<String> getTable8() {
        return JSONGeneral.KEY_8_TABLE;
    }

    protected final String getCacheEightCharsKey(char[] buf, int offset, int len, long hashValue) {
        return JSONGeneral.getCacheEightCharsKey(buf, offset, len, hashValue, this.getTable8());
    }

    protected final String getCacheKey(char[] buf, int offset, int len, long hashValue) {
        return JSONGeneral.getCacheKey(buf, offset, len, hashValue, this.getTable32());
    }

    protected final String getCacheEightBytesKey(byte[] bytes, int offset, int len, long hashValue) {
        return JSONGeneral.getCacheEightBytesKey(bytes, offset, len, hashValue, this.getTable8());
    }

    protected final String getCacheKey(byte[] bytes, int offset, int len, long hashValue) {
        return JSONGeneral.getCacheKey(bytes, offset, len, hashValue, this.getTable32());
    }
}

