/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONReaderHook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class JSONReaderHookRegular
extends JSONReaderHook {
    private final String regular;
    final Pattern pattern;
    private final boolean onlyLeaf;

    public JSONReaderHookRegular(String regular) {
        this(regular, false);
    }

    public JSONReaderHookRegular(String regular, boolean onlyLeaf) {
        this.regular = regular;
        this.pattern = Pattern.compile(this.regular);
        this.onlyLeaf = onlyLeaf;
    }

    @Override
    protected Map createdMap(String path) {
        if (this.onlyLeaf || !this.pattern.matcher(path).matches()) {
            return null;
        }
        return new LinkedHashMap();
    }

    @Override
    protected Collection createdCollection(String path) {
        if (this.onlyLeaf || !this.pattern.matcher(path).matches()) {
            return null;
        }
        return new ArrayList();
    }

    @Override
    protected void parseValue(String key, Object value, Object host, int elementIndex, String path, int type) throws Exception {
        if (this.pattern.matcher(path).matches()) {
            this.results.add(value);
        }
        if (!this.onlyLeaf && host != null) {
            if (host instanceof Map) {
                ((Map)host).put(key, value);
            } else {
                ((List)host).add(value);
            }
        }
    }
}

