/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONImplInstCreator;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONPojoDeserializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.JSONTypeExtensionDesr;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONValueMatcher;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JSONTypeDeserializer
extends JSONGeneral {
    static final int LENGTH;
    static final JSONTypeDeserializer[] TYPE_DESERIALIZERS;
    static final CharSequenceImpl CHAR_SEQUENCE;
    protected static final CharSequenceImpl CHAR_SEQUENCE_STRING;
    protected static final NumberImpl NUMBER;
    protected static final NumberImpl.Skipper NUMBER_SKIPPER;
    protected static final NumberImpl NUMBER_LONG;
    protected static final NumberImpl NUMBER_INTEGER;
    protected static final NumberImpl NUMBER_SHORT;
    protected static final NumberImpl NUMBER_BYTE;
    protected static final NumberImpl NUMBER_FLOAT;
    protected static final NumberImpl NUMBER_DOUBLE;
    protected static final NumberImpl NUMBER_BIGDECIMAL;
    protected static final NumberImpl NUMBER_BIGINTEGER;
    protected static final BinaryImpl BINARY;
    protected static final ArrayImpl.IntArrayImpl INTEGER_ARRAY;
    static final BooleanImpl BOOLEAN;
    static final DateImpl DATE;
    protected static final ArrayImpl ARRAY;
    protected static final CollectionImpl COLLECTION;
    protected static final MapImpl MAP;
    protected static final ObjectImpl OBJECT;
    protected static final JSONTypeDeserializer ANY;
    protected static final SerializableImpl SERIALIZABLE_DESERIALIZER;
    private static final Map<Class<?>, JSONTypeDeserializer> classJSONTypeDeserializerMap;
    private static final Set<Class> REGISTERED_TYPES;
    private static final Map<String, Class<?>> classNameMapping;
    static final Set<Class<?>> BUILT_IN_TYPE_SET;

    static final boolean isBuiltInType(Class<?> type) {
        return BUILT_IN_TYPE_SET.contains(type);
    }

    static final void putTypeDeserializer(JSONTypeDeserializer typeDeserializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
        }
    }

    static final void registerTypeDeserializer(JSONTypeDeserializer typeDeserializer, Class type) {
        classJSONTypeDeserializerMap.put(type, typeDeserializer);
        REGISTERED_TYPES.add(type);
    }

    static final JSONTypeDeserializer checkSuperclassRegistered(Class<?> cls) {
        for (Class type : REGISTERED_TYPES) {
            if (!type.isAssignableFrom(cls)) continue;
            return classJSONTypeDeserializerMap.get(type);
        }
        return null;
    }

    static final JSONTypeDeserializer getCachedTypeDeserializer(Class type) {
        return classJSONTypeDeserializerMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final JSONTypeDeserializer getTypeDeserializer(Class type) {
        if (type == null) {
            return ANY;
        }
        JSONTypeDeserializer typeDeserializer = classJSONTypeDeserializerMap.get(type);
        if (typeDeserializer != null) {
            return typeDeserializer.ensureInitialized();
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(type);
        Class clazz = type;
        synchronized (clazz) {
            if (classJSONTypeDeserializerMap.containsKey(type)) {
                return classJSONTypeDeserializerMap.get(type).ensureInitialized();
            }
            switch (classCategory) {
                case ObjectCategory: {
                    typeDeserializer = JSONTypeDeserializer.createObjectDeserializer(type);
                    break;
                }
                case EnumCategory: {
                    typeDeserializer = JSONTypeDeserializer.createEnumDeserializer(type);
                    break;
                }
                case CollectionCategory: {
                    Class collectionClass = type;
                    GenericParameterizedType parameterizedType = GenericParameterizedType.collectionOf(collectionClass);
                    typeDeserializer = new CollectionImpl.CollectionInstanceImpl(parameterizedType);
                    break;
                }
                case MapCategory: {
                    Class mapClass = type;
                    GenericParameterizedType parameterizedType = GenericParameterizedType.mapOf(mapClass);
                    typeDeserializer = new MapInstanceImpl(parameterizedType);
                    break;
                }
                case NonInstance: {
                    typeDeserializer = new NonInstanceImpl(type);
                }
            }
            if (typeDeserializer == null) {
                typeDeserializer = JSONTypeDeserializer.checkSuperclassRegistered(type);
                if (typeDeserializer == null) {
                    typeDeserializer = TYPE_DESERIALIZERS[classCategory.ordinal()];
                }
                if (typeDeserializer == null) {
                    return null;
                }
            }
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
            typeDeserializer.ensureInitialized();
        }
        return typeDeserializer;
    }

    JSONTypeDeserializer ensureInitialized() {
        return this;
    }

    static final JSONTypeDeserializer createObjectDeserializer(Class type) {
        ClassStrucWrap classStrucWrap = ClassStrucWrap.get(type);
        if (classStrucWrap.isRecord()) {
            return new JSONPojoDeserializer.RecordImpl(JSONPojoStructure.get(type));
        }
        if (classStrucWrap.isTemporal()) {
            ClassStrucWrap.ClassWrapperType classWrapperType = classStrucWrap.getClassWrapperType();
            return JSONTemporalDeserializer.getTemporalDeserializerInstance(classWrapperType, GenericParameterizedType.actualType(type), null);
        }
        return new JSONPojoDeserializer(JSONPojoStructure.get(type));
    }

    static final JSONTypeDeserializer createEnumDeserializer(Class type) {
        Enum[] values = (Enum[])type.getEnumConstants();
        HashMap<String, Enum> enumValues = new HashMap<String, Enum>();
        for (Enum value : values) {
            String name = value.name();
            enumValues.put(name, value);
        }
        JSONValueMatcher<Enum> enumMatcher = JSONValueMatcher.build(enumValues);
        return new EnumImpl.EnumInstanceImpl(values, enumMatcher);
    }

    protected static final JSONTypeDeserializer getFieldDeserializer(GenericParameterizedType genericParameterizedType, JsonProperty property) {
        if (genericParameterizedType == null || genericParameterizedType.getActualType() == null) {
            return ANY;
        }
        ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
        switch (classCategory) {
            case CollectionCategory: {
                int collectionType = JSONTypeDeserializer.getCollectionType(genericParameterizedType.getActualType());
                switch (collectionType) {
                    case 1: {
                        return new CollectionImpl.ArrayListImpl(genericParameterizedType);
                    }
                    case 2: {
                        return new CollectionImpl.HashSetImpl(genericParameterizedType);
                    }
                }
                return new CollectionImpl.CollectionInstanceImpl(genericParameterizedType);
            }
            case DateCategory: {
                return property == null ? DATE : new DateImpl.DateInstanceImpl(genericParameterizedType, property);
            }
            case ObjectCategory: {
                ClassStrucWrap classStrucWrap = ClassStrucWrap.get(genericParameterizedType.getActualType());
                if (!classStrucWrap.isTemporal()) break;
                ClassStrucWrap.ClassWrapperType classWrapperType = classStrucWrap.getClassWrapperType();
                return JSONTemporalDeserializer.getTemporalDeserializerInstance(classWrapperType, genericParameterizedType, property);
            }
        }
        return JSONTypeDeserializer.getTypeDeserializer(genericParameterizedType.getActualType());
    }

    protected static final Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, parseContext);
    }

    protected static final Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, parseContext);
    }

    protected <T> GenericParameterizedType getGenericParameterizedType(Class<T> actualType) {
        return GenericParameterizedType.actualType(actualType);
    }

    void skip(CharSource charSource, char[] buf, int fromIndex, char endToken, JSONParseContext parseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    void skip(CharSource charSource, byte[] buf, int fromIndex, byte endToken, JSONParseContext parseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    boolean validate(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext parseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    boolean validate(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext parseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract Object deserialize(CharSource var1, char[] var2, int var3, GenericParameterizedType var4, Object var5, char var6, JSONParseContext var7) throws Exception;

    protected abstract Object deserialize(CharSource var1, byte[] var2, int var3, GenericParameterizedType var4, Object var5, byte var6, JSONParseContext var7) throws Exception;

    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        throw new JSONException("string value \"" + value + "\" is not supported " + actualType);
    }

    protected static final String parseObjectClassName(CharSource charSource, char[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
        char ch;
        int i = fromIndex + 1;
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (parseContext.allowComment && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            ch = buf[i];
        }
        boolean matched = false;
        if (ch == '\"') {
            if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\"') {
                matched = true;
                ++i;
            }
        } else {
            if (ch == '}') {
                return null;
            }
            if (ch == '\'') {
                if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\'') {
                    matched = true;
                    ++i;
                }
            } else if (parseContext.allowUnquotedFieldNames) {
                char atChar = buf[i++];
                char cChar = buf[i++];
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (atChar == '@' && cChar == 'c' && ch == ':') {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (parseContext.allowComment && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            ch = buf[i];
        }
        if (ch == ':') {
            Object value;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (parseContext.allowComment && ch == '/') {
                i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                ch = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, null, null, '}', parseContext)) instanceof String) {
                return ((String)value).trim();
            }
            return null;
        }
        String errorContextTextAt = JSONTypeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
    }

    protected static final String parseObjectClassName(CharSource charSource, byte[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
        byte b;
        int i = fromIndex + 1;
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (parseContext.allowComment && b == 47) {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            b = buf[i];
        }
        boolean matched = false;
        if (b == 34) {
            if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 34) {
                matched = true;
                ++i;
            }
        } else {
            if (b == 125) {
                return null;
            }
            if (b == 39) {
                if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 39) {
                    matched = true;
                    ++i;
                }
            } else if (parseContext.allowUnquotedFieldNames) {
                byte atChar = buf[i++];
                byte cChar = buf[i++];
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (atChar == 64 && cChar == 99 && b == 58) {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (parseContext.allowComment && b == 47) {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
            b = buf[i];
        }
        if (b == 58) {
            Object value;
            while ((b = buf[++i]) <= 32) {
            }
            if (parseContext.allowComment && b == 47) {
                i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                b = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, null, null, (byte)125, parseContext)) instanceof String) {
                return ((String)value).trim();
            }
            return null;
        }
        String errorContextTextAt = JSONTypeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
    }

    protected static final Class<?> getClassByName(String className) throws ClassNotFoundException {
        Class<?> cls = classNameMapping.get(className);
        if (cls != null) {
            return cls;
        }
        cls = Class.forName(className);
        classNameMapping.put(className, cls);
        return cls;
    }

    protected static final Object parseNull(byte[] bytes, int fromIndex, JSONParseContext parseContext) {
        int endIndex = fromIndex + 3;
        if (JSONUnsafe.getInt(bytes, fromIndex) == NULL_INT) {
            parseContext.endIndex = endIndex;
            return null;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return null;
        }
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(bytes, fromIndex, Math.min(parseContext.toIndex - fromIndex + 1, 4)) + "'");
    }

    protected static final Object parseNull(char[] buf, int fromIndex, JSONParseContext parseContext) {
        int endIndex = fromIndex + 3;
        if (JSONUnsafe.getLong(buf, fromIndex) == NULL_LONG) {
            parseContext.endIndex = endIndex;
            return null;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return null;
        }
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(buf, fromIndex, Math.min(parseContext.toIndex - fromIndex + 1, 4)) + "'");
    }

    protected static final boolean parseTrue(char[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
        int endIndex = fromIndex + 3;
        if (JSONUnsafe.getLong(buf, fromIndex) == TRUE_LONG) {
            parseContext.endIndex = endIndex;
            return true;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return false;
        }
        int len = Math.min(parseContext.toIndex - fromIndex + 1, 4);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(buf, fromIndex, len) + "'");
    }

    protected static final boolean parseFalse(char[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
        int endIndex = fromIndex + 4;
        if (JSONUnsafe.getLong(buf, fromIndex + 1) == ALSE_LONG) {
            parseContext.endIndex = endIndex;
            return false;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return false;
        }
        int len = Math.min(parseContext.toIndex - fromIndex + 1, 5);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(buf, fromIndex, len) + "'");
    }

    protected static final boolean parseTrue(byte[] bytes, int fromIndex, JSONParseContext parseContext) throws Exception {
        int endIndex = fromIndex + 3;
        if (JSONUnsafe.getInt(bytes, fromIndex) == TRUE_INT) {
            parseContext.endIndex = endIndex;
            return true;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return false;
        }
        int len = Math.min(parseContext.toIndex - fromIndex + 1, 4);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    protected static final boolean parseFalse(byte[] bytes, int fromIndex, JSONParseContext parseContext) throws Exception {
        int endIndex = fromIndex + 4;
        if (JSONUnsafe.getInt(bytes, fromIndex + 1) == ALSE_INT) {
            parseContext.endIndex = endIndex;
            return false;
        }
        if (parseContext.validate) {
            parseContext.validateFail = true;
            return false;
        }
        int len = Math.min(parseContext.toIndex - fromIndex + 1, 5);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    static String parseMapKey(byte[] bytes, int from, char endCh, JSONParseContext parseContext) {
        int beginIndex;
        int i = beginIndex = from + 1;
        JSONCharArrayWriter writer = null;
        boolean escape = false;
        while (true) {
            byte b;
            if ((b = bytes[i]) != 92 && b != endCh) {
                ++i;
                continue;
            }
            if (b != 92) break;
            if (writer == null) {
                writer = JSONTypeDeserializer.getContextWriter(parseContext);
            }
            escape = true;
            if (i > beginIndex) {
                writer.writeBytes(bytes, beginIndex, i - beginIndex);
            }
            i = beginIndex = JSONTypeDeserializer.escapeNextBytes(bytes, bytes[i + 1], i, writer);
        }
        parseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.writeBytes(bytes, beginIndex, len);
            return writer.toString();
        }
        return len == 0 ? "" : new String(bytes, beginIndex, len);
    }

    static String parseMapKeyByCache(byte[] bytes, int from, char endCh, JSONParseContext parseContext) {
        long hashValue;
        int beginIndex = from + 1;
        JSONCharArrayWriter writer = null;
        if (!parseContext.escape) {
            byte b1;
            byte b;
            int i = from;
            long hashValue2 = 92L;
            if ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                if ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                    hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                    while ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                        hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                    }
                }
            }
            if (b != endCh) {
                hashValue2 = hashValue2 << 8 | (long)b;
            }
            parseContext.endIndex = i;
            int len = i - beginIndex;
            if (len <= 8) {
                return parseContext.getCacheEightBytesKey(bytes, beginIndex, len, hashValue2);
            }
            return parseContext.getCacheKey(bytes, beginIndex, len, hashValue2);
        }
        int i = beginIndex;
        boolean escape = false;
        while (true) {
            byte b;
            hashValue = 92L;
            while ((b = bytes[i]) != 92 && b != endCh) {
                hashValue = hashValue << 8 | (long)b;
                ++i;
            }
            if (b != 92) break;
            if (writer == null) {
                writer = JSONTypeDeserializer.getContextWriter(parseContext);
            }
            escape = true;
            if (i > beginIndex) {
                writer.writeBytes(bytes, beginIndex, i - beginIndex);
            }
            i = beginIndex = JSONTypeDeserializer.escapeNextBytes(bytes, bytes[i + 1], i, writer);
        }
        parseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.writeBytes(bytes, beginIndex, len);
            return writer.toString();
        }
        if (len <= 8) {
            return parseContext.getCacheEightBytesKey(bytes, beginIndex, len, hashValue);
        }
        return parseContext.getCacheKey(bytes, beginIndex, len, hashValue);
    }

    static {
        CharSequenceImpl stringDeserializer;
        LENGTH = ReflectConsts.ClassCategory.values().length;
        TYPE_DESERIALIZERS = new JSONTypeDeserializer[LENGTH];
        CHAR_SEQUENCE = new CharSequenceImpl();
        NUMBER = new NumberImpl();
        NUMBER_SKIPPER = new NumberImpl.Skipper();
        NUMBER_LONG = new NumberImpl.LongImpl();
        NUMBER_INTEGER = new NumberImpl.IntegerImpl();
        NUMBER_SHORT = new NumberImpl.ShortImpl();
        NUMBER_BYTE = new NumberImpl.ByteImpl();
        NUMBER_FLOAT = new NumberImpl.FloatImpl();
        NUMBER_DOUBLE = new NumberImpl.DoubleImpl();
        NUMBER_BIGDECIMAL = new NumberImpl.BigDecimalImpl();
        NUMBER_BIGINTEGER = new NumberImpl.BigIntegerImpl();
        BINARY = new BinaryImpl();
        INTEGER_ARRAY = new ArrayImpl.IntArrayImpl();
        BOOLEAN = new BooleanImpl();
        DATE = new DateImpl();
        ARRAY = new ArrayImpl();
        COLLECTION = new CollectionImpl();
        MAP = new MapImpl();
        OBJECT = new ObjectImpl();
        ANY = new AnyImpl();
        SERIALIZABLE_DESERIALIZER = new SerializableImpl();
        classJSONTypeDeserializerMap = new ConcurrentHashMap(256);
        REGISTERED_TYPES = new HashSet<Class>();
        classNameMapping = new ConcurrentHashMap();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = CHAR_SEQUENCE;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = NUMBER;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = BOOLEAN;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = DATE;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassImpl();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = new EnumImpl();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationImpl();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = BINARY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = ARRAY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = COLLECTION;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = MAP;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = OBJECT;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = ANY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NonInstance.ordinal()] = null;
        JSONTypeDeserializer.putTypeDeserializer(BOOLEAN, Boolean.TYPE, Boolean.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_LONG, Long.TYPE, Long.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_INTEGER, Integer.TYPE, Integer.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_DOUBLE, Double.TYPE, Double.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_FLOAT, Float.TYPE, Float.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_SHORT, Short.TYPE, Short.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BYTE, Byte.TYPE, Byte.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BIGDECIMAL, BigDecimal.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BIGINTEGER, BigInteger.class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.StringArrayImpl(), String[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.DoubleArrayImpl(), Double[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.PrimitiveDoubleArrayImpl(), double[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.FloatArrayImpl(), Float[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.PrimitiveFloatArrayImpl(), float[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.LongArrayImpl(), Long[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.PrimitiveLongArrayImpl(), long[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.IntArrayImpl(), Integer[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.PrimitiveIntArrayImpl(), int[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayImpl.ByteArrayImpl(), Byte[].class);
        JSONTypeDeserializer.putTypeDeserializer(BINARY, byte[].class);
        if (EnvUtils.JDK_9_PLUS) {
            System.out.println("# wast_json supported_intrinsic_candidate -> " + SUPPORTED_INTRINSIC_CANDIDATE);
            stringDeserializer = SUPPORTED_INTRINSIC_CANDIDATE ? new CharSequenceImpl.StringJDK16PlusImpl() : new CharSequenceImpl.StringJDK9PlusImpl();
        } else {
            stringDeserializer = new CharSequenceImpl.StringJDK8Impl();
        }
        CHAR_SEQUENCE_STRING = stringDeserializer;
        JSONTypeDeserializer.putTypeDeserializer(CHAR_SEQUENCE_STRING, String.class, CharSequence.class);
        JSONTypeDeserializer.putTypeDeserializer(CHAR_SEQUENCE, StringBuilder.class, StringBuffer.class, char[].class);
        JSONTypeDeserializer.putTypeDeserializer(SERIALIZABLE_DESERIALIZER, Serializable.class);
        JSONTypeDeserializer.putTypeDeserializer(new CharSequenceImpl.CharImpl(), Character.TYPE, Character.class);
        MapImpl HASH_TABLE = MapImpl.hashtable();
        JSONTypeDeserializer.putTypeDeserializer(HASH_TABLE, Dictionary.class, Hashtable.class);
        JSONTypeDeserializer.putTypeDeserializer(MAP, Map.class, HashMap.class, LinkedHashMap.class);
        JSONTypeDeserializer.putTypeDeserializer(COLLECTION, List.class, Set.class);
        JSONTypeExtensionDesr.initExtens();
        BUILT_IN_TYPE_SET = new HashSet(classJSONTypeDeserializerMap.keySet());
    }

    static final class NonInstanceImpl
    extends JSONTypeDeserializer {
        final Class<?> baseClass;

        NonInstanceImpl(Class<?> baseClass) {
            this.baseClass = baseClass;
        }

        boolean isAvailableImpl(Class<?> cls) {
            return this.baseClass.isAssignableFrom(cls) && ReflectConsts.getClassCategory(cls) == ReflectConsts.ClassCategory.ObjectCategory;
        }

        JSONTypeDeserializer getJSONTypeDeserializer(String className) {
            if (className != null) {
                try {
                    Class<?> cls = NonInstanceImpl.getClassByName(className);
                    if (this.isAvailableImpl(cls)) {
                        return NonInstanceImpl.getTypeDeserializer(cls);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new JSONException(throwable.getMessage(), throwable);
                }
            }
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
            char ch;
            String className = NonInstanceImpl.parseObjectClassName(charSource, buf, fromIndex, parseContext);
            JSONPojoDeserializer deserializer = (JSONPojoDeserializer)this.getJSONTypeDeserializer(className);
            if (deserializer == null) {
                ANY.skip(charSource, buf, fromIndex, endToken, parseContext);
                return null;
            }
            int i = parseContext.endIndex;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (ch == ',') {
                return deserializer.deserializePojo(charSource, buf, i, parameterizedType, defaultValue, parseContext);
            }
            if (ch == '}') {
                parseContext.endIndex = i;
                return deserializer.pojo(deserializer.createPojo());
            }
            String errorContextTextAt = NonInstanceImpl.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            byte b;
            String className = NonInstanceImpl.parseObjectClassName(charSource, bytes, fromIndex, parseContext);
            JSONPojoDeserializer deserializer = (JSONPojoDeserializer)this.getJSONTypeDeserializer(className);
            if (deserializer == null) {
                ANY.skip(charSource, bytes, fromIndex, endToken, parseContext);
                return null;
            }
            int i = parseContext.endIndex;
            while ((b = bytes[++i]) <= 32) {
            }
            if (b == 44) {
                return deserializer.deserializePojo(charSource, bytes, i, parameterizedType, defaultValue, parseContext);
            }
            if (b == 125) {
                parseContext.endIndex = i;
                return deserializer.pojo(deserializer.createPojo());
            }
            String errorContextTextAt = NonInstanceImpl.createErrorContextText(bytes, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
        }
    }

    static final class SerializableImpl
    extends JSONTypeDeserializer {
        SerializableImpl() {
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, parseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, parseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }
    }

    static final class AnyImpl
    extends JSONTypeDeserializer {
        AnyImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value;
        }

        @Override
        boolean validate(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return MAP.validate(charSource, buf, fromIndex, toIndex, endToken, parseContext);
                }
                case '[': {
                    return COLLECTION.validate(charSource, buf, fromIndex, toIndex, endToken, parseContext);
                }
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, parseContext);
                    break;
                }
                case 'n': {
                    AnyImpl.parseNull(buf, fromIndex, parseContext);
                    break;
                }
                case 't': {
                    AnyImpl.parseTrue(buf, fromIndex, parseContext);
                    break;
                }
                case 'f': {
                    AnyImpl.parseFalse(buf, fromIndex, parseContext);
                    break;
                }
                default: {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                }
            }
            return !parseContext.validateFail;
        }

        @Override
        boolean validate(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 123: {
                    return MAP.validate(charSource, buf, fromIndex, toIndex, endToken, parseContext);
                }
                case 91: {
                    return COLLECTION.validate(charSource, buf, fromIndex, toIndex, endToken, parseContext);
                }
                case 34: 
                case 39: {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginByte, parseContext);
                    break;
                }
                case 110: {
                    AnyImpl.parseNull(buf, fromIndex, parseContext);
                    break;
                }
                case 116: {
                    AnyImpl.parseTrue(buf, fromIndex, parseContext);
                    break;
                }
                case 102: {
                    AnyImpl.parseFalse(buf, fromIndex, parseContext);
                    break;
                }
                default: {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                }
            }
            return !parseContext.validateFail;
        }

        @Override
        void skip(CharSource charSource, char[] buf, int fromIndex, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    MAP.skip(charSource, buf, fromIndex, parseContext);
                    break;
                }
                case '[': {
                    COLLECTION.skip(charSource, buf, fromIndex, parseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, parseContext);
                    break;
                }
                case 'n': {
                    AnyImpl.parseNull(buf, fromIndex, parseContext);
                    break;
                }
                case 't': {
                    AnyImpl.parseTrue(buf, fromIndex, parseContext);
                    break;
                }
                case 'f': {
                    AnyImpl.parseFalse(buf, fromIndex, parseContext);
                    break;
                }
                default: {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                }
            }
        }

        @Override
        void skip(CharSource charSource, byte[] buf, int fromIndex, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 123: {
                    MAP.skip(charSource, buf, fromIndex, parseContext);
                    break;
                }
                case 91: {
                    COLLECTION.skip(charSource, buf, fromIndex, parseContext);
                    break;
                }
                case 34: 
                case 39: {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginByte, parseContext);
                    break;
                }
                case 110: {
                    AnyImpl.parseNull(buf, fromIndex, parseContext);
                    break;
                }
                case 116: {
                    AnyImpl.parseTrue(buf, fromIndex, parseContext);
                    break;
                }
                case 102: {
                    AnyImpl.parseFalse(buf, fromIndex, parseContext);
                    break;
                }
                default: {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                }
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return JSONDefaultParser.parseJSONObject(charSource, buf, fromIndex, new LinkedHashMap(), parseContext);
                }
                case '[': {
                    return JSONDefaultParser.parseJSONArray(charSource, buf, fromIndex, new ArrayList(), parseContext);
                }
                case '\"': 
                case '\'': {
                    return CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, beginChar, GenericParameterizedType.StringType, parseContext);
                }
                case 'n': {
                    return AnyImpl.parseNull(buf, fromIndex, parseContext);
                }
                case 't': {
                    return AnyImpl.parseTrue(buf, fromIndex, parseContext);
                }
                case 'f': {
                    return AnyImpl.parseFalse(buf, fromIndex, parseContext);
                }
            }
            return NUMBER.deserialize(charSource, buf, fromIndex, parseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, endToken, parseContext);
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return JSONDefaultParser.parseJSONObject(charSource, buf, fromIndex, new LinkedHashMap(), parseContext);
                }
                case '[': {
                    return JSONDefaultParser.parseJSONArray(charSource, buf, fromIndex, new ArrayList(), parseContext);
                }
                case '\"': 
                case '\'': {
                    return CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, beginByte, GenericParameterizedType.StringType, parseContext);
                }
                case 'n': {
                    return AnyImpl.parseNull(buf, fromIndex, parseContext);
                }
                case 't': {
                    return AnyImpl.parseTrue(buf, fromIndex, parseContext);
                }
                case 'f': {
                    return AnyImpl.parseFalse(buf, fromIndex, parseContext);
                }
            }
            return NUMBER.deserialize(null, buf, fromIndex, GenericParameterizedType.AnyType, null, endToken, parseContext);
        }
    }

    static final class ObjectImpl
    extends JSONTypeDeserializer {
        ObjectImpl() {
        }

        Object deserializeObject(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            Class<?> clazz = genericParameterizedType.getActualType();
            JSONPojoDeserializer pojoDeserializer = (JSONPojoDeserializer)ObjectImpl.createObjectDeserializer(clazz);
            return pojoDeserializer.deserializePojo(charSource, buf, fromIndex, genericParameterizedType, instance, parseContext);
        }

        Object deserializeObject(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            Class<?> clazz = genericParameterizedType.getActualType();
            JSONPojoDeserializer pojoDeserializer = (JSONPojoDeserializer)ObjectImpl.createObjectDeserializer(clazz);
            return pojoDeserializer.deserializePojo(charSource, buf, fromIndex, genericParameterizedType, instance, parseContext);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType genericParameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, genericParameterizedType, instance, parseContext);
                }
                case 'n': {
                    return ObjectImpl.parseNull(buf, fromIndex, parseContext);
                }
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ObjectImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' , expected '{' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType genericParameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, genericParameterizedType, instance, parseContext);
                }
                case 'n': {
                    return ObjectImpl.parseNull(buf, fromIndex, parseContext);
                }
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ObjectImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' , expected '{' ");
        }
    }

    static final class MapInstanceImpl
    extends MapImpl {
        final GenericParameterizedType genericParameterizedType;
        final GenericParameterizedType valueParameterizedType;
        JSONTypeDeserializer valueDeserializer;

        @Override
        GenericParameterizedType getValueType(GenericParameterizedType parameterizedType) {
            return this.valueParameterizedType;
        }

        @Override
        protected <T> GenericParameterizedType getGenericParameterizedType(Class<T> actualType) {
            return this.genericParameterizedType;
        }

        @Override
        protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
            if (this.valueDeserializer == null) {
                this.valueDeserializer = this.valueParameterizedType == null ? ANY : MapInstanceImpl.getTypeDeserializer(this.valueParameterizedType.getActualType());
            }
            return this.valueDeserializer;
        }

        public MapInstanceImpl(GenericParameterizedType genericParameterizedType) {
            this.genericParameterizedType = genericParameterizedType;
            this.valueParameterizedType = genericParameterizedType.getValueType();
        }
    }

    static class MapImpl
    extends JSONTypeDeserializer {
        MapImpl() {
        }

        public static MapImpl hashtable() {
            return new MapImpl(){

                @Override
                Map createMap(GenericParameterizedType parameterizedType) {
                    return new Hashtable();
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean validate(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext parseContext) throws Exception {
            boolean empty = true;
            boolean allowComment = parseContext.allowComment;
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                boolean result;
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == '\"') {
                    CHAR_SEQUENCE.skip(charSource, buf, i, ch, parseContext);
                    i = parseContext.endIndex + 1;
                    empty = false;
                } else {
                    if (ch == '}') {
                        if (!empty && !parseContext.allowLastEndComma) {
                            return false;
                        }
                        parseContext.endIndex = i;
                        return true;
                    }
                    if (ch == '\'') {
                        if (!parseContext.allowSingleQuotes) return false;
                        CHAR_SEQUENCE.skip(charSource, buf, i, ch, parseContext);
                        i = parseContext.endIndex + 1;
                        empty = false;
                    } else {
                        if (!parseContext.allowUnquotedFieldNames) return false;
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch != ':') return false;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                }
                if (!(result = ANY.validate(charSource, buf, i, toIndex, '}', parseContext))) {
                    return false;
                }
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch != '}') return false;
                parseContext.endIndex = i;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean validate(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext parseContext) throws Exception {
            boolean empty = true;
            boolean allowComment = parseContext.allowComment;
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                boolean result;
                byte ch;
                while ((ch = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == 34) {
                    CHAR_SEQUENCE.skip(charSource, buf, i, ch, parseContext);
                    i = parseContext.endIndex + 1;
                    empty = false;
                } else {
                    if (ch == 125) {
                        if (!empty && !parseContext.allowLastEndComma) {
                            return false;
                        }
                        parseContext.endIndex = i;
                        return true;
                    }
                    if (ch == 39) {
                        if (!parseContext.allowSingleQuotes) return false;
                        CHAR_SEQUENCE.skip(charSource, buf, i, ch, parseContext);
                        i = parseContext.endIndex + 1;
                        empty = false;
                    } else {
                        if (!parseContext.allowUnquotedFieldNames) return false;
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                    }
                }
                while ((ch = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch != 58) return false;
                while ((ch = buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                }
                if (!(result = ANY.validate(charSource, buf, i, toIndex, (byte)125, parseContext))) {
                    return false;
                }
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == 44) continue;
                if (ch != 125) return false;
                parseContext.endIndex = i;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, char[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
            char ch;
            boolean empty = true;
            int toIndex = parseContext.toIndex;
            boolean allowComment = parseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == '\"') {
                    CHAR_SEQUENCE.skip(charSource, buf, i, '\"', parseContext);
                    i = parseContext.endIndex + 1;
                    empty = false;
                } else {
                    if (ch == '}') {
                        if (!empty && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return;
                    }
                    if (ch == '\'') {
                        if (!parseContext.allowSingleQuotes) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        CHAR_SEQUENCE.skip(charSource, buf, i, '\'', parseContext);
                        i = parseContext.endIndex + 1;
                        empty = false;
                    } else if (parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch != ':') {
                    String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                }
                ANY.skip(charSource, buf, i, '}', parseContext);
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch != ',') break;
                ++i;
            }
            if (ch == '}') {
                parseContext.endIndex = i;
                return;
            }
            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, byte[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
            byte b;
            boolean empty = true;
            int toIndex = parseContext.toIndex;
            boolean allowComment = parseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 34) {
                    CHAR_SEQUENCE.skip(charSource, buf, i, b, parseContext);
                    i = parseContext.endIndex + 1;
                    empty = false;
                } else {
                    if (b == 125) {
                        if (!empty && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return;
                    }
                    if (b == 39) {
                        if (!parseContext.allowSingleQuotes) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        CHAR_SEQUENCE.skip(charSource, buf, i, b, parseContext);
                        i = parseContext.endIndex + 1;
                        empty = false;
                    } else if (parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b != 58) {
                    String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
                }
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                }
                ANY.skip(charSource, buf, i, (byte)125, parseContext);
                i = parseContext.endIndex;
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b != 44) break;
                ++i;
            }
            if (b == 125) {
                parseContext.endIndex = i;
                return;
            }
            String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '{') {
                return this.deserializeMap(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginChar == 'n') {
                return MapImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = MapImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Map Type, expected '{' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            if (beginChar == '{') {
                return this.deserializeMap(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginChar == 'n') {
                return MapImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = MapImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Map Type, expected '{' ");
        }

        protected static Object mapKeyToType(Serializable mapKey, Class<?> keyType) {
            if (mapKey == null || keyType == null || keyType == String.class || keyType == CharSequence.class) {
                return mapKey;
            }
            Object key = ObjectUtils.toType(mapKey, keyType);
            if (key == null) {
                throw new UnsupportedOperationException("not supported type '" + keyType + "' as map key ");
            }
            return key;
        }

        Map createMap(GenericParameterizedType parameterizedType) {
            return MapImpl.createMapInstance(parameterizedType);
        }

        GenericParameterizedType getValueType(GenericParameterizedType parameterizedType) {
            return parameterizedType.getValueType();
        }

        JSONTypeDeserializer getValueDeserializer(GenericParameterizedType parameterizedType) {
            GenericParameterizedType valueType = parameterizedType.getValueType();
            return valueType == null ? ANY : MapImpl.getTypeDeserializer(valueType.getActualType());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext parseContext) throws Exception {
            Map instance = obj != null ? (Map)obj : this.createMap(parameterizedType);
            int toIndex = parseContext.toIndex;
            boolean empty = true;
            boolean disableCacheMapKey = parseContext.disableCacheMapKey;
            boolean allowComment = parseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                Object mapKey;
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    mapKey = disableCacheMapKey ? (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, i, '\"', GenericParameterizedType.StringType, parseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, '\"', parseContext);
                    i = parseContext.endIndex;
                    empty = false;
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty && !parseContext.allowLastEndComma) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return instance;
                    }
                    if (ch == '\'') {
                        if (!parseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                        }
                        empty = false;
                        mapKey = MapImpl.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                        mapKey = MapImpl.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ':') {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapImpl.mapKeyToType((Serializable)mapKey, mapKeyClass);
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                    JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(parameterizedType);
                    Object value = valueDeserializer.deserialize(charSource, buf, i, this.getValueType(parameterizedType), null, '}', parseContext);
                    instance.put(key, value);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        parseContext.endToken = 0;
                    }
                    if (ch != ',') {
                        if (ch == '}') {
                            parseContext.endIndex = i;
                            return instance;
                        }
                        String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
                    }
                } else {
                    String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
                }
                ++i;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext parseContext) throws Exception {
            Map instance = obj != null ? (Map)obj : MapImpl.createMapInstance(parameterizedType);
            int toIndex = parseContext.toIndex;
            boolean empty = true;
            boolean disableCacheMapKey = parseContext.disableCacheMapKey;
            boolean allowComment = parseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                Object mapKey;
                byte b;
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                int fieldKeyFrom = i;
                if (b == 34) {
                    mapKey = disableCacheMapKey ? MapImpl.parseMapKey(buf, i, '\"', parseContext) : MapImpl.parseMapKeyByCache(buf, i, '\"', parseContext);
                    i = parseContext.endIndex;
                    empty = false;
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty && !parseContext.allowLastEndComma) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return instance;
                    }
                    if (b == 39) {
                        if (!parseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != 39 || buf[i - 1] == 92)) {
                        }
                        empty = false;
                        mapKey = MapImpl.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                        mapKey = MapImpl.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (b == 110 && buf[i] == 117 && buf[++i] == 108 && buf[++i] == 108) {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = MapImpl.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 58) {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapImpl.mapKeyToType((Serializable)mapKey, mapKeyClass);
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                    Object value = this.getValueDeserializer(parameterizedType).deserialize(charSource, buf, i, this.getValueType(parameterizedType), null, (byte)125, parseContext);
                    instance.put(key, value);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = MapImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        parseContext.endToken = 0;
                    }
                    if (b != 44) {
                        if (b == 125) {
                            parseContext.endIndex = i;
                            return instance;
                        }
                        String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
                    }
                } else {
                    String errorContextTextAt = MapImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
                }
                ++i;
            }
        }
    }

    static class CollectionImpl
    extends JSONTypeDeserializer {
        CollectionImpl() {
        }

        @Override
        boolean validate(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext parseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = parseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (size > 0 && !parseContext.allowLastEndComma) {
                        return false;
                    }
                    parseContext.endIndex = i;
                    return true;
                }
                ++size;
                boolean validate = ANY.validate(charSource, buf, i, toIndex, ']', parseContext);
                if (!validate) {
                    return false;
                }
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch == ']') {
                    parseContext.endIndex = i;
                    parseContext.elementSize = size;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        boolean validate(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext parseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = parseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                byte ch;
                while ((ch = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == 93) {
                    if (size > 0 && !parseContext.allowLastEndComma) {
                        return false;
                    }
                    parseContext.endIndex = i;
                    return true;
                }
                ++size;
                boolean validate = ANY.validate(charSource, buf, i, toIndex, (byte)93, parseContext);
                if (!validate) {
                    return false;
                }
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == 44) continue;
                if (ch == 93) {
                    parseContext.endIndex = i;
                    parseContext.elementSize = size;
                    return true;
                }
                return false;
            }
            return false;
        }

        void skip(CharSource charSource, char[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int toIndex = parseContext.toIndex;
            int size = 0;
            boolean allowComment = parseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (size > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, ']', parseContext);
                i = parseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch == ']') {
                    parseContext.endIndex = i;
                    parseContext.elementSize = size;
                    return;
                }
                String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        void skip(CharSource charSource, byte[] buf, int fromIndex, JSONParseContext parseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            int toIndex = parseContext.toIndex;
            boolean allowComment = parseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (size > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, (byte)93, parseContext);
                i = parseContext.endIndex;
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 44) continue;
                if (b == 93) {
                    parseContext.endIndex = i;
                    parseContext.elementSize = size;
                    return;
                }
                String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
            Class<?> collectionCls = parameterizedType.getActualType();
            if (collectionCls == null || collectionCls == List.class || collectionCls == ArrayList.class) {
                return new ArrayList(5);
            }
            return CollectionImpl.createCollectionInstance(collectionCls);
        }

        protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
            return JSONTypeDeserializer.getTypeDeserializer(valueGenType.getActualType());
        }

        Collection deserializeCollection(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = parseContext.allowComment;
            int beginIndex = fromIndex + 1;
            char ch = '\u0000';
            int i = beginIndex;
            while (true) {
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, valueGenType, null, ']', parseContext);
                collection.add(value);
                i = parseContext.endIndex;
                int endChar = parseContext.endToken;
                if (endChar == 0) {
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                } else {
                    ch = (char)endChar;
                    parseContext.endToken = 0;
                }
                if (ch != ',') {
                    if (ch == ']') {
                        parseContext.endIndex = i;
                        return collection;
                    }
                    String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        Collection deserializeCollection(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = parseContext.allowComment;
            int beginIndex = fromIndex + 1;
            byte b = 0;
            int i = beginIndex;
            while (true) {
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, valueGenType, null, (byte)93, parseContext);
                collection.add(value);
                i = parseContext.endIndex;
                int endChar = parseContext.endToken;
                if (endChar == 0) {
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = CollectionImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                } else {
                    b = (byte)endChar;
                    parseContext.endToken = 0;
                }
                if (b != 44) {
                    if (b == 93) {
                        parseContext.endIndex = i;
                        return collection;
                    }
                    String errorContextTextAt = CollectionImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '[') {
                return this.deserializeCollection(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginChar == 'n') {
                return CollectionImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = CollectionImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + beginChar + "' for Collection Type ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 91) {
                return this.deserializeCollection(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginByte == 110) {
                return CollectionImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (parseContext.unMatchedEmptyAsNull && beginByte == 34 && buf[fromIndex + 1] == 34) {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = CollectionImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + (char)beginByte + "' for Collection Type ");
        }

        static final class HashSetImpl
        extends CollectionInstanceImpl {
            HashSetImpl(GenericParameterizedType genericParameterizedType) {
                super(genericParameterizedType);
            }

            @Override
            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                return new HashSet(5);
            }
        }

        static final class ArrayListImpl
        extends CollectionInstanceImpl {
            ArrayListImpl(GenericParameterizedType genericParameterizedType) {
                super(genericParameterizedType);
            }

            @Override
            Collection deserializeCollection(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                char ch;
                boolean allowComment = parseContext.allowComment;
                ArrayList<Object> collection = new ArrayList<Object>(5);
                int i = fromIndex;
                while (true) {
                    if ((ch = buf[++i]) <= ' ') {
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayListImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (collection.size() > 0 && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayListImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return collection;
                    }
                    Object value = this.valueDeserializer.deserialize(charSource, buf, i, this.valueType, null, ']', parseContext);
                    collection.add(value);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = ArrayListImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        parseContext.endToken = 0;
                    }
                    if (ch != ',') break;
                }
                if (ch == ']') {
                    parseContext.endIndex = i;
                    return collection;
                }
                String errorContextTextAt = ArrayListImpl.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
            }

            @Override
            Collection deserializeCollection(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                byte b;
                boolean allowComment = parseContext.allowComment;
                ArrayList<Object> collection = new ArrayList<Object>(5);
                int i = fromIndex;
                while (true) {
                    if ((b = buf[++i]) <= 32) {
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = ArrayListImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (!collection.isEmpty() && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayListImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return collection;
                    }
                    Object value = this.valueDeserializer.deserialize(charSource, buf, i, this.valueType, null, (byte)93, parseContext);
                    collection.add(value);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = ArrayListImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        parseContext.endToken = 0;
                    }
                    if (b != 44) break;
                }
                if (b == 93) {
                    parseContext.endIndex = i;
                    return collection;
                }
                String errorContextTextAt = ArrayListImpl.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
            }

            @Override
            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                return new ArrayList(5);
            }
        }

        static class CollectionInstanceImpl
        extends CollectionImpl {
            protected final GenericParameterizedType parameterizedType;
            protected final GenericParameterizedType valueType;
            protected final JSONTypeDeserializer valueDeserializer;
            private final Class<? extends Collection> constructionClass;

            CollectionInstanceImpl(GenericParameterizedType genericParameterizedType) {
                this.parameterizedType = genericParameterizedType;
                this.valueType = genericParameterizedType.getValueType();
                this.valueDeserializer = this.valueType == null ? ANY : CollectionInstanceImpl.getTypeDeserializer(this.valueType.getActualType());
                this.constructionClass = genericParameterizedType.getActualType();
            }

            @Override
            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                try {
                    Class<? extends Collection> targetClass = this.constructionClass;
                    if (targetClass.isInterface() || Modifier.isAbstract(targetClass.getModifiers())) {
                        JSONImplInstCreator implInstCreator = CollectionInstanceImpl.getJSONImplInstCreator(targetClass);
                        if (implInstCreator != null) {
                            return (Collection)implInstCreator.create(parameterizedType);
                        }
                        throw new JSONException("create instance error for " + targetClass);
                    }
                    return (Collection)UnsafeHelper.newInstance(targetClass);
                }
                catch (Throwable throwable) {
                    throw new JSONException("create instance error for " + parameterizedType.getActualType());
                }
            }

            @Override
            protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
                return this.valueDeserializer;
            }
        }
    }

    static class ArrayImpl
    extends JSONTypeDeserializer {
        ArrayImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return null;
        }

        Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            JSONTypeDeserializer valueDeserializer;
            Class<?> elementCls;
            int beginIndex = fromIndex + 1;
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
                valueDeserializer = ArrayImpl.getTypeDeserializer(elementCls);
            } else {
                elementCls = valueType.getActualType();
                valueDeserializer = ArrayImpl.getTypeDeserializer(elementCls);
            }
            ArrayList<Object> collection = new ArrayList<Object>(5);
            boolean allowComment = parseContext.allowComment;
            int i = beginIndex;
            while (true) {
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = ArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = ArrayImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return CollectionUtils.toArray(collection, elementCls);
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, valueType, null, ']', parseContext);
                collection.add(value);
                i = parseContext.endIndex;
                int endChar = parseContext.endToken;
                if (endChar == 0) {
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                } else {
                    ch = (char)endChar;
                    parseContext.endToken = 0;
                }
                if (ch != ',') {
                    if (ch == ']') {
                        parseContext.endIndex = i;
                        return CollectionUtils.toArray(collection, elementCls);
                    }
                    String errorContextTextAt = ArrayImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
            JSONTypeDeserializer valueDeserializer;
            Class<?> elementCls;
            int beginIndex = fromIndex + 1;
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
                valueDeserializer = ArrayImpl.getTypeDeserializer(elementCls);
            } else {
                elementCls = valueType.getActualType();
                valueDeserializer = ArrayImpl.getTypeDeserializer(elementCls);
            }
            ArrayList<Object> collection = new ArrayList<Object>(5);
            boolean allowComment = parseContext.allowComment;
            int i = beginIndex;
            while (true) {
                byte b;
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = ArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0 && !parseContext.allowLastEndComma) {
                        String errorContextTextAt = ArrayImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    parseContext.endIndex = i;
                    return CollectionUtils.toArray(collection, elementCls);
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, valueType, null, (byte)93, parseContext);
                collection.add(value);
                i = parseContext.endIndex;
                int endChar = parseContext.endToken;
                if (endChar == 0) {
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = ArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                } else {
                    b = (byte)endChar;
                    parseContext.endToken = 0;
                }
                if (b != 44) {
                    if (b == 93) {
                        parseContext.endIndex = i;
                        return CollectionUtils.toArray(collection, elementCls);
                    }
                    String errorContextTextAt = ArrayImpl.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '[') {
                return this.deserializeArray(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginChar == 'n') {
                return ArrayImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ArrayImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for collection type ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 91) {
                return this.deserializeArray(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
            }
            if (beginByte == 110) {
                return ArrayImpl.parseNull(buf, fromIndex, parseContext);
            }
            char beginChar = (char)beginByte;
            if (parseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                parseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ArrayImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Collection Type ");
        }

        static final class ByteArrayImpl
        extends ArrayInstanceImpl {
            ByteArrayImpl() {
            }

            @Override
            public Object empty() {
                return new Byte[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Byte[10];
            }

            @Override
            public int size(Object arr) {
                return ((Byte[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Byte[] value = (Byte[])arr;
                value[index] = (Byte)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Byte[] value = (Byte[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_BYTE;
            }
        }

        static final class PrimitiveIntArrayImpl
        extends ArrayInstanceImpl {
            PrimitiveIntArrayImpl() {
            }

            @Override
            public Object empty() {
                return EMPTY_INTS;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return INT_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((int[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                int[] value = (int[])arr;
                value[index] = (Integer)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                int[] value = (int[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_INTEGER;
            }
        }

        static final class IntArrayImpl
        extends ArrayInstanceImpl {
            IntArrayImpl() {
            }

            @Override
            public Object empty() {
                return new Integer[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Integer[10];
            }

            @Override
            public int size(Object arr) {
                return ((Integer[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Integer[] value = (Integer[])arr;
                value[index] = (Integer)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Integer[] value = (Integer[])arr;
                return Arrays.copyOf(value, len);
            }

            protected Integer[] deserialize(char[] chars, int offset, JSONParseContext parseContext) {
                try {
                    return (Integer[])this.deserializeArray(null, chars, offset, null, null, parseContext);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_INTEGER;
            }
        }

        static final class PrimitiveFloatArrayImpl
        extends ArrayInstanceImpl {
            PrimitiveFloatArrayImpl() {
            }

            @Override
            public Object empty() {
                return new float[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new float[10];
            }

            @Override
            public int size(Object arr) {
                return ((float[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                float[] value = (float[])arr;
                value[index] = ((Float)element).floatValue();
            }

            @Override
            public Object copyOf(Object arr, int len) {
                float[] value = (float[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_FLOAT;
            }
        }

        static final class FloatArrayImpl
        extends ArrayInstanceImpl {
            FloatArrayImpl() {
            }

            @Override
            public Object empty() {
                return new Float[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Float[10];
            }

            @Override
            public int size(Object arr) {
                return ((Float[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Float[] value = (Float[])arr;
                value[index] = (Float)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Float[] value = (Float[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_FLOAT;
            }
        }

        static final class PrimitiveLongArrayImpl
        extends ArrayInstanceImpl {
            PrimitiveLongArrayImpl() {
            }

            @Override
            public Object empty() {
                return EMPTY_LONGS;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return LONG_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((long[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                long[] value = (long[])arr;
                value[index] = (Long)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                long[] value = (long[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public Object subOf(Object arr, int len) {
                long[] value = (long[])arr;
                return JSONUnsafe.copyLongs(value, 0, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_LONG;
            }
        }

        static final class LongArrayImpl
        extends ArrayInstanceImpl {
            LongArrayImpl() {
            }

            @Override
            public Object empty() {
                return new Long[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Long[10];
            }

            @Override
            public int size(Object arr) {
                return ((Long[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Long[] value = (Long[])arr;
                value[index] = (Long)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Long[] value = (Long[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_LONG;
            }
        }

        static final class PrimitiveDoubleArrayImpl
        extends ArrayInstanceImpl {
            PrimitiveDoubleArrayImpl() {
            }

            @Override
            public Object empty() {
                return EMPTY_DOUBLES;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return DOUBLE_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((double[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                double[] value = (double[])arr;
                value[index] = (Double)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                double[] value = (double[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public Object subOf(Object arr, int len) {
                double[] value = (double[])arr;
                return JSONUnsafe.copyDoubles(value, 0, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_DOUBLE;
            }
        }

        static final class DoubleArrayImpl
        extends ArrayInstanceImpl {
            DoubleArrayImpl() {
            }

            @Override
            public Object empty() {
                return new Double[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Double[10];
            }

            @Override
            public int size(Object arr) {
                return ((Double[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Double[] value = (Double[])arr;
                value[index] = (Double)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Double[] value = (Double[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_DOUBLE;
            }
        }

        static final class StringArrayImpl
        extends ArrayInstanceImpl {
            StringArrayImpl() {
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new String[]{value};
            }

            @Override
            Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                String[] arr = parseContext.getContextStrings();
                int size = arr.length;
                int len = 0;
                boolean allowComment = parseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    char ch;
                    if ((ch = buf[i]) <= ' ') {
                        ++i;
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = StringArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (len > 0 && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = StringArrayImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return len == 0 ? EMPTY_STRINGS : JSONUnsafe.copyStrings(arr, 0, len);
                    }
                    String value = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, i, null, null, ']', parseContext);
                    if (len >= size) {
                        arr = Arrays.copyOf(arr, size <<= 1);
                    }
                    arr[len++] = value;
                    i = parseContext.endIndex;
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = StringArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                    if (ch != ',') {
                        if (ch == ']') {
                            parseContext.endIndex = i;
                            return JSONUnsafe.copyStrings(arr, 0, len);
                        }
                        String errorContextTextAt = StringArrayImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }

            @Override
            Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                String[] arr = parseContext.getContextStrings();
                int size = arr.length;
                int len = 0;
                boolean allowComment = parseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    byte b;
                    if ((b = buf[i]) <= 32) {
                        ++i;
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = StringArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (len > 0 && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = StringArrayImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return len == 0 ? EMPTY_STRINGS : JSONUnsafe.copyStrings(arr, 0, len);
                    }
                    String value = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, i, null, null, (byte)93, parseContext);
                    if (len >= size) {
                        arr = Arrays.copyOf(arr, size <<= 1);
                    }
                    arr[len++] = value;
                    i = parseContext.endIndex;
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = StringArrayImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                    if (b != 44) {
                        if (b == 93) {
                            parseContext.endIndex = i;
                            return JSONUnsafe.copyStrings(arr, 0, len);
                        }
                        String errorContextTextAt = StringArrayImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }
        }

        static abstract class ArrayInstanceImpl
        extends ArrayImpl {
            ArrayInstanceImpl() {
            }

            public Object empty() {
                throw new UnsupportedOperationException();
            }

            public Object initArray(JSONParseContext parseContext) {
                throw new UnsupportedOperationException();
            }

            public int size(Object arr) {
                throw new UnsupportedOperationException();
            }

            public void setElementAt(Object arr, Object element, int index) {
                throw new UnsupportedOperationException();
            }

            public Object copyOf(Object value, int len) {
                throw new UnsupportedOperationException();
            }

            public Object subOf(Object value, int len) {
                return this.copyOf(value, len);
            }

            public JSONTypeDeserializer getValueDeserializer() {
                throw new UnsupportedOperationException();
            }

            @Override
            Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                Object arr = this.initArray(parseContext);
                int size = this.size(arr);
                int len = 0;
                boolean allowComment = parseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    char ch;
                    if ((ch = buf[i]) <= ' ') {
                        ++i;
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayInstanceImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (len > 0 && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayInstanceImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return len == 0 ? this.empty() : this.subOf(arr, len);
                    }
                    Object value = this.getValueDeserializer().deserialize(charSource, buf, i, null, null, ']', parseContext);
                    if (len >= size) {
                        arr = this.copyOf(arr, size <<= 1);
                    }
                    this.setElementAt(arr, value, len++);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = ArrayInstanceImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        parseContext.endToken = 0;
                    }
                    if (ch != ',') {
                        if (ch == ']') {
                            parseContext.endIndex = i;
                            return this.subOf(arr, len);
                        }
                        String errorContextTextAt = ArrayInstanceImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }

            @Override
            Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext parseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                Object arr = this.initArray(parseContext);
                int size = this.size(arr);
                int len = 0;
                boolean allowComment = parseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    byte b;
                    if ((b = buf[i]) <= 32) {
                        ++i;
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = ArrayInstanceImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (len > 0 && !parseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayInstanceImpl.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        parseContext.endIndex = i;
                        return len == 0 ? this.empty() : this.subOf(arr, len);
                    }
                    Object value = this.getValueDeserializer().deserialize(charSource, buf, i, null, null, (byte)93, parseContext);
                    if (len >= size) {
                        arr = this.copyOf(arr, size <<= 1);
                    }
                    this.setElementAt(arr, value, len++);
                    i = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = ArrayInstanceImpl.clearCommentAndWhiteSpaces(buf, i + 1, parseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        parseContext.endToken = 0;
                    }
                    if (b != 44) {
                        if (b == 93) {
                            parseContext.endIndex = i;
                            return this.subOf(arr, len);
                        }
                        String errorContextTextAt = ArrayInstanceImpl.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }
        }
    }

    static final class BinaryImpl
    extends JSONTypeDeserializer {
        BinaryImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value.getBytes();
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case 'n': {
                    return BinaryImpl.parseNull(buf, fromIndex, parseContext);
                }
                case '\"': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, parseContext);
                    int endStringIndex = parseContext.endIndex;
                    byte[] bytes = BinaryImpl.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, parseContext);
                    return bytes;
                }
                case '[': {
                    return ARRAY.deserialize(charSource, buf, fromIndex, GenericParameterizedType.arrayType(Byte.TYPE), null, '\u0000', parseContext);
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case 'n': {
                    return BinaryImpl.parseNull(buf, fromIndex, parseContext);
                }
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginByte, parseContext);
                    int endStringIndex = parseContext.endIndex;
                    byte[] bytes = BinaryImpl.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, parseContext);
                    return bytes;
                }
                case '[': {
                    return ARRAY.deserialize(charSource, buf, fromIndex, GenericParameterizedType.arrayType(Byte.TYPE), null, endToken, parseContext);
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, char[] buf, JSONParseContext parseContext) {
            if (parseContext.byteArrayFromHexString) {
                return BinaryImpl.hexString2Bytes(buf, fromIndex + 1, len);
            }
            return Base64Utils.decode(buf, fromIndex + 1, len);
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, byte[] buf, JSONParseContext parseContext) {
            if (parseContext.byteArrayFromHexString) {
                return BinaryImpl.hexString2Bytes(buf, fromIndex + 1, len);
            }
            return Base64Utils.decode(buf, fromIndex + 1, len);
        }
    }

    static final class AnnotationImpl
    extends JSONTypeDeserializer {
        AnnotationImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, endToken, parseContext);
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, endToken, parseContext);
            return null;
        }
    }

    static final class ClassImpl
    extends JSONTypeDeserializer {
        ClassImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) throws ClassNotFoundException {
            return Class.forName(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '\"') {
                String name = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, beginChar, GenericParameterizedType.StringType, parseContext);
                return Class.forName(name);
            }
            if (beginChar == 'n') {
                return ClassImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = ClassImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Class Type, expected '\"' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 34) {
                String name = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, beginByte, GenericParameterizedType.StringType, parseContext);
                return Class.forName(name);
            }
            if (beginByte == 110) {
                return ClassImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = ClassImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)beginByte + "' for Class Type, expected '\"' ");
        }
    }

    static class EnumImpl
    extends JSONTypeDeserializer {
        EnumImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            Class<?> enumCls = actualType;
            return Enum.valueOf(enumCls, value);
        }

        protected Enum deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, Class enumCls, JSONParseContext parseContext) throws Exception {
            String name = (String)CHAR_SEQUENCE.deserializeString(charSource, buf, fromIndex, '\"', GenericParameterizedType.StringType, parseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (parseContext.unknownEnumAsNull) {
                    return null;
                }
                throw exception;
            }
        }

        protected Enum deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, Class enumCls, JSONParseContext parseContext) throws Exception {
            String name = (String)CHAR_SEQUENCE.deserializeString(charSource, buf, fromIndex, 34, GenericParameterizedType.StringType, parseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (parseContext.unknownEnumAsNull) {
                    return null;
                }
                throw exception;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            Class<?> clazz = parameterizedType.getActualType();
            if (beginChar == '\"') {
                return this.deserializeEnumName(charSource, buf, fromIndex, clazz, parseContext);
            }
            if (beginChar == 'n') {
                return EnumImpl.parseNull(buf, fromIndex, parseContext);
            }
            Integer ordinal = (Integer)NUMBER_INTEGER.deserialize(charSource, buf, fromIndex, GenericParameterizedType.IntType, null, endToken, parseContext);
            Enum[] values = (Enum[])this.getEnumConstants(clazz);
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        protected Object getEnumConstants(Class clazz) {
            return clazz.getEnumConstants();
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte b = buf[fromIndex];
            Class<?> clazz = parameterizedType.getActualType();
            if (b == 34) {
                return this.deserializeEnumName(charSource, buf, fromIndex, clazz, parseContext);
            }
            if (b == 110) {
                return EnumImpl.parseNull(buf, fromIndex, parseContext);
            }
            Integer ordinal = (Integer)NUMBER_INTEGER.deserialize(charSource, buf, fromIndex, GenericParameterizedType.IntType, null, endToken, parseContext);
            Enum[] values = (Enum[])clazz.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        static final class EnumInstanceImpl
        extends EnumImpl {
            private final Enum[] values;
            protected final JSONValueMatcher<Enum> enumValueMatcher;

            public EnumInstanceImpl(Enum[] values, JSONValueMatcher<Enum> enumValueMatcher) {
                this.values = values;
                this.enumValueMatcher = enumValueMatcher;
            }

            @Override
            protected Object getEnumConstants(Class clazz) {
                return this.values;
            }

            @Override
            protected Enum deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, Class enumCls, JSONParseContext parseContext) throws Exception {
                int begin = fromIndex + 1;
                int i = begin;
                Enum value = this.enumValueMatcher.matchValue(charSource, buf, i, 34, parseContext);
                if (value == null) {
                    i = parseContext.endIndex;
                    if (buf[i - 1] == '\\') {
                        char ch;
                        char prev = '\u0000';
                        while ((ch = buf[++i]) != '\"' || prev == '\\') {
                            prev = ch;
                        }
                    }
                    parseContext.endIndex = i;
                    if (parseContext.unknownEnumAsNull) {
                        return null;
                    }
                    String errorContextTextAt = EnumInstanceImpl.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                return value;
            }

            @Override
            protected Enum deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, Class enumCls, JSONParseContext parseContext) throws Exception {
                int begin = fromIndex + 1;
                int i = begin;
                Enum value = this.enumValueMatcher.matchValue(charSource, buf, i, 34, parseContext);
                if (value == null) {
                    i = parseContext.endIndex;
                    if (buf[i - 1] == 92) {
                        byte b;
                        byte prev = 0;
                        while ((b = buf[++i]) != 34 || prev == 92) {
                            prev = b;
                        }
                    }
                    parseContext.endIndex = i;
                    if (parseContext.unknownEnumAsNull) {
                        return null;
                    }
                    String errorContextTextAt = EnumInstanceImpl.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                return value;
            }
        }
    }

    static class DateImpl
    extends JSONTypeDeserializer {
        DateImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return DateImpl.matchDate(DateImpl.getChars(value), 0, value.length(), null, actualType);
        }

        protected Object deserializeDate(char[] buf, int from, int to, Class<? extends Date> dateCls) {
            return DateImpl.matchDate(buf, from + 1, to - 1, null, dateCls);
        }

        protected Object deserializeDate(byte[] buf, int from, int to, Class<? extends Date> dateCls) {
            return DateImpl.matchDate(buf, from + 1, to - 1, null, dateCls);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, parseContext);
                    int endStringIndex = parseContext.endIndex;
                    Class<?> dateCls = parameterizedType.getActualType();
                    return this.deserializeDate(buf, fromIndex, endStringIndex + 1, dateCls);
                }
                case 'n': {
                    return DateImpl.parseNull(buf, fromIndex, parseContext);
                }
                case '{': {
                    return OBJECT.deserializeObject(charSource, buf, fromIndex, parameterizedType, instance, parseContext);
                }
            }
            long timestamp = (Long)NUMBER_LONG.deserialize(charSource, buf, fromIndex, GenericParameterizedType.LongType, null, endToken, parseContext);
            return DateImpl.parseDate(timestamp, parameterizedType.getActualType());
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = bytes[fromIndex];
            switch (beginByte) {
                case 34: 
                case 39: {
                    CHAR_SEQUENCE.skip(charSource, bytes, fromIndex, beginByte, parseContext);
                    int endStringIndex = parseContext.endIndex;
                    Class<?> dateCls = parameterizedType.getActualType();
                    return this.deserializeDate(bytes, fromIndex, endStringIndex + 1, dateCls);
                }
                case 110: {
                    return DateImpl.parseNull(bytes, fromIndex, parseContext);
                }
                case 123: {
                    return OBJECT.deserializeObject(charSource, bytes, fromIndex, parameterizedType, instance, parseContext);
                }
            }
            long timestamp = (Long)NUMBER_LONG.deserialize(charSource, bytes, fromIndex, GenericParameterizedType.LongType, null, endToken, parseContext);
            return DateImpl.parseDate(timestamp, parameterizedType.getActualType());
        }

        static final class DateInstanceImpl
        extends DateImpl {
            String pattern;
            int patternType;
            DateTemplate dateTemplate;
            String timezone;

            public DateInstanceImpl(GenericParameterizedType genericParameterizedType, JsonProperty property) {
                String patternAt;
                genericParameterizedType.getClass();
                String timezoneAt = property.timezone().trim();
                if (timezoneAt.length() > 0) {
                    this.timezone = timezoneAt;
                }
                if ((patternAt = property.pattern().trim()).length() > 0) {
                    this.pattern = patternAt;
                    this.patternType = DateInstanceImpl.getPatternType(this.pattern);
                }
                if (this.patternType == 4) {
                    this.dateTemplate = new DateTemplate(this.pattern);
                }
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return DateInstanceImpl.parseDateValueOfString(DateInstanceImpl.getChars(value), -1, value.length() + 1, this.pattern, this.patternType, this.dateTemplate, this.timezone, actualType);
            }

            @Override
            protected Object deserializeDate(char[] buf, int from, int to, Class<? extends Date> dateCls) {
                return DateInstanceImpl.parseDateValueOfString(buf, from, to, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
            }

            @Override
            protected Object deserializeDate(byte[] buf, int from, int to, Class<? extends Date> dateCls) {
                return DateInstanceImpl.parseDateValueOfString(buf, from, to, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
            }
        }
    }

    static final class BooleanImpl
    extends JSONTypeDeserializer {
        BooleanImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value.equals("true");
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == 't') {
                return BooleanImpl.parseTrue(buf, fromIndex, parseContext);
            }
            if (beginChar == 'f') {
                return BooleanImpl.parseFalse(buf, fromIndex, parseContext);
            }
            if (beginChar == 'n' && parameterizedType.getActualType() == Boolean.class) {
                return BooleanImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = BooleanImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for boolean Type, expected 't' or 'f'");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 116) {
                return BooleanImpl.parseTrue(buf, fromIndex, parseContext);
            }
            if (beginByte == 102) {
                return BooleanImpl.parseFalse(buf, fromIndex, parseContext);
            }
            if (beginByte == 110 && parameterizedType.getActualType() == Boolean.class) {
                return BooleanImpl.parseNull(buf, fromIndex, parseContext);
            }
            String errorContextTextAt = BooleanImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)beginByte + "' for Boolean Type, expected 't' or 'f'");
        }
    }

    static class NumberImpl
    extends JSONTypeDeserializer {
        protected NumberImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return Double.parseDouble(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.deserializeNumber((long)(beginChar & 0xF), false, 1, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
            }
            switch (beginChar) {
                case '+': 
                case '0': {
                    return this.deserializeNumber(0L, false, 0, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
                case '-': {
                    return this.deserializeNumber(0L, true, 0, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
                case '\"': {
                    char ch = buf[++fromIndex];
                    if (ch == '\"') {
                        if (parseContext.unMatchedEmptyAsNull) {
                            parseContext.endIndex = fromIndex;
                            return null;
                        }
                        throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected empty string '\"\"' when parsing a number, use ReadOption.UnMatchedEmptyAsNull to support");
                    }
                    Number result = (Number)this.deserialize(charSource, buf, fromIndex, parameterizedType, instance, '\"', parseContext);
                    int endIndex = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        if (buf[++endIndex] != '\"') {
                            throw new JSONException("Syntax error, for input: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\", unable to convert to number");
                        }
                        parseContext.endIndex = endIndex;
                    } else {
                        parseContext.endToken = 0;
                        if (endChar != 34) {
                            throw new JSONException("Syntax error, for input: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\", unable to convert to number");
                        }
                    }
                    return ObjectUtils.toTypeNumber(result, parameterizedType.getActualType());
                }
                case 'n': {
                    NumberImpl.parseNull(buf, fromIndex, parseContext);
                    if (parameterizedType.getActualType().isPrimitive()) {
                        return (byte)0;
                    }
                    return null;
                }
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '" + beginChar + "' when try parsing a number");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext parseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.deserializeNumber((long)(beginByte & 0xF), false, 1, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
                case 43: 
                case 48: {
                    return this.deserializeNumber(0L, false, 0, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
                case 45: {
                    return this.deserializeNumber(0L, true, 0, buf, fromIndex++, fromIndex, parameterizedType, endToken, parseContext);
                }
                case 34: {
                    byte b = buf[++fromIndex];
                    if (b == 34) {
                        throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '\"' when parsing a number");
                    }
                    Number result = (Number)this.deserialize(charSource, buf, fromIndex, parameterizedType, instance, (byte)34, parseContext);
                    int endIndex = parseContext.endIndex;
                    int endChar = parseContext.endToken;
                    if (endChar == 0) {
                        if (buf[++endIndex] != 34) {
                            throw new JSONException("Syntax error, for input: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\", unable to convert to number");
                        }
                        parseContext.endIndex = endIndex;
                    } else {
                        parseContext.endToken = 0;
                        if (endChar != 34) {
                            throw new JSONException("Syntax error, for input: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\", unable to convert to number");
                        }
                    }
                    return result;
                }
                case 110: {
                    NumberImpl.parseNull(buf, fromIndex, parseContext);
                    if (parameterizedType.getActualType().isPrimitive()) {
                        return (byte)0;
                    }
                    return null;
                }
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '" + (char)beginByte + "' when try parsing a number");
        }

        static final Number parseNumber(char[] buf, int fromIndex, int offset, long val, int cnt, boolean negative, char endToken, int returnType, JSONParseContext parseContext) throws Exception {
            int endIndex;
            char ch;
            int i;
            int specifySuffix;
            int mode;
            boolean expNegative;
            int expValue;
            int decimalCount;
            long value;
            block56: {
                block57: {
                    value = val;
                    decimalCount = 0;
                    expValue = 0;
                    expNegative = false;
                    mode = 0;
                    specifySuffix = 0;
                    i = offset;
                    while (NumberUtils.isDigit(ch = buf[i])) {
                        value = (value << 3) + (value << 1) + (long)(ch & 0xF);
                        ++cnt;
                        ++i;
                    }
                    if (ch == '.') {
                        mode = 1;
                        while (NumberUtils.isDigit(ch = buf[++i])) {
                            value = (value << 3) + (value << 1) + (long)(ch & 0xF);
                            ++decimalCount;
                            ++cnt;
                        }
                    }
                    if (ch <= ' ') {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                    }
                    if (ch == ',' || ch == endToken) break block56;
                    if (ch != 'E' && ch != 'e') break block57;
                    mode = 2;
                    if ((expNegative = (ch = buf[++i]) == '-') || ch == '+') {
                        ch = buf[++i];
                    }
                    if (NumberUtils.isDigit(ch)) {
                        expValue = ch & 0xF;
                        while (NumberUtils.isDigit(ch = buf[++i])) {
                            expValue = (expValue << 3) + (expValue << 1) + (ch & 0xF);
                        }
                    }
                    if (ch <= ' ') {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                    }
                    if (ch == ',' || ch == endToken) break block56;
                }
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        specifySuffix = 1;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    case 'F': 
                    case 'f': {
                        specifySuffix = 2;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    case 'D': 
                    case 'd': {
                        specifySuffix = 3;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    default: {
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                }
            }
            parseContext.endIndex = endIndex = i - 1;
            if (returnType == 4) {
                if (cnt > 19) {
                    value = 0L;
                    cnt = 0;
                    int decimalPointIndex = endIndex;
                    decimalCount = 0;
                    for (int j = fromIndex; j < i; ++j) {
                        ch = buf[j];
                        if (NumberUtils.isDigit(ch)) {
                            if (cnt++ < 18) {
                                value = value * 10L + (long)(ch & 0xF);
                            }
                            if (j > decimalPointIndex) {
                                ++decimalCount;
                            }
                        } else if (ch == '.') {
                            decimalPointIndex = j;
                        } else if (ch == 'e' || ch == 'E') break;
                        if (cnt >= 18 && decimalCount > 0) break;
                    }
                    decimalCount -= cnt - 18;
                }
                double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                return negative ? -dv : dv;
            }
            switch (returnType) {
                case 1: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= ' ') {
                            --endIndex;
                        }
                        return new BigDecimal(buf, fromIndex, endIndex - fromIndex + 1);
                    }
                    value = negative ? -value : value;
                    return new BigDecimal(BigInteger.valueOf(value), expNegative ? expValue + decimalCount : decimalCount - expValue);
                }
                case 2: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= ' ') {
                            --endIndex;
                        }
                        return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return BigInteger.valueOf(value);
                }
                case 3: {
                    float fv = NumberUtils.scientificToIEEEFloat(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                    return Float.valueOf(negative ? -fv : fv);
                }
            }
            if (mode == 0) {
                if (cnt > 19) {
                    while (buf[endIndex] <= ' ') {
                        --endIndex;
                    }
                    return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                }
                long l = value = negative ? -value : value;
                if (specifySuffix > 0) {
                    switch (specifySuffix) {
                        case 1: {
                            return value;
                        }
                        case 2: {
                            return Float.valueOf(value);
                        }
                    }
                    return value;
                }
                if (value <= Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
                    return (int)value;
                }
                return value;
            }
            if (cnt > 19 && (value < 0L || cnt > 25)) {
                while (buf[endIndex] <= ' ') {
                    --endIndex;
                }
                return new BigDecimal(buf, fromIndex, endIndex - fromIndex + 1);
            }
            expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            double doubleVal = NumberUtils.scientificToIEEEDouble(value, -expValue);
            double d = doubleVal = negative ? -doubleVal : doubleVal;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)doubleVal;
                    }
                    case 2: {
                        return Float.valueOf((float)doubleVal);
                    }
                }
                return doubleVal;
            }
            return doubleVal;
        }

        static final Number parseNumber(byte[] buf, int fromIndex, int offset, long val, int cnt, boolean negative, byte endToken, int returnType, JSONParseContext parseContext) throws Exception {
            int endIndex;
            byte b;
            int i;
            int specifySuffix;
            int mode;
            boolean expNegative;
            int expValue;
            int decimalCount;
            long value;
            block58: {
                block59: {
                    int v;
                    value = val;
                    decimalCount = 0;
                    expValue = 0;
                    expNegative = false;
                    mode = 0;
                    specifySuffix = 0;
                    i = offset;
                    while ((v = JSONUnsafe.UNSAFE_ENDIAN.digits2Bytes(buf, i)) != -1) {
                        value = value * 100L + (long)v;
                        cnt += 2;
                        i += 2;
                    }
                    b = buf[i];
                    if (NumberUtils.isDigit(b)) {
                        value = (value << 3) + (value << 1) + (long)(b & 0xF);
                        b = buf[++i];
                        ++cnt;
                    }
                    if (b == 46) {
                        mode = 1;
                        ++i;
                        while ((v = JSONUnsafe.UNSAFE_ENDIAN.digits2Bytes(buf, i)) != -1) {
                            value = value * 100L + (long)v;
                            cnt += 2;
                            decimalCount += 2;
                            i += 2;
                        }
                        b = buf[i];
                        if (NumberUtils.isDigit(b)) {
                            value = (value << 3) + (value << 1) + (long)(b & 0xF);
                            b = buf[++i];
                            ++cnt;
                            ++decimalCount;
                        }
                    }
                    if (b <= 32) {
                        while ((b = buf[++i]) <= 32) {
                        }
                    }
                    if (b == 44 || b == endToken) break block58;
                    if (b != 69 && b != 101) break block59;
                    mode = 2;
                    if ((expNegative = (b = buf[++i]) == 45) || b == 43) {
                        b = buf[++i];
                    }
                    if (NumberUtils.isDigit(b)) {
                        expValue = b & 0xF;
                        while (NumberUtils.isDigit(b = buf[++i])) {
                            expValue = (expValue << 3) + (expValue << 1) + (b & 0xF);
                        }
                    }
                    if (b <= 32) {
                        while ((b = buf[++i]) <= 32) {
                        }
                    }
                    if (b == 44 || b == endToken) break block58;
                }
                switch (b) {
                    case 76: 
                    case 108: {
                        specifySuffix = 1;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 70: 
                    case 102: {
                        specifySuffix = 2;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 68: 
                    case 100: {
                        specifySuffix = 3;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    default: {
                        String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                }
            }
            parseContext.endIndex = endIndex = i - 1;
            if (returnType == 4) {
                if (cnt > 19) {
                    value = 0L;
                    cnt = 0;
                    int decimalPointIndex = endIndex;
                    decimalCount = 0;
                    for (int j = fromIndex; j < i; ++j) {
                        b = buf[j];
                        if (NumberUtils.isDigit(b)) {
                            if (cnt++ < 18) {
                                value = value * 10L + (long)(b & 0xF);
                            }
                            if (j > decimalPointIndex) {
                                ++decimalCount;
                            }
                        } else if (b == 46) {
                            decimalPointIndex = j;
                        } else if (b == 101 || b == 69) break;
                        if (cnt >= 18 && decimalCount > 0) break;
                    }
                    decimalCount -= cnt - 18;
                }
                double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                return negative ? -dv : dv;
            }
            switch (returnType) {
                case 1: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= 32) {
                            --endIndex;
                        }
                        return new BigDecimal(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return new BigDecimal(BigInteger.valueOf(value), expNegative ? expValue + decimalCount : decimalCount - expValue);
                }
                case 2: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= 32) {
                            --endIndex;
                        }
                        return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return BigInteger.valueOf(value);
                }
                case 3: {
                    float fv = NumberUtils.scientificToIEEEFloat(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                    return Float.valueOf(negative ? -fv : fv);
                }
            }
            if (mode == 0) {
                if (cnt > 19) {
                    while (buf[endIndex] <= 32) {
                        --endIndex;
                    }
                    return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                }
                long l = value = negative ? -value : value;
                if (specifySuffix > 0) {
                    switch (specifySuffix) {
                        case 1: {
                            return value;
                        }
                        case 2: {
                            return Float.valueOf(value);
                        }
                    }
                    return value;
                }
                if (value <= Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
                    return (int)value;
                }
                return value;
            }
            if (cnt > 19 && (value < 0L || cnt > 25)) {
                while (buf[endIndex] <= 32) {
                    --endIndex;
                }
                return new BigDecimal(new String(buf, fromIndex, endIndex - fromIndex + 1));
            }
            expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            double doubleVal = NumberUtils.scientificToIEEEDouble(value, -expValue);
            double d = doubleVal = negative ? -doubleVal : doubleVal;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)doubleVal;
                    }
                    case 2: {
                        return Float.valueOf((float)doubleVal);
                    }
                }
                return doubleVal;
            }
            return doubleVal;
        }

        protected static final long deserializeInteger(long value, boolean negative, int cnt, char[] buf, int fromIndex, char endToken, JSONParseContext parseContext) throws Exception {
            char ch;
            boolean isDigit;
            int i = fromIndex;
            char ch1 = '\u0000';
            while ((isDigit = NumberUtils.isDigit(ch = buf[i])) && NumberUtils.isDigit(ch1 = buf[++i])) {
                value = value * 100L + (long)NumberImpl.twoDigitsValue(ch, ch1);
                ++i;
            }
            if (isDigit) {
                value = (value << 3) + (value << 1) + (long)(ch & 0xF);
                ch = ch1;
            }
            if (ch == ',' || ch == endToken) {
                parseContext.endIndex = i;
                parseContext.endToken = ch;
                return negative ? -value : value;
            }
            if (ch <= ' ') {
                while ((ch = buf[++i]) <= ' ') {
                }
                if (ch == ',' || ch == endToken) {
                    parseContext.endIndex = i;
                    parseContext.endToken = ch;
                    return negative ? -value : value;
                }
                String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
            }
            return NumberImpl.parseNumber(buf, fromIndex, i, value, cnt + i - fromIndex, negative, endToken, 0, parseContext).longValue();
        }

        protected static final long deserializeInteger(long value, boolean negative, int cnt, byte[] buf, int fromIndex, byte endToken, JSONParseContext parseContext) throws Exception {
            int val;
            int i = fromIndex;
            while ((val = JSONUnsafe.UNSAFE_ENDIAN.digits2Bytes(buf, i)) != -1) {
                value = value * 100L + (long)val;
                i += 2;
            }
            int b = buf[i];
            if (NumberUtils.isDigit(b)) {
                value = (value << 3) + (value << 1) + (long)(b & 0xF);
                b = buf[++i];
            }
            if (b == 44 || b == endToken) {
                parseContext.endIndex = i;
                parseContext.endToken = b;
                return negative ? -value : value;
            }
            if (b <= 32) {
                while ((b = buf[++i]) <= 32) {
                }
                if (b == 44 || b == endToken) {
                    parseContext.endIndex = i;
                    parseContext.endToken = b;
                    return negative ? -value : value;
                }
                String contextErrorAt = NumberImpl.createErrorContextText(buf, i);
                throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
            }
            return NumberImpl.parseNumber(buf, fromIndex, i, value, cnt + i - fromIndex, negative, endToken, 0, parseContext).longValue();
        }

        protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 0, parseContext);
            }
            if (parameterizedType == GenericParameterizedType.BigDecimalType) {
                return NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 1, parseContext);
            }
            Number value = NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 0, parseContext);
            return ObjectUtils.toTypeNumber(value, parameterizedType.getActualType());
        }

        protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 0, parseContext);
            }
            if (parameterizedType == GenericParameterizedType.BigDecimalType) {
                return NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 1, parseContext);
            }
            Number value = NumberImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 0, parseContext);
            return ObjectUtils.toTypeNumber(value, parameterizedType.getActualType());
        }

        static final class Skipper
        extends NumberImpl {
            Skipper() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                int i;
                block19: {
                    char ch;
                    block20: {
                        i = offset;
                        while (NumberUtils.isDigit(ch = buf[i])) {
                            ++i;
                        }
                        if (ch == '.') {
                            while (NumberUtils.isDigit(ch = buf[++i])) {
                            }
                        }
                        if (ch <= ' ') {
                            while ((ch = buf[++i]) <= ' ') {
                            }
                        }
                        if (ch == ',' || ch == endToken) break block19;
                        if (ch != 'E' && ch != 'e') break block20;
                        if ((ch = buf[++i]) == '-' || ch == '+') {
                            ch = buf[++i];
                        }
                        if (NumberUtils.isDigit(ch)) {
                            while (NumberUtils.isDigit(ch = buf[++i])) {
                            }
                        }
                        if (ch <= ' ') {
                            while ((ch = buf[++i]) <= ' ') {
                            }
                        }
                        if (ch == ',' || ch == endToken) break block19;
                    }
                    switch (ch) {
                        case 'D': 
                        case 'F': 
                        case 'L': 
                        case 'd': 
                        case 'f': 
                        case 'l': {
                            while ((ch = buf[++i]) <= ' ') {
                            }
                            if (ch == ',' || ch == endToken) break;
                            if (parseContext.validate) {
                                parseContext.validateFail = true;
                                return null;
                            }
                            String contextErrorAt = Skipper.createErrorContextText(buf, i);
                            throw new JSONException("skip input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                        default: {
                            if (parseContext.validate) {
                                parseContext.validateFail = true;
                                return null;
                            }
                            String contextErrorAt = Skipper.createErrorContextText(buf, i);
                            throw new JSONException("skip input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                        }
                    }
                }
                parseContext.endIndex = i - 1;
                return null;
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                int i;
                block18: {
                    byte b;
                    block19: {
                        i = offset;
                        while (NumberUtils.isDigit(b = buf[i])) {
                            ++i;
                        }
                        if (b == 46) {
                            i = Skipper.skipDigits(buf, i + 1);
                            b = buf[i];
                        }
                        if (b <= 32) {
                            while ((b = buf[++i]) <= 32) {
                            }
                        }
                        if (b == 44 || b == endToken) break block18;
                        if (b != 69 && b != 101) break block19;
                        if ((b = buf[++i]) == 45 || b == 43) {
                            b = buf[++i];
                        }
                        if (NumberUtils.isDigit(b)) {
                            while (NumberUtils.isDigit(b = buf[++i])) {
                            }
                        }
                        if (b <= 32) {
                            while ((b = buf[++i]) <= 32) {
                            }
                        }
                        if (b == 44 || b == endToken) break block18;
                    }
                    switch (b) {
                        case 68: 
                        case 70: 
                        case 76: 
                        case 100: 
                        case 102: 
                        case 108: {
                            while ((b = buf[++i]) <= 32) {
                            }
                            if (b == 44 || b == endToken) break;
                            if (parseContext.validate) {
                                parseContext.validateFail = true;
                                return null;
                            }
                            String contextErrorAt = Skipper.createErrorContextText(buf, i);
                            throw new JSONException("skip input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                        }
                        default: {
                            if (parseContext.validate) {
                                parseContext.validateFail = true;
                                return null;
                            }
                            String contextErrorAt = Skipper.createErrorContextText(buf, i);
                            throw new JSONException("skip input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                        }
                    }
                }
                parseContext.endIndex = i - 1;
                return null;
            }
        }

        static final class BigIntegerImpl
        extends NumberImpl {
            BigIntegerImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return BigIntegerImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 2, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return BigIntegerImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 2, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new BigInteger(value);
            }
        }

        static final class BigDecimalImpl
        extends NumberImpl {
            BigDecimalImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return BigDecimalImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 1, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return BigDecimalImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 1, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new BigDecimal(value);
            }
        }

        static final class FloatImpl
        extends NumberImpl {
            FloatImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return FloatImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 3, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return FloatImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 3, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }

        static final class DoubleImpl
        extends NumberImpl {
            DoubleImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return DoubleImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 4, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return DoubleImpl.parseNumber(buf, fromIndex, offset, initValue, cnt, negative, endToken, 4, parseContext);
            }
        }

        static final class ByteImpl
        extends NumberImpl {
            ByteImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return (byte)ByteImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return (byte)ByteImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Byte.parseByte(value);
            }
        }

        static final class ShortImpl
        extends NumberImpl {
            ShortImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return (short)ShortImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return (short)ShortImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Short.parseShort(value);
            }
        }

        static final class IntegerImpl
        extends NumberImpl {
            IntegerImpl() {
            }

            @Override
            protected Integer deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return (int)IntegerImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Integer deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return (int)IntegerImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Integer.parseInt(value);
            }
        }

        static final class LongImpl
        extends NumberImpl {
            LongImpl() {
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, char endToken, JSONParseContext parseContext) throws Exception {
                return LongImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext parseContext) throws Exception {
                return LongImpl.deserializeInteger(initValue, negative, cnt, buf, offset, endToken, parseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Long.parseLong(value);
            }
        }
    }

    static class CharSequenceImpl
    extends JSONTypeDeserializer {
        CharSequenceImpl() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) throws Exception {
            if (actualType == char[].class) {
                return value.toCharArray();
            }
            if (actualType == StringBuilder.class) {
                return new StringBuilder(value);
            }
            if (actualType == StringBuffer.class) {
                return new StringBuffer(value);
            }
            return value;
        }

        @Override
        protected void skip(CharSource source, char[] buf, int fromIndex, char endCh, JSONParseContext parseContext) throws Exception {
            if (source == null) {
                int i = fromIndex;
                while (buf[++i] != endCh) {
                }
                char prev = buf[i - 1];
                while (prev == '\\') {
                    boolean prevEscapeFlag = true;
                    int j = i - 1;
                    while (buf[--j] == '\\') {
                        prevEscapeFlag = !prevEscapeFlag;
                    }
                    if (!prevEscapeFlag) break;
                    while (buf[++i] != endCh) {
                    }
                    prev = buf[i - 1];
                }
                parseContext.endIndex = i;
            } else {
                String input = source.input();
                int beginIndex = fromIndex + 1;
                int endIndex = input.indexOf(endCh, beginIndex);
                char prev = buf[endIndex - 1];
                while (prev == '\\') {
                    boolean prevEscapeFlag = true;
                    int j = endIndex - 1;
                    while (buf[--j] == '\\') {
                        prevEscapeFlag = !prevEscapeFlag;
                    }
                    if (!prevEscapeFlag) break;
                    endIndex = input.indexOf(endCh, endIndex + 1);
                    prev = buf[endIndex - 1];
                }
                parseContext.endIndex = endIndex;
            }
        }

        @Override
        protected void skip(CharSource source, byte[] buf, int fromIndex, byte endByte, JSONParseContext parseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            if (source != null) {
                String input = source.input();
                int endIndex = JSONGeneral.JSON_UTIL.indexOf(input, buf, beginIndex, endByte);
                byte prev = buf[endIndex - 1];
                while (prev == 92) {
                    boolean prevEscapeFlag = true;
                    int j = endIndex - 1;
                    while (buf[--j] == 92) {
                        prevEscapeFlag = !prevEscapeFlag;
                    }
                    if (!prevEscapeFlag) break;
                    endIndex = JSONGeneral.JSON_UTIL.indexOf(input, buf, endIndex + 1, endByte);
                    prev = buf[endIndex - 1];
                }
                parseContext.endIndex = endIndex;
                return;
            }
            int i = fromIndex;
            while (buf[++i] != endByte) {
            }
            byte prev = buf[i - 1];
            while (prev == 92) {
                boolean prevEscapeFlag = true;
                int j = i - 1;
                while (buf[--j] == 92) {
                    prevEscapeFlag = !prevEscapeFlag;
                }
                if (!prevEscapeFlag) break;
                while (buf[++i] != endByte) {
                }
                prev = buf[i - 1];
            }
            parseContext.endIndex = i;
        }

        Object deserializeString(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
            String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, endByte, parameterizedType, parseContext);
            Class<?> actualType = parameterizedType.getActualType();
            if (actualType == char[].class) {
                return value.toCharArray();
            }
            if (actualType == StringBuilder.class) {
                return new StringBuilder(value);
            }
            return new StringBuffer(value);
        }

        Object deserializeString(CharSource charSource, char[] buf, int fromIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
            String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, endChar, parameterizedType, parseContext);
            Class<?> actualType = parameterizedType.getActualType();
            if (actualType == char[].class) {
                return value.toCharArray();
            }
            if (actualType == StringBuilder.class) {
                return new StringBuilder(value);
            }
            return new StringBuffer(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '\"') {
                return this.deserializeString(charSource, buf, fromIndex, beginChar, parameterizedType, parseContext);
            }
            if (beginChar == 'n') {
                return CharSequenceImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (beginChar == '\'') {
                return this.deserializeString(charSource, buf, fromIndex, beginChar, parameterizedType, parseContext);
            }
            if (parameterizedType == GenericParameterizedType.StringType) {
                try {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                    return new String(buf, fromIndex, parseContext.endIndex + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = CharSequenceImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for CharSequence, expected '\"' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
            boolean isStringType;
            byte b = buf[fromIndex];
            if (b == 34) {
                return this.deserializeString(charSource, buf, fromIndex, b, parameterizedType, parseContext);
            }
            if (b == 110) {
                return CharSequenceImpl.parseNull(buf, fromIndex, parseContext);
            }
            if (b == 39) {
                return this.deserializeString(charSource, buf, fromIndex, b, parameterizedType, parseContext);
            }
            boolean bl = isStringType = parameterizedType.getActualType() == String.class;
            if (isStringType) {
                try {
                    NUMBER_SKIPPER.deserialize(charSource, buf, fromIndex, null, null, endToken, parseContext);
                    return new String(buf, fromIndex, parseContext.endIndex + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = CharSequenceImpl.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "' for CharSequence, expected '\"' ");
        }

        static final class CharImpl
        extends CharSequenceImpl {
            CharImpl() {
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Character.valueOf(value.charAt(0));
            }

            @Override
            protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext parseContext) throws Exception {
                char firstChar = buf[fromIndex];
                switch (firstChar) {
                    case '\"': 
                    case '\'': {
                        char result = '\u0000';
                        String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, firstChar, null, parseContext);
                        if (value != null && !value.isEmpty()) {
                            result = value.charAt(0);
                        }
                        return Character.valueOf(result);
                    }
                    case 'n': {
                        return CharImpl.parseNull(buf, fromIndex, parseContext);
                    }
                }
                short value = (Short)NUMBER_SHORT.deserialize(charSource, buf, fromIndex, parameterizedType, instance, endToken, parseContext);
                return Character.valueOf((char)value);
            }

            @Override
            protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext parseContext) throws Exception {
                byte firstByte = buf[fromIndex];
                switch (firstByte) {
                    case 34: 
                    case 39: {
                        char result = '\u0000';
                        String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, firstByte, null, parseContext);
                        if (value != null && !value.isEmpty()) {
                            result = value.charAt(0);
                        }
                        return Character.valueOf(result);
                    }
                    case 110: {
                        return CharImpl.parseNull(buf, fromIndex, parseContext);
                    }
                }
                short value = (Short)NUMBER_SHORT.deserialize(charSource, buf, fromIndex, parameterizedType, defaultValue, endToken, parseContext);
                return Character.valueOf((char)value);
            }
        }

        static final class StringJDK16PlusImpl
        extends CharSequenceImpl {
            StringJDK16PlusImpl() {
            }

            @Override
            String deserializeString(CharSource charSource, char[] buf, int fromIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                int endIndex;
                int beginIndex = fromIndex + 1;
                String source = charSource.input();
                if (!parseContext.checkEscapeBackslashJDK16(source, beginIndex, endIndex = source.indexOf(endChar, beginIndex))) {
                    parseContext.endIndex = endIndex;
                    return new String(buf, beginIndex, endIndex - beginIndex);
                }
                JSONCharArrayWriter writer = StringJDK16PlusImpl.getContextWriter(parseContext);
                do {
                    int escapeIndex;
                    if ((escapeIndex = parseContext.getEscapeOffset()) > beginIndex) {
                        writer.write(buf, beginIndex, escapeIndex - beginIndex);
                    }
                    if ((beginIndex = StringJDK16PlusImpl.escapeNextChars(buf, buf[escapeIndex + 1], escapeIndex, writer)) <= endIndex) continue;
                    endIndex = source.indexOf(endChar, endIndex + 1);
                } while (parseContext.checkEscapeBackslashJDK16(source, beginIndex, endIndex));
                parseContext.endIndex = endIndex;
                writer.write(source, beginIndex, endIndex - beginIndex);
                return writer.toString();
            }

            @Override
            String deserializeString(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                int endIndex;
                int beginIndex;
                String source = charSource.input();
                if (!parseContext.checkEscapeBackslashJDK16(source, beginIndex = fromIndex + 1, endIndex = source.indexOf(endByte, beginIndex))) {
                    parseContext.endIndex = endIndex;
                    return charSource.substring(buf, beginIndex, endIndex);
                }
                JSONCharArrayWriter writer = StringJDK16PlusImpl.getContextWriter(parseContext);
                do {
                    int escapeIndex;
                    if ((escapeIndex = parseContext.getEscapeOffset()) > beginIndex) {
                        charSource.writeString(writer, buf, beginIndex, escapeIndex - beginIndex);
                    }
                    if ((beginIndex = StringJDK16PlusImpl.escapeNextBytes(buf, buf[escapeIndex + 1], escapeIndex, writer)) <= endIndex) continue;
                    endIndex = source.indexOf(endByte, endIndex + 1);
                } while (parseContext.checkEscapeBackslashJDK16(source, beginIndex, endIndex));
                parseContext.endIndex = endIndex;
                charSource.writeString(writer, buf, beginIndex, endIndex - beginIndex);
                return writer.toString();
            }
        }

        static final class StringJDK9PlusImpl
        extends CharSequenceImpl {
            StringJDK9PlusImpl() {
            }

            @Override
            String deserializeString(CharSource charSource, char[] buf, int fromIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                long quoteMask;
                int beginIndex;
                String source = charSource.input();
                int i = beginIndex = fromIndex + 1;
                JSONCharArrayWriter writer = null;
                boolean noEscapeFlag = true;
                long l = quoteMask = endChar == '\"' ? -9570295239278627L : -10977691597996072L;
                while (true) {
                    char ch;
                    if ((ch = buf[i = JSON_UTIL.ensureIndexOfQuoteOrBackslashChar(buf, i, endChar, quoteMask)]) == endChar) {
                        parseContext.endIndex = i;
                        if (noEscapeFlag) {
                            return source.substring(beginIndex, i);
                        }
                        int len = i - beginIndex;
                        writer.write(buf, beginIndex, len);
                        return writer.toString();
                    }
                    if (writer == null) {
                        writer = StringJDK9PlusImpl.getContextWriter(parseContext);
                        noEscapeFlag = false;
                    }
                    if (i > beginIndex) {
                        writer.write(buf, beginIndex, i - beginIndex);
                    }
                    i = beginIndex = StringJDK9PlusImpl.escapeNextChars(buf, buf[i + 1], i, writer);
                }
            }

            @Override
            String deserializeString(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                long quoteMask;
                int beginIndex;
                int i = beginIndex = fromIndex + 1;
                JSONCharArrayWriter writer = null;
                long l = quoteMask = endByte == 34 ? -2459565876494606883L : -2821266740684990248L;
                while (true) {
                    byte b;
                    if ((b = buf[i = JSON_UTIL.ensureIndexOfQuoteOrBackslashOrUTF8Byte(buf, i, endByte, quoteMask)]) == endByte) {
                        parseContext.endIndex = i;
                        if (writer == null) {
                            return JSONUnsafe.createAsciiString(buf, beginIndex, i - beginIndex);
                        }
                        if (i > beginIndex) {
                            charSource.writeString(writer, buf, beginIndex, i - beginIndex);
                        }
                        return writer.toString();
                    }
                    if (writer == null) {
                        writer = StringJDK9PlusImpl.getContextWriter(parseContext);
                        writer.ensureCapacity(buf.length);
                    }
                    if (i > beginIndex) {
                        charSource.writeString(writer, buf, beginIndex, i - beginIndex);
                    }
                    if (b == 92) {
                        i = beginIndex = StringJDK9PlusImpl.escapeNextBytes(buf, buf[i + 1], i, writer);
                        continue;
                    }
                    do {
                        byte b2;
                        byte b1 = buf[++i];
                        int s = b >> 4;
                        if (s == -2) {
                            try {
                                b2 = buf[++i];
                                int a = (b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                                writer.writeDirect((char)a);
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else if (s == -3 || s == -4) {
                            try {
                                int a = (b & 0x1F) << 6 | b1 & 0x3F;
                                writer.writeDirect((char)a);
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else if (s == -1) {
                            try {
                                b2 = buf[++i];
                                byte b3 = buf[++i];
                                int a = (b & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
                                if (Character.isSupplementaryCodePoint(a)) {
                                    writer.writeDirect((char)((a >>> 10) + 55232));
                                    writer.writeDirect((char)((a & 0x3FF) + 56320));
                                }
                                writer.writeDirect((char)a);
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else {
                            throw new UnsupportedOperationException("utf-8 character error ");
                        }
                    } while ((b = buf[++i]) < 0);
                    beginIndex = i;
                }
            }
        }

        static final class StringJDK8Impl
        extends CharSequenceImpl {
            StringJDK8Impl() {
            }

            @Override
            String deserializeString(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                long quoteMask;
                int beginIndex;
                int i = beginIndex = fromIndex + 1;
                int count = 0;
                JSONCharArrayWriter writer = null;
                char[] chars = null;
                long l = quoteMask = endByte == 34 ? -2459565876494606883L : -2821266740684990248L;
                while (true) {
                    byte b;
                    if ((b = buf[i = JSON_UTIL.ensureIndexOfQuoteOrBackslashOrUTF8Byte(buf, i, endByte, quoteMask)]) == endByte) {
                        parseContext.endIndex = i;
                        if (writer == null) {
                            return JSONUnsafe.createStringByAsciiBytesJDK8(buf, beginIndex, i);
                        }
                        if (i > beginIndex) {
                            count += JSONUnsafe.asciiBytesToChars(buf, beginIndex, i, chars, count);
                        }
                        return new String(chars, 0, count);
                    }
                    if (writer == null) {
                        writer = StringJDK8Impl.getContextWriter(parseContext);
                        chars = writer.ensureCapacity(buf.length);
                    }
                    if (i > beginIndex) {
                        count += JSONUnsafe.asciiBytesToChars(buf, beginIndex, i, chars, count);
                    }
                    if (b == 92) {
                        writer.count = count;
                        i = beginIndex = StringJDK8Impl.escapeNextBytes(buf, buf[i + 1], i, writer);
                        count = writer.count;
                        continue;
                    }
                    do {
                        byte b2;
                        byte b1 = buf[++i];
                        int s = b >> 4;
                        if (s == -2) {
                            try {
                                b2 = buf[++i];
                                int a = (b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                                chars[count++] = (char)a;
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else if (s == -3 || s == -4) {
                            try {
                                int a = (b & 0x1F) << 6 | b1 & 0x3F;
                                chars[count++] = (char)a;
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else if (s == -1) {
                            try {
                                b2 = buf[++i];
                                byte b3 = buf[++i];
                                int a = (b & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
                                if (Character.isSupplementaryCodePoint(a)) {
                                    chars[count++] = (char)((a >>> 10) + 55232);
                                    chars[count++] = (char)((a & 0x3FF) + 56320);
                                }
                                chars[count++] = (char)a;
                            }
                            catch (Throwable throwable) {
                                throw new UnsupportedOperationException("utf-8 character error ");
                            }
                        } else {
                            throw new UnsupportedOperationException("utf-8 character error ");
                        }
                    } while ((b = buf[++i]) < 0);
                    beginIndex = i;
                }
            }

            @Override
            String deserializeString(CharSource source, char[] buf, int fromIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext parseContext) {
                long quoteMask;
                int beginIndex;
                int i = beginIndex = fromIndex + 1;
                JSONCharArrayWriter writer = null;
                boolean noEscapeFlag = true;
                long l = quoteMask = endChar == '\"' ? -9570295239278627L : -10977691597996072L;
                while (true) {
                    char ch;
                    if ((ch = buf[i = JSON_UTIL.ensureIndexOfQuoteOrBackslashChar(buf, i, endChar, quoteMask)]) == endChar) {
                        parseContext.endIndex = i;
                        int len = i - beginIndex;
                        if (noEscapeFlag) {
                            return JSONUnsafe.createStringJDK8(buf, beginIndex, len);
                        }
                        writer.write(buf, beginIndex, len);
                        return writer.toString();
                    }
                    if (writer == null) {
                        writer = StringJDK8Impl.getContextWriter(parseContext);
                        noEscapeFlag = false;
                    }
                    if (i > beginIndex) {
                        writer.write(buf, beginIndex, i - beginIndex);
                    }
                    i = beginIndex = StringJDK8Impl.escapeNextChars(buf, buf[i + 1], i, writer);
                }
            }
        }
    }
}

