/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateFormatter;
import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.compiler.JDKCompiler;
import io.github.wycst.wast.common.reflect.ClassStrucWrap;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONCustomMapper;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoSerializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONTypeExtensionSer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JSONTypeSerializer
extends JSONGeneral {
    static final int LENGTH = ReflectConsts.ClassCategory.values().length;
    static final JSONTypeSerializer[] TYPE_SERIALIZERS = new JSONTypeSerializer[LENGTH];
    private static final Map<Class<?>, JSONTypeSerializer> classJSONTypeSerializerMap = new ConcurrentHashMap();
    private static final Set<Class> REGISTERED_TYPES = new LinkedHashSet<Class>();
    static final JSONTypeSerializer SIMPLE = new SimpleImpl();
    static final CharSequenceImpl CHAR_SEQUENCE = new CharSequenceImpl();
    static final CharSequenceImpl CHAR_SEQUENCE_STRING = EnvUtils.JDK_9_PLUS ? new StringJDK9PlusImpl() : new StringJDK8Impl();
    static final JSONTypeSerializer TO_STRING = new ToStringImpl();
    static final EnumImpl ENUM = new EnumImpl();
    static final BinaryImpl BINARY = new BinaryImpl();
    static final SimpleNumberImpl NUMBER = new SimpleNumberImpl();
    static final SimpleNumberImpl NUMBER_LONG = new LongImpl();
    static final SimpleNumberImpl NUMBER_INTEGER = new IntegerImpl();
    static final SimpleNumberImpl NUMBER_DOUBLE = new DoubleImpl();
    static final SimpleNumberImpl NUMBER_FLOAT = new FloatImpl();
    static final MapImpl MAP = new MapImpl();
    static final ObjectImpl OBJECT = new ObjectImpl();
    static final AnyImpl ANY = new AnyImpl();
    static final ArrayImpl ARRAY_OBJECT = new ArrayImpl();
    static final ArrayImpl ARRAY_STRING = new ArrayStringImpl();
    static final ArrayImpl ARRAY_PRIMITIVE_LONG = new ArrayPrimitiveImpl(NUMBER_LONG, ReflectConsts.PrimitiveType.PrimitiveLong);
    static final ArrayImpl ARRAY_PRIMITIVE_BYTE = new ArrayPrimitiveImpl(NUMBER_INTEGER, ReflectConsts.PrimitiveType.PrimitiveByte);
    static final ArrayImpl ARRAY_PRIMITIVE_INTEGER = new ArrayPrimitiveImpl(NUMBER_INTEGER, ReflectConsts.PrimitiveType.PrimitiveInt);
    static final ArrayImpl ARRAY_PRIMITIVE_SHORT = new ArrayPrimitiveImpl(NUMBER_INTEGER, ReflectConsts.PrimitiveType.PrimitiveShort);
    static final ArrayImpl ARRAY_PRIMITIVE_FLOAT = new ArrayPrimitiveImpl(NUMBER_FLOAT, ReflectConsts.PrimitiveType.PrimitiveFloat);
    static final ArrayImpl ARRAY_PRIMITIVE_DOUBLE = new ArrayPrimitiveImpl(NUMBER_DOUBLE, ReflectConsts.PrimitiveType.PrimitiveDouble);
    static final CollectionImpl COLLECTION = new CollectionImpl();
    static final JSONTypeSerializer DATE_AS_TIME_SERIALIZER = new DateAsTimeImpl();
    static final Set<Class<?>> BUILT_IN_TYPE_SET;

    static boolean isBuiltInType(Class<?> type) {
        return BUILT_IN_TYPE_SET.contains(type);
    }

    static void putTypeSerializer(JSONTypeSerializer typeSerializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeSerializerMap.put(type, typeSerializer);
        }
    }

    static final void registerTypeSerializer(JSONTypeSerializer typeSerializer, Class type) {
        classJSONTypeSerializerMap.put(type, typeSerializer);
        REGISTERED_TYPES.add(type);
    }

    static final JSONTypeSerializer checkSuperclassRegistered(Class<?> cls) {
        for (Class type : REGISTERED_TYPES) {
            if (!type.isAssignableFrom(cls)) continue;
            return classJSONTypeSerializerMap.get(type);
        }
        return null;
    }

    static JSONTypeSerializer getTypeSerializer(ReflectConsts.ClassCategory classCategory, JsonProperty jsonProperty) {
        int ordinal = classCategory.ordinal();
        if (classCategory == ReflectConsts.ClassCategory.DateCategory && jsonProperty != null) {
            if (jsonProperty.asTimestamp()) {
                return DATE_AS_TIME_SERIALIZER;
            }
            String pattern = jsonProperty.pattern().trim();
            if (pattern.length() > 0) {
                String timeZoneId = jsonProperty.timezone().trim();
                return new DatePatternImpl(DateFormatter.of(pattern), JSONTypeSerializer.getTimeZone(timeZoneId));
            }
        }
        if (classCategory == ReflectConsts.ClassCategory.NonInstance) {
            return new ObjectImpl.ObjectWithTypeImpl();
        }
        return TYPE_SERIALIZERS[ordinal];
    }

    static final JSONTypeSerializer getMapValueSerializer(Class<?> cls) {
        int classHashCode = cls.getName().hashCode();
        switch (classHashCode) {
            case 1195259493: {
                if (cls != String.class) break;
                return CHAR_SEQUENCE_STRING;
            }
            case -2056817302: 
            case 104431: 
            case 3327612: 
            case 398795216: {
                if (!Number.class.isAssignableFrom(cls)) break;
                return NUMBER_LONG;
            }
            case -1402722386: 
            case 1258621781: {
                if (!Map.class.isAssignableFrom(cls)) break;
                return MAP;
            }
            case -1402716492: 
            case -1114099497: {
                if (!Collection.class.isAssignableFrom(cls)) break;
                return COLLECTION;
            }
        }
        return JSONTypeSerializer.getTypeSerializer(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final JSONTypeSerializer getTypeSerializer(Class<?> cls) {
        JSONTypeSerializer typeSerializer = classJSONTypeSerializerMap.get(cls);
        if (typeSerializer != null) {
            return typeSerializer.ensureInitialized();
        }
        Class<?> clazz = cls;
        synchronized (clazz) {
            typeSerializer = classJSONTypeSerializerMap.get(cls);
            if (typeSerializer != null) {
                return typeSerializer.ensureInitialized();
            }
            ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(cls);
            if (classCategory == ReflectConsts.ClassCategory.ObjectCategory) {
                ClassStrucWrap classStrucWrap = ClassStrucWrap.get(cls);
                if (classStrucWrap.isTemporal()) {
                    typeSerializer = JSONTemporalSerializer.getTemporalSerializerInstance(classStrucWrap, null);
                } else if (classStrucWrap.isSubEnum()) {
                    typeSerializer = ENUM;
                } else {
                    JSONPojoStructure pojoStructure = JSONPojoStructure.get(cls);
                    if (ENABLE_JIT && pojoStructure.isSupportedJIT()) {
                        try {
                            Class<?> serializerClass = JDKCompiler.compileJavaSource(JSONPojoSerializer.generateRuntimeJavaCodeSource(pojoStructure));
                            Constructor<?> constructor = serializerClass.getDeclaredConstructor(JSONPojoStructure.class);
                            UnsafeHelper.setAccessible(constructor);
                            typeSerializer = (JSONPojoSerializer)constructor.newInstance(pojoStructure);
                        }
                        catch (Throwable throwable) {
                            typeSerializer = new ObjectImpl.ObjectWrapperImpl(cls, pojoStructure);
                        }
                    } else {
                        typeSerializer = new ObjectImpl.ObjectWrapperImpl(cls, pojoStructure);
                    }
                }
            } else {
                typeSerializer = JSONTypeSerializer.checkSuperclassRegistered(cls);
                if (typeSerializer == null) {
                    typeSerializer = JSONTypeSerializer.getTypeSerializer(classCategory, null);
                }
            }
            classJSONTypeSerializerMap.put(cls, typeSerializer);
            return typeSerializer.ensureInitialized();
        }
    }

    JSONTypeSerializer ensureInitialized() {
        return this;
    }

    static JSONTypeSerializer getEnumSerializer(Class<?> enumClass) {
        JSONTypeSerializer enumSerializer = classJSONTypeSerializerMap.get(enumClass);
        if (enumSerializer != null) {
            return enumSerializer;
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        char[][] enumNames = new char[values.length][];
        for (Enum value : values) {
            String enumName = value.name();
            char[] chars = new char[enumName.length() + 2];
            chars[chars.length - 1] = 34;
            chars[0] = 34;
            enumName.getChars(0, enumName.length(), chars, 1);
            enumNames[value.ordinal()] = chars;
        }
        enumSerializer = new EnumImpl.EnumInstanceImpl(enumNames);
        classJSONTypeSerializerMap.put(enumClass, enumSerializer);
        return enumSerializer;
    }

    static JSONTypeSerializer createCollectionSerializer(Class valueClass) {
        return new CollectionImpl.CollectionFinalTypeImpl(JSONTypeSerializer.getTypeSerializer(valueClass));
    }

    static JSONTypeSerializer getFieldTypeSerializer(ReflectConsts.ClassCategory classCategory, Class<?> type, JsonProperty jsonProperty) {
        switch (classCategory) {
            case EnumCategory: {
                return JSONTypeSerializer.getEnumSerializer(type);
            }
            case NumberCategory: {
                return JSONTypeSerializer.getTypeSerializer(type);
            }
            case ArrayCategory: {
                if (Object[].class.isAssignableFrom(type)) {
                    return type == String[].class ? ARRAY_STRING : ARRAY_OBJECT;
                }
                return JSONTypeSerializer.getTypeSerializer(type);
            }
            case ObjectCategory: {
                ClassStrucWrap classStrucWrap = ClassStrucWrap.get(type);
                if (classStrucWrap.isTemporal()) {
                    return JSONTemporalSerializer.getTemporalSerializerInstance(classStrucWrap, jsonProperty);
                }
                if (jsonProperty != null && jsonProperty.unfixedType()) {
                    return new ObjectImpl.ObjectWithTypeImpl();
                }
                return JSONTypeSerializer.getTypeSerializer(type);
            }
        }
        return JSONTypeSerializer.getTypeSerializer(classCategory, jsonProperty);
    }

    protected abstract void serialize(Object var1, JSONWriter var2, JSONConfig var3, int var4) throws Exception;

    protected void serializeCustomized(Object value, JSONWriter writer, JSONConfig jsonConfig, int indentLevel, JSONCustomMapper customizedMapper) throws Exception {
        this.serialize(value, writer, jsonConfig, indentLevel);
    }

    protected boolean checkWriteClassName(boolean writeClassName, JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
        if (writeClassName) {
            this.writeType(writer, clazz, formatOut, indentLevel, jsonConfig);
            return true;
        }
        return false;
    }

    void writeType(JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
        JSONTypeSerializer.writeFormatOutSymbols(writer, indentLevel + 1, formatOut, jsonConfig);
        if (formatOut && jsonConfig.formatOutColonSpace) {
            writer.write("\"@c\": \"");
        } else {
            writer.write("\"@c\":\"");
        }
        writer.write(clazz.getName());
        writer.write("\"");
    }

    protected static final void writeDate(int year, int month, int day, int hourOfDay, int minute, int second, int millisecond, DateFormatter dateFormatter, JSONWriter writer) throws Exception {
        if (writer instanceof JSONCharArrayWriter) {
            JSONCharArrayWriter charArrayWriter = (JSONCharArrayWriter)writer;
            char[] buf = charArrayWriter.ensureCapacity(dateFormatter.getEstimateSize() + 128);
            int off = charArrayWriter.count;
            off += dateFormatter.write(year, month, day, hourOfDay, minute, second, millisecond, buf, off);
            charArrayWriter.count = off;
            return;
        }
        dateFormatter.formatTo(year, month, day, hourOfDay, minute, second, millisecond, writer);
    }

    protected static final void writeGeneralDate(GeneralDate generalDate, DateFormatter dateFormatter, JSONWriter writer) throws Exception {
        int year = generalDate.getYear();
        int month = generalDate.getMonth();
        int day = generalDate.getDay();
        int hourOfDay = generalDate.getHourOfDay();
        int minute = generalDate.getMinute();
        int second = generalDate.getSecond();
        int millisecond = generalDate.getMillisecond();
        JSONTypeSerializer.writeDate(year, month, day, hourOfDay, minute, second, millisecond, dateFormatter, writer);
    }

    static {
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = CHAR_SEQUENCE;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = NUMBER;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = SIMPLE;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = new DateImpl();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassImpl();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = ENUM;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationImpl();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = BINARY;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = ARRAY_OBJECT;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = COLLECTION;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = MAP;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = OBJECT;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = ANY;
        JSONTypeSerializer.putTypeSerializer(MAP, LinkedHashMap.class, HashMap.class, ConcurrentHashMap.class, Hashtable.class);
        JSONTypeSerializer.putTypeSerializer(CHAR_SEQUENCE_STRING, String.class);
        JSONTypeSerializer.putTypeSerializer(new BigIntegerImpl(), BigInteger.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_DOUBLE, Double.TYPE, Double.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_FLOAT, Float.TYPE, Float.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_LONG, Long.TYPE, Long.class, AtomicLong.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_INTEGER, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, AtomicInteger.class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_OBJECT, Object[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_STRING, String[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_LONG, long[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_INTEGER, int[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_FLOAT, float[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_DOUBLE, double[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_SHORT, short[].class);
        JSONTypeSerializer.putTypeSerializer(BINARY, byte[].class);
        JSONTypeSerializer.putTypeSerializer(new ArrayPrimitiveImpl(SIMPLE, ReflectConsts.PrimitiveType.PrimitiveBoolean), boolean[].class);
        JSONTypeSerializer.putTypeSerializer(CHAR_SEQUENCE, char[].class, StringBuffer.class, StringBuilder.class);
        JSONTypeExtensionSer.initExtens();
        BUILT_IN_TYPE_SET = new HashSet(classJSONTypeSerializerMap.keySet());
    }

    static final class ToStringImpl
    extends JSONTypeSerializer {
        ToStringImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            CHAR_SEQUENCE_STRING.serialize(value.toString(), writer, jsonConfig, indent);
        }
    }

    static final class AnyImpl
    extends JSONTypeSerializer {
        AnyImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Class<?> clazz = value.getClass();
            if (clazz == Object.class) {
                writer.write(EMPTY_OBJECT);
            } else {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(clazz);
                int ordinal = classCategory.ordinal();
                TYPE_SERIALIZERS[ordinal].serialize(value, writer, jsonConfig, indent);
            }
        }
    }

    static class ObjectImpl
    extends JSONTypeSerializer {
        ObjectImpl() {
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            boolean writeFullProperty = jsonConfig.isFullProperty();
            boolean formatOut = jsonConfig.isFormatOut();
            boolean formatOutColonSpace = formatOut && jsonConfig.isFormatOutColonSpace();
            boolean writeClassName = jsonConfig.isWriteClassName();
            writer.writeJSONToken('{');
            Class<?> clazz = obj.getClass();
            JSONPojoStructure pojoStructure = this.getPojoStructure(clazz);
            boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, clazz, formatOut, indentLevel, jsonConfig);
            JSONPojoFieldSerializer[] fieldSerializers = pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
            boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
            boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
            int indentPlus = indentLevel + 1;
            for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
                Object value;
                GetterInfo getterInfo = fieldSerializer.getterInfo;
                if (!getterInfo.existField() && skipGetterOfNoExistField || (value = JSON_SECURE_TRUSTED_ACCESS.get(getterInfo, obj)) == null && !writeFullProperty) continue;
                if (isEmptyFlag) {
                    isEmptyFlag = false;
                } else {
                    writer.writeJSONToken(',');
                }
                ObjectImpl.writeFormatOutSymbols(writer, indentPlus, formatOut, jsonConfig);
                if (value != null) {
                    if (unCamelCaseToUnderline) {
                        fieldSerializer.writeFieldNameAndColonTo(writer);
                    } else {
                        writer.writeJSONToken('\"');
                        writer.write(getterInfo.getUnderlineName());
                        writer.write("\":");
                    }
                    if (formatOutColonSpace) {
                        writer.writeJSONToken(' ');
                    }
                    fieldSerializer.serializer.serialize(value, writer, jsonConfig, indentPlus);
                    continue;
                }
                if (unCamelCaseToUnderline) {
                    if (formatOutColonSpace) {
                        fieldSerializer.writeFieldNameAndColonTo(writer);
                        writer.writeJSONToken(' ');
                        writer.writeNull();
                        continue;
                    }
                    fieldSerializer.writeJSONFieldNameWithNull(writer);
                    continue;
                }
                writer.writeJSONToken('\"');
                writer.write(getterInfo.getUnderlineName());
                writer.writeJSONToken('\"');
                if (formatOutColonSpace) {
                    writer.write(": null");
                    continue;
                }
                writer.write(":null");
            }
            if (!isEmptyFlag) {
                ObjectImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
            }
            writer.write(125);
            jsonConfig.setStatus(hashcode, -1);
        }

        JSONPojoStructure getPojoStructure(Class clazz) {
            JSONPojoStructure pojoStructure = JSONPojoStructure.get(clazz);
            pojoStructure.ensureInitializedFieldSerializers();
            return pojoStructure;
        }

        static final class ObjectWrapperImpl
        extends ObjectImpl {
            final JSONPojoStructure pojoStructure;
            final Class objectCls;

            ObjectWrapperImpl(Class cls, JSONPojoStructure pojoStructure) {
                this.objectCls = cls;
                this.pojoStructure = pojoStructure;
            }

            @Override
            JSONPojoStructure getPojoStructure(Class clazz) {
                return clazz == this.objectCls ? this.pojoStructure : super.getPojoStructure(clazz);
            }

            @Override
            JSONTypeSerializer ensureInitialized() {
                this.pojoStructure.ensureInitializedFieldSerializers();
                return this;
            }
        }

        static final class ObjectWithTypeImpl
        extends ObjectImpl {
            ObjectWithTypeImpl() {
            }

            @Override
            protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(obj.getClass());
                if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
                    ObjectWithTypeImpl.getTypeSerializer(classCategory, null).serialize(obj, writer, jsonConfig, indentLevel);
                } else {
                    super.serialize(obj, writer, jsonConfig, indentLevel);
                }
            }

            @Override
            protected boolean checkWriteClassName(boolean writeClassName, JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
                this.writeType(writer, clazz, formatOut, indentLevel, jsonConfig);
                return true;
            }
        }
    }

    static class MapImpl
    extends JSONTypeSerializer {
        MapImpl() {
        }

        private static void writeMap(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            boolean formatOutColonSpace = formatOut && jsonConfig.isFormatOutColonSpace();
            Map map = (Map)obj;
            if (map.size() == 0) {
                writer.write(EMPTY_OBJECT);
            } else {
                writer.writeJSONToken('{');
                Set entrySet = map.entrySet();
                boolean isFirstKey = true;
                int indentLevelPlus = indentLevel + 1;
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (isFirstKey) {
                        isFirstKey = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    MapImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (jsonConfig.isAllowUnquotedMapKey() && (key == null || key instanceof Number)) {
                        writer.append(String.valueOf(key)).write(58);
                    } else {
                        String stringKey = key == null ? "null" : key.toString();
                        writer.writeJSONKeyAndColon(stringKey);
                    }
                    if (formatOutColonSpace) {
                        writer.writeJSONToken(' ');
                    }
                    if (value != null) {
                        JSONTypeSerializer valueSerializer = MapImpl.getMapValueSerializer(value.getClass());
                        valueSerializer.serialize(value, writer, jsonConfig, formatOut ? indentLevelPlus : -1);
                        continue;
                    }
                    writer.writeNull();
                }
                MapImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.write(125);
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            MapImpl.writeMap(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }

        @Override
        protected final void serializeCustomized(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel, JSONCustomMapper customizedMapper) throws Exception {
            boolean formatOut;
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            boolean formatOutColonSpace = (formatOut = jsonConfig.isFormatOut()) && jsonConfig.isFormatOutColonSpace();
            Map map = (Map)obj;
            if (map.size() == 0) {
                writer.write(EMPTY_OBJECT);
            } else {
                writer.writeJSONToken('{');
                Set entrySet = map.entrySet();
                boolean isFirstKey = true;
                int indentLevelPlus = indentLevel + 1;
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (isFirstKey) {
                        isFirstKey = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    MapImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (jsonConfig.isAllowUnquotedMapKey() && (key == null || key instanceof Number)) {
                        writer.append(String.valueOf(key)).write(58);
                    } else {
                        String stringKey = key == null ? "null" : key.toString();
                        writer.writeJSONKeyAndColon(stringKey);
                    }
                    if (formatOutColonSpace) {
                        writer.writeJSONToken(' ');
                    }
                    if (value != null) {
                        JSONTypeSerializer valueSerializer = customizedMapper.getCustomizedSerializer(value.getClass());
                        valueSerializer.serializeCustomized(value, writer, jsonConfig, formatOut ? indentLevelPlus : -1, customizedMapper);
                        continue;
                    }
                    writer.writeNull();
                }
                MapImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.write(125);
            }
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    static class CollectionImpl
    extends JSONTypeSerializer {
        CollectionImpl() {
        }

        protected void writeCollection(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Collection collect = (Collection)obj;
            if (collect.size() > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                boolean isEmptyFlag = true;
                Class<?> firstElementClass = null;
                JSONTypeSerializer firstSerializer = null;
                for (Object value : collect) {
                    if (isEmptyFlag) {
                        isEmptyFlag = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    CollectionImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (value != null) {
                        Class<?> valueClass = value.getClass();
                        if (valueClass == firstElementClass) {
                            firstSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        if (firstElementClass == null) {
                            firstElementClass = valueClass;
                            firstSerializer = CollectionImpl.getTypeSerializer(valueClass);
                            firstSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        CollectionImpl.getTypeSerializer(valueClass).serialize(value, writer, jsonConfig, indentLevelPlus);
                        continue;
                    }
                    writer.writeNull();
                }
                if (!isEmptyFlag) {
                    CollectionImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                }
                writer.write(93);
            } else {
                writer.writeEmptyArray();
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.writeCollection(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }

        @Override
        protected final void serializeCustomized(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel, JSONCustomMapper customizedMapper) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            boolean formatOut = jsonConfig.isFormatOut();
            Collection collect = (Collection)obj;
            if (collect.size() > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                boolean isEmptyFlag = true;
                Class<?> firstElementClass = null;
                JSONTypeSerializer firstSerializer = null;
                for (Object value : collect) {
                    if (isEmptyFlag) {
                        isEmptyFlag = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    CollectionImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (value != null) {
                        Class<?> valueClass = value.getClass();
                        if (valueClass == firstElementClass) {
                            firstSerializer.serializeCustomized(value, writer, jsonConfig, indentLevelPlus, customizedMapper);
                            continue;
                        }
                        if (firstElementClass == null) {
                            firstElementClass = valueClass;
                            firstSerializer = customizedMapper.getCustomizedSerializer(valueClass);
                            firstSerializer.serializeCustomized(value, writer, jsonConfig, indentLevelPlus, customizedMapper);
                            continue;
                        }
                        CollectionImpl.getTypeSerializer(valueClass).serializeCustomized(value, writer, jsonConfig, indentLevelPlus, customizedMapper);
                        continue;
                    }
                    writer.writeNull();
                }
                if (!isEmptyFlag) {
                    CollectionImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                }
                writer.write(93);
            } else {
                writer.writeEmptyArray();
            }
            jsonConfig.setStatus(hashcode, -1);
        }

        static final class CollectionFinalTypeImpl
        extends CollectionImpl {
            private final JSONTypeSerializer valueSerializer;

            CollectionFinalTypeImpl(JSONTypeSerializer valueSerializer) {
                this.valueSerializer = valueSerializer;
            }

            @Override
            protected void writeCollection(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                boolean formatOut = jsonConfig.isFormatOut();
                Collection collect = (Collection)obj;
                if (collect.size() > 0) {
                    writer.writeJSONToken('[');
                    int indentLevelPlus = indentLevel + 1;
                    boolean isEmptyFlag = true;
                    for (Object value : collect) {
                        if (isEmptyFlag) {
                            isEmptyFlag = false;
                        } else {
                            writer.writeJSONToken(',');
                        }
                        CollectionFinalTypeImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                        if (value != null) {
                            this.valueSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        writer.writeNull();
                    }
                    if (!isEmptyFlag) {
                        CollectionFinalTypeImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                    }
                    writer.write(93);
                } else {
                    writer.writeEmptyArray();
                }
            }
        }
    }

    static final class ArrayPrimitiveImpl
    extends ArrayImpl {
        final JSONTypeSerializer valueSerializer;
        final ReflectConsts.PrimitiveType primitiveType;

        public ArrayPrimitiveImpl(JSONTypeSerializer valueSerializer, ReflectConsts.PrimitiveType primitiveType) {
            this.valueSerializer = valueSerializer;
            this.primitiveType = primitiveType;
        }

        @Override
        protected void writeArray(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            int length = this.primitiveType.arrayLength(obj);
            if (length > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                ArrayPrimitiveImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                this.valueSerializer.serialize(this.primitiveType.elementAt(obj, 0), writer, jsonConfig, indentLevelPlus);
                for (int i = 1; i < length; ++i) {
                    writer.writeJSONToken(',');
                    ArrayPrimitiveImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    this.valueSerializer.serialize(this.primitiveType.elementAt(obj, i), writer, jsonConfig, indentLevelPlus);
                }
                ArrayPrimitiveImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.writeJSONToken(']');
            } else {
                writer.writeEmptyArray();
            }
        }
    }

    static final class ArrayStringImpl
    extends ArrayImpl {
        ArrayStringImpl() {
        }

        @Override
        protected JSONTypeSerializer getComponentTypeSerializer(Class<?> componentType) {
            return null;
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            this.writeArray(obj, writer, jsonConfig, indentLevel);
        }

        @Override
        protected void serializeComponent(JSONTypeSerializer valueSerializer, Object value, Class<?> componentType, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            CHAR_SEQUENCE_STRING.serialize(value, writer, jsonConfig, indentLevel);
        }
    }

    static class ArrayImpl
    extends JSONTypeSerializer {
        ArrayImpl() {
        }

        protected JSONTypeSerializer getComponentTypeSerializer(Class<?> componentType) {
            return JSONTypeSerializer.getTypeSerializer(componentType);
        }

        protected void writeArray(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Object[] objects = (Object[])obj;
            int length = objects.length;
            if (length > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                Class<?> componentType = obj.getClass().getComponentType();
                JSONTypeSerializer valueSerializer = this.getComponentTypeSerializer(componentType);
                Object value = objects[0];
                ArrayImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                if (value != null) {
                    this.serializeComponent(valueSerializer, value, componentType, writer, jsonConfig, indentLevelPlus);
                } else {
                    writer.writeNull();
                }
                for (int i = 1; i < length; ++i) {
                    writer.writeJSONToken(',');
                    ArrayImpl.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    value = objects[i];
                    if (value != null) {
                        this.serializeComponent(valueSerializer, value, componentType, writer, jsonConfig, indentLevelPlus);
                        continue;
                    }
                    writer.writeNull();
                }
                ArrayImpl.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.write(93);
            } else {
                writer.writeEmptyArray();
            }
        }

        protected void serializeComponent(JSONTypeSerializer valueSerializer, Object value, Class<?> componentType, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            Class<?> valueClass = value.getClass();
            if (componentType == valueClass) {
                valueSerializer.serialize(value, writer, jsonConfig, indentLevel);
            } else {
                ArrayImpl.getTypeSerializer(valueClass).serialize(value, writer, jsonConfig, indentLevel);
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.writeArray(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    static final class BinaryImpl
    extends JSONTypeSerializer {
        BinaryImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            if (jsonConfig.isBytesArrayToNative()) {
                ARRAY_PRIMITIVE_BYTE.serialize(value, writer, jsonConfig, indent);
            } else {
                byte[] bytes = (byte[])value;
                if (jsonConfig.isBytesArrayToHex()) {
                    writer.writeAsHexString(bytes);
                } else {
                    writer.writeAsBase64String(bytes);
                }
            }
        }
    }

    static final class AnnotationImpl
    extends JSONTypeSerializer {
        AnnotationImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.writeJSONToken('\"');
            writer.write(value.toString());
            writer.writeJSONToken('\"');
        }
    }

    static final class ClassImpl
    extends JSONTypeSerializer {
        ClassImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.writeJSONToken('\"');
            writer.write(((Class)value).getName());
            writer.writeJSONToken('\"');
        }
    }

    static class EnumImpl
    extends JSONTypeSerializer {
        EnumImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Enum enmuValue = (Enum)value;
            if (jsonConfig.isWriteEnumAsOrdinal()) {
                writer.writeLong(enmuValue.ordinal());
            } else {
                writer.writeJSONToken('\"');
                writer.write(enmuValue.name());
                writer.writeJSONToken('\"');
            }
        }

        static class EnumInstanceImpl
        extends EnumImpl {
            final EnumFieldNameData[] enumFieldNameDatas;

            EnumInstanceImpl(char[][] enumNameTokenChars) {
                EnumFieldNameData[] enumFieldNameDatas = new EnumFieldNameData[enumNameTokenChars.length];
                for (int i = 0; i < enumNameTokenChars.length; ++i) {
                    boolean useUnsafe;
                    char[] chars = enumNameTokenChars[i];
                    String enumNameTokenStr = new String(chars);
                    boolean bl = useUnsafe = enumNameTokenStr.getBytes().length == chars.length;
                    enumFieldNameDatas[i] = useUnsafe ? new EnumFieldNameData(null, null, UnsafeHelper.getCharLongs(enumNameTokenStr), UnsafeHelper.getByteLongs(enumNameTokenStr), chars.length) : (EnvUtils.JDK_9_PLUS ? new EnumFieldNameData(enumNameTokenStr, null, null, null, chars.length) : new EnumFieldNameData(null, chars, null, null, chars.length));
                }
                this.enumFieldNameDatas = enumFieldNameDatas;
            }

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                Enum enmuValue = (Enum)value;
                int ordinal = enmuValue.ordinal();
                if (!jsonConfig.isWriteEnumAsOrdinal()) {
                    EnumFieldNameData fieldNameData = this.enumFieldNameDatas[ordinal];
                    if (fieldNameData.useLong) {
                        writer.writeMemory(fieldNameData.enumNameTokenCharLongs, fieldNameData.enumNameTokenByteLongs, fieldNameData.tokenLength);
                    } else if (EnvUtils.JDK_9_PLUS) {
                        String enumNameToken = fieldNameData.enumNameTokenStr;
                        writer.write(enumNameToken, 0, enumNameToken.length());
                    } else {
                        char[] chars = fieldNameData.enumNameTokenChars;
                        writer.writeShortChars(chars, 0, chars.length);
                    }
                } else {
                    writer.writeLong(ordinal);
                }
            }
        }

        static class EnumFieldNameData {
            final String enumNameTokenStr;
            final char[] enumNameTokenChars;
            final long[] enumNameTokenCharLongs;
            final long[] enumNameTokenByteLongs;
            final int tokenLength;
            final boolean useLong;

            public EnumFieldNameData(String enumNameTokenStr, char[] enumNameTokenChars, long[] enumNameTokenCharLongs, long[] enumNameTokenByteLongs, int tokenLength) {
                this.enumNameTokenStr = enumNameTokenStr;
                this.enumNameTokenChars = enumNameTokenChars;
                this.enumNameTokenCharLongs = enumNameTokenCharLongs;
                this.enumNameTokenByteLongs = enumNameTokenByteLongs;
                this.tokenLength = tokenLength;
                this.useLong = enumNameTokenCharLongs != null;
            }
        }
    }

    static final class DatePatternImpl
    extends DateImpl {
        protected final DateFormatter dateFormatter;

        public DatePatternImpl(DateFormatter dateFormatter, TimeZone timeZone) {
            this.dateFormatter = dateFormatter;
            this.timeZone = timeZone;
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Date date = (Date)value;
            TimeZone timeZone = jsonConfig.getTimezone();
            if (timeZone == null) {
                timeZone = this.timeZone;
            }
            writer.writeJSONToken('\"');
            GeneralDate generalDate = new GeneralDate(date.getTime(), timeZone);
            DatePatternImpl.writeGeneralDate(generalDate, this.dateFormatter, writer);
            writer.writeJSONToken('\"');
        }
    }

    static final class DateAsTimeImpl
    extends DateImpl {
        DateAsTimeImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.writeLong(((Date)value).getTime());
        }
    }

    static class DateImpl
    extends JSONTypeSerializer {
        protected TimeZone timeZone;

        DateImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Date date = (Date)value;
            if (jsonConfig.isWriteDateAsTime()) {
                writer.writeLong(date.getTime());
                return;
            }
            TimeZone timeZone = jsonConfig.getTimezone();
            if (timeZone == null) {
                timeZone = this.timeZone;
            }
            GeneralDate generalDate = new GeneralDate(date.getTime(), timeZone);
            int year = generalDate.getYear();
            int month = generalDate.getMonth();
            int day = generalDate.getDay();
            int hourOfDay = generalDate.getHourOfDay();
            int minute = generalDate.getMinute();
            int second = generalDate.getSecond();
            writer.writeJSONToken('\"');
            if (date instanceof Time) {
                writer.writeTime(hourOfDay, minute, second);
            } else {
                writer.writeDate(year, month, day, hourOfDay, minute, second);
            }
            writer.writeJSONToken('\"');
        }
    }

    static final class FloatImpl
    extends SimpleNumberImpl {
        FloatImpl() {
        }

        @Override
        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            float numValue = ((Number)value).floatValue();
            writer.writeFloat(numValue);
        }
    }

    static final class DoubleImpl
    extends SimpleNumberImpl {
        DoubleImpl() {
        }

        @Override
        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            double numValue = ((Number)value).doubleValue();
            writer.writeDouble(numValue);
        }
    }

    static final class IntegerImpl
    extends SimpleNumberImpl {
        IntegerImpl() {
        }

        @Override
        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int numValue = ((Number)value).intValue();
            writer.writeInt(numValue);
        }
    }

    static final class LongImpl
    extends SimpleNumberImpl {
        LongImpl() {
        }

        @Override
        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            long numValue = ((Number)value).longValue();
            writer.writeLong(numValue);
        }
    }

    static final class BigIntegerImpl
    extends SimpleNumberImpl {
        BigIntegerImpl() {
        }

        @Override
        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.writeBigInteger((BigInteger)value);
        }
    }

    static class SimpleNumberImpl
    extends SimpleImpl {
        SimpleNumberImpl() {
        }

        protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.writeLatinString(value.toString());
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            boolean writeAsString = jsonConfig.isWriteNumberAsString();
            if (!writeAsString) {
                this.serializeNumber(value, writer, jsonConfig, indent);
            } else {
                writer.write(34);
                this.serializeNumber(value, writer, jsonConfig, indent);
                writer.write(34);
            }
        }
    }

    static class SimpleImpl
    extends JSONTypeSerializer {
        SimpleImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.write(value.toString());
        }
    }

    static final class StringJDK9PlusImpl
    extends CharSequenceImpl {
        StringJDK9PlusImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            String stringVal = value.toString();
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(stringVal);
            writer.writeJSONStringBytes(stringVal, bytes);
        }
    }

    static final class StringJDK8Impl
    extends CharSequenceImpl {
        StringJDK8Impl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            String stringVal = value.toString();
            writer.writeJSONChars((char[])JSONUnsafe.getStringValue(stringVal));
        }
    }

    static class CharSequenceImpl
    extends JSONTypeSerializer {
        CharSequenceImpl() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            if (value instanceof CharSequence) {
                writer.writeJSONString(value.toString());
            } else if (value instanceof char[]) {
                writer.writeJSONChars((char[])value);
            } else {
                char c = ((Character)value).charValue();
                writer.writeJSONChar(c);
            }
        }
    }
}

