/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.Instant;

public class TemporalInstantDeserializer
extends JSONTemporalDeserializer {
    public TemporalInstantDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long millis = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return Instant.ofEpochMilli(millis);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long millis = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return Instant.ofEpochMilli(millis);
    }

    @Override
    protected Object deserializeDefault(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        boolean isDigitFlag;
        int year;
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = TemporalInstantDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else if (c1 == '-' && NumberUtils.isDigit(c1 = buf[++i]) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = -TemporalInstantDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(c1 = buf[++i])) {
            year = year * 10 + (c1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(c1 = buf[++i])) && NumberUtils.isDigit(c2 = buf[++i])) {
            month = TemporalInstantDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            month = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            day = TemporalInstantDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            day = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            hour = TemporalInstantDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            hour = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            minute = TemporalInstantDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            minute = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            second = TemporalInstantDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            second = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        long epochSecond = GeneralDate.getSeconds(year, month, day, hour, minute, second);
        int nanoOfSecond = 0;
        char c = buf[i];
        if (c == '.') {
            int cnt = 9;
            while ((isDigitFlag = NumberUtils.isDigit(c = buf[++i])) && NumberUtils.isDigit(c1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + TemporalInstantDeserializer.twoDigitsValue(c, c1);
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = c1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        switch (c) {
            case 'Z': 
            case 'z': {
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        }
        String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefault(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        byte b2;
        boolean isDigitFlag;
        byte b1;
        int i = offset;
        int year = TemporalInstantDeserializer.fourDigitsValue(buf, i);
        if (year != -1) {
            i += 3;
        } else if (buf[i] == 45 && (year = TemporalInstantDeserializer.fourDigitsValue(buf, i + 1)) != -1) {
            year = -year;
            i += 4;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(b1 = buf[++i])) {
            year = year * 10 + (b1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(b1 = buf[++i])) && NumberUtils.isDigit(b2 = buf[++i])) {
            month = TemporalInstantDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            month = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            day = TemporalInstantDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            day = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            hour = TemporalInstantDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            hour = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            minute = TemporalInstantDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            minute = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            second = TemporalInstantDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            second = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        long epochSecond = GeneralDate.getSeconds(year, month, day, hour, minute, second);
        int nanoOfSecond = 0;
        byte c = buf[i];
        if (c == 46) {
            int val;
            int cnt = 9;
            ++i;
            while ((val = TemporalInstantDeserializer.digits2Bytes(buf, i)) != -1) {
                i += 2;
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + val;
            }
            c = buf[i];
            if (NumberUtils.isDigit(c)) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = buf[++i];
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        switch (c) {
            case 90: 
            case 122: {
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        }
        String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return Instant.parse(value);
    }

    @Override
    protected Object fromTime(long timestamp) {
        long epochSecond = timestamp / 1000L;
        long millis = timestamp - epochSecond;
        return Instant.ofEpochSecond(epochSecond, millis * 1000000L);
    }

    @Override
    protected boolean supportedTime() {
        return true;
    }
}

