/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import java.time.Instant;
import java.util.TimeZone;

public class TemporalInstantSerializer
extends JSONTemporalSerializer {
    final TimeZone timeZone;
    final boolean asTimestamp;

    public TemporalInstantSerializer(Class<?> temporalClass, JsonProperty property) {
        super(temporalClass, property);
        TimeZone timeZone = ZERO_TIME_ZONE;
        if (this.dateFormatter != null && property.timezone().length() > 0) {
            timeZone = TemporalInstantSerializer.getTimeZone(property.timezone());
        }
        this.timeZone = timeZone;
        this.asTimestamp = property != null && property.asTimestamp();
    }

    @Override
    protected void checkClass(Class<?> temporalClass) {
    }

    @Override
    protected void writeTemporalWithTemplate(Object value, JSONWriter writer, JSONConfig jsonConfig) throws Exception {
        Instant instant = (Instant)value;
        if (this.asTimestamp) {
            writer.writeLong(instant.toEpochMilli());
        } else {
            long epochMilli = instant.toEpochMilli();
            GeneralDate date = new GeneralDate(epochMilli, this.timeZone);
            writer.write(34);
            TemporalInstantSerializer.writeGeneralDate(date, this.dateFormatter, writer);
            writer.write(34);
        }
    }

    @Override
    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        Instant instant = (Instant)value;
        if (this.asTimestamp) {
            writer.writeLong(instant.toEpochMilli());
        } else {
            long epochSeconds = instant.getEpochSecond();
            int nano = instant.getNano();
            writer.writeJSONInstant(epochSeconds, nano);
        }
    }
}

