/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.LocalDate;

public class TemporalLocalDateDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalDateDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDate.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay());
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDate.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay());
    }

    @Override
    protected LocalDate deserializeDefault(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int day;
        int month;
        boolean isDigitFlag;
        int year;
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = TemporalLocalDateDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else if (c1 == '-' && NumberUtils.isDigit(c1 = buf[++i]) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = -TemporalLocalDateDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(c1 = buf[++i])) {
            year = year * 10 + (c1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(c1 = buf[++i])) && NumberUtils.isDigit(c2 = buf[++i])) {
            month = TemporalLocalDateDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            month = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            day = TemporalLocalDateDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            day = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        if (buf[i] == endToken) {
            jsonParseContext.endIndex = i;
            return LocalDate.of(year, month, day);
        }
        String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + buf[i] + "', expected '" + endToken + "'");
    }

    @Override
    protected LocalDate deserializeDefault(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int day;
        int month;
        byte b2;
        boolean isDigitFlag;
        byte b1;
        int i = offset;
        int year = TemporalLocalDateDeserializer.fourDigitsValue(buf, i);
        if (year != -1) {
            i += 3;
        } else if (buf[i] == 45 && (year = TemporalLocalDateDeserializer.fourDigitsValue(buf, i + 1)) != -1) {
            year = -year;
            i += 4;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(b1 = buf[++i])) {
            year = year * 10 + (b1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(b1 = buf[++i])) && NumberUtils.isDigit(b2 = buf[++i])) {
            month = TemporalLocalDateDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            month = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            day = TemporalLocalDateDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            day = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        if (buf[i] == endToken) {
            jsonParseContext.endIndex = i;
            return LocalDate.of(year, month, day);
        }
        String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)buf[i] + "', expected '" + endToken + "'");
    }

    @Override
    protected LocalDate valueOf(String value, Class<?> actualType) throws Exception {
        return LocalDate.parse(value);
    }
}

