/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TemporalZonedDateTimeDeserializer
extends JSONTemporalDeserializer {
    private static TimeZone defaultTimezone = UnsafeHelper.getDefaultTimeZone();
    private static ZoneId defaultZoneId = defaultTimezone.toZoneId();
    static final ZoneId ZERO = ZoneId.of("Z");
    static final ZoneOffset DEFAULT_ZONE_OFFSET = (ZoneOffset)ZERO;
    private static Map<String, ZoneId> zoneIdMap = new ConcurrentHashMap<String, ZoneId>();

    public static Object defaultZoneId() throws Exception {
        TimeZone timeZone = UnsafeHelper.getDefaultTimeZone();
        if (timeZone == defaultTimezone) {
            return defaultZoneId;
        }
        defaultTimezone = timeZone;
        defaultZoneId = defaultTimezone.toZoneId();
        return defaultZoneId;
    }

    public static ZoneId ofZoneId(String zoneId) throws Exception {
        ZoneId value = zoneIdMap.get(zoneId);
        if (value == null) {
            value = ZoneId.of(zoneId);
            zoneIdMap.put(zoneId, value);
        }
        return value;
    }

    public TemporalZonedDateTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != '.') {
            if (ch == '+' || ch == '-' || ch == 'Z') {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != '[' || buf[endIndex - 1] != ']') continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalZonedDateTimeDeserializer.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        byte ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != 46) {
            if (ch == 43 || ch == 45 || ch == 90) {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != 91 || buf[endIndex - 1] != 93) continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalZonedDateTimeDeserializer.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeDefault(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        boolean isDigitFlag;
        int year;
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (NumberUtils.isDigit(c1) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = TemporalZonedDateTimeDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else if (c1 == '-' && NumberUtils.isDigit(c1 = buf[++i]) && NumberUtils.isDigit(c2 = buf[++i]) && NumberUtils.isDigit(c3 = buf[++i]) && NumberUtils.isDigit(c4 = buf[++i])) {
            year = -TemporalZonedDateTimeDeserializer.fourDigitsValue(c1 & 0xF, c2 & 0xF, c3 & 0xF, c4);
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(c1 = buf[++i])) {
            year = year * 10 + (c1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(c1 = buf[++i])) && NumberUtils.isDigit(c2 = buf[++i])) {
            month = TemporalZonedDateTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            month = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            day = TemporalZonedDateTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            day = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            hour = TemporalZonedDateTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            hour = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            minute = TemporalZonedDateTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            minute = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        c1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(c1);
        if (isDigitFlag && NumberUtils.isDigit(c2 = buf[++i])) {
            second = TemporalZonedDateTimeDeserializer.twoDigitsValue(c1, c2);
            ++i;
        } else if (isDigitFlag) {
            second = c1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int nanoOfSecond = 0;
        char c = buf[i];
        if (c == '.') {
            int cnt = 9;
            while ((isDigitFlag = NumberUtils.isDigit(c = buf[++i])) && NumberUtils.isDigit(c1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + TemporalZonedDateTimeDeserializer.twoDigitsValue(c, c1);
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = c1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 'Z': 
            case 'z': {
                zoneObject = ZERO;
                c = buf[++i];
                break;
            }
            case '+': 
            case '-': {
                int zoneBeginOff = i;
                while (NumberUtils.isDigit(c = buf[++i]) || c == ':') {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneBeginOff, i - zoneBeginOff));
                break;
            }
        }
        if (c == '[') {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = i;
                while (buf[++i] != ']') {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneRegionOff + 1, i - zoneRegionOff - 1));
                c = buf[++i];
            } else {
                while (buf[++i] != ']') {
                }
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefault(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        byte b2;
        boolean isDigitFlag;
        byte b1;
        int i = offset;
        int year = TemporalZonedDateTimeDeserializer.fourDigitsValue(buf, i);
        if (year != -1) {
            i += 3;
        } else if (buf[i] == 45 && (year = TemporalZonedDateTimeDeserializer.fourDigitsValue(buf, i + 1)) != -1) {
            year = -year;
            i += 4;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        while (NumberUtils.isDigit(b1 = buf[++i])) {
            year = year * 10 + (b1 & 0xF);
        }
        if ((isDigitFlag = NumberUtils.isDigit(b1 = buf[++i])) && NumberUtils.isDigit(b2 = buf[++i])) {
            month = TemporalZonedDateTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            month = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            day = TemporalZonedDateTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            day = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            hour = TemporalZonedDateTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            hour = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            minute = TemporalZonedDateTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            minute = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        b1 = buf[++i];
        isDigitFlag = NumberUtils.isDigit(b1);
        if (isDigitFlag && NumberUtils.isDigit(b2 = buf[++i])) {
            second = TemporalZonedDateTimeDeserializer.twoDigitsValue(b1, b2);
            ++i;
        } else if (isDigitFlag) {
            second = b1 & 0xF;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int nanoOfSecond = 0;
        byte c = buf[i];
        if (c == 46) {
            int val;
            int cnt = 9;
            ++i;
            while ((val = TemporalZonedDateTimeDeserializer.digits2Bytes(buf, i)) != -1) {
                i += 2;
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + val;
            }
            c = buf[i];
            if (NumberUtils.isDigit(c)) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + (c & 0xF);
                c = buf[++i];
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 90: 
            case 122: {
                zoneObject = ZERO;
                c = buf[++i];
                break;
            }
            case 43: 
            case 45: {
                int zoneBeginOff = i;
                while (NumberUtils.isDigit(c = buf[++i]) || c == 58) {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneBeginOff, i - zoneBeginOff));
                break;
            }
        }
        if (c == 91) {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = i;
                while (buf[++i] != 93) {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneRegionOff + 1, i - zoneRegionOff - 1));
                c = buf[++i];
            } else {
                while (buf[++i] != 93) {
                }
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    protected boolean supportedZoneRegion() {
        return true;
    }

    protected Object getDefaultZoneId() throws Exception {
        return TemporalZonedDateTimeDeserializer.defaultZoneId();
    }

    protected Temporal ofTemporalDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, Object zone) throws Exception {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, (ZoneId)zone);
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return ZonedDateTime.parse(value);
    }
}

